/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.pdf;

import clover.com.lowagie.text.DocumentException;
import clover.com.lowagie.text.pdf.PdfArray;
import clover.com.lowagie.text.pdf.PdfDictionary;
import clover.com.lowagie.text.pdf.PdfIndirectReference;
import clover.com.lowagie.text.pdf.PdfName;
import clover.com.lowagie.text.pdf.PdfNumber;
import clover.com.lowagie.text.pdf.PdfPage;
import clover.com.lowagie.text.pdf.PdfPageElement;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class PdfPages
extends PdfDictionary
implements PdfPageElement {
    private PdfNumber count;
    private PdfArray kids;
    private ArrayList pages = new ArrayList();

    PdfPages() {
        super(PdfDictionary.PAGES);
        this.count = new PdfNumber(0);
        this.kids = new PdfArray();
        this.put(PdfName.COUNT, this.count);
        this.put(PdfName.KIDS, this.kids);
    }

    public void setParent(PdfIndirectReference pdfIndirectReference) {
        this.put(PdfName.PARENT, pdfIndirectReference);
    }

    public boolean isParent() {
        return true;
    }

    void add(PdfPages pdfPages) {
        pdfPages.add(pdfPages);
    }

    void add(PdfPage pdfPage) {
        this.pages.add(pdfPage);
    }

    void add(PdfIndirectReference pdfIndirectReference) {
        this.count.increment();
        this.kids.add(pdfIndirectReference);
    }

    Iterator iterator() {
        return ((AbstractList)this.pages).iterator();
    }

    int reorderPages(int[] nArray) throws DocumentException {
        if (nArray == null) {
            return this.kids.size();
        }
        if (nArray.length != this.kids.size()) {
            throw new DocumentException("Page reordering requires and array with the same size as the number of pages.");
        }
        int n = this.kids.size();
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (n3 < 1 || n3 > n) {
                throw new DocumentException("Page reordering requires pages between 1 and " + n + ". Found " + n3 + ".");
            }
            if (blArray[n3 - 1]) {
                throw new DocumentException("Page reordering requires no page repetition. Page " + n3 + " is repeated.");
            }
            blArray[n3 - 1] = true;
            ++n2;
        }
        ArrayList arrayList = this.kids.getArrayList();
        Object[] objectArray = arrayList.toArray();
        int n4 = 0;
        while (n4 < n) {
            arrayList.set(n4, objectArray[nArray[n4] - 1]);
            ++n4;
        }
        return n;
    }
}

