/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.pdf;

import clover.com.lowagie.text.ListItem;
import clover.com.lowagie.text.pdf.PdfChunk;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class PdfLine {
    protected ArrayList line;
    protected float left;
    protected float width;
    protected int alignment;
    protected float height;
    protected PdfChunk listSymbol = null;
    protected float symbolIndent;
    protected boolean newlineSplit = false;
    protected float originalWidth;
    protected boolean isRTL = false;

    PdfLine(float f, float f2, int n, float f3) {
        this.left = f;
        this.originalWidth = this.width = f2 - f;
        this.alignment = n;
        this.height = f3;
        this.line = new ArrayList();
    }

    PdfLine(float f, float f2, int n, boolean bl, ArrayList arrayList, boolean bl2) {
        this.left = f;
        this.width = f2;
        this.alignment = n;
        this.line = arrayList;
        this.newlineSplit = bl;
        this.isRTL = bl2;
    }

    PdfChunk add(PdfChunk pdfChunk) {
        if (pdfChunk == null || pdfChunk.toString().equals("")) {
            return null;
        }
        PdfChunk pdfChunk2 = pdfChunk.split(this.width);
        boolean bl = this.newlineSplit = pdfChunk.isNewlineSplit() || pdfChunk2 == null;
        if (pdfChunk.length() > 0) {
            if (pdfChunk2 != null) {
                pdfChunk.trimLastSpace();
            }
            this.width -= pdfChunk.width();
            this.line.add(pdfChunk);
        } else {
            if (this.line.size() < 1) {
                pdfChunk = pdfChunk2;
                pdfChunk2 = pdfChunk.truncate(this.width);
                this.width -= pdfChunk.width();
                if (pdfChunk.length() > 0) {
                    this.line.add(pdfChunk);
                    return pdfChunk2;
                }
                this.line.add(pdfChunk2);
                return null;
            }
            this.width += ((PdfChunk)this.line.get(this.line.size() - 1)).trimLastSpace();
        }
        return pdfChunk2;
    }

    public int size() {
        return this.line.size();
    }

    public Iterator iterator() {
        return ((AbstractList)this.line).iterator();
    }

    float height() {
        return this.height;
    }

    float indentLeft() {
        if (this.isRTL) {
            switch (this.alignment) {
                case 0: {
                    return this.left + this.width;
                }
                case 1: {
                    return this.left + this.width / 2.0f;
                }
            }
            return this.left;
        }
        switch (this.alignment) {
            case 2: {
                return this.left + this.width;
            }
            case 1: {
                return this.left + this.width / 2.0f;
            }
        }
        return this.left;
    }

    public boolean hasToBeJustified() {
        return this.alignment == 3 && this.width != 0.0f;
    }

    public void resetAlignment() {
        if (this.alignment == 3) {
            this.alignment = 0;
        }
    }

    float widthLeft() {
        return this.width;
    }

    int numberOfSpaces() {
        String string = this.toString();
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (string.charAt(n3) == ' ') {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public void setListItem(ListItem listItem) {
        this.listSymbol = new PdfChunk(listItem.listSymbol(), null);
        this.symbolIndent = listItem.indentationLeft();
    }

    public PdfChunk listSymbol() {
        return this.listSymbol;
    }

    public float listIndent() {
        return this.symbolIndent;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = ((AbstractList)this.line).iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((PdfChunk)iterator.next()).toString());
        }
        return stringBuffer.toString();
    }

    public boolean isNewlineSplit() {
        return this.newlineSplit;
    }

    public int getLastStrokeChunk() {
        int n = this.line.size() - 1;
        while (n >= 0) {
            PdfChunk pdfChunk = (PdfChunk)this.line.get(n);
            if (pdfChunk.isStroked()) break;
            --n;
        }
        return n;
    }

    public PdfChunk getChunk(int n) {
        if (n < 0 || n >= this.line.size()) {
            return null;
        }
        return (PdfChunk)this.line.get(n);
    }

    public float getOriginalWidth() {
        return this.originalWidth;
    }

    float getMaxSize() {
        float f = 0.0f;
        int n = 0;
        while (n < this.line.size()) {
            PdfChunk pdfChunk = (PdfChunk)this.line.get(n);
            f = !pdfChunk.isImage() || !pdfChunk.changeLeading() ? Math.max(pdfChunk.font().size(), f) : Math.max(pdfChunk.getImage().scaledHeight() + pdfChunk.getImageOffsetY(), f);
            ++n;
        }
        return f;
    }

    float getMaxSizeSimple() {
        float f = 0.0f;
        int n = 0;
        while (n < this.line.size()) {
            PdfChunk pdfChunk = (PdfChunk)this.line.get(n);
            f = !pdfChunk.isImage() ? Math.max(pdfChunk.font().size(), f) : Math.max(pdfChunk.getImage().scaledHeight() + pdfChunk.getImageOffsetY(), f);
            ++n;
        }
        return f;
    }

    boolean isRTL() {
        return this.isRTL;
    }

    public float getWidthCorrected(float f, float f2) {
        float f3 = 0.0f;
        int n = 0;
        while (n < this.line.size()) {
            PdfChunk pdfChunk = (PdfChunk)this.line.get(n);
            f3 += pdfChunk.getWidthCorrected(f, f2);
            ++n;
        }
        return f3;
    }
}

