/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.MissingResourceException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileException;
import org.qedeq.kernel.se.common.SourceFileExceptionList;
import org.qedeq.kernel.xml.common.XmlSyntaxException;
import org.qedeq.kernel.xml.handler.common.SaxDefaultHandler;
import org.qedeq.kernel.xml.handler.common.SimpleHandler;
import org.qedeq.kernel.xml.parser.SaxEntityResolver;
import org.qedeq.kernel.xml.parser.SaxErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;

public final class SaxParser {
    private static final Class CLASS = SaxParser.class;
    private static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    private static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    private static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    private SaxDefaultHandler handler;
    private XMLReader reader;
    private final SimpleHandler deflt;
    private SourceFileExceptionList exceptionList;
    private Plugin plugin;

    public SaxParser(Plugin plugin, SaxDefaultHandler handler) throws ParserConfigurationException, SAXException {
        this.handler = handler;
        this.deflt = new SimpleHandler();
        this.plugin = plugin;
        String factoryImpl = System.getProperty("javax.xml.parsers.SAXParserFactory");
        if (factoryImpl == null) {
            System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        factory.setFeature(NAMESPACES_FEATURE_ID, true);
        factory.setFeature(VALIDATION_FEATURE_ID, true);
        try {
            factory.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
        }
        catch (SAXNotRecognizedException e) {
            Trace.trace(CLASS, (Object)this, "constructor", (Throwable)e);
        }
        try {
            factory.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, true);
        }
        catch (SAXNotRecognizedException e) {
            Trace.trace(CLASS, (Object)this, "constructor", (Throwable)e);
        }
        SAXParser parser = factory.newSAXParser();
        if (!parser.isNamespaceAware()) {
            throw new ParserConfigurationException("Current XML parser doesn't support namespaces.");
        }
        if (!parser.isValidating()) {
            throw new ParserConfigurationException("Current XML parser doesn't support schema validation.");
        }
        this.reader = parser.getXMLReader();
        this.reader.setEntityResolver(new SaxEntityResolver(handler));
        this.reader.setFeature(NAMESPACES_FEATURE_ID, true);
        this.reader.setFeature(VALIDATION_FEATURE_ID, true);
        try {
            this.reader.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
        }
        catch (SAXNotRecognizedException e) {
            Trace.trace(CLASS, (Object)this, "constructor", (Throwable)e);
        }
        try {
            this.reader.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, true);
        }
        catch (SAXNotRecognizedException e) {
            Trace.trace(CLASS, (Object)this, "constructor", (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parse(File in, boolean validateOnly, String original) throws SourceFileExceptionList {
        block16: {
            method = "parse(URL, boolean, InputStream)";
            stream = null;
            this.exceptionList = new SourceFileExceptionList();
            try {
                block15: {
                    stream = new FileInputStream(in);
                    input = new InputSource(stream);
                    this.reader.setErrorHandler(new SaxErrorHandler(this.plugin, original, this.exceptionList));
                    this.handler.setUrl(original);
                    this.deflt.setUrl(original);
                    if (validateOnly) {
                        try {
                            this.reader.setContentHandler(this.deflt);
                            this.reader.parse(input);
                            break block15;
                        }
                        catch (MissingResourceException ex) {
                            throw new SAXException("For " + ex.getClassName() + " we searched for value" + " of " + ex.getKey(), ex);
                        }
                    }
                    this.handler.setExceptionList(this.exceptionList);
                    this.reader.setContentHandler(this.handler);
                    this.reader.parse(input);
                }
                var9_12 = null;
                ** if (stream == null) goto lbl-1000
            }
            catch (Throwable var8_16) {
                var9_13 = null;
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception e) {
                        Trace.trace(SaxParser.CLASS, (Object)this, "parse(URL, boolean, InputStream)", (Throwable)e);
                    }
                }
                throw var8_16;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    stream.close();
                }
                catch (Exception e) {
                    Trace.trace(SaxParser.CLASS, (Object)this, "parse(URL, boolean, InputStream)", (Throwable)e);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block16;
                catch (SAXException e) {
                    if (this.exceptionList.size() <= 0) {
                        xml = XmlSyntaxException.createBySAXException(e);
                        this.exceptionList.add(new SourceFileException(this.plugin, xml, this.handler.createSourceArea(), null));
                    }
                    throw this.exceptionList;
                }
                catch (IOException e) {
                    xml = XmlSyntaxException.createByIOException(e);
                    this.exceptionList.add(new SourceFileException(this.plugin, xml, this.handler.createSourceArea(), null));
                    throw this.exceptionList;
                }
            }
        }
        if (this.exceptionList.size() > 0) {
            throw this.exceptionList;
        }
    }

    public final void parse(String fileName, String original) throws SourceFileExceptionList {
        File file = new File(fileName);
        this.parse(file.getAbsoluteFile(), original);
    }

    public final void parse(File file, String original) throws SourceFileExceptionList {
        String org = original;
        if (org == null) {
            org = "" + file;
        }
        this.parse(file, true, org);
        this.parse(file, false, org);
    }

    public SourceFileExceptionList getExceptionList() {
        return this.exceptionList;
    }

    public String getEncoding() {
        return this.deflt.getEncoding();
    }
}

