/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.se.base.list.Element;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileExceptionList;
import org.qedeq.kernel.xml.handler.common.SaxDefaultHandler;
import org.qedeq.kernel.xml.handler.list.BasicHandler;
import org.qedeq.kernel.xml.parser.SaxErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class BasicParser {
    private static final Class CLASS = BasicParser.class;
    private SaxDefaultHandler handler;
    private XMLReader reader;
    private static Plugin plugin = new Plugin(){

        public String getPluginDescription() {
            return "parses element lists and atoms";
        }

        public String getPluginId() {
            return (class$org$qedeq$kernel$xml$parser$BasicParser == null ? (class$org$qedeq$kernel$xml$parser$BasicParser = BasicParser.class$("org.qedeq.kernel.xml.parser.BasicParser")) : class$org$qedeq$kernel$xml$parser$BasicParser).getName();
        }

        public String getPluginActionName() {
            return "element parser";
        }
    };

    private BasicParser(SaxDefaultHandler handler) throws ParserConfigurationException, SAXException {
        this.handler = handler;
        String factoryImpl = System.getProperty("javax.xml.parsers.SAXParserFactory");
        if (factoryImpl == null) {
            System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        SAXParser parser = factory.newSAXParser();
        this.reader = parser.getXMLReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parse(String url, Reader in) throws IOException, SAXException {
        String method = "parse(URL, boolean, InputStream)";
        BufferedReader dis = null;
        SourceFileExceptionList exceptionList = new SourceFileExceptionList();
        try {
            dis = new BufferedReader(in);
            InputSource input = new InputSource(dis);
            this.reader.setErrorHandler(new SaxErrorHandler(plugin, url, exceptionList));
            this.handler.setExceptionList(exceptionList);
            this.reader.setContentHandler(this.handler);
            this.handler.setUrl(url);
            this.reader.parse(input);
            Object var8_7 = null;
            if (dis == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (dis == null) throw throwable;
            try {
                dis.close();
                throw throwable;
            }
            catch (Exception e) {
                Trace.trace(CLASS, (Object)this, "parse(URL, boolean, InputStream)", (Throwable)e);
            }
            throw throwable;
        }
        try {
            dis.close();
            return;
        }
        catch (Exception e) {
            Trace.trace(CLASS, (Object)this, "parse(URL, boolean, InputStream)", (Throwable)e);
        }
    }

    public static final Element[] createElements(String xml) throws ParserConfigurationException, SAXException {
        try {
            String data = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<basic>\n" + xml + "\n" + "</basic>\n";
            SaxDefaultHandler handler = new SaxDefaultHandler(plugin);
            BasicHandler simple = new BasicHandler(handler);
            handler.setBasisDocumentHandler(simple);
            BasicParser parser = new BasicParser(handler);
            parser.parse("memory", IoUtility.stringToReader(data));
            return simple.getElements().toArray(new Element[0]);
        }
        catch (SAXException e) {
            Trace.trace(BasicParser.class, "createElement", e);
            Trace.trace(BasicParser.class, "createElement", e.getCause());
            throw e;
        }
        catch (IOException e) {
            Trace.trace(BasicParser.class, "createElement", e);
            throw new RuntimeException(e);
        }
    }

    public static final Element createElement(String xml) throws ParserConfigurationException, SAXException {
        Element[] elements = BasicParser.createElements(xml);
        if (elements == null || elements.length == 0) {
            return null;
        }
        return elements[0];
    }
}

