/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.dao;

import com.sun.syndication.io.XmlReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import org.qedeq.base.io.SourceArea;
import org.qedeq.base.io.TextOutput;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.common.QedeqBo;
import org.qedeq.kernel.bo.common.ServiceProcess;
import org.qedeq.kernel.bo.module.InternalKernelServices;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.QedeqFileDao;
import org.qedeq.kernel.se.base.module.Qedeq;
import org.qedeq.kernel.se.common.ModuleContext;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileExceptionList;
import org.qedeq.kernel.xml.dao.Qedeq2Xml;
import org.qedeq.kernel.xml.handler.common.SaxDefaultHandler;
import org.qedeq.kernel.xml.handler.module.QedeqHandler;
import org.qedeq.kernel.xml.mapper.Context2SimpleXPath;
import org.qedeq.kernel.xml.parser.SaxParser;
import org.qedeq.kernel.xml.tracker.SimpleXPath;
import org.qedeq.kernel.xml.tracker.XPathLocationParser;
import org.xml.sax.SAXException;

public class XmlQedeqFileDao
implements QedeqFileDao,
Plugin {
    private static final Class CLASS = XmlQedeqFileDao.class;
    private InternalKernelServices services;

    public void setServices(InternalKernelServices services) {
        this.services = services;
    }

    public InternalKernelServices getServices() {
        return this.services;
    }

    public Qedeq loadQedeq(ServiceProcess process, QedeqBo prop, File file) throws SourceFileExceptionList {
        String method = "loadModule";
        SaxDefaultHandler handler = new SaxDefaultHandler(this);
        QedeqHandler simple = new QedeqHandler(handler);
        handler.setBasisDocumentHandler(simple);
        SaxParser parser = null;
        Locale.setDefault(Locale.US);
        try {
            parser = new SaxParser(this, handler);
        }
        catch (SAXException e) {
            Trace.fatal(CLASS, this, "loadModule", "XML Parser: Severe configuration problem.", e);
            throw this.services.createSourceFileExceptionList(892773010, "Parser configuration error.", file + "", e);
        }
        catch (ParserConfigurationException e) {
            Trace.fatal(CLASS, this, "loadModule", "XML Parser: Option not recognized or supported.", e);
            throw this.services.createSourceFileExceptionList(754123030, "Option not recognized or supported.", file + "", e);
        }
        try {
            parser.parse(file, prop.getUrl());
        }
        catch (SourceFileExceptionList e) {
            Trace.trace(CLASS, (Object)this, "loadModule", (Throwable)e);
            throw e;
        }
        return simple.getQedeq();
    }

    public void saveQedeq(ServiceProcess process, KernelQedeqBo prop, File localFile) throws SourceFileExceptionList, IOException {
        FileOutputStream outputStream = new FileOutputStream(localFile);
        TextOutput printer = new TextOutput(localFile.getName(), outputStream, "UTF-8");
        Qedeq2Xml.print(process, this, prop, printer);
    }

    public SourceArea createSourceArea(Qedeq qedeq, ModuleContext context) {
        SimpleXPath xpath;
        String method = "createSourceArea(Qedeq, ModuleContext)";
        if (context == null) {
            return null;
        }
        if (qedeq == null) {
            return new SourceArea(context.getModuleLocation().getUrl());
        }
        ModuleContext ctext = new ModuleContext(context);
        try {
            xpath = Context2SimpleXPath.getXPath(ctext, qedeq);
        }
        catch (ModuleDataException e) {
            Trace.fatal(CLASS, "createSourceArea(Qedeq, ModuleContext)", "not found: \"" + ctext + "\"", e);
            if (Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("qedeq.test.xmlLocationFailures"))) {
                throw new RuntimeException(e);
            }
            return new SourceArea(ctext.getModuleLocation().getUrl());
        }
        File local = this.services.getLocalFilePath(ctext.getModuleLocation());
        return XPathLocationParser.findSourceArea(ctext.getModuleLocation().getUrl(), xpath, ctext.getStartDelta(), ctext.getEndDelta(), local);
    }

    public Reader getModuleReader(KernelQedeqBo bo) throws IOException {
        return new XmlReader(this.services.getLocalFilePath(bo.getModuleAddress()));
    }

    public String getPluginId() {
        return CLASS.getName();
    }

    public String getPluginActionName() {
        return "XML Worker";
    }

    public String getPluginDescription() {
        return "can read and write XML QEDEQ modules";
    }
}

