/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.dao;

import java.io.IOException;
import org.qedeq.base.io.TextOutput;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.kernel.bo.KernelContext;
import org.qedeq.kernel.bo.common.ServiceProcess;
import org.qedeq.kernel.bo.module.ControlVisitor;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.se.base.list.ElementList;
import org.qedeq.kernel.se.base.module.Add;
import org.qedeq.kernel.se.base.module.Author;
import org.qedeq.kernel.se.base.module.AuthorList;
import org.qedeq.kernel.se.base.module.Axiom;
import org.qedeq.kernel.se.base.module.ChangedRule;
import org.qedeq.kernel.se.base.module.Chapter;
import org.qedeq.kernel.se.base.module.Conclusion;
import org.qedeq.kernel.se.base.module.ConditionalProof;
import org.qedeq.kernel.se.base.module.Existential;
import org.qedeq.kernel.se.base.module.FormalProof;
import org.qedeq.kernel.se.base.module.FormalProofLine;
import org.qedeq.kernel.se.base.module.FormalProofLineList;
import org.qedeq.kernel.se.base.module.Formula;
import org.qedeq.kernel.se.base.module.FunctionDefinition;
import org.qedeq.kernel.se.base.module.Header;
import org.qedeq.kernel.se.base.module.Hypothesis;
import org.qedeq.kernel.se.base.module.Import;
import org.qedeq.kernel.se.base.module.ImportList;
import org.qedeq.kernel.se.base.module.InitialFunctionDefinition;
import org.qedeq.kernel.se.base.module.InitialPredicateDefinition;
import org.qedeq.kernel.se.base.module.Latex;
import org.qedeq.kernel.se.base.module.LatexList;
import org.qedeq.kernel.se.base.module.LinkList;
import org.qedeq.kernel.se.base.module.LiteratureItem;
import org.qedeq.kernel.se.base.module.LiteratureItemList;
import org.qedeq.kernel.se.base.module.Location;
import org.qedeq.kernel.se.base.module.LocationList;
import org.qedeq.kernel.se.base.module.ModusPonens;
import org.qedeq.kernel.se.base.module.Node;
import org.qedeq.kernel.se.base.module.PredicateDefinition;
import org.qedeq.kernel.se.base.module.Proof;
import org.qedeq.kernel.se.base.module.Proposition;
import org.qedeq.kernel.se.base.module.Qedeq;
import org.qedeq.kernel.se.base.module.Rename;
import org.qedeq.kernel.se.base.module.Rule;
import org.qedeq.kernel.se.base.module.Section;
import org.qedeq.kernel.se.base.module.Specification;
import org.qedeq.kernel.se.base.module.Subsection;
import org.qedeq.kernel.se.base.module.SubsectionList;
import org.qedeq.kernel.se.base.module.SubstFree;
import org.qedeq.kernel.se.base.module.SubstFunc;
import org.qedeq.kernel.se.base.module.SubstPred;
import org.qedeq.kernel.se.base.module.Term;
import org.qedeq.kernel.se.base.module.Universal;
import org.qedeq.kernel.se.base.module.UsedByList;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileExceptionList;

public final class Qedeq2Xml
extends ControlVisitor
implements Plugin {
    private TextOutput printer;

    public Qedeq2Xml(Plugin plugin, KernelQedeqBo bo, TextOutput printer) {
        super(plugin, bo);
        this.printer = printer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void print(ServiceProcess process, Plugin plugin, KernelQedeqBo bo, TextOutput printer) throws SourceFileExceptionList, IOException {
        Qedeq2Xml converter = new Qedeq2Xml(plugin, bo, printer);
        try {
            converter.traverse(process);
            Object var6_5 = null;
            printer.flush();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            printer.flush();
            throw throwable;
        }
        if (printer.checkError()) {
            throw printer.getError();
        }
    }

    public final void visitEnter(Qedeq qedeq) {
        this.printer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.printer.println("<QEDEQ");
        this.printer.println("    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        this.printer.println("    xsi:noNamespaceSchemaLocation=\"http://www.qedeq.org/" + KernelContext.getInstance().getKernelVersionDirectory() + "/xml/qedeq.xsd\">");
        this.printer.pushLevel();
    }

    public final void visitLeave(Qedeq qedeq) {
        this.printer.popLevel();
        this.printer.println("</QEDEQ>");
    }

    public void visitEnter(Header header) {
        this.printer.print("<HEADER");
        if (header.getEmail() != null) {
            this.printer.print(" email=\"" + StringUtility.escapeXml(header.getEmail()) + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(Header header) {
        this.printer.popLevel();
        this.printer.println("</HEADER>");
    }

    public void visitEnter(Specification specification) {
        this.printer.print("<SPECIFICATION");
        if (specification.getName() != null) {
            this.printer.print(" name=\"" + StringUtility.escapeXml(specification.getName()) + "\"");
        }
        if (specification.getName() != null) {
            this.printer.print(" ruleVersion=\"" + StringUtility.escapeXml(specification.getRuleVersion()) + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(Specification specification) {
        this.printer.popLevel();
        this.printer.println("</SPECIFICATION>");
    }

    public void visitEnter(LatexList latexList) {
        String last = this.getCurrentContext().getLocationWithinModule();
        if (last.endsWith(".getTitle()")) {
            this.printer.println("<TITLE>");
        } else if (last.endsWith(".getSummary()")) {
            this.printer.println("<ABSTRACT>");
        } else if (last.endsWith(".getIntroduction()")) {
            this.printer.println("<INTRODUCTION>");
        } else if (last.endsWith(".getName()")) {
            this.printer.println("<NAME>");
        } else if (last.endsWith(".getPrecedingText()")) {
            this.printer.println("<PRECEDING>");
        } else if (last.endsWith(".getSucceedingText()")) {
            this.printer.println("<SUCCEEDING>");
        } else if (last.endsWith(".getLatex()")) {
            this.printer.println("<TEXT>");
        } else if (last.endsWith(".getDescription()") && last.indexOf(".getChangedRuleList().get(") < 0) {
            this.printer.println("<DESCRIPTION>");
        }
        this.printer.pushLevel();
    }

    public void visitLeave(LatexList latexList) {
        this.printer.popLevel();
        String last = this.getCurrentContext().getLocationWithinModule();
        if (last.endsWith(".getTitle()")) {
            this.printer.println("</TITLE>");
        } else if (last.endsWith(".getSummary()")) {
            this.printer.println("</ABSTRACT>");
        } else if (last.endsWith(".getIntroduction()")) {
            this.printer.println("</INTRODUCTION>");
        } else if (last.endsWith(".getName()")) {
            this.printer.println("</NAME>");
        } else if (last.endsWith(".getPrecedingText()")) {
            this.printer.println("</PRECEDING>");
        } else if (last.endsWith(".getSucceedingText()")) {
            this.printer.println("</SUCCEEDING>");
        } else if (last.endsWith(".getLatex()")) {
            this.printer.println("</TEXT>");
        } else if (last.endsWith(".getDescription()") && last.indexOf(".getChangedRuleList().get(") < 0) {
            this.printer.println("</DESCRIPTION>");
        }
    }

    public void visitEnter(Latex latex) {
        this.printer.print("<LATEX");
        if (latex.getLanguage() != null) {
            this.printer.print(" language=\"" + latex.getLanguage() + "\"");
        }
        this.printer.println(">");
        if (latex.getLatex() != null) {
            this.printer.pushLevel();
            this.printer.println("<![CDATA[");
            this.printer.addToken("  ");
            String tabs = this.printer.getLevel();
            this.printer.clearLevel();
            String data = StringUtility.replace(latex.getLatex(), "]]>", "]]]]><![CDATA[>");
            this.printer.println(StringUtility.useSystemLineSeparator(data).trim());
            this.printer.pushLevel(tabs);
        }
    }

    public void visitLeave(Latex latex) {
        if (latex.getLatex() != null) {
            this.printer.println("]]>");
            this.printer.popLevel();
        }
        this.printer.println("</LATEX>");
    }

    public void visitEnter(LocationList locationList) {
        this.printer.println("<LOCATIONS>");
        this.printer.pushLevel();
    }

    public void visitLeave(LocationList locationList) {
        this.printer.popLevel();
        this.printer.println("</LOCATIONS>");
    }

    public void visitEnter(Location location) {
        this.printer.print("<LOCATION");
        if (location.getLocation() != null) {
            this.printer.print(" value=\"" + location.getLocation() + "\"");
        }
        this.printer.println(" />");
    }

    public void visitEnter(AuthorList authorList) {
        this.printer.println("<AUTHORS>");
        this.printer.pushLevel();
    }

    public void visitLeave(AuthorList authorList) {
        this.printer.popLevel();
        this.printer.println("</AUTHORS>");
    }

    public void visitEnter(Author author) {
        this.printer.print("<AUTHOR");
        if (author.getEmail() != null) {
            this.printer.print(" email=\"" + StringUtility.escapeXml(author.getEmail()) + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
        if (author.getName() != null) {
            this.printer.println("<NAME>");
        }
        this.printer.pushLevel();
    }

    public void visitLeave(Author author) {
        this.printer.popLevel();
        if (author.getName() != null) {
            this.printer.println("</NAME>");
        }
        this.printer.popLevel();
        this.printer.println("</AUTHOR>");
    }

    public void visitEnter(ImportList importList) {
        this.printer.println("<IMPORTS>");
        this.printer.pushLevel();
    }

    public void visitLeave(ImportList importList) {
        this.printer.popLevel();
        this.printer.println("</IMPORTS>");
    }

    public void visitEnter(Import imp) {
        this.printer.print("<IMPORT");
        if (imp.getLabel() != null) {
            this.printer.print(" label=\"" + StringUtility.escapeXml(imp.getLabel()) + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(Import imp) {
        this.printer.popLevel();
        this.printer.println("</IMPORT>");
    }

    public void visitEnter(UsedByList usedByList) {
        this.printer.println("<USEDBY>");
        this.printer.pushLevel();
    }

    public void visitLeave(UsedByList usedByList) {
        this.printer.popLevel();
        this.printer.println("</USEDBY>");
    }

    public void visitEnter(Chapter chapter) {
        this.printer.print("<CHAPTER");
        if (chapter.getNoNumber() != null) {
            this.printer.print(" noNumber=\"" + chapter.getNoNumber() + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(Chapter chapter) {
        this.printer.popLevel();
        this.printer.println("</CHAPTER>");
    }

    public void visitEnter(Section section) {
        this.printer.print("<SECTION");
        if (section.getNoNumber() != null) {
            this.printer.print(" noNumber=\"" + section.getNoNumber() + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(Section section) {
        this.printer.popLevel();
        this.printer.println("</SECTION>");
    }

    public void visitEnter(SubsectionList subsectionList) {
        this.printer.println("<SUBSECTIONS>");
        this.printer.pushLevel();
    }

    public void visitLeave(SubsectionList subsectionList) {
        this.printer.popLevel();
        this.printer.println("</SUBSECTIONS>");
    }

    public void visitEnter(Subsection subsection) {
        this.printer.print("<SUBSECTION");
        if (subsection.getId() != null) {
            this.printer.print(" id=\"" + StringUtility.escapeXml(subsection.getId()) + "\"");
        }
        if (subsection.getLevel() != null) {
            this.printer.print(" level=\"" + StringUtility.escapeXml(subsection.getLevel()) + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(Subsection subsection) {
        this.printer.popLevel();
        this.printer.println("</SUBSECTION>");
    }

    public void visitEnter(Node node) {
        this.printer.print("<NODE");
        if (node.getId() != null) {
            this.printer.print(" id=\"" + StringUtility.escapeXml(node.getId()) + "\"");
        }
        if (node.getLevel() != null) {
            this.printer.print(" level=\"" + StringUtility.escapeXml(node.getLevel()) + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(Node node) {
        this.printer.popLevel();
        this.printer.println("</NODE>");
    }

    public void visitEnter(Axiom axiom) {
        this.printer.print("<AXIOM");
        if (axiom.getDefinedOperator() != null) {
            this.printer.print(" definedOperator=\"" + StringUtility.escapeXml(axiom.getDefinedOperator()) + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(Axiom axiom) {
        this.printer.popLevel();
        this.printer.println("</AXIOM>");
    }

    public void visitEnter(Proposition proposition) {
        this.printer.println("<THEOREM>");
        this.printer.pushLevel();
    }

    public void visitLeave(Proposition proposition) {
        this.printer.popLevel();
        this.printer.println("</THEOREM>");
    }

    public void visitEnter(Proof proof) {
        this.printer.print("<PROOF");
        if (proof.getKind() != null) {
            this.printer.print(" kind=\"" + StringUtility.escapeXml(proof.getKind()) + "\"");
        }
        if (proof.getLevel() != null) {
            this.printer.print(" level=\"" + StringUtility.escapeXml(proof.getLevel()) + "\"");
        }
        this.printer.println(">");
    }

    public void visitLeave(Proof proof) {
        this.printer.println("</PROOF>");
    }

    public void visitEnter(FormalProof proof) {
        this.printer.println("<FORMAL_PROOF>");
        this.printer.pushLevel();
    }

    public void visitLeave(FormalProof proof) {
        this.printer.popLevel();
        this.printer.println("</FORMAL_PROOF>");
    }

    public void visitEnter(FormalProofLineList proof) {
        this.printer.println("<LINES>");
        this.printer.pushLevel();
    }

    public void visitLeave(FormalProofLineList proof) {
        this.printer.popLevel();
        this.printer.println("</LINES>");
    }

    public void visitEnter(FormalProofLine line) {
        this.printer.print("<L");
        if (line.getLabel() != null) {
            this.printer.print(" label=\"" + StringUtility.escapeXml(line.getLabel()) + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(FormalProofLine line) {
        this.printer.popLevel();
        this.printer.println("</L>");
    }

    public void visitEnter(ModusPonens reason) {
        this.printer.print("<MP");
        if (reason.getReference1() != null) {
            this.printer.print(" ref1=\"" + StringUtility.escapeXml(reason.getReference1()) + "\"");
        }
        if (reason.getReference2() != null) {
            this.printer.print(" ref2=\"" + StringUtility.escapeXml(reason.getReference2()) + "\"");
        }
    }

    public void visitLeave(ModusPonens reason) {
        this.printer.println("/>");
    }

    public void visitEnter(Add reason) {
        this.printer.print("<ADD");
        if (reason.getReference() != null) {
            this.printer.print(" ref=\"" + StringUtility.escapeXml(reason.getReference()) + "\"");
        }
    }

    public void visitLeave(Add reason) {
        this.printer.println("/>");
    }

    public void visitEnter(Rename reason) {
        this.printer.print("<RENAME");
        if (reason.getReference() != null) {
            this.printer.print(" ref=\"" + StringUtility.escapeXml(reason.getReference()) + "\"");
        }
        if (reason.getOccurrence() != 0) {
            this.printer.print(" occurrence=\"" + StringUtility.escapeXml("" + reason.getOccurrence()) + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(Rename reason) {
        this.printer.popLevel();
        this.printer.println("</RENAME>");
    }

    public void visitEnter(SubstFree reason) {
        this.printer.print("<SUBST_FREE");
        if (reason.getReference() != null) {
            this.printer.print(" ref=\"" + StringUtility.escapeXml(reason.getReference()) + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(SubstFree reason) {
        this.printer.popLevel();
        this.printer.println("</SUBST_FREE>");
    }

    public void visitEnter(SubstFunc reason) {
        this.printer.print("<SUBST_FUNVAR");
        if (reason.getReference() != null) {
            this.printer.print(" ref=\"" + StringUtility.escapeXml(reason.getReference()) + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(SubstFunc reason) {
        this.printer.popLevel();
        this.printer.println("</SUBST_FUNVAR>");
    }

    public void visitEnter(SubstPred reason) {
        this.printer.print("<SUBST_PREDVAR");
        if (reason.getReference() != null) {
            this.printer.print(" ref=\"" + StringUtility.escapeXml(reason.getReference()) + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(SubstPred reason) {
        this.printer.popLevel();
        this.printer.println("</SUBST_PREDVAR>");
    }

    public void visitEnter(Existential reason) {
        this.printer.print("<EXISTENTIAL");
        if (reason.getReference() != null) {
            this.printer.print(" ref=\"" + StringUtility.escapeXml(reason.getReference()) + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(Existential reason) {
        this.printer.popLevel();
        this.printer.println("</EXISTENTIAL>");
    }

    public void visitEnter(Universal reason) {
        this.printer.print("<UNIVERSAL");
        if (reason.getReference() != null) {
            this.printer.print(" ref=\"" + StringUtility.escapeXml(reason.getReference()) + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(Universal reason) {
        this.printer.popLevel();
        this.printer.println("</UNIVERSAL>");
    }

    public void visitEnter(ConditionalProof reason) {
        this.printer.println("<CP>");
        this.printer.pushLevel();
    }

    public void visitLeave(ConditionalProof reason) {
        this.printer.popLevel();
        this.printer.println("</CP>");
    }

    public void visitEnter(Hypothesis hypothesis) {
        this.printer.print("<HYPOTHESIS");
        if (hypothesis.getLabel() != null) {
            this.printer.print(" label=\"" + StringUtility.escapeXml(hypothesis.getLabel()) + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(Hypothesis hypothesis) {
        this.printer.popLevel();
        this.printer.println("</HYPOTHESIS>");
    }

    public void visitEnter(Conclusion conclusion) {
        this.printer.print("<CONCLUSION");
        if (conclusion.getLabel() != null) {
            this.printer.print(" label=\"" + StringUtility.escapeXml(conclusion.getLabel()) + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(Conclusion conclusion) {
        this.printer.popLevel();
        this.printer.println("</CONCLUSION>");
    }

    public void visitEnter(InitialPredicateDefinition definition) {
        this.printer.print("<DEFINITION_PREDICATE_INITIAL");
        if (definition.getArgumentNumber() != null) {
            this.printer.print(" arguments=\"" + StringUtility.escapeXml(definition.getArgumentNumber()) + "\"");
        }
        if (definition.getName() != null) {
            this.printer.print(" name=\"" + StringUtility.escapeXml(definition.getName()) + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
        if (definition.getLatexPattern() != null) {
            this.printer.println("<LATEXPATTERN>" + StringUtility.escapeXml(definition.getLatexPattern()) + "</LATEXPATTERN>");
        }
    }

    public void visitLeave(InitialPredicateDefinition definition) {
        this.printer.popLevel();
        this.printer.println("</DEFINITION_PREDICATE_INITIAL>");
    }

    public void visitEnter(PredicateDefinition definition) {
        this.printer.print("<DEFINITION_PREDICATE");
        if (definition.getArgumentNumber() != null) {
            this.printer.print(" arguments=\"" + StringUtility.escapeXml(definition.getArgumentNumber()) + "\"");
        }
        if (definition.getName() != null) {
            this.printer.print(" name=\"" + StringUtility.escapeXml(definition.getName()) + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
        if (definition.getLatexPattern() != null) {
            this.printer.println("<LATEXPATTERN>" + StringUtility.escapeXml(definition.getLatexPattern()) + "</LATEXPATTERN>");
        }
    }

    public void visitLeave(PredicateDefinition definition) {
        this.printer.popLevel();
        this.printer.println("</DEFINITION_PREDICATE>");
    }

    public void visitEnter(InitialFunctionDefinition definition) {
        this.printer.print("<DEFINITION_FUNCTION_INITIAL");
        if (definition.getArgumentNumber() != null) {
            this.printer.print(" arguments=\"" + StringUtility.escapeXml(definition.getArgumentNumber()) + "\"");
        }
        if (definition.getName() != null) {
            this.printer.print(" name=\"" + StringUtility.escapeXml(definition.getName()) + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
        if (definition.getLatexPattern() != null) {
            this.printer.println("<LATEXPATTERN>" + definition.getLatexPattern() + "</LATEXPATTERN>");
        }
    }

    public void visitLeave(InitialFunctionDefinition definition) {
        this.printer.popLevel();
        this.printer.println("</DEFINITION_FUNCTION_INITIAL>");
    }

    public void visitEnter(FunctionDefinition definition) {
        this.printer.print("<DEFINITION_FUNCTION");
        if (definition.getArgumentNumber() != null) {
            this.printer.print(" arguments=\"" + StringUtility.escapeXml(definition.getArgumentNumber()) + "\"");
        }
        if (definition.getName() != null) {
            this.printer.print(" name=\"" + StringUtility.escapeXml(definition.getName()) + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
        if (definition.getLatexPattern() != null) {
            this.printer.println("<LATEXPATTERN>" + definition.getLatexPattern() + "</LATEXPATTERN>");
        }
    }

    public void visitLeave(FunctionDefinition definition) {
        this.printer.popLevel();
        this.printer.println("</DEFINITION_FUNCTION>");
    }

    public void visitEnter(Rule rule) {
        this.printer.print("<RULE");
        if (rule.getName() != null) {
            this.printer.print(" name=\"" + StringUtility.escapeXml(rule.getName()) + "\"");
        }
        if (rule.getVersion() != null) {
            this.printer.print(" version=\"" + StringUtility.escapeXml(rule.getVersion()) + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(Rule rule) {
        this.printer.popLevel();
        this.printer.println("</RULE>");
    }

    public void visitEnter(LinkList linkList) {
        for (int i = 0; i < linkList.size(); ++i) {
            this.printer.print("<LINK");
            if (linkList.get(i) != null) {
                this.printer.print(" id=\"" + StringUtility.escapeXml(linkList.get(i)) + "\"");
            }
            this.printer.println("/>");
        }
    }

    public void visitEnter(ChangedRule rule) {
        this.printer.print("<CHANGED_RULE");
        if (rule.getName() != null) {
            this.printer.print(" name=\"" + StringUtility.escapeXml(rule.getName()) + "\"");
        }
        if (rule.getVersion() != null) {
            this.printer.print(" version=\"" + StringUtility.escapeXml(rule.getVersion()) + "\"");
        }
        this.printer.println(">");
    }

    public void visitLeave(ChangedRule rule) {
        this.printer.println("</CHANGED_RULE>");
    }

    public void visitEnter(Formula formula) {
        this.printer.println("<FORMULA>");
        this.printer.pushLevel();
    }

    public void visitLeave(Formula formula) {
        this.printer.popLevel();
        this.printer.println("</FORMULA>");
    }

    public void visitEnter(Term term) {
        this.printer.println("<TERM>");
        this.printer.pushLevel();
    }

    public void visitLeave(Term term) {
        this.printer.popLevel();
        this.printer.println("</TERM>");
    }

    public void visitEnter(ElementList list) {
        String atom;
        boolean firstIsAtom;
        String operator = list.getOperator();
        this.printer.print("<" + operator);
        boolean bl = firstIsAtom = list.size() > 0 && list.getElement(0).isAtom();
        if (firstIsAtom && (atom = list.getElement(0).getAtom().getString()) != null) {
            if ("VAR".equals(operator) || "PREDVAR".equals(operator) || "FUNVAR".equals(operator)) {
                this.printer.print(" id=\"" + StringUtility.escapeXml(atom) + "\"");
            } else if ("PREDCON".equals(operator) || "FUNCON".equals(operator)) {
                this.printer.print(" ref=\"" + StringUtility.escapeXml(atom) + "\"");
            } else {
                this.printer.print(" unknown=\"" + StringUtility.escapeXml(atom) + "\"");
            }
        }
        if (list.size() == 0 || list.size() == 1 && list.getElement(0).isAtom()) {
            this.printer.print("/");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(ElementList list) {
        this.printer.popLevel();
        if (list.size() == 0 || list.size() == 1 && list.getElement(0).isAtom()) {
            return;
        }
        this.printer.println("</" + list.getOperator() + ">");
    }

    public void visitEnter(LiteratureItemList list) {
        this.printer.println("<BIBLIOGRAPHY>");
        this.printer.pushLevel();
    }

    public void visitLeave(LiteratureItemList list) {
        this.printer.popLevel();
        this.printer.println("</BIBLIOGRAPHY>");
    }

    public void visitEnter(LiteratureItem item) {
        this.printer.print("<ITEM");
        if (item.getLabel() != null) {
            this.printer.print(" label=\"" + StringUtility.escapeXml(item.getLabel()) + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(LiteratureItem item) {
        this.printer.popLevel();
        this.printer.println("</ITEM>");
    }

    public String getPluginId() {
        return this.getClass().getName();
    }

    public String getPluginActionName() {
        return "generate XML";
    }

    public String getPluginDescription() {
        return "Transformes QEDEQ module into XML data";
    }
}

