/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.se.visitor;

import org.qedeq.base.utility.StringUtility;
import org.qedeq.kernel.se.base.module.Latex;
import org.qedeq.kernel.se.base.module.LatexList;

public class LatexList2Text {
    public String transform(LatexList list) {
        return this.transform(list, "en");
    }

    public String transform(LatexList list, String language) {
        int i;
        if (list == null) {
            return "";
        }
        String lan = language != null ? language : "en";
        for (i = 0; i < list.size(); ++i) {
            if (list.get(i) == null || !lan.equals(list.get(i).getLanguage())) continue;
            return this.getLatex(list.get(i));
        }
        for (i = 0; i < list.size(); ++i) {
            if (list.get(i) == null || list.get(i).getLanguage() != null) continue;
            return this.getLatex(list.get(i));
        }
        if (!"en".equals(lan)) {
            lan = "en";
            for (i = 0; i < list.size(); ++i) {
                if (list.get(i) == null || !lan.equals(list.get(i).getLanguage())) continue;
                return this.getLatex(list.get(i));
            }
        }
        for (i = 0; i < list.size(); ++i) {
            if (list.get(i) == null) continue;
            return this.getLatex(list.get(i));
        }
        return "";
    }

    protected String getLatex(Latex latex) {
        if (latex == null) {
            return "";
        }
        String result = latex.getLatex();
        if (result == null) {
            result = "";
        }
        result = result.trim();
        result = result.replaceAll("\\\\index\\{.*\\}", "");
        result = result.replaceAll("\\\\(\\w*)\\{(.*)\\}", "$2");
        result = StringUtility.replace(result, "{", "");
        result = StringUtility.replace(result, "}", "");
        return result.trim();
    }
}

