/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.se.dto.module;

import org.apache.commons.lang.ArrayUtils;
import org.qedeq.base.utility.EqualsUtility;
import org.qedeq.kernel.se.base.module.Conclusion;
import org.qedeq.kernel.se.base.module.ConditionalProof;
import org.qedeq.kernel.se.base.module.FormalProofLineList;
import org.qedeq.kernel.se.base.module.Formula;
import org.qedeq.kernel.se.base.module.Hypothesis;
import org.qedeq.kernel.se.base.module.Reason;

public class ConditionalProofVo
implements ConditionalProof {
    private Hypothesis hypothesis;
    private FormalProofLineList formalProofLineList;
    private Conclusion conclusion;

    public ConditionalProofVo(Hypothesis hypothesis, FormalProofLineList proofLines, Conclusion conclusion) {
        this.hypothesis = hypothesis;
        this.formalProofLineList = proofLines;
        this.conclusion = conclusion;
    }

    public ConditionalProofVo() {
    }

    public ConditionalProof getConditionalProof() {
        return this;
    }

    public Hypothesis getHypothesis() {
        return this.hypothesis;
    }

    public void setHypothesis(Hypothesis hypothesis) {
        this.hypothesis = hypothesis;
    }

    public String[] getReferences() {
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public void setFormalProofLineList(FormalProofLineList list) {
        this.formalProofLineList = list;
    }

    public FormalProofLineList getFormalProofLineList() {
        return this.formalProofLineList;
    }

    public Conclusion getConclusion() {
        return this.conclusion;
    }

    public void setConclusion(Conclusion conclusion) {
        this.conclusion = conclusion;
    }

    public Formula getFormula() {
        if (this.conclusion == null) {
            return null;
        }
        return this.conclusion.getFormula();
    }

    public String getLabel() {
        if (this.conclusion == null) {
            return null;
        }
        return this.conclusion.getLabel();
    }

    public String getName() {
        return "CP";
    }

    public Reason getReason() {
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConditionalProofVo)) {
            return false;
        }
        ConditionalProofVo other = (ConditionalProofVo)obj;
        return EqualsUtility.equals(this.hypothesis, other.hypothesis) && EqualsUtility.equals(this.formalProofLineList, other.formalProofLineList) && EqualsUtility.equals(this.conclusion, other.conclusion);
    }

    public int hashCode() {
        return (this.hypothesis != null ? this.hypothesis.hashCode() : 0) ^ (this.formalProofLineList != null ? 2 ^ this.formalProofLineList.hashCode() : 0) ^ (this.conclusion != null ? 4 ^ this.conclusion.hashCode() : 0);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getName());
        if (this.hypothesis != null || this.formalProofLineList != null || this.conclusion != null) {
            result.append(" (");
            if (this.hypothesis != null) {
                result.append("\n");
                result.append(this.hypothesis);
            }
            if (this.formalProofLineList != null) {
                result.append("\n");
                result.append(this.formalProofLineList);
            }
            if (this.conclusion != null) {
                result.append("\n");
                result.append(this.conclusion);
            }
            result.append("\n");
            result.append(")");
        }
        return result.toString();
    }
}

