/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.se.dto.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.qedeq.kernel.se.base.list.Atom;
import org.qedeq.kernel.se.base.list.Element;
import org.qedeq.kernel.se.base.list.ElementList;

public final class DefaultElementList
implements ElementList {
    private final String operator;
    private final List elements;

    public DefaultElementList(String operator) {
        if (operator == null) {
            throw new IllegalArgumentException("NullPointer as operator is not allowed");
        }
        this.operator = operator;
        this.elements = new ArrayList();
    }

    public DefaultElementList(String operator, Element[] elements) {
        if (operator == null) {
            throw new IllegalArgumentException("NullPointer as operator is not allowed");
        }
        if (elements == null) {
            throw new IllegalArgumentException("NullPointer as element array is not allowed");
        }
        this.operator = operator;
        this.elements = new ArrayList<Element>(Arrays.asList(elements));
    }

    public final boolean isAtom() {
        return false;
    }

    public final Atom getAtom() {
        throw new ClassCastException("this is no " + Atom.class.getName() + ", but a " + this.getClass().getName());
    }

    public final boolean isList() {
        return true;
    }

    public final ElementList getList() {
        return this;
    }

    public final String getOperator() {
        return this.operator;
    }

    public final int size() {
        return this.elements.size();
    }

    public final Element getElement(int i) {
        if (i >= 0 && i < this.elements.size()) {
            return (Element)this.elements.get(i);
        }
        if (this.size() == 0) {
            throw new IllegalArgumentException("there are no elements, therefore no element number " + i);
        }
        throw new IllegalArgumentException("there is no element number " + i + " the maximum element number is " + this.size());
    }

    public final List getElements() {
        return this.elements;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() == this.getClass()) {
            ElementList element = (ElementList)object;
            if (this.getOperator().equals(element.getOperator()) && this.size() == element.size()) {
                for (int i = 0; i < this.size(); ++i) {
                    if (((Object)this.getElement(i)).equals(element.getElement(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public final Element copy() {
        Element[] copied = new Element[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            copied[i] = this.getElement(i).copy();
        }
        return new DefaultElementList(this.getOperator(), copied);
    }

    public final Element replace(Element search, Element replacement) {
        if (this.equals(search)) {
            return replacement.copy();
        }
        Element[] replaced = new Element[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            replaced[i] = this.getElement(i).replace(search, replacement);
        }
        return new DefaultElementList(this.getOperator(), replaced);
    }

    public final void add(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("NullPointer couldn't be added");
        }
        this.elements.add(element);
    }

    public final void insert(int position, Element element) {
        if (element == null) {
            throw new IllegalArgumentException("NullPointer couldn't be inserted");
        }
        if (position < 0 || position > this.elements.size()) {
            throw new IllegalArgumentException("allowed set is {0" + (this.elements.size() > 0 ? ", .. " + this.elements.size() : "") + "}, and " + position + " is not in this set");
        }
        this.elements.add(position, element);
    }

    public final void replace(int position, Element element) {
        if (element == null) {
            throw new IllegalArgumentException("NullPointer is no element");
        }
        if (position >= 0 && position < this.elements.size()) {
            this.elements.set(position, element);
            return;
        }
        if (this.size() == 0) {
            throw new IllegalArgumentException("there are no elements, therefore no element number " + position + " could be replaced");
        }
        if (this.size() > 1) {
            throw new IllegalArgumentException("there is no element number " + position + ", you have to choose a number between 0 and " + (this.size() - 1));
        }
        throw new IllegalArgumentException("there is no element number " + position + ", you can only ask for the element at position 0");
    }

    public final void remove(int i) {
        if (i >= 0 && i < this.elements.size()) {
            this.elements.remove(i);
            return;
        }
        if (this.size() == 0) {
            throw new IllegalArgumentException("there are no elements, therefore no element number " + i + " could be removed");
        }
        throw new IllegalArgumentException("there is no element number " + i + " the maximum element number is " + this.size());
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public final String toString() {
        if (this.size() > 0) {
            StringBuffer buffer = new StringBuffer(this.getOperator() + " ( ");
            for (int i = 0; i < this.size(); ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.getElement(i));
            }
            buffer.append(")");
            return buffer.toString();
        }
        return this.getOperator();
    }
}

