/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.se.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.qedeq.base.io.IoUtility;

final class ConfigAccess {
    private final File configFile;
    private Properties properties = new Properties();
    private final String description;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigAccess(File configFile, String description) throws IOException {
        this.configFile = configFile;
        this.description = description;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(configFile);
            this.load(stream);
        }
        catch (IOException e) {
            try {
                System.out.println("no config file found, using default values");
            }
            catch (Throwable throwable) {
                IoUtility.close(stream);
                throw throwable;
            }
            IoUtility.close(stream);
        }
        IoUtility.close(stream);
        this.setString("configFileLocation", configFile.getCanonicalPath());
    }

    public final File getConfigFile() {
        return this.configFile;
    }

    public final String getConfigDescription() {
        return this.description;
    }

    private final Properties getProperties() {
        return this.properties;
    }

    private final void load(InputStream inStream) throws IOException {
        this.getProperties().load(inStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void store() throws IOException {
        OutputStream out = null;
        try {
            File file = this.getConfigFile();
            IoUtility.createNecessaryDirectories(file);
            out = new FileOutputStream(file);
            this.getProperties().store(out, this.getConfigDescription());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(e.toString());
                }
            }
        }
    }

    public final String getString(String name) {
        return this.getProperties().getProperty(name);
    }

    public final String getString(String name, String defaultValue) {
        String value = this.getProperties().getProperty(name);
        if (value == null) {
            this.setString(name, defaultValue);
            return defaultValue;
        }
        return value;
    }

    public final void setString(String name, String value) {
        this.getProperties().setProperty(name, value);
    }

    public final String[] getStringProperties(String namePrefix) {
        ArrayList<Object> list = new ArrayList<Object>();
        Enumeration<Object> keys = this.getProperties().keys();
        ArrayList<Object> keyList = Collections.list(keys);
        Collections.sort(keyList);
        for (int i = 0; i < keyList.size(); ++i) {
            String key = (String)keyList.get(i);
            if (!key.startsWith(namePrefix)) continue;
            list.add(this.getProperties().get(key));
        }
        return list.toArray(new String[list.size()]);
    }

    public final Map getProperties(String namePrefix) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Iterator<Map.Entry<Object, Object>> i = this.getProperties().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> entry = i.next();
            String name = String.valueOf(entry.getKey());
            if (!name.startsWith(namePrefix)) continue;
            result.put(name.substring(namePrefix.length()), entry.getValue());
        }
        return result;
    }

    public final void setInteger(String name, int value) {
        this.setString(name, "" + value);
    }

    public final int getInteger(String name) {
        String intPropAsString = this.getProperties().getProperty(name);
        if (intPropAsString == null) {
            throw new NullPointerException("property \"" + name + "\" not found");
        }
        try {
            return Integer.parseInt(intPropAsString);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("int property " + intPropAsString + " has invalid format");
        }
    }

    public final int getInteger(String name, int defaultValue) {
        String intPropAsString = this.getProperties().getProperty(name);
        if (intPropAsString == null || intPropAsString.length() == 0) {
            this.setInteger(name, defaultValue);
            return defaultValue;
        }
        try {
            return Integer.parseInt(intPropAsString);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Integer-Property " + intPropAsString + " has invalid format");
        }
    }

    public final void removeProperty(String name) {
        this.getProperties().remove(name);
    }

    public final void removeProperties(String namePrefix) {
        Enumeration<Object> keys = this.getProperties().keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(namePrefix)) continue;
            this.getProperties().remove(key);
        }
    }
}

