/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.se.common;

import java.io.IOException;
import org.qedeq.base.io.SourceArea;
import org.qedeq.base.io.SourcePosition;
import org.qedeq.base.utility.EqualsUtility;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.QedeqException;

public class SourceFileException
extends QedeqException {
    private static final long serialVersionUID = -4109767904038020052L;
    private final Plugin plugin;
    private final SourceArea errorArea;
    private final SourceArea referenceArea;

    public SourceFileException(Plugin plugin, int errorCode, String errorText, Throwable exception, SourceArea errorArea, SourceArea referenceArea) {
        super(errorCode, errorText, exception);
        this.plugin = plugin;
        this.errorArea = errorArea;
        this.referenceArea = referenceArea;
    }

    public SourceFileException(Plugin plugin, QedeqException exception, SourceArea errorArea, SourceArea referenceArea) {
        this(plugin, exception.getErrorCode(), exception.getMessage(), exception, errorArea, referenceArea);
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public SourceArea getSourceArea() {
        return this.errorArea;
    }

    public SourceArea getReferenceArea() {
        return this.referenceArea;
    }

    public String getMessage() {
        if (this.getCause() != null) {
            if (this.getCause().getCause() != null) {
                return this.getText(super.getMessage(), this.getCause().getCause());
            }
            return this.getText(super.getMessage(), this.getCause());
        }
        return super.getMessage();
    }

    private String getText(String message, Throwable cause) {
        if (message != null) {
            if (message.equals(cause.getMessage())) {
                return message;
            }
            if (cause instanceof IOException || cause instanceof NullPointerException) {
                return message + "; " + cause.toString();
            }
            return message + "; " + cause.getMessage();
        }
        return cause.toString();
    }

    public String getDescription() {
        StringBuffer buffer = new StringBuffer();
        if (this.errorArea != null && this.errorArea.getStartPosition() != null) {
            SourcePosition start = this.errorArea.getStartPosition();
            buffer.append(this.errorArea.getAddress() + ":" + start.getRow() + ":" + start.getColumn());
            buffer.append("\n");
        }
        buffer.append("\t" + this.getErrorCode() + ": " + this.getMessage());
        return buffer.toString();
    }

    public final int hashCode() {
        return this.getErrorCode() ^ (this.errorArea != null ? this.errorArea.hashCode() : 13) ^ (this.getPlugin() != null ? this.getPlugin().hashCode() : 131) ^ (this.getMessage() != null ? this.getMessage().hashCode() : 499);
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof SourceFileException)) {
            return false;
        }
        SourceFileException other = (SourceFileException)obj;
        return this.getErrorCode() == other.getErrorCode() && EqualsUtility.equals(this.getPlugin(), other.getPlugin()) && EqualsUtility.equals(this.getMessage(), other.getMessage()) && EqualsUtility.equals(this.errorArea, other.errorArea);
    }

    public final String toString() {
        return this.getDescription();
    }
}

