/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.se.common;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.qedeq.base.io.Path;
import org.qedeq.base.io.UrlUtility;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.kernel.se.base.module.LocationList;
import org.qedeq.kernel.se.base.module.Specification;
import org.qedeq.kernel.se.common.ModuleAddress;
import org.qedeq.kernel.se.common.ModuleContext;

public class DefaultModuleAddress
implements ModuleAddress {
    public static final DefaultModuleAddress MEMORY = new DefaultModuleAddress();
    private static final Class CLASS = DefaultModuleAddress.class;
    private final String url;
    private final String header;
    private final String path;
    private final String fileName;
    private final boolean relativeAddress;
    private final boolean fileAddress;
    private final String name;

    public DefaultModuleAddress(String u) throws MalformedURLException {
        this(u, (ModuleAddress)null);
    }

    public DefaultModuleAddress(URL u) throws MalformedURLException {
        this(u.toExternalForm(), (ModuleAddress)null);
    }

    public DefaultModuleAddress(File file) throws IOException {
        this(UrlUtility.toUrl(file.getCanonicalFile()));
    }

    public DefaultModuleAddress() {
        this(true, "default");
    }

    public DefaultModuleAddress(boolean memory, String identifier) {
        if (!memory) {
            throw new IllegalArgumentException("memory must be true");
        }
        if (identifier == null) {
            throw new NullPointerException();
        }
        this.url = "memory://" + identifier;
        this.name = identifier;
        this.fileAddress = false;
        this.fileName = identifier;
        this.header = "memory:";
        this.path = "";
        this.relativeAddress = false;
    }

    public DefaultModuleAddress(String address, ModuleAddress parent) throws MalformedURLException {
        String mname;
        URL urmel;
        String method = "ModuleAddress(String, ModuleAddress)";
        if (address == null) {
            throw new NullPointerException();
        }
        try {
            urmel = parent != null ? new URL(new URL(StringUtility.replace(parent.getUrl(), "file://", "file:")), address) : new URL(address);
        }
        catch (MalformedURLException e) {
            Trace.trace(CLASS, (Object)this, "ModuleAddress(String, ModuleAddress)", "address=" + address);
            Trace.trace(CLASS, (Object)this, "ModuleAddress(String, ModuleAddress)", "parent=" + parent);
            Trace.trace(CLASS, (Object)this, "ModuleAddress(String, ModuleAddress)", (Throwable)e);
            try {
                String newAddress = "file:" + address;
                urmel = parent != null ? new URL(new URL(parent.getUrl()), newAddress) : new URL(newAddress);
            }
            catch (MalformedURLException ex) {
                throw e;
            }
        }
        Path p = new Path(urmel.getPath());
        this.path = p.getDirectory();
        this.fileName = p.getFileName();
        Trace.trace(CLASS, (Object)this, "ModuleAddress(String, ModuleAddress)", "path=" + this.path);
        Trace.trace(CLASS, (Object)this, "ModuleAddress(String, ModuleAddress)", "fileName=" + this.fileName);
        this.relativeAddress = p.isRelative();
        if (!this.fileName.endsWith(".xml")) {
            throw new MalformedURLException("file name doesn't end with \".xml\": " + this.fileName);
        }
        Trace.trace(CLASS, (Object)this, "ModuleAddress(String, ModuleAddress)", "protocol=" + urmel.getProtocol());
        this.fileAddress = urmel.getProtocol().equalsIgnoreCase("file");
        String urm = urmel.toString();
        Trace.trace(CLASS, (Object)this, "ModuleAddress(String, ModuleAddress)", "replacing " + urmel.getPath() + " by " + p.toString());
        urm = StringUtility.replace(urm, urmel.getPath(), p.toString());
        if (this.fileAddress && urm.startsWith("file:") && !urm.startsWith("file://")) {
            urm = "file://" + urm.substring("file:".length());
        }
        this.url = urm;
        int positionBefore = this.fileName.lastIndexOf(".");
        this.name = mname = this.fileName.substring(0, positionBefore);
        int positionPath = this.url.lastIndexOf(p.toString());
        if (positionPath < 0) {
            throw new IllegalArgumentException("couldn't determine begin of file path: " + this.url + "\nsearching for: " + p);
        }
        this.header = this.url.substring(0, positionPath);
    }

    public ModuleContext createModuleContext() {
        return new ModuleContext(this);
    }

    public String getHeader() {
        return this.header;
    }

    public String getPath() {
        return this.path;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isRelativeAddress() {
        return this.relativeAddress;
    }

    public boolean isFileAddress() {
        return this.fileAddress;
    }

    public final String toString() {
        return this.url;
    }

    public final int hashCode() {
        return this.url.hashCode();
    }

    public final boolean equals(Object object) {
        if (!(object instanceof DefaultModuleAddress)) {
            return false;
        }
        return this.url.equals(((DefaultModuleAddress)object).url);
    }

    private static final String getModuleFileName(Specification spec) {
        return spec.getName() + ".xml";
    }

    public final ModuleAddress[] getModulePaths(Specification spec) throws IOException {
        String fileNameEnd = DefaultModuleAddress.getModuleFileName(spec);
        LocationList locations = spec.getLocationList();
        ArrayList<DefaultModuleAddress> result = new ArrayList<DefaultModuleAddress>();
        for (int i = 0; locations != null && i < locations.size(); ++i) {
            if (locations.get(i) == null) continue;
            String file = locations.get(i).getLocation();
            if (file.equals(".")) {
                file = "";
            } else if (!file.endsWith("/")) {
                file = file + "/";
            }
            file = file + fileNameEnd;
            result.add(new DefaultModuleAddress(file, this));
        }
        return result.toArray(new ModuleAddress[0]);
    }

    public static final String createRelativeAddress(String origin, String next) {
        URL urlOrgin;
        if (origin.equals(next)) {
            return "";
        }
        try {
            urlOrgin = new URL(origin);
        }
        catch (MalformedURLException e) {
            return DefaultModuleAddress.createRelative(origin, next);
        }
        try {
            URL urlNext = new URL(next);
            if (urlOrgin.getProtocol().equals(urlNext.getProtocol()) && urlOrgin.getHost().equals(urlNext.getHost()) && urlOrgin.getPort() == urlNext.getPort()) {
                String org = urlOrgin.getFile();
                String nex = urlNext.getFile();
                return DefaultModuleAddress.createRelative(org, nex);
            }
            return urlNext.toString();
        }
        catch (MalformedURLException e) {
            return next;
        }
    }

    public static String createRelative(String org, String nex) {
        Path from = new Path(org);
        return from.createRelative(nex).toString();
    }
}

