/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service.unicode;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import org.qedeq.base.io.Parameters;
import org.qedeq.base.io.TextOutput;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.KernelContext;
import org.qedeq.kernel.bo.log.QedeqLog;
import org.qedeq.kernel.bo.module.InternalServiceProcess;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.PluginExecutor;
import org.qedeq.kernel.bo.service.unicode.Qedeq2UnicodeVisitor;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileExceptionList;

public class Qedeq2Utf8Executor
implements PluginExecutor {
    private static final Class CLASS = Qedeq2Utf8Executor.class;
    private TextOutput printer;
    private File destination;
    private final Qedeq2UnicodeVisitor visitor;
    private int maxColumns;
    private String[] languages;
    private int run = 0;

    public Qedeq2Utf8Executor(Plugin plugin, KernelQedeqBo prop, Parameters parameters) {
        boolean info = parameters.getBoolean("info");
        this.maxColumns = parameters.getInt("maximumColumn");
        if (parameters.getInt("maximumColumn") != 0) {
            this.maxColumns = Math.max(10, this.maxColumns);
        }
        boolean brief = parameters.getBoolean("brief");
        this.visitor = new Qedeq2UnicodeVisitor(plugin, prop, info, this.maxColumns, true, brief);
    }

    public Object executePlugin(InternalServiceProcess process, Object data) {
        String method = "executePlugin()";
        try {
            String result;
            QedeqLog.getInstance().logRequest("Generate UTF-8", this.visitor.getQedeqBo().getUrl());
            this.languages = this.visitor.getQedeqBo().getSupportedLanguages();
            this.run = 0;
            while (this.run < this.languages.length) {
                result = this.generateUtf8(process, this.languages[this.run], "1");
                if (this.languages[this.run] != null) {
                    QedeqLog.getInstance().logSuccessfulReply("UTF-8 for language \"" + this.languages[this.run] + "\" was generated into \"" + result + "\"", this.visitor.getQedeqBo().getUrl());
                } else {
                    QedeqLog.getInstance().logSuccessfulReply("UTF-8 for default language was generated into \"" + result + "\"", this.visitor.getQedeqBo().getUrl());
                }
                ++this.run;
            }
            if (this.languages.length == 0) {
                QedeqLog.getInstance().logMessage("no supported language found, assuming 'en'");
                result = this.generateUtf8(process, "en", "1");
                QedeqLog.getInstance().logSuccessfulReply("UTF-8 for language \"en\" was generated into \"" + result + "\"", this.visitor.getQedeqBo().getUrl());
            }
        }
        catch (SourceFileExceptionList e) {
            String msg = "Generation failed";
            Trace.fatal(CLASS, this, "executePlugin()", "Generation failed", e);
            QedeqLog.getInstance().logFailureReply("Generation failed", this.visitor.getQedeqBo().getUrl(), e.getMessage());
        }
        catch (IOException e) {
            String msg = "Generation failed";
            Trace.fatal(CLASS, this, "executePlugin()", "Generation failed", e);
            QedeqLog.getInstance().logFailureReply("Generation failed", this.visitor.getQedeqBo().getUrl(), e.getMessage());
        }
        catch (RuntimeException e) {
            Trace.fatal(CLASS, this, "executePlugin()", "unexpected problem", e);
            QedeqLog.getInstance().logFailureReply("Generation failed", this.visitor.getQedeqBo().getUrl(), "unexpected problem: " + (e.getMessage() != null ? e.getMessage() : e.toString()));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateUtf8(InternalServiceProcess process, String language, String level) throws SourceFileExceptionList, IOException {
        String txt;
        try {
            this.visitor.getQedeqBo().getKernelServices().loadRequiredModules(this.visitor.getQedeqBo(), process);
            this.visitor.getQedeqBo().getKernelServices().checkWellFormedness(this.visitor.getQedeqBo(), process);
        }
        catch (Exception e) {
            Trace.trace(CLASS, "generateUtf8(KernelQedeqBo, String, String)", e);
        }
        String lan = "en";
        if (language != null) {
            lan = language;
        }
        if ((txt = this.visitor.getQedeqBo().getModuleAddress().getFileName()).toLowerCase(Locale.US).endsWith(".xml")) {
            txt = txt.substring(0, txt.length() - 4);
        }
        if (lan.length() > 0) {
            txt = txt + "_" + lan;
        }
        this.destination = new File(KernelContext.getInstance().getConfig().getGenerationDirectory(), txt + ".txt").getCanonicalFile();
        this.printer = new TextOutput(this.visitor.getQedeqBo().getName(), new FileOutputStream(this.destination), "UTF-8");
        try {
            this.visitor.generateUtf8(process, this.printer, lan, level);
            Object var7_7 = null;
            this.printer.flush();
            this.printer.close();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.printer.flush();
            this.printer.close();
            throw throwable;
        }
        if (this.printer.checkError()) {
            throw this.printer.getError();
        }
        return this.destination.toString();
    }

    public String getLocationDescription() {
        if (this.languages != null && this.run < this.languages.length) {
            return this.languages[this.run] + " " + this.visitor.getLocationDescription();
        }
        if (this.languages != null && this.languages.length > 0) {
            return this.languages[this.languages.length] + " " + this.visitor.getLocationDescription();
        }
        return "unknown";
    }

    public double getExecutionPercentage() {
        return this.visitor.getExecutionPercentage() / (double)this.languages.length * (double)(this.run + 1);
    }

    public boolean getInterrupted() {
        return this.visitor.getInterrupted();
    }
}

