/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service.unicode;

import java.io.IOException;
import org.qedeq.base.io.Parameters;
import org.qedeq.base.io.StringOutput;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.common.ServiceProcess;
import org.qedeq.kernel.bo.log.QedeqLog;
import org.qedeq.kernel.bo.module.InternalServiceProcess;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.PluginExecutor;
import org.qedeq.kernel.bo.service.unicode.Qedeq2UnicodeVisitor;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileExceptionList;

public final class Qedeq2UnicodeTextExecutor
implements PluginExecutor {
    private static final Class CLASS = Qedeq2UnicodeTextExecutor.class;
    private StringOutput printer;
    private String language;
    private final Qedeq2UnicodeVisitor visitor;

    Qedeq2UnicodeTextExecutor(Plugin plugin, KernelQedeqBo prop, Parameters parameters) {
        this.language = parameters.getString("language");
        boolean info = parameters.getBoolean("info");
        int maxColumns = parameters.getInt("maximumColumn");
        maxColumns = Math.max(10, maxColumns);
        this.visitor = new Qedeq2UnicodeVisitor(plugin, prop, info, maxColumns, false, false);
    }

    public Object executePlugin(InternalServiceProcess process, Object data) {
        String method = "executePlugin()";
        String result = "";
        try {
            QedeqLog.getInstance().logRequest("Show UTF-8 text", this.visitor.getQedeqBo().getUrl());
            result = this.generateUtf8(process, this.language, "1");
            QedeqLog.getInstance().logSuccessfulReply("UTF-8 text was shown", this.visitor.getQedeqBo().getUrl());
        }
        catch (SourceFileExceptionList e) {
            String msg = "Generation failed";
            Trace.fatal(CLASS, this, "executePlugin()", "Generation failed", e);
            QedeqLog.getInstance().logFailureReply("Generation failed", this.visitor.getQedeqBo().getUrl(), e.getMessage());
        }
        catch (IOException e) {
            String msg = "Generation failed";
            Trace.fatal(CLASS, this, "executePlugin()", "Generation failed", e);
            QedeqLog.getInstance().logFailureReply("Generation failed", this.visitor.getQedeqBo().getUrl(), e.getMessage());
        }
        catch (RuntimeException e) {
            Trace.fatal(CLASS, this, "executePlugin()", "unexpected problem", e);
            QedeqLog.getInstance().logFailureReply("Generation failed", this.visitor.getQedeqBo().getUrl(), "unexpected problem: " + (e.getMessage() != null ? e.getMessage() : e.toString()));
        }
        return result;
    }

    public String generateUtf8(ServiceProcess process, String language, String level) throws SourceFileExceptionList, IOException {
        String lan = "en";
        if (language != null) {
            lan = language;
        }
        this.printer = new StringOutput();
        this.visitor.generateUtf8(process, this.printer, lan, level);
        return this.printer.toString();
    }

    public String getLocationDescription() {
        return this.visitor.getLocationDescription();
    }

    public double getExecutionPercentage() {
        return this.visitor.getExecutionPercentage();
    }

    public boolean getInterrupted() {
        return this.visitor.getInterrupted();
    }
}

