/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service.unicode;

public final class Latex2UnicodeSpecials {
    private static final String SUBSCRIPT_CHARACTERS = "0123456789()+-=";
    private static final String SUPERSCRIPT_CHARACTERS = "0123456789()+-=n";

    private Latex2UnicodeSpecials() {
    }

    public static String transform2Bold(String token) {
        StringBuffer buffer = new StringBuffer();
        block4: for (int i = 0; i < token.length(); ++i) {
            char c = token.charAt(i);
            switch (c) {
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': {
                    buffer.append((char)(65248 + c));
                    continue block4;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    buffer.append((char)(65248 + c));
                    continue block4;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    public static String transform2Mathfrak(String token) {
        StringBuffer buffer = new StringBuffer();
        block23: for (int i = 0; i < token.length(); ++i) {
            char c = token.charAt(i);
            switch (c) {
                case 'A': {
                    buffer.append("\u13af");
                    continue block23;
                }
                case 'B': {
                    buffer.append("\u212c");
                    continue block23;
                }
                case 'b': {
                    buffer.append("\u13b2");
                    continue block23;
                }
                case 'C': {
                    buffer.append("\u212d");
                    continue block23;
                }
                case 'E': {
                    buffer.append("\u2130");
                    continue block23;
                }
                case 'e': {
                    buffer.append("\u212f");
                    continue block23;
                }
                case 'F': {
                    buffer.append("\u2131");
                    continue block23;
                }
                case 'G': {
                    buffer.append("\u13b6");
                    continue block23;
                }
                case 'g': {
                    buffer.append("\u210a");
                    continue block23;
                }
                case 'L': {
                    buffer.append("\u2112");
                    continue block23;
                }
                case 'l': {
                    buffer.append("\u2113");
                    continue block23;
                }
                case 'M': {
                    buffer.append("\u2133");
                    continue block23;
                }
                case 'o': {
                    buffer.append("\u2134");
                    continue block23;
                }
                case 'P': {
                    buffer.append("\u2118");
                    continue block23;
                }
                case 'R': {
                    buffer.append("\u211b");
                    continue block23;
                }
                case 'S': {
                    buffer.append("\u093d");
                    continue block23;
                }
                case 's': {
                    buffer.append("\u0d1f");
                    continue block23;
                }
                case 'T': {
                    buffer.append("\u01ac");
                    continue block23;
                }
                case 'V': {
                    buffer.append("\u01b2");
                    continue block23;
                }
                case 'Y': {
                    buffer.append("\u01b3");
                    continue block23;
                }
                case 'Z': {
                    buffer.append("\u2128");
                    continue block23;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    public static String transform2Subscript(String content) {
        int i;
        StringBuffer buffer = new StringBuffer();
        boolean supported = true;
        for (i = 0; i < content.length(); ++i) {
            if (SUBSCRIPT_CHARACTERS.indexOf(content.charAt(i)) >= 0) continue;
            supported = false;
            break;
        }
        if (!supported) {
            if (content.length() == 1) {
                buffer.append("_" + content);
            } else {
                buffer.append("_(" + content + ")");
            }
        } else {
            block9: for (i = 0; i < content.length(); ++i) {
                char c = content.charAt(i);
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        buffer.append((char)(c - 48 + 8320));
                        continue block9;
                    }
                    case '+': {
                        buffer.append('\u208a');
                        continue block9;
                    }
                    case '-': {
                        buffer.append('\u208b');
                        continue block9;
                    }
                    case '=': {
                        buffer.append('\u208c');
                        continue block9;
                    }
                    case '(': {
                        buffer.append('\u208d');
                        continue block9;
                    }
                    case ')': {
                        buffer.append('\u208e');
                        continue block9;
                    }
                    default: {
                        buffer.append(c);
                    }
                }
            }
        }
        return buffer.toString();
    }

    public static String transform2Superscript(String content) {
        int i;
        StringBuffer buffer = new StringBuffer();
        boolean supported = true;
        for (i = 0; i < content.length(); ++i) {
            if (SUPERSCRIPT_CHARACTERS.indexOf(content.charAt(i)) >= 0) continue;
            supported = false;
            break;
        }
        if (!supported) {
            if (content.length() == 1) {
                buffer.append("^" + content);
            } else {
                buffer.append("^(" + content + ")");
            }
        } else {
            block14: for (i = 0; i < content.length(); ++i) {
                char c = content.charAt(i);
                switch (c) {
                    case '0': {
                        buffer.append((char)(c - 48 + 8304));
                        continue block14;
                    }
                    case '1': {
                        buffer.append((char)(c - 48 + 185));
                        continue block14;
                    }
                    case '2': {
                        buffer.append((char)(c - 48 + 178));
                        continue block14;
                    }
                    case '3': {
                        buffer.append((char)(c - 48 + 179));
                        continue block14;
                    }
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        buffer.append((char)(c - 52 + 8308));
                        continue block14;
                    }
                    case '+': {
                        buffer.append('\u207a');
                        continue block14;
                    }
                    case '-': {
                        buffer.append('\u207b');
                        continue block14;
                    }
                    case '=': {
                        buffer.append('\u207c');
                        continue block14;
                    }
                    case '(': {
                        buffer.append('\u207d');
                        continue block14;
                    }
                    case ')': {
                        buffer.append('\u207e');
                        continue block14;
                    }
                    case 'n': {
                        buffer.append('\u207f');
                        continue block14;
                    }
                    default: {
                        buffer.append(c);
                    }
                }
            }
        }
        return buffer.toString();
    }

    public static String transform2Emph(String token) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < token.length(); ++i) {
            buffer.append(' ');
            buffer.append(token.charAt(i));
        }
        return buffer.toString();
    }
}

