/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service.unicode;

import java.util.Stack;
import org.qedeq.base.io.AbstractOutput;
import org.qedeq.base.io.SourcePosition;
import org.qedeq.base.io.StringOutput;
import org.qedeq.base.io.SubTextInput;
import org.qedeq.base.io.TextInput;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.service.unicode.Latex2UnicodeSpecials;
import org.qedeq.kernel.bo.service.unicode.ReferenceFinder;

public final class Latex2UnicodeParser {
    private static final Class CLASS = Latex2UnicodeParser.class;
    private static final String SPECIALCHARACTERS = "(),{}\\~%$&'`^_-";
    private final AbstractOutput output;
    private final ReferenceFinder finder;
    private SubTextInput input;
    private boolean mathMode = false;
    private boolean mathfrak = false;
    private boolean emph = false;
    private boolean bold = false;
    private boolean mathbb = false;
    private Stack inputStack = new Stack();
    private Stack mathModeStack = new Stack();
    private Stack mathfrakStack = new Stack();
    private Stack emphStack = new Stack();
    private Stack boldStack = new Stack();
    private Stack mathbbStack = new Stack();
    private Stack skipWhitespaceStack = new Stack();
    private boolean skipWhitespace;
    private int tokenBegin;
    private int tokenEnd;
    private int itemNumber;

    public static final String transform(ReferenceFinder finder, String input, int columns) {
        Latex2UnicodeParser parser = new Latex2UnicodeParser(finder);
        parser.output.setColumns(columns);
        return parser.getUtf8(input);
    }

    private Latex2UnicodeParser(ReferenceFinder finder) {
        this.finder = finder == null ? new ReferenceFinder(){

            public String getReferenceLink(String reference, SourcePosition startDelta, SourcePosition endDelta) {
                return "[" + reference + "]";
            }

            public void addWarning(int code, String msg, SourcePosition startDelta, SourcePosition endDelta) {
            }
        } : finder;
        this.output = new StringOutput();
    }

    private String getUtf8(String text) {
        this.skipWhitespace = true;
        this.input = new SubTextInput(text);
        this.parseAndPrint(this.input);
        return this.output.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseAndPrint(SubTextInput input) {
        this.inputStack.push(this.input);
        this.mathModeStack.push(this.mathMode);
        this.mathfrakStack.push(this.mathfrak);
        this.emphStack.push(this.emph);
        this.boldStack.push(this.bold);
        this.mathbbStack.push(this.mathbb);
        this.skipWhitespaceStack.push(this.skipWhitespace);
        try {
            this.input = input;
            boolean whitespace = false;
            while (!this.eof()) {
                Object content;
                String token = this.readToken();
                if (!token.startsWith("\\")) {
                    token = token.trim();
                }
                if (token.length() == 0) {
                    whitespace = true;
                    continue;
                }
                if (whitespace && !"\\par".equals(token)) {
                    this.print(" ");
                    whitespace = false;
                }
                if ("\\begin".equals(token)) {
                    this.parseBegin();
                    continue;
                }
                if ("\\footnote".equals(token)) {
                    this.parseFootnote();
                    continue;
                }
                if ("\\qref".equals(token)) {
                    this.parseQref();
                    continue;
                }
                if ("$$".equals(token)) {
                    this.mathMode = true;
                    content = this.readTilToken(token);
                    this.println();
                    this.parseAndPrint((SubTextInput)content);
                    this.println();
                    this.mathMode = false;
                    continue;
                }
                if ("$".equals(token)) {
                    this.mathMode = true;
                    content = this.readTilToken(token);
                    this.parseAndPrint((SubTextInput)content);
                    this.mathMode = false;
                    continue;
                }
                if ("\\mathfrak".equals(token)) {
                    if (123 == this.getChar()) {
                        this.mathfrak = true;
                        content = this.readCurlyBraceContents();
                        this.parseAndPrint((SubTextInput)content);
                        this.mathfrak = false;
                        continue;
                    }
                    this.mathfrak = true;
                    continue;
                }
                if ("\\mathbb".equals(token)) {
                    if (123 == this.getChar()) {
                        this.mathbb = true;
                        content = this.readCurlyBraceContents();
                        this.parseAndPrint((SubTextInput)content);
                        this.mathbb = false;
                        continue;
                    }
                    this.mathbb = true;
                    continue;
                }
                if ("\\emph".equals(token)) {
                    if (123 == this.getChar()) {
                        this.emph = true;
                        content = this.readCurlyBraceContents();
                        this.parseAndPrint((SubTextInput)content);
                        this.output.addWs(" ");
                        this.emph = false;
                        continue;
                    }
                    this.emph = true;
                    continue;
                }
                if ("\\textbf".equals(token)) {
                    if (123 == this.getChar()) {
                        this.bold = true;
                        content = this.readCurlyBraceContents();
                        this.parseAndPrint((SubTextInput)content);
                        this.bold = false;
                        continue;
                    }
                    this.bold = true;
                    continue;
                }
                if ("\\cite".equals(token)) {
                    if (123 != this.getChar()) continue;
                    content = this.readCurlyBraceContents();
                    this.output.addToken("[" + ((TextInput)content).asString() + "]");
                    continue;
                }
                if ("\\tag".equals(token)) {
                    if (123 != this.getChar()) continue;
                    content = this.readCurlyBraceContents();
                    this.output.addToken("(" + ((TextInput)content).asString() + ")");
                    continue;
                }
                if ("\\mbox".equals(token)) {
                    if (123 != this.getChar()) continue;
                    content = this.readCurlyBraceContents();
                    this.parseAndPrint((SubTextInput)content);
                    continue;
                }
                if ("\\cline".equals(token)) {
                    if (123 == this.getChar()) {
                        this.readCurlyBraceContents();
                    }
                    this.output.addToken("_______________________________________");
                    this.println();
                    continue;
                }
                if ("\\item".equals(token)) {
                    this.output.popLevel(3);
                    ++this.itemNumber;
                    this.output.println();
                    this.output.addToken(this.itemNumber + ".");
                    this.output.addWs("");
                    this.output.pushLevel("   ");
                    this.output.setTabLevel();
                    continue;
                }
                if ("{".equals(token)) {
                    input.readInverse();
                    content = this.readCurlyBraceContents();
                    this.parseAndPrint((SubTextInput)content);
                    continue;
                }
                if ("\\url".equals(token)) {
                    content = this.readCurlyBraceContents();
                    this.output.addToken(" " + ((TextInput)content).asString() + " ");
                    continue;
                }
                if (123 == this.getChar() && ("\\index".equals(token) || "\\label".equals(token) || token.equals("\\vspace") || token.equals("\\hspace") || token.equals("\\vspace*") || token.equals("\\hspace*"))) {
                    this.readCurlyBraceContents();
                    continue;
                }
                if ("_".equals(token) || "^".equals(token)) {
                    if (this.mathMode) {
                        content = 123 == this.getChar() ? this.readCurlyBraceContents().asString() : this.readToken();
                        if ("_".equals(token)) {
                            this.printSubscript((String)content);
                            continue;
                        }
                        this.printSuperscript((String)content);
                        continue;
                    }
                    this.print(token);
                    continue;
                }
                this.print(token);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.input = (SubTextInput)this.inputStack.pop();
            this.mathMode = (Boolean)this.mathModeStack.pop();
            this.mathfrak = (Boolean)this.mathfrakStack.pop();
            this.emph = (Boolean)this.emphStack.pop();
            this.bold = (Boolean)this.boldStack.pop();
            this.skipWhitespace = (Boolean)this.skipWhitespaceStack.pop();
            this.output.flush();
            throw throwable;
        }
        this.input = (SubTextInput)this.inputStack.pop();
        this.mathMode = (Boolean)this.mathModeStack.pop();
        this.mathfrak = (Boolean)this.mathfrakStack.pop();
        this.emph = (Boolean)this.emphStack.pop();
        this.bold = (Boolean)this.boldStack.pop();
        this.skipWhitespace = (Boolean)this.skipWhitespaceStack.pop();
        this.output.flush();
    }

    private void parseFootnote() {
        if (123 == this.getChar()) {
            SubTextInput content = this.readCurlyBraceContents();
            this.println();
            this.output.printWithoutSplit("          \u250c");
            this.output.pushLevel();
            this.output.pushLevel();
            this.output.pushLevel();
            this.output.pushLevel();
            this.output.pushLevel();
            this.output.pushLevel("\u2502 ");
            this.println();
            this.parseAndPrint(content);
            this.output.popLevel();
            this.output.popLevel();
            this.output.popLevel();
            this.output.popLevel();
            this.output.popLevel();
            this.output.popLevel();
            this.println();
            this.output.printWithoutSplit("          \u2514");
            this.println();
        }
    }

    private void parseQref() {
        String method = "parseQref()";
        int localStart1 = this.input.getAbsolutePosition();
        if (123 == this.getChar()) {
            SubTextInput content = this.readCurlyBraceContents();
            String ref = content.asString().trim();
            Trace.param(CLASS, (Object)this, "parseQref()", "ref", ref);
            if (ref.length() == 0) {
                this.addWarning(80008, "empty reference: \"\\qref{}\"", localStart1, this.input.getAbsolutePosition());
                return;
            }
            if (ref.length() > 1024) {
                this.addWarning(80007, "ending \"}\" for \"\\qref{\" not found within 1024 characters", localStart1, this.input.getAbsolutePosition());
                return;
            }
            if (ref.indexOf("{") >= 0) {
                this.addWarning(80007, "ending \"}\" for \"\\qref{\" not found within 1024 characters", localStart1, this.input.getAbsolutePosition());
                this.input.setAbsolutePosition(localStart1);
                return;
            }
            String display = this.finder.getReferenceLink(ref, this.getAbsoluteSourcePosition(localStart1), this.getAbsoluteSourcePosition(this.input.getAbsolutePosition()));
            this.output.addToken(display);
        }
    }

    private void parseBegin() {
        String kind = this.readCurlyBraceContents().asString();
        SubTextInput content = this.readSection(kind);
        if ("eqnarray".equals(kind) || "eqnarray*".equals(kind) || "equation*".equals(kind)) {
            this.mathMode = true;
            this.skipWhitespace = false;
            this.parseAndPrint(content);
            this.println();
            this.mathMode = false;
        } else if ("quote".equals(kind)) {
            this.output.pushLevel();
            this.output.pushLevel();
            this.output.pushLevel();
            this.println();
            this.parseAndPrint(content);
            this.println();
            this.output.popLevel();
            this.output.popLevel();
            this.output.popLevel();
        } else if ("tabularx".equals(kind)) {
            this.skipWhitespace = false;
            this.parseAndPrint(content);
        } else if ("enumerate".equals(kind)) {
            this.itemNumber = 0;
            this.output.pushLevel("   ");
            this.parseAndPrint(content);
            this.output.popLevel(3);
        } else if ("verbatim".equals(kind)) {
            String level = this.output.getLevel();
            this.output.setLevel("");
            this.print(content.asString());
            this.output.setLevel(level);
        } else {
            this.parseAndPrint(content);
        }
    }

    private void printSubscript(String content) {
        this.output.addToken(Latex2UnicodeSpecials.transform2Subscript(content));
    }

    private void printSuperscript(String content) {
        this.output.addToken(Latex2UnicodeSpecials.transform2Superscript(content));
    }

    private SubTextInput readSection(String kind) {
        String curly2;
        String item;
        int localStart;
        if (123 == this.getChar()) {
            this.readCurlyBraceContents();
        }
        if (123 == this.getChar()) {
            this.readCurlyBraceContents();
        }
        int current = localStart = this.input.getAbsolutePosition();
        do {
            current = this.input.getAbsolutePosition();
            item = this.readToken();
            if (item != null) continue;
            Trace.fatal(CLASS, this, "readSection", "not found: \\end{" + kind + "}", new IllegalArgumentException("from " + localStart + " to " + this.input.getAbsolutePosition() + this.input.getPosition()));
            break;
        } while (!"\\end".equals(item) || !kind.equals(curly2 = this.readCurlyBraceContents().asString()));
        return this.input.getSubTextInput(localStart, current);
    }

    private SubTextInput readTilToken(String token) {
        int localStart = this.input.getAbsolutePosition();
        StringBuffer buffer = new StringBuffer();
        int current = localStart;
        while (true) {
            current = this.input.getAbsolutePosition();
            String item = this.readToken();
            if (item == null) {
                Trace.fatal(CLASS, this, "readSection", "not found: " + token, new IllegalArgumentException("from " + localStart + " to " + current + this.input.getAbsolutePosition()));
                break;
            }
            if (token.equals(item)) break;
            buffer.append(item);
        }
        return this.input.getSubTextInput(localStart, current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String readToken() {
        String string;
        String method = "readToken()";
        Trace.begin(CLASS, this, "readToken()");
        this.tokenBegin = this.input.getAbsolutePosition();
        StringBuffer token = new StringBuffer();
        try {
            block8: do {
                if (this.eof()) {
                    if (token.length() > 0) break;
                    token = null;
                    break;
                }
                char c = (char)this.getChar();
                if (Character.isDigit(c)) {
                    token.append((char)this.read());
                    if (!Character.isDigit((char)this.getChar())) break;
                    continue;
                }
                if (Character.isLetter(c)) {
                    token.append((char)this.read());
                    if (!Character.isLetter((char)this.getChar())) break;
                    continue;
                }
                if (SPECIALCHARACTERS.indexOf(c) >= 0) {
                    switch (c) {
                        case '&': 
                        case '^': 
                        case '_': 
                        case '{': 
                        case '}': 
                        case '~': {
                            token.append((char)this.read());
                            break;
                        }
                        case '$': 
                        case '\'': 
                        case '-': 
                        case '`': {
                            token.append((char)this.read());
                            if (c != this.getChar()) break block8;
                            continue block8;
                        }
                        case '%': {
                            token.append((char)this.read());
                            if (c != this.getChar()) break block8;
                            token.append(this.readln());
                            token.setLength(0);
                            continue block8;
                        }
                        case '\\': {
                            if (32 == this.getChar()) {
                                token.append("\\");
                                token.append((char)this.read());
                                break;
                            }
                            String t = this.readBackslashToken();
                            token.append(t);
                            break;
                        }
                        default: {
                            this.read();
                            token.append(c);
                            break;
                        }
                    }
                    break;
                }
                token.append((char)this.read());
                if (95 != this.getChar() && 94 != this.getChar()) break;
                token.append((char)this.read());
            } while (!this.eof());
            Trace.param(CLASS, (Object)this, "readToken()", "Read token", token);
            this.tokenEnd = this.input.getAbsolutePosition();
            string = token != null ? token.toString() : null;
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            Trace.end(CLASS, this, "readToken()");
            throw throwable;
        }
        Trace.end(CLASS, this, "readToken()");
        return string;
    }

    private String readBackslashToken() {
        String method = "readBackslashToken()";
        Trace.begin(CLASS, this, "readBackslashToken()");
        if (this.getChar() != 92) {
            throw new IllegalArgumentException("\\ expected");
        }
        this.read();
        if (this.eof()) {
            Trace.param(CLASS, (Object)this, "readBackslashToken()", "return", null);
            Trace.end(CLASS, this, "readBackslashToken()");
            return null;
        }
        if (!Character.isLetter((char)this.getChar())) {
            Trace.param(CLASS, (Object)this, "readBackslashToken()", "return", (char)this.getChar());
            Trace.end(CLASS, this, "readBackslashToken()");
            return "\\" + (char)this.read();
        }
        StringBuffer buffer = new StringBuffer("\\");
        do {
            buffer.append((char)this.read());
        } while (!this.eof() && (Character.isLetter((char)this.getChar()) || '*' == (char)this.getChar()));
        Trace.param(CLASS, (Object)this, "readBackslashToken()", "return", buffer.toString());
        Trace.end(CLASS, this, "readBackslashToken()");
        return buffer.toString();
    }

    private SubTextInput readCurlyBraceContents() {
        int curlyStart;
        int localStart = this.input.getAbsolutePosition();
        String first = this.readToken();
        if (!"{".equals(first)) {
            this.addWarning(80016, "expected, but not found: \"{\"", localStart, this.input.getAbsolutePosition());
            throw new IllegalArgumentException("\"{\" expected, but was: \"" + first + "\"");
        }
        int curlyEnd = curlyStart = this.input.getAbsolutePosition();
        StringBuffer buffer = new StringBuffer();
        String next = "";
        int level = 1;
        while (level > 0 && this.getChar() != -1) {
            next = this.readToken();
            if ("{".equals(next)) {
                ++level;
            } else if ("}".equals(next)) {
                --level;
            }
            if (level <= 0) break;
            buffer.append(next);
            curlyEnd = this.input.getAbsolutePosition();
        }
        if (!"}".equals(next)) {
            this.addWarning(80017, "ending \"}\" for \"{\" not found", localStart, this.input.getAbsolutePosition());
            buffer.setLength(0);
            this.input.setAbsolutePosition(curlyStart);
            curlyEnd = curlyStart;
        }
        return this.input.getSubTextInput(curlyStart, curlyEnd);
    }

    private final void print(String token) {
        if (token.trim().length() == 0 && this.skipWhitespace) {
            return;
        }
        this.skipWhitespace = false;
        if (token.equals("\\par")) {
            this.println();
            this.println();
            this.skipWhitespace = true;
        } else if (token.equals("\\\\")) {
            this.println();
        } else if (token.equals("&")) {
            this.output.addWs(" ");
        } else if (!token.equals("\\-")) {
            if (token.equals("--")) {
                this.output.addToken("\u2012");
            } else if (token.equals("`")) {
                this.output.addWs("\u2018");
            } else if (token.equals("'")) {
                this.output.addToken("\u2019");
            } else if (token.equals("\\neq")) {
                this.output.addToken("\u2260");
            } else if (token.equals("\\in")) {
                this.output.addToken("\u2208");
            } else if (token.equals("\\forall")) {
                this.output.addToken("\u2200");
            } else if (token.equals("\\exists")) {
                this.output.addToken("\u2203");
            } else if (token.equals("\\emptyset")) {
                this.output.addToken("\u2205");
            } else if (token.equals("\\rightarrow")) {
                this.output.addToken("\u2192");
            } else if (token.equals("\\Rightarrow")) {
                this.output.addToken("\u21d2");
            } else if (token.equals("\\leftrightarrow")) {
                this.output.addToken("\u2194");
            } else if (token.equals("\\Leftarrow")) {
                this.output.addToken("\u21d0");
            } else if (token.equals("\\Leftrightarrow")) {
                this.output.addToken("\u21d4");
            } else if (token.equals("\\langle")) {
                this.output.addToken("\u2329");
            } else if (token.equals("\\rangle")) {
                this.output.addToken("\u232a");
            } else if (token.equals("\\land") || token.equals("\\vee")) {
                this.output.addToken("\u2227");
            } else if (token.equals("\\lor") || token.equals("\\wedge")) {
                this.output.addToken("\u2228");
            } else if (token.equals("\\bar")) {
                this.output.addToken("\u203e");
            } else if (token.equals("\\bigcap")) {
                this.output.addToken("\u22c2");
            } else if (token.equals("\\cap")) {
                this.output.addToken("\u2229");
            } else if (token.equals("\\bigcup")) {
                this.output.addToken("\u22c3");
            } else if (token.equals("\\cup")) {
                this.output.addToken("\u222a");
            } else if (token.equals("\\in")) {
                this.output.addToken("\u2208");
            } else if (token.equals("\\notin")) {
                this.output.addToken("\u2209");
            } else if (token.equals("\\Alpha")) {
                this.output.addToken("\u0391");
            } else if (token.equals("\\alpha")) {
                this.output.addToken("\u03b1");
            } else if (token.equals("\\Beta")) {
                this.output.addToken("\u0392");
            } else if (token.equals("\\beta")) {
                this.output.addToken("\u03b2");
            } else if (token.equals("\\Gamma")) {
                this.output.addToken("\u0393");
            } else if (token.equals("\\gamma")) {
                this.output.addToken("\u03b3");
            } else if (token.equals("\\Delta")) {
                this.output.addToken("\u0394");
            } else if (token.equals("\\delta")) {
                this.output.addToken("\u03b4");
            } else if (token.equals("\\Epslilon")) {
                this.output.addToken("\u0395");
            } else if (token.equals("\\epsilon")) {
                this.output.addToken("\u03b5");
            } else if (token.equals("\\Zeta")) {
                this.output.addToken("\u0396");
            } else if (token.equals("\\zeta")) {
                this.output.addToken("\u03b6");
            } else if (token.equals("\\Eta")) {
                this.output.addToken("\u0397");
            } else if (token.equals("\\eta")) {
                this.output.addToken("\u03b7");
            } else if (token.equals("\\Theta")) {
                this.output.addToken("\u0398");
            } else if (token.equals("\\theta")) {
                this.output.addToken("\u03b8");
            } else if (token.equals("\\Iota")) {
                this.output.addToken("\u0399");
            } else if (token.equals("\\iota")) {
                this.output.addToken("\u03b9");
            } else if (token.equals("\\Kappa")) {
                this.output.addToken("\u039a");
            } else if (token.equals("\\kappa")) {
                this.output.addToken("\u03ba");
            } else if (token.equals("\\Lamda")) {
                this.output.addToken("\u039b");
            } else if (token.equals("\\lamda")) {
                this.output.addToken("\u03bb");
            } else if (token.equals("\\Mu")) {
                this.output.addToken("\u039c");
            } else if (token.equals("\\mu")) {
                this.output.addToken("\u03bc");
            } else if (token.equals("\\Nu")) {
                this.output.addToken("\u039d");
            } else if (token.equals("\\nu")) {
                this.output.addToken("\u03bd");
            } else if (token.equals("\\Xi")) {
                this.output.addToken("\u039e");
            } else if (token.equals("\\xi")) {
                this.output.addToken("\u03be");
            } else if (token.equals("\\Omikron")) {
                this.output.addToken("\u039f");
            } else if (token.equals("\\omikron")) {
                this.output.addToken("\u03bf");
            } else if (token.equals("\\Pi")) {
                this.output.addToken("\u03a0");
            } else if (token.equals("\\pi")) {
                this.output.addToken("\u03c0");
            } else if (token.equals("\\Rho")) {
                this.output.addToken("\u03a1");
            } else if (token.equals("\\rho")) {
                this.output.addToken("\u03c1");
            } else if (token.equals("\\Sigma")) {
                this.output.addToken("\u03a3");
            } else if (token.equals("\\sigma")) {
                this.output.addToken("\u03c3");
            } else if (token.equals("\\Tau")) {
                this.output.addToken("\u03a4");
            } else if (token.equals("\\tau")) {
                this.output.addToken("\u03c4");
            } else if (token.equals("\\Upsilon")) {
                this.output.addToken("\u03a5");
            } else if (token.equals("\\upsilon")) {
                this.output.addToken("\u03c5");
            } else if (token.equals("\\Phi")) {
                this.output.addToken("\u03a6");
            } else if (token.equals("\\phi")) {
                this.output.addToken("\u03c6");
            } else if (token.equals("\\Chi")) {
                this.output.addToken("\u03a6");
            } else if (token.equals("\\chi")) {
                this.output.addToken("\u03c7");
            } else if (token.equals("\\Psi")) {
                this.output.addToken("\u03a8");
            } else if (token.equals("\\psi")) {
                this.output.addToken("\u03c8");
            } else if (token.equals("\\Omega")) {
                this.output.addToken("\u03a9");
            } else if (token.equals("\\omega")) {
                this.output.addToken("\u03c9");
            } else if (token.equals("\\subset")) {
                this.output.addToken("\u2282");
            } else if (token.equals("\\supset")) {
                this.output.addToken("\u2283");
            } else if (token.equals("\\subseteq")) {
                this.output.addToken("\u2286");
            } else if (token.equals("\\supseteq")) {
                this.output.addToken("\u2287");
            } else if (token.equals("\\{")) {
                this.output.addToken("{");
            } else if (token.equals("\\}")) {
                this.output.addToken("}");
            } else if (token.equals("\\&")) {
                this.output.addToken("&");
            } else if (token.equals("\\ ")) {
                this.output.addWs(" ");
            } else if (token.equals("\\S")) {
                this.output.addToken("\u00a7");
            } else if (!(token.equals("\\tt") || token.equals("\\tiny") || token.equals("\\nonumber"))) {
                if (token.equals("\\LaTeX")) {
                    this.output.addToken("LaTeX");
                } else if (token.equals("\\vdash")) {
                    this.output.addToken("\u22a2");
                } else if (token.equals("\\dashv")) {
                    this.output.addToken("\u22a3");
                } else if (token.equals("\\times")) {
                    this.output.addToken("\u00d7");
                } else if (token.equals("~")) {
                    this.output.addToken("\u00a0");
                } else if (token.equals("\\quad")) {
                    this.output.addWs(" ");
                } else if (token.equals("\\qquad")) {
                    this.output.addWs("  ");
                } else if (token.equals("\\,")) {
                    this.output.addWs(" ");
                } else if (token.equals("\\neg") || token.equals("\\not")) {
                    this.output.addToken("\u00ac");
                } else if (token.equals("\\bot")) {
                    this.output.addToken("\u22a5");
                } else if (token.equals("\\top")) {
                    this.output.addToken("\u22a4");
                } else if (token.equals("''") || token.equals("\\grqq")) {
                    this.output.addToken("\u201d");
                } else if (token.equals("``") || token.equals("\\glqq")) {
                    this.skipWhitespace = true;
                    this.output.addToken("\u201e");
                } else if (token.equals("\\ldots")) {
                    this.output.addToken("...");
                } else if (token.equals("\\overline")) {
                    this.output.addToken("\u2201");
                } else if (token.startsWith("\\")) {
                    this.addWarning(80017, "LaTeX command not supported: " + token, this.tokenBegin, this.tokenEnd);
                } else if (this.mathfrak) {
                    this.mathfrak(token);
                } else if (this.mathbb) {
                    this.mathbb(token);
                } else if (this.emph) {
                    this.emph(token);
                } else if (this.bold) {
                    this.bold(token);
                } else if (this.isWs(token)) {
                    this.output.addWs(token);
                } else {
                    this.output.addToken(token);
                }
            }
        }
    }

    private void emph(String token) {
        if (this.isWs(token)) {
            this.output.addWs(Latex2UnicodeSpecials.transform2Emph(token));
        } else {
            this.output.addToken(Latex2UnicodeSpecials.transform2Emph(token));
        }
    }

    private void mathbb(String token) {
        block9: for (int i = 0; i < token.length(); ++i) {
            char c = token.charAt(i);
            switch (c) {
                case 'C': {
                    this.output.addToken("\u2102");
                    continue block9;
                }
                case 'H': {
                    this.output.addToken("\u210d");
                    continue block9;
                }
                case 'N': {
                    this.output.addToken("\u2115");
                    continue block9;
                }
                case 'P': {
                    this.output.addToken("\u2119");
                    continue block9;
                }
                case 'Q': {
                    this.output.addToken("\u211a");
                    continue block9;
                }
                case 'R': {
                    this.output.addToken("\u211d");
                    continue block9;
                }
                case 'Z': {
                    this.output.addToken("\u2124");
                    continue block9;
                }
                default: {
                    if (Character.isWhitespace(c)) {
                        this.output.addWs("" + c);
                        continue block9;
                    }
                    this.output.addToken("" + c);
                }
            }
        }
    }

    private boolean isWs(String token) {
        return token == null || token.trim().length() == 0;
    }

    private void mathfrak(String token) {
        if (this.isWs(token)) {
            this.output.addWs(Latex2UnicodeSpecials.transform2Mathfrak(token));
        } else {
            this.output.addToken(Latex2UnicodeSpecials.transform2Mathfrak(token));
        }
    }

    private void bold(String token) {
        if (this.isWs(token)) {
            this.output.addWs(Latex2UnicodeSpecials.transform2Bold(token));
        } else {
            this.output.addToken(Latex2UnicodeSpecials.transform2Bold(token));
        }
    }

    private final void println() {
        this.output.println();
    }

    protected final int getChar() {
        return this.input.getChar();
    }

    protected final int read() {
        return this.input.read();
    }

    protected final String readln() {
        int c;
        StringBuffer result = new StringBuffer();
        while (-1 != (c = this.read()) && c != 10) {
            result.append((char)c);
        }
        return result.toString();
    }

    public final boolean eof() {
        return this.input.isEmpty();
    }

    public SourcePosition getAbsoluteSourcePosition(int absolutePosition) {
        return ((SubTextInput)this.inputStack.get(0)).getPosition(absolutePosition);
    }

    private void addWarning(int code, String message, int from, int to) {
        this.finder.addWarning(code, message, this.getAbsoluteSourcePosition(from), this.getAbsoluteSourcePosition(to));
    }
}

