/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service.logic;

import java.util.HashMap;
import java.util.Iterator;
import org.qedeq.base.io.Parameters;
import org.qedeq.base.io.Version;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.EqualsUtility;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.kernel.bo.common.ServiceProcess;
import org.qedeq.kernel.bo.log.QedeqLog;
import org.qedeq.kernel.bo.logic.FormulaCheckerFactoryImpl;
import org.qedeq.kernel.bo.logic.common.FormulaCheckerFactory;
import org.qedeq.kernel.bo.logic.common.FormulaUtility;
import org.qedeq.kernel.bo.logic.common.FunctionConstant;
import org.qedeq.kernel.bo.logic.common.FunctionKey;
import org.qedeq.kernel.bo.logic.common.LogicalCheckExceptionList;
import org.qedeq.kernel.bo.logic.common.PredicateConstant;
import org.qedeq.kernel.bo.logic.common.PredicateKey;
import org.qedeq.kernel.bo.module.ControlVisitor;
import org.qedeq.kernel.bo.module.InternalServiceProcess;
import org.qedeq.kernel.bo.module.KernelModuleReferenceList;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.ModuleConstantsExistenceChecker;
import org.qedeq.kernel.bo.module.PluginExecutor;
import org.qedeq.kernel.bo.service.dependency.LoadRequiredModulesPlugin;
import org.qedeq.kernel.bo.service.logic.CheckRequiredModuleException;
import org.qedeq.kernel.bo.service.logic.ModuleConstantsExistenceCheckerImpl;
import org.qedeq.kernel.se.base.list.Element;
import org.qedeq.kernel.se.base.list.ElementList;
import org.qedeq.kernel.se.base.module.Axiom;
import org.qedeq.kernel.se.base.module.ChangedRule;
import org.qedeq.kernel.se.base.module.ChangedRuleList;
import org.qedeq.kernel.se.base.module.ConditionalProof;
import org.qedeq.kernel.se.base.module.FormalProof;
import org.qedeq.kernel.se.base.module.FormalProofLine;
import org.qedeq.kernel.se.base.module.FormalProofLineList;
import org.qedeq.kernel.se.base.module.Formula;
import org.qedeq.kernel.se.base.module.FunctionDefinition;
import org.qedeq.kernel.se.base.module.InitialFunctionDefinition;
import org.qedeq.kernel.se.base.module.InitialPredicateDefinition;
import org.qedeq.kernel.se.base.module.PredicateDefinition;
import org.qedeq.kernel.se.base.module.Proposition;
import org.qedeq.kernel.se.base.module.Reason;
import org.qedeq.kernel.se.base.module.Rule;
import org.qedeq.kernel.se.base.module.Specification;
import org.qedeq.kernel.se.base.module.SubstFree;
import org.qedeq.kernel.se.base.module.SubstFunc;
import org.qedeq.kernel.se.base.module.SubstPred;
import org.qedeq.kernel.se.common.IllegalModuleDataException;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.RuleKey;
import org.qedeq.kernel.se.common.SourceFileException;
import org.qedeq.kernel.se.common.SourceFileExceptionList;
import org.qedeq.kernel.se.dto.list.ElementSet;
import org.qedeq.kernel.se.state.WellFormedState;

public final class WellFormedCheckerExecutor
extends ControlVisitor
implements PluginExecutor {
    private static final Class CLASS = WellFormedCheckerExecutor.class;
    private static final RuleKey CLASS_DEFINITION_VIA_FORMULA_RULE = new RuleKey("CLASS_DEFINITION_BY_FORMULA", "1.00.00");
    private ModuleConstantsExistenceCheckerImpl existence;
    private FormulaCheckerFactory checkerFactory = null;
    private Parameters parameters;

    WellFormedCheckerExecutor(Plugin plugin, KernelQedeqBo qedeq, Parameters parameters) {
        super(plugin, qedeq);
        String method = "QedeqBoFormalLogicChecker(Plugin, KernelQedeqBo, Map)";
        this.parameters = parameters;
        String checkerFactoryClass = parameters.getString("checkerFactory");
        if (checkerFactoryClass != null && checkerFactoryClass.length() > 0) {
            try {
                Class<?> cl = Class.forName(checkerFactoryClass);
                this.checkerFactory = (FormulaCheckerFactory)cl.newInstance();
            }
            catch (ClassNotFoundException e) {
                Trace.fatal(CLASS, this, "QedeqBoFormalLogicChecker(Plugin, KernelQedeqBo, Map)", "FormulaCheckerFactory class not in class path: " + checkerFactoryClass, e);
            }
            catch (InstantiationException e) {
                Trace.fatal(CLASS, this, "QedeqBoFormalLogicChecker(Plugin, KernelQedeqBo, Map)", "FormulaCheckerFactory class could not be instanciated: " + checkerFactoryClass, e);
            }
            catch (IllegalAccessException e) {
                Trace.fatal(CLASS, this, "QedeqBoFormalLogicChecker(Plugin, KernelQedeqBo, Map)", "Programming error, access for instantiation failed for model: " + checkerFactoryClass, e);
            }
            catch (RuntimeException e) {
                Trace.fatal(CLASS, this, "QedeqBoFormalLogicChecker(Plugin, KernelQedeqBo, Map)", "Programming error, instantiation failed for model: " + checkerFactoryClass, e);
            }
        }
        if (this.checkerFactory == null) {
            this.checkerFactory = new FormulaCheckerFactoryImpl();
        }
    }

    private Parameters getParameters() {
        return this.parameters;
    }

    public Object executePlugin(InternalServiceProcess process, Object data) {
        if (this.getQedeqBo().isWellFormed()) {
            return Boolean.TRUE;
        }
        QedeqLog.getInstance().logRequest("Check logical well formedness", this.getQedeqBo().getUrl());
        if (!this.getQedeqBo().hasLoadedRequiredModules()) {
            this.getServices().executePlugin(LoadRequiredModulesPlugin.class.getName(), this.getQedeqBo(), null, process);
        }
        if (!this.getQedeqBo().hasLoadedRequiredModules()) {
            String msg = "Check of logical well formedness failed";
            QedeqLog.getInstance().logFailureReply("Check of logical well formedness failed", this.getQedeqBo().getUrl(), "Not all required modules could be loaded.");
            return Boolean.FALSE;
        }
        this.getQedeqBo().setWellFormedProgressState(this.getPlugin(), WellFormedState.STATE_EXTERNAL_CHECKING);
        SourceFileExceptionList sfl = new SourceFileExceptionList();
        HashMap<RuleKey, KernelQedeqBo> rules = new HashMap<RuleKey, KernelQedeqBo>();
        KernelModuleReferenceList list = this.getQedeqBo().getKernelRequiredModules();
        for (int i = 0; i < list.size(); ++i) {
            ModuleConstantsExistenceChecker existenceChecker;
            Trace.trace(CLASS, (Object)"check(DefaultQedeqBo)", "checking label", list.getLabel(i));
            this.getServices().checkWellFormedness(list.getKernelQedeqBo(i), process);
            if (!list.getKernelQedeqBo(i).isWellFormed()) {
                CheckRequiredModuleException md = new CheckRequiredModuleException(11231, "import check failed: " + list.getQedeqBo(i).getModuleAddress(), list.getModuleContext(i));
                sfl.add(this.getQedeqBo().createSourceFileException(this.getPlugin(), md));
            }
            if ((existenceChecker = list.getKernelQedeqBo(i).getExistenceChecker()) == null) continue;
            Iterator iter = existenceChecker.getRules().keySet().iterator();
            while (iter.hasNext()) {
                RuleKey key = (RuleKey)iter.next();
                KernelQedeqBo newQedeq = existenceChecker.getQedeq(key);
                KernelQedeqBo previousQedeq = (KernelQedeqBo)rules.get(key);
                if (previousQedeq != null && !newQedeq.equals(previousQedeq)) {
                    CheckRequiredModuleException md = new CheckRequiredModuleException(37390, "this rule is defined in two different modules: " + key + " " + previousQedeq.getUrl() + " " + newQedeq.getUrl(), list.getModuleContext(i));
                    sfl.add(this.getQedeqBo().createSourceFileException(this.getPlugin(), md));
                    continue;
                }
                rules.put(key, newQedeq);
            }
        }
        if (sfl.size() > 0) {
            this.getQedeqBo().setWellfFormedFailureState(WellFormedState.STATE_EXTERNAL_CHECKING_FAILED, sfl);
            String msg = "Check of logical well formedness failed";
            QedeqLog.getInstance().logFailureReply("Check of logical well formedness failed", this.getQedeqBo().getUrl(), StringUtility.replace(sfl.getMessage(), "\n", "\n\t"));
            return Boolean.FALSE;
        }
        this.getQedeqBo().setWellFormedProgressState(this.getPlugin(), WellFormedState.STATE_INTERNAL_CHECKING);
        try {
            this.traverse(process);
        }
        catch (SourceFileExceptionList e) {
            this.getQedeqBo().setWellfFormedFailureState(WellFormedState.STATE_INTERNAL_CHECKING_FAILED, e);
            this.getQedeqBo().setExistenceChecker(this.existence);
            String msg = "Check of logical well formedness failed";
            QedeqLog.getInstance().logFailureReply("Check of logical well formedness failed", this.getQedeqBo().getUrl(), StringUtility.replace(sfl.getMessage(), "\n", "\n\t"));
            return Boolean.FALSE;
        }
        this.getQedeqBo().setWellFormed(this.existence);
        QedeqLog.getInstance().logSuccessfulReply("Check of logical well formedness successful", this.getQedeqBo().getUrl());
        return Boolean.TRUE;
    }

    public void traverse(ServiceProcess process) throws SourceFileExceptionList {
        try {
            this.existence = new ModuleConstantsExistenceCheckerImpl(this.getQedeqBo());
        }
        catch (ModuleDataException me) {
            this.addError(me);
            throw this.getErrorList();
        }
        super.traverse(process);
        this.setLocationWithinModule("");
        if (this.getQedeqBo().getQedeq().getHeader() == null) {
            this.addError(new IllegalModuleDataException(37310, "module has no header", this.getCurrentContext()));
        }
        if (this.getQedeqBo().getQedeq().getHeader().getSpecification() == null) {
            this.addError(new IllegalModuleDataException(37320, "module has no header specification", this.getCurrentContext()));
        }
    }

    public void visitEnter(Specification specification) throws ModuleDataException {
        if (specification == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.setLocationWithinModule(context + ".getRuleVersion()");
        String version = specification.getRuleVersion();
        try {
            new Version(version);
        }
        catch (RuntimeException e) {
            this.addError(new IllegalModuleDataException(37300, "a version must be formed like a.b.c with nonegative integers a, b, c; out problem is: " + e.getMessage(), this.getCurrentContext()));
        }
    }

    public void visitEnter(Axiom axiom) throws ModuleDataException {
        if (axiom == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.getNodeBo().setWellFormed(0);
        if (axiom.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula().getElement()");
            Formula formula = axiom.getFormula();
            LogicalCheckExceptionList list = this.checkerFactory.createFormulaChecker().checkFormula(formula.getElement(), this.getCurrentContext(), this.existence);
            for (int i = 0; i < list.size(); ++i) {
                this.addError(list.get(i));
            }
        } else {
            this.getNodeBo().setWellFormed(10);
        }
        if (!this.getNodeBo().isNotWellFormed()) {
            this.getNodeBo().setWellFormed(20);
        }
        this.setLocationWithinModule(context);
        this.setBlocked(true);
    }

    public void visitLeave(Axiom axiom) {
        this.setBlocked(false);
    }

    public void visitEnter(PredicateDefinition definition) throws ModuleDataException {
        if (definition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.getNodeBo().setWellFormed(0);
        PredicateKey predicateKey = new PredicateKey(definition.getName(), definition.getArgumentNumber());
        if (this.existence.predicateExists(predicateKey)) {
            this.addError(new IllegalModuleDataException(40400, "predicate was already defined for this argument number: " + predicateKey, this.getCurrentContext()));
        } else if (definition.getFormula() == null) {
            this.addError(new IllegalModuleDataException(30810, "a predicate definition needs an equivalence relation (with two parameters)", this.getCurrentContext()));
        } else {
            Element completeFormula = definition.getFormula().getElement();
            if (completeFormula == null) {
                this.addError(new IllegalModuleDataException(30810, "a predicate definition needs an equivalence relation (with two parameters)", this.getCurrentContext()));
            } else {
                this.setLocationWithinModule(context + ".getFormula().getElement()");
                if (completeFormula.isAtom()) {
                    this.addError(new IllegalModuleDataException(30810, "a predicate definition needs an equivalence relation (with two parameters)", this.getCurrentContext()));
                } else {
                    ElementList equi = completeFormula.getList();
                    String operator = equi.getOperator();
                    if (!operator.equals("EQUI") || equi.size() != 2) {
                        this.addError(new IllegalModuleDataException(30810, "a predicate definition needs an equivalence relation (with two parameters)", this.getCurrentContext()));
                    } else {
                        this.setLocationWithinModule(context + ".getFormula().getElement().getList().getElement(0)");
                        if (equi.getElement(0).isAtom()) {
                            this.addError(new IllegalModuleDataException(30810, "a predicate definition needs an predicate constant as the first parameter", this.getCurrentContext()));
                        } else {
                            ElementList predicate = equi.getElement(0).getList();
                            if (predicate.getOperator() != "PREDCON") {
                                this.addError(new IllegalModuleDataException(30810, "a predicate definition needs an predicate constant as the first parameter", this.getCurrentContext()));
                            } else {
                                Element definingFormula = equi.getElement(1);
                                ElementSet free = FormulaUtility.getFreeSubjectVariables(definingFormula);
                                for (int i = 0; i < predicate.size(); ++i) {
                                    this.setLocationWithinModule(context + ".getFormula().getElement().getList().getElement(0).getList().getElement(" + i + ")");
                                    if (i == 0) {
                                        if (!predicate.getElement(0).isAtom() || !EqualsUtility.equals(definition.getName(), predicate.getElement(0).getAtom().getString())) {
                                            this.addError(new IllegalModuleDataException(40720, "predicate name found is not as expected: " + StringUtility.quote(definition.getName()) + " - " + StringUtility.quote(predicate.getElement(0).getAtom().getString()), this.getCurrentContext()));
                                            continue;
                                        }
                                    } else if (!FormulaUtility.isSubjectVariable(predicate.getElement(i))) {
                                        this.addError(new IllegalModuleDataException(40500, "a subject variable was expected here, but we found: " + predicate.getElement(i), this.getCurrentContext()));
                                        continue;
                                    }
                                    this.setLocationWithinModule(context + ".getFormula().getElement().getList().getElement(1)");
                                    if (i == 0 || free.contains(predicate.getElement(i))) continue;
                                    this.addError(new IllegalModuleDataException(40510, "subject variable doesn't occur free in formula or term: " + predicate.getElement(i), this.getCurrentContext()));
                                }
                                this.setLocationWithinModule(context + ".getFormula().getElement()");
                                if (predicate.size() - 1 != free.size()) {
                                    this.addError(new IllegalModuleDataException(40520, "number of subject variables in definition not equal to number of free subject variables of formula or term", this.getCurrentContext()));
                                }
                                this.setLocationWithinModule(context + ".getFormula().getElement().getList().getElement(1)");
                                LogicalCheckExceptionList list = this.checkerFactory.createFormulaChecker().checkFormula(definingFormula, this.getCurrentContext(), this.existence);
                                for (int i = 0; i < list.size(); ++i) {
                                    this.addError(list.get(i));
                                }
                                if (list.size() <= 0) {
                                    this.setLocationWithinModule(context + ".getFormula().getElement().getList()");
                                    PredicateConstant constant = new PredicateConstant(predicateKey, equi, this.getCurrentContext());
                                    this.setLocationWithinModule(context);
                                    if (this.existence.predicateExists(predicateKey)) {
                                        this.addError(new IllegalModuleDataException(40400, "predicate was already defined for this argument number: " + predicateKey, this.getCurrentContext()));
                                    } else if (!this.getNodeBo().isNotWellFormed()) {
                                        this.existence.add(constant);
                                        this.setLocationWithinModule(context + ".getFormula().getElement()");
                                        LogicalCheckExceptionList errorlist = this.checkerFactory.createFormulaChecker().checkFormula(completeFormula, this.getCurrentContext(), this.existence);
                                        for (int i = 0; i < errorlist.size(); ++i) {
                                            this.addError(errorlist.get(i));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        this.setLocationWithinModule(context);
        if ("2".equals(predicateKey.getArguments()) && "equal".equals(predicateKey.getName())) {
            this.existence.setIdentityOperatorDefined(predicateKey.getName(), this.getQedeqBo(), this.getCurrentContext());
        }
        if (!this.getNodeBo().isNotWellFormed()) {
            this.getNodeBo().setWellFormed(20);
        }
        this.setBlocked(true);
    }

    public void visitLeave(PredicateDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(InitialPredicateDefinition definition) throws ModuleDataException {
        if (definition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.getNodeBo().setWellFormed(0);
        PredicateKey predicateKey = new PredicateKey(definition.getName(), definition.getArgumentNumber());
        this.setLocationWithinModule(context);
        if (this.existence.predicateExists(predicateKey)) {
            this.addError(new IllegalModuleDataException(40400, "predicate was already defined for this argument number: " + predicateKey, this.getCurrentContext()));
        }
        this.existence.add(definition);
        if ("2".equals(predicateKey.getArguments()) && "equal".equals(predicateKey.getName())) {
            this.existence.setIdentityOperatorDefined(predicateKey.getName(), this.getQedeqBo(), this.getCurrentContext());
        }
        if (!this.getNodeBo().isNotWellFormed()) {
            this.getNodeBo().setWellFormed(20);
        }
        this.setBlocked(true);
    }

    public void visitLeave(InitialPredicateDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(InitialFunctionDefinition definition) throws ModuleDataException {
        if (definition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.getNodeBo().setWellFormed(0);
        FunctionKey function = new FunctionKey(definition.getName(), definition.getArgumentNumber());
        if (this.existence.functionExists(function)) {
            this.addError(new IllegalModuleDataException(40400, "function was already defined for this argument number: " + function, this.getCurrentContext()));
        }
        this.existence.add(definition);
        this.setLocationWithinModule(context);
        if (!this.getNodeBo().isNotWellFormed()) {
            this.getNodeBo().setWellFormed(20);
        }
        this.setBlocked(true);
    }

    public void visitLeave(InitialFunctionDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(FunctionDefinition definition) throws ModuleDataException {
        if (definition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.getNodeBo().setWellFormed(0);
        FunctionKey function = new FunctionKey(definition.getName(), definition.getArgumentNumber());
        if (this.existence.functionExists(function)) {
            this.addError(new IllegalModuleDataException(40400, "function was already defined for this argument number: " + function, this.getCurrentContext()));
        } else if (definition.getFormula() == null) {
            this.addError(new IllegalModuleDataException(40730, "no definition formula for new function found", this.getCurrentContext()));
        } else {
            Formula formulaArgument = definition.getFormula();
            this.setLocationWithinModule(context + ".getFormula()");
            if (formulaArgument.getElement() == null || formulaArgument.getElement().isAtom()) {
                this.addError(new IllegalModuleDataException(40730, "no definition formula for new function found", this.getCurrentContext()));
            } else {
                ElementList formula = formulaArgument.getElement().getList();
                this.setLocationWithinModule(context + ".getFormula().getElement().getList()");
                if (!this.existence.identityOperatorExists()) {
                    this.addError(new IllegalModuleDataException(40530, "the identity operator must be defined firstly before you can define a function constant", this.getCurrentContext()));
                } else if (!"PREDCON".equals(formula.getOperator())) {
                    this.addError(new IllegalModuleDataException(40540, "a function definition must be an equal relation", this.getCurrentContext()));
                } else if (formula.size() != 3) {
                    this.addError(new IllegalModuleDataException(40540, "a function definition must be an equal relation", this.getCurrentContext()));
                } else if (!formula.getElement(0).isAtom()) {
                    this.addError(new IllegalModuleDataException(40540, "a function definition must be an equal relation", this.getCurrentContext()));
                } else if (!EqualsUtility.equals(this.existence.getIdentityOperator(), formula.getElement(0).getAtom().getString())) {
                    this.addError(new IllegalModuleDataException(40540, "a function definition must be an equal relation", this.getCurrentContext()));
                } else {
                    this.setLocationWithinModule(context + ".getFormula().getElement().getList().getElement(1)");
                    if (formula.getElement(1).isAtom()) {
                        this.addError(new IllegalModuleDataException(40550, "first operand of equal relation must be the new function constant", this.getCurrentContext()));
                    } else {
                        ElementList functionConstant = formula.getElement(1).getList();
                        if (!"FUNCON".equals(functionConstant.getOperator())) {
                            this.addError(new IllegalModuleDataException(40550, "first operand of equal relation must be the new function constant", this.getCurrentContext()));
                        } else {
                            this.setLocationWithinModule(context + ".getFormula().getElement().getList().getElement(1).getList()");
                            int size = functionConstant.size();
                            if (!("" + (size - 1)).equals(definition.getArgumentNumber())) {
                                this.addError(new IllegalModuleDataException(40550, "first operand of equal relation must be the new function constant", this.getCurrentContext()));
                            } else {
                                this.setLocationWithinModule(context + ".getFormula().getElement().getList().getElement(1).getList().getElement(0)");
                                if (!functionConstant.getElement(0).isAtom()) {
                                    this.addError(new IllegalModuleDataException(40550, "first operand of equal relation must be the new function constant", this.getCurrentContext()));
                                } else if (!EqualsUtility.equals(definition.getName(), functionConstant.getElement(0).getAtom().getString())) {
                                    this.addError(new IllegalModuleDataException(40550, "first operand of equal relation must be the new function constant", this.getCurrentContext()));
                                } else {
                                    this.setLocationWithinModule(context + ".getFormula().getElement().getList().getElement(2)");
                                    if (formula.getElement(2).isAtom()) {
                                        this.addError(new IllegalModuleDataException(40560, "first operand of equal relation must be the new function constant", this.getCurrentContext()));
                                    } else {
                                        ElementList term = formula.getElement(2).getList();
                                        this.setLocationWithinModule(context + ".getFormula().getElement().getList().getElement(1)");
                                        ElementSet free = FormulaUtility.getFreeSubjectVariables(term);
                                        if (size - 1 != free.size()) {
                                            this.addError(new IllegalModuleDataException(40520, "number of subject variables in definition not equal to number of free subject variables of formula or term", this.getCurrentContext()));
                                        } else {
                                            if (functionConstant.getElement(0).isList() || !EqualsUtility.equals(function.getName(), functionConstant.getElement(0).getAtom().getString())) {
                                                this.addError(new IllegalModuleDataException(37395, "function name in formula must be same as in definition, expected: " + function.getName(), this.getCurrentContext()));
                                            }
                                            for (int i = 1; i < size; ++i) {
                                                this.setLocationWithinModule(context + ".getFormula().getElement().getList().getElement(1)" + ".getList().getElement(" + i + ")");
                                                if (!FormulaUtility.isSubjectVariable(functionConstant.getElement(i))) {
                                                    this.addError(new IllegalModuleDataException(40500, "a subject variable was expected here, but we found: " + functionConstant.getElement(i), this.getCurrentContext()));
                                                }
                                                if (free.contains(functionConstant.getElement(i))) continue;
                                                this.addError(new IllegalModuleDataException(40510, "subject variable doesn't occur free in formula or term: " + functionConstant.getElement(i), this.getCurrentContext()));
                                            }
                                            this.setLocationWithinModule(context + ".getFormula().getElement().getList().getElement(2)");
                                            LogicalCheckExceptionList list = this.checkerFactory.createFormulaChecker().checkTerm(term, this.getCurrentContext(), this.existence);
                                            for (int i = 0; i < list.size(); ++i) {
                                                this.addError(list.get(i));
                                            }
                                            if (list.size() <= 0) {
                                                this.setLocationWithinModule(context + ".getFormula().getElement()");
                                                if (!this.getNodeBo().isNotWellFormed()) {
                                                    this.existence.add(new FunctionConstant(function, formula, this.getCurrentContext()));
                                                    LogicalCheckExceptionList listComplete = this.checkerFactory.createFormulaChecker().checkFormula(formulaArgument.getElement(), this.getCurrentContext(), this.existence);
                                                    for (int i = 0; i < listComplete.size(); ++i) {
                                                        this.addError(listComplete.get(i));
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        this.setLocationWithinModule(context);
        if (!this.getNodeBo().isNotWellFormed()) {
            this.getNodeBo().setWellFormed(20);
        }
        this.setBlocked(true);
    }

    public void visitLeave(FunctionDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(Proposition proposition) throws ModuleDataException {
        if (proposition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.getNodeBo().setWellFormed(0);
        if (proposition.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula().getElement()");
            Formula formula = proposition.getFormula();
            LogicalCheckExceptionList list = this.checkerFactory.createFormulaChecker().checkFormula(formula.getElement(), this.getCurrentContext(), this.existence);
            for (int i = 0; i < list.size(); ++i) {
                this.addError(list.get(i));
            }
        } else {
            this.getNodeBo().setWellFormed(10);
        }
        if (proposition.getFormalProofList() != null) {
            for (int i = 0; i < proposition.getFormalProofList().size(); ++i) {
                FormalProof proof = proposition.getFormalProofList().get(i);
                if (proof == null) continue;
                FormalProofLineList list = proof.getFormalProofLineList();
                this.setLocationWithinModule(context + ".getFormalProofList().get(" + i + ").getFormalProofLineList()");
                this.checkFormalProof(list);
            }
        }
        this.setLocationWithinModule(context);
        if (!this.getNodeBo().isNotWellFormed()) {
            this.getNodeBo().setWellFormed(20);
        }
        this.setBlocked(true);
    }

    private void checkFormalProof(FormalProofLineList list) {
        String context = this.getCurrentContext().getLocationWithinModule();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                FormalProofLine line = list.get(i);
                this.setLocationWithinModule(context + ".get(" + i + ")");
                this.checkProofLine(line);
            }
        }
    }

    private void checkProofLine(FormalProofLine line) {
        if (line instanceof ConditionalProof) {
            this.checkProofLine((ConditionalProof)line);
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        LogicalCheckExceptionList elist = new LogicalCheckExceptionList();
        if (line != null) {
            Reason reason;
            Formula formula = line.getFormula();
            if (formula != null) {
                this.setLocationWithinModule(context + ".getFormula().getElement()");
                elist = this.checkerFactory.createFormulaChecker().checkFormula(formula.getElement(), this.getCurrentContext(), this.existence);
                for (int k = 0; k < elist.size(); ++k) {
                    this.addError(elist.get(k));
                }
            }
            if ((reason = line.getReason()) != null) {
                Reason subst;
                if (reason instanceof SubstFree) {
                    subst = (SubstFree)reason;
                    if (subst.getSubstFree().getSubstituteTerm() != null) {
                        this.setLocationWithinModule(context + ".getReason().getSubstFree().getSubstituteTerm()");
                        elist = this.checkerFactory.createFormulaChecker().checkTerm(subst.getSubstFree().getSubstituteTerm(), this.getCurrentContext(), this.existence);
                    }
                } else if (reason instanceof SubstPred) {
                    subst = (SubstPred)reason;
                    if (subst.getSubstPred().getSubstituteFormula() != null) {
                        this.setLocationWithinModule(context + ".getReason().getSubstPred().getSubstituteFormula()");
                        elist = this.checkerFactory.createFormulaChecker().checkFormula(subst.getSubstPred().getSubstituteFormula(), this.getCurrentContext(), this.existence);
                    }
                } else if (reason instanceof SubstFunc && (subst = (SubstFunc)reason).getSubstFunc().getSubstituteTerm() != null) {
                    this.setLocationWithinModule(context + ".getReason().getSubstFunc().getSubstituteTerm()");
                    elist = this.checkerFactory.createFormulaChecker().checkTerm(subst.getSubstFunc().getSubstituteTerm(), this.getCurrentContext(), this.existence);
                }
                for (int k = 0; k < elist.size(); ++k) {
                    this.addError(elist.get(k));
                }
            }
        }
    }

    private void checkProofLine(ConditionalProof line) {
        String context = this.getCurrentContext().getLocationWithinModule();
        LogicalCheckExceptionList elist = new LogicalCheckExceptionList();
        if (line != null) {
            int k;
            Formula formula = line.getFormula();
            if (formula != null && formula.getElement() != null) {
                this.setLocationWithinModule(context + ".getFormula().getElement()");
                elist = this.checkerFactory.createFormulaChecker().checkFormula(formula.getElement(), this.getCurrentContext(), this.existence);
                for (k = 0; k < elist.size(); ++k) {
                    this.addError(elist.get(k));
                }
            }
            if (line.getHypothesis() != null && (formula = line.getHypothesis().getFormula()) != null && formula.getElement() != null) {
                this.setLocationWithinModule(context + ".getHypothesis().getFormula().getElement()");
                elist = this.checkerFactory.createFormulaChecker().checkFormula(formula.getElement(), this.getCurrentContext(), this.existence);
                for (k = 0; k < elist.size(); ++k) {
                    this.addError(elist.get(k));
                }
            }
            if (line.getFormalProofLineList() != null) {
                this.setLocationWithinModule(context + ".getFormalProofLineList()");
                this.checkFormalProof(line.getFormalProofLineList());
            }
            if (line.getConclusion() != null && (formula = line.getConclusion().getFormula()) != null && formula.getElement() != null) {
                this.setLocationWithinModule(context + ".getConclusion().getFormula().getElement()");
                elist = this.checkerFactory.createFormulaChecker().checkFormula(formula.getElement(), this.getCurrentContext(), this.existence);
                for (k = 0; k < elist.size(); ++k) {
                    this.addError(elist.get(k));
                }
            }
        }
    }

    public void visitLeave(Proposition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(Rule rule) throws ModuleDataException {
        String context = this.getCurrentContext().getLocationWithinModule();
        this.getNodeBo().setWellFormed(0);
        RuleKey ruleKey = new RuleKey(rule.getName(), rule.getVersion());
        if (rule.getName() != null && rule.getName().length() > 0 && rule.getVersion() != null && rule.getVersion().length() > 0) {
            try {
                this.setLocationWithinModule(context + ".getVersion()");
                new Version(rule.getVersion());
            }
            catch (RuntimeException e) {
                this.addError(new IllegalModuleDataException(37300, "a version must be formed like a.b.c with nonegative integers a, b, c; out problem is: " + e.getMessage(), this.getCurrentContext()));
            }
            if (this.existence.ruleExists(ruleKey)) {
                this.addError(new IllegalModuleDataException(37260, "rule was already defined for this version: " + ruleKey + "  " + this.existence.getQedeq(ruleKey).getUrl(), this.getCurrentContext()));
            } else {
                if (CLASS_DEFINITION_VIA_FORMULA_RULE.equals(ruleKey)) {
                    this.existence.setClassOperatorModule(this.getQedeqBo(), this.getCurrentContext());
                }
                this.existence.add(ruleKey, rule);
            }
            if (rule.getChangedRuleList() != null) {
                ChangedRuleList list = rule.getChangedRuleList();
                for (int i = 0; i < list.size(); ++i) {
                    this.setLocationWithinModule(context + ".getChangedRuleList().get(" + i + ")");
                    ChangedRule r = list.get(i);
                    if (r == null || r.getName() == null || r.getName().length() <= 0 || r.getVersion() == null || r.getVersion().length() <= 0) {
                        this.addError(new IllegalModuleDataException(37380, "this rule has no name or version: " + (r == null ? "null" : r.getName() + " [" + r.getVersion() + "]"), this.getCurrentContext()));
                        continue;
                    }
                    this.setLocationWithinModule(context + ".getChangedRuleList().get(" + i + ").getVersion()");
                    String ruleName = r.getName();
                    String ruleVersion = r.getVersion();
                    try {
                        new Version(ruleVersion);
                    }
                    catch (RuntimeException e) {
                        this.addError(new IllegalModuleDataException(37300, "a version must be formed like a.b.c with nonegative integers a, b, c; out problem is: " + e.getMessage(), this.getCurrentContext()));
                    }
                    RuleKey key1 = this.getLocalRuleKey(ruleName);
                    if (key1 == null) {
                        key1 = this.existence.getParentRuleKey(ruleName);
                    }
                    if (key1 == null) {
                        this.addError(new IllegalModuleDataException(37330, "a rule with this name was not declared yet: " + ruleName, this.getCurrentContext()));
                        continue;
                    }
                    RuleKey key2 = new RuleKey(ruleName, ruleVersion);
                    if (this.existence.ruleExists(key2)) {
                        this.addError(new IllegalModuleDataException(37340, "a rule with this version was already declared: " + ruleName, this.getCurrentContext(), this.getQedeqBo().getLabels().getRuleContext(key2)));
                    } else {
                        try {
                            if (!Version.less(key1.getVersion(), key2.getVersion())) {
                                this.addError(new IllegalModuleDataException(37360, "the new declared rule version must be higher than the old one: " + key1 + " " + key2, this.getCurrentContext(), this.getQedeqBo().getLabels().getRuleContext(key2)));
                            }
                        }
                        catch (RuntimeException e) {
                            this.addError(new IllegalModuleDataException(37370, "the version numbers have not the allowed pattern (old or new rule version): " + key1 + " " + key2, this.getCurrentContext(), this.getQedeqBo().getLabels().getRuleContext(key2)));
                        }
                    }
                    this.existence.add(key2, rule);
                }
            }
        } else {
            this.addError(new IllegalModuleDataException(37380, "this rule has no name or version: " + ruleKey, this.getCurrentContext()));
        }
        if (!this.getNodeBo().isNotWellFormed()) {
            this.getNodeBo().setWellFormed(20);
        }
        this.setBlocked(true);
    }

    public void visitLeave(Rule rule) {
        this.setBlocked(false);
    }

    protected void addError(ModuleDataException me) {
        if (this.getNodeBo() != null) {
            this.getNodeBo().setWellFormed(10);
        }
        super.addError(me);
    }

    protected void addError(SourceFileException me) {
        if (this.getNodeBo() != null) {
            this.getNodeBo().setWellFormed(10);
        }
        super.addError(me);
    }
}

