/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service.logic;

import java.io.File;
import org.qedeq.base.io.Parameters;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.YodaUtility;
import org.qedeq.kernel.bo.log.ModuleLogListener;
import org.qedeq.kernel.bo.log.QedeqLog;
import org.qedeq.kernel.bo.logic.ProofFinderFactoryImpl;
import org.qedeq.kernel.bo.logic.proof.common.ProofFinder;
import org.qedeq.kernel.bo.logic.proof.common.ProofFinderFactory;
import org.qedeq.kernel.bo.logic.proof.common.ProofFoundException;
import org.qedeq.kernel.bo.logic.proof.common.ProofNotFoundException;
import org.qedeq.kernel.bo.module.ControlVisitor;
import org.qedeq.kernel.bo.module.InternalServiceProcess;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.PluginExecutor;
import org.qedeq.kernel.bo.module.QedeqFileDao;
import org.qedeq.kernel.se.base.module.Axiom;
import org.qedeq.kernel.se.base.module.FormalProofLineList;
import org.qedeq.kernel.se.base.module.FunctionDefinition;
import org.qedeq.kernel.se.base.module.InitialFunctionDefinition;
import org.qedeq.kernel.se.base.module.InitialPredicateDefinition;
import org.qedeq.kernel.se.base.module.PredicateDefinition;
import org.qedeq.kernel.se.base.module.Proposition;
import org.qedeq.kernel.se.base.module.Rule;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileExceptionList;
import org.qedeq.kernel.se.dto.module.AddVo;
import org.qedeq.kernel.se.dto.module.FormalProofLineListVo;
import org.qedeq.kernel.se.dto.module.FormalProofLineVo;
import org.qedeq.kernel.se.dto.module.FormalProofVo;
import org.qedeq.kernel.se.dto.module.FormulaVo;
import org.qedeq.kernel.se.dto.module.PropositionVo;
import org.qedeq.kernel.se.state.WellFormedState;

public final class SimpleProofFinderExecutor
extends ControlVisitor
implements PluginExecutor {
    private static final Class CLASS = SimpleProofFinderExecutor.class;
    private ProofFinderFactory finderFactory = null;
    private FormalProofLineListVo validFormulas;
    private boolean noSave;
    private ProofFinder finder;
    private Parameters parameters;

    SimpleProofFinderExecutor(Plugin plugin, KernelQedeqBo qedeq, Parameters parameters) {
        super(plugin, qedeq);
        String method = "SimpleProofFinderExecutor(Plugin, KernelQedeqBo, Map)";
        String finderFactoryClass = parameters.getString("checkerFactory");
        if (finderFactoryClass != null && finderFactoryClass.length() > 0) {
            try {
                Class<?> cl = Class.forName(finderFactoryClass);
                this.finderFactory = (ProofFinderFactory)cl.newInstance();
            }
            catch (ClassNotFoundException e) {
                Trace.fatal(CLASS, this, "SimpleProofFinderExecutor(Plugin, KernelQedeqBo, Map)", "ProofFinderFactory class not in class path: " + finderFactoryClass, e);
            }
            catch (InstantiationException e) {
                Trace.fatal(CLASS, this, "SimpleProofFinderExecutor(Plugin, KernelQedeqBo, Map)", "ProofFinderFactory class could not be instanciated: " + finderFactoryClass, e);
            }
            catch (IllegalAccessException e) {
                Trace.fatal(CLASS, this, "SimpleProofFinderExecutor(Plugin, KernelQedeqBo, Map)", "Programming error, access for instantiation failed for model: " + finderFactoryClass, e);
            }
            catch (RuntimeException e) {
                Trace.fatal(CLASS, this, "SimpleProofFinderExecutor(Plugin, KernelQedeqBo, Map)", "Programming error, instantiation failed for model: " + finderFactoryClass, e);
            }
        }
        if (this.finderFactory == null) {
            this.finderFactory = new ProofFinderFactoryImpl();
        }
        this.noSave = parameters.getBoolean("noSave");
        this.parameters = parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executePlugin(InternalServiceProcess process, Object data) {
        this.getServices().checkWellFormedness(this.getQedeqBo(), process);
        QedeqLog.getInstance().logRequest("Trying to create formal proofs", this.getQedeqBo().getUrl());
        try {
            try {
                this.validFormulas = new FormalProofLineListVo();
                this.traverse(process);
                QedeqLog.getInstance().logSuccessfulReply("Proof creation finished for", this.getQedeqBo().getUrl());
            }
            catch (SourceFileExceptionList e) {
                String msg = "Proof creation not (fully?) successful";
                QedeqLog.getInstance().logFailureReply("Proof creation not (fully?) successful", this.getQedeqBo().getUrl(), e.getMessage());
                Boolean bl = Boolean.FALSE;
                Object var7_4 = null;
                this.getQedeqBo().addPluginErrorsAndWarnings(this.getPlugin(), this.getErrorList(), this.getWarningList());
                return bl;
            }
            Object var7_3 = null;
            this.getQedeqBo().addPluginErrorsAndWarnings(this.getPlugin(), this.getErrorList(), this.getWarningList());
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this.getQedeqBo().addPluginErrorsAndWarnings(this.getPlugin(), this.getErrorList(), this.getWarningList());
            throw throwable;
        }
        return Boolean.TRUE;
    }

    public void visitEnter(Axiom axiom) throws ModuleDataException {
        if (axiom == null) {
            return;
        }
        this.validFormulas.add(new FormalProofLineVo(new FormulaVo(this.getNodeBo().getFormula()), new AddVo(this.getNodeBo().getNodeVo().getId())));
        this.setBlocked(true);
    }

    public void visitLeave(Axiom axiom) {
        this.setBlocked(false);
    }

    public void visitEnter(PredicateDefinition definition) throws ModuleDataException {
        if (definition == null) {
            return;
        }
        this.validFormulas.add(new FormalProofLineVo(new FormulaVo(this.getNodeBo().getFormula()), new AddVo(this.getNodeBo().getNodeVo().getId())));
        this.setBlocked(true);
    }

    public void visitLeave(PredicateDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(InitialPredicateDefinition definition) throws ModuleDataException {
        this.setBlocked(true);
    }

    public void visitLeave(InitialPredicateDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(InitialFunctionDefinition definition) throws ModuleDataException {
        this.setBlocked(true);
    }

    public void visitLeave(InitialFunctionDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(FunctionDefinition definition) throws ModuleDataException {
        if (definition == null) {
            return;
        }
        this.validFormulas.add(new FormalProofLineVo(new FormulaVo(this.getNodeBo().getFormula()), new AddVo(this.getNodeBo().getNodeVo().getId())));
        this.setBlocked(true);
    }

    public void visitLeave(FunctionDefinition definition) {
        this.setBlocked(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitEnter(Proposition proposition) throws ModuleDataException {
        String method = "visitEnter(Proposition)";
        Trace.begin(CLASS, this, "visitEnter(Proposition)");
        if (proposition == null) {
            Trace.end(CLASS, this, "visitEnter(Proposition)");
            return;
        }
        if (proposition.getFormalProofList() == null) {
            String msg;
            FormalProofLineList proof;
            block16: {
                proof = null;
                try {
                    Object var6_4;
                    try {
                        this.finder = this.finderFactory.createProofFinder();
                        this.finder.findProof(proposition.getFormula().getElement(), this.validFormulas, this.getCurrentContext(), this.parameters, new ModuleLogListener(){

                            public void logMessageState(String text) {
                                QedeqLog.getInstance().logMessageState(text, SimpleProofFinderExecutor.this.getQedeqBo().getUrl());
                            }
                        }, this.getQedeqBo().getElement2Utf8());
                    }
                    catch (ProofFoundException e) {
                        proof = e.getProofLines();
                        var6_4 = null;
                        this.finder = null;
                        break block16;
                    }
                    catch (ProofNotFoundException e) {
                        this.addWarning(e);
                        var6_4 = null;
                        this.finder = null;
                    }
                    var6_4 = null;
                    this.finder = null;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    this.finder = null;
                    throw throwable;
                }
            }
            if (proof != null) {
                QedeqLog.getInstance().logMessage("proof found for " + super.getLocationDescription());
                try {
                    Object state = YodaUtility.getFieldValue(this.getQedeqBo(), "stateManager");
                    YodaUtility.executeMethod(state, "setWellFormedState", new Class[]{WellFormedState.class}, new Object[]{WellFormedState.STATE_UNCHECKED});
                    ((PropositionVo)proposition).addFormalProof(new FormalProofVo(proof));
                    YodaUtility.executeMethod(state, "setErrors", new Class[]{SourceFileExceptionList.class}, new Object[]{null});
                }
                catch (Exception e) {
                    msg = "changing properties failed";
                    Trace.fatal(CLASS, "visitEnter(Proposition)", "changing properties failed", e);
                    QedeqLog.getInstance().logMessage("changing properties failed " + e.toString());
                }
            } else {
                QedeqLog.getInstance().logMessage("proof not found for " + super.getLocationDescription());
            }
            if (proof != null && !this.noSave) {
                File file = this.getServices().getLocalFilePath(this.getQedeqBo().getModuleAddress());
                try {
                    QedeqLog.getInstance().logMessage("Saving file \"" + file + "\"");
                    QedeqFileDao dao = this.getServices().getQedeqFileDao();
                    dao.saveQedeq(this.getServiceProcess(), this.getQedeqBo(), file);
                    if (!this.getQedeqBo().getModuleAddress().isFileAddress()) {
                        QedeqLog.getInstance().logMessage("Only the the buffered file changed!");
                    }
                }
                catch (Exception e) {
                    msg = "Saving file \"" + file + "\" failed";
                    Trace.fatal(CLASS, "visitEnter(Proposition)", msg, e);
                    QedeqLog.getInstance().logMessage(msg + " " + e.toString());
                }
            }
        } else {
            Trace.info(CLASS, "visitEnter(Proposition)", "has already a proof: " + super.getLocationDescription());
            this.validFormulas.add(new FormalProofLineVo(new FormulaVo(this.getNodeBo().getFormula()), new AddVo(this.getNodeBo().getNodeVo().getId())));
        }
        this.setBlocked(true);
        Trace.end(CLASS, this, "visitEnter(Proposition)");
    }

    public void visitLeave(Proposition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(Rule rule) throws ModuleDataException {
        if (rule == null) {
            return;
        }
        this.setBlocked(true);
    }

    public void visitLeave(Rule rule) {
        this.setBlocked(false);
    }

    public String getLocationDescription() {
        String s = super.getLocationDescription();
        if (this.finder == null) {
            return s;
        }
        return s + " " + this.finder.getExecutionActionDescription();
    }
}

