/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service.logic;

import org.qedeq.base.io.Parameters;
import org.qedeq.base.io.Version;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.kernel.bo.log.QedeqLog;
import org.qedeq.kernel.bo.logic.ProofCheckerFactoryImpl;
import org.qedeq.kernel.bo.logic.common.FormulaUtility;
import org.qedeq.kernel.bo.logic.common.FunctionKey;
import org.qedeq.kernel.bo.logic.common.LogicalCheckExceptionList;
import org.qedeq.kernel.bo.logic.common.PredicateKey;
import org.qedeq.kernel.bo.logic.common.ReferenceResolver;
import org.qedeq.kernel.bo.logic.proof.checker.ProofCheckException;
import org.qedeq.kernel.bo.logic.proof.common.ProofCheckerFactory;
import org.qedeq.kernel.bo.logic.proof.common.RuleChecker;
import org.qedeq.kernel.bo.module.ControlVisitor;
import org.qedeq.kernel.bo.module.InternalServiceProcess;
import org.qedeq.kernel.bo.module.KernelModuleReferenceList;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.PluginExecutor;
import org.qedeq.kernel.bo.module.Reference;
import org.qedeq.kernel.bo.service.logic.CheckRequiredModuleException;
import org.qedeq.kernel.se.base.list.Element;
import org.qedeq.kernel.se.base.list.ElementList;
import org.qedeq.kernel.se.base.module.Axiom;
import org.qedeq.kernel.se.base.module.ChangedRule;
import org.qedeq.kernel.se.base.module.ChangedRuleList;
import org.qedeq.kernel.se.base.module.FormalProof;
import org.qedeq.kernel.se.base.module.FormalProofLineList;
import org.qedeq.kernel.se.base.module.FunctionDefinition;
import org.qedeq.kernel.se.base.module.Header;
import org.qedeq.kernel.se.base.module.InitialFunctionDefinition;
import org.qedeq.kernel.se.base.module.InitialPredicateDefinition;
import org.qedeq.kernel.se.base.module.PredicateDefinition;
import org.qedeq.kernel.se.base.module.Proposition;
import org.qedeq.kernel.se.base.module.Rule;
import org.qedeq.kernel.se.common.ModuleContext;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.RuleKey;
import org.qedeq.kernel.se.common.SourceFileException;
import org.qedeq.kernel.se.common.SourceFileExceptionList;
import org.qedeq.kernel.se.dto.list.DefaultAtom;
import org.qedeq.kernel.se.dto.list.DefaultElementList;
import org.qedeq.kernel.se.state.FormallyProvedState;

public final class FormalProofCheckerExecutor
extends ControlVisitor
implements PluginExecutor,
ReferenceResolver,
RuleChecker {
    private static final Class CLASS = FormalProofCheckerExecutor.class;
    private ProofCheckerFactory checkerFactory = null;
    private Parameters parameters;
    private Version ruleVersion;

    FormalProofCheckerExecutor(Plugin plugin, KernelQedeqBo qedeq, Parameters parameters) {
        super(plugin, qedeq);
        String method = "FormalProofCheckerExecutor(Plugin, KernelQedeqBo, Map)";
        this.parameters = parameters;
        String checkerFactoryClass = parameters.getString("checkerFactory");
        if (checkerFactoryClass != null && checkerFactoryClass.length() > 0) {
            try {
                Class<?> cl = Class.forName(checkerFactoryClass);
                this.checkerFactory = (ProofCheckerFactory)cl.newInstance();
            }
            catch (ClassNotFoundException e) {
                Trace.fatal(CLASS, this, "FormalProofCheckerExecutor(Plugin, KernelQedeqBo, Map)", "ProofCheckerFactory class not in class path: " + checkerFactoryClass, e);
            }
            catch (InstantiationException e) {
                Trace.fatal(CLASS, this, "FormalProofCheckerExecutor(Plugin, KernelQedeqBo, Map)", "ProofCheckerFactory class could not be instanciated: " + checkerFactoryClass, e);
            }
            catch (IllegalAccessException e) {
                Trace.fatal(CLASS, this, "FormalProofCheckerExecutor(Plugin, KernelQedeqBo, Map)", "Programming error, access for instantiation failed for model: " + checkerFactoryClass, e);
            }
            catch (RuntimeException e) {
                Trace.fatal(CLASS, this, "FormalProofCheckerExecutor(Plugin, KernelQedeqBo, Map)", "Programming error, instantiation failed for model: " + checkerFactoryClass, e);
            }
        }
        if (this.checkerFactory == null) {
            this.checkerFactory = new ProofCheckerFactoryImpl();
        }
    }

    private Parameters getParameters() {
        return this.parameters;
    }

    public Object executePlugin(InternalServiceProcess process, Object data) {
        this.ruleVersion = new Version("0.00.00");
        QedeqLog.getInstance().logRequest("Check logical correctness", this.getQedeqBo().getUrl());
        this.getServices().checkWellFormedness(this.getQedeqBo(), process);
        if (!this.getQedeqBo().isWellFormed()) {
            String msg = "Check of logical correctness failed";
            QedeqLog.getInstance().logFailureReply("Check of logical correctness failed", this.getQedeqBo().getUrl(), "Module is not even well formed.");
            return Boolean.FALSE;
        }
        this.getQedeqBo().setFormallyProvedProgressState(this.getPlugin(), FormallyProvedState.STATE_EXTERNAL_CHECKING);
        KernelModuleReferenceList list = this.getQedeqBo().getKernelRequiredModules();
        for (int i = 0; i < list.size(); ++i) {
            Trace.trace(CLASS, (Object)"check(DefaultQedeqBo)", "checking label", list.getLabel(i));
            this.getServices().checkFormallyProved(list.getKernelQedeqBo(i), process);
            if (!list.getKernelQedeqBo(i).hasErrors()) continue;
            this.addError(new CheckRequiredModuleException(11231, "import check failed: " + list.getQedeqBo(i).getModuleAddress(), list.getModuleContext(i)));
        }
        if (this.getQedeqBo().hasErrors()) {
            this.getQedeqBo().setFormallyProvedFailureState(FormallyProvedState.STATE_EXTERNAL_CHECKING_FAILED, this.getErrorList());
            String msg = "Check of logical correctness failed";
            QedeqLog.getInstance().logFailureReply("Check of logical correctness failed", this.getQedeqBo().getUrl(), StringUtility.replace(this.getQedeqBo().getErrors().getMessage(), "\n", "\n\t"));
            return Boolean.FALSE;
        }
        this.getQedeqBo().setFormallyProvedProgressState(this.getPlugin(), FormallyProvedState.STATE_INTERNAL_CHECKING);
        try {
            this.traverse(process);
        }
        catch (SourceFileExceptionList e) {
            this.getQedeqBo().setFormallyProvedFailureState(FormallyProvedState.STATE_INTERNAL_CHECKING_FAILED, this.getErrorList());
            String msg = "Check of logical correctness failed";
            QedeqLog.getInstance().logFailureReply("Check of logical correctness failed", this.getQedeqBo().getUrl(), StringUtility.replace(e.getMessage(), "\n", "\n\t"));
            return Boolean.FALSE;
        }
        this.getQedeqBo().setFormallyProvedProgressState(this.getPlugin(), FormallyProvedState.STATE_CHECKED);
        QedeqLog.getInstance().logSuccessfulReply("Check of logical correctness successful", this.getQedeqBo().getUrl());
        return Boolean.TRUE;
    }

    public void visitEnter(Header header) throws ModuleDataException {
        if (header.getSpecification() == null || header.getSpecification().getRuleVersion() == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.setLocationWithinModule(context + ".getSpecification().getRuleVersion()");
        String version = header.getSpecification().getRuleVersion().trim();
        if (!this.checkerFactory.isRuleVersionSupported(version)) {
            this.addError(new ProofCheckException(37250, "this rule version has still no proof checker implementation: " + version, this.getCurrentContext()));
        } else {
            try {
                this.ruleVersion = new Version(version);
            }
            catch (RuntimeException e) {
                this.addError(new ProofCheckException(37300, "a version must be formed like a.b.c with nonegative integers a, b, c; out problem is: " + version, this.getCurrentContext()));
            }
        }
        this.setLocationWithinModule(context);
    }

    public void visitEnter(Axiom axiom) throws ModuleDataException {
        if (!this.getNodeBo().isWellFormed()) {
            this.getNodeBo().setProved(10);
            this.addError(new ProofCheckException(37250, "only nodes with well formed formulas can be checked", this.getCurrentContext()));
            return;
        }
        this.getNodeBo().setProved(20);
        this.setBlocked(true);
    }

    public void visitLeave(Axiom axiom) {
        this.setBlocked(false);
    }

    public void visitEnter(PredicateDefinition definition) throws ModuleDataException {
        if (!this.getNodeBo().isWellFormed()) {
            this.getNodeBo().setProved(10);
            this.addError(new ProofCheckException(37250, "only nodes with well formed formulas can be checked", this.getCurrentContext()));
            return;
        }
        this.getNodeBo().setProved(20);
        this.setBlocked(true);
    }

    public void visitLeave(PredicateDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(InitialPredicateDefinition definition) throws ModuleDataException {
        if (!this.getNodeBo().isWellFormed()) {
            this.getNodeBo().setProved(10);
            this.addError(new ProofCheckException(37250, "only nodes with well formed formulas can be checked", this.getCurrentContext()));
            return;
        }
        this.getNodeBo().setProved(20);
        this.setBlocked(true);
    }

    public void visitLeave(InitialPredicateDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(InitialFunctionDefinition definition) throws ModuleDataException {
        if (!this.getNodeBo().isWellFormed()) {
            this.getNodeBo().setProved(10);
            this.addError(new ProofCheckException(37250, "only nodes with well formed formulas can be checked", this.getCurrentContext()));
            return;
        }
        this.getNodeBo().setProved(20);
        this.setBlocked(true);
    }

    public void visitLeave(InitialFunctionDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(FunctionDefinition definition) throws ModuleDataException {
        if (!this.getNodeBo().isWellFormed()) {
            this.getNodeBo().setProved(10);
            this.addError(new ProofCheckException(37250, "only nodes with well formed formulas can be checked", this.getCurrentContext()));
            return;
        }
        this.getNodeBo().setProved(20);
        this.setBlocked(true);
    }

    public void visitLeave(FunctionDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(Proposition proposition) throws ModuleDataException {
        if (!this.getNodeBo().isWellFormed()) {
            this.getNodeBo().setProved(10);
            this.addError(new ProofCheckException(37250, "only nodes with well formed formulas can be checked", this.getCurrentContext()));
            return;
        }
        this.getNodeBo().setProved(0);
        if (proposition.getFormula() == null) {
            this.getNodeBo().setProved(10);
            this.addError(new ProofCheckException(37230, "proposition formula must not be null", this.getCurrentContext()));
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        boolean correctProofFound = false;
        if (proposition.getFormalProofList() != null) {
            for (int i = 0; i < proposition.getFormalProofList().size(); ++i) {
                FormalProofLineList list;
                FormalProof proof = proposition.getFormalProofList().get(i);
                if (proof == null || (list = proof.getFormalProofLineList()) == null) continue;
                this.setLocationWithinModule(context + ".getFormalProofList().get(" + i + ").getFormalProofLineList()");
                LogicalCheckExceptionList eList = this.checkerFactory.createProofChecker(this.ruleVersion).checkProof(proposition.getFormula().getElement(), list, this, this.getCurrentContext(), this);
                if (!correctProofFound && eList.size() == 0) {
                    correctProofFound = true;
                }
                for (int j = 0; j < eList.size(); ++j) {
                    this.addError(eList.get(j));
                }
            }
        }
        this.setLocationWithinModule(context + ".getFormula()");
        if (correctProofFound) {
            this.getNodeBo().setProved(20);
        } else {
            this.getNodeBo().setProved(10);
            this.addError(new ProofCheckException(37240, "no correct formal proof found", this.getCurrentContext()));
        }
        this.setBlocked(true);
    }

    public void visitLeave(Proposition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(Rule rule) throws ModuleDataException {
        String context = this.getCurrentContext().getLocationWithinModule();
        this.getNodeBo().setProved(0);
        ChangedRuleList list = rule.getChangedRuleList();
        for (int i = 0; list != null && i < list.size(); ++i) {
            this.setLocationWithinModule(context + ".getChangedRuleList().get(" + i + ").getVersion()");
            ChangedRule r = list.get(i);
            if (Version.equals(rule.getVersion(), r.getVersion())) continue;
            this.addError(new ProofCheckException(37350, "we expected this rule verson: " + rule.getVersion() + " but we got: " + r.getVersion(), this.getCurrentContext()));
        }
        if (this.getNodeBo().isNotProved()) {
            this.getNodeBo().setProved(20);
        } else {
            this.getNodeBo().setProved(10);
        }
    }

    protected void addError(ModuleDataException me) {
        if (this.getNodeBo() != null) {
            this.getNodeBo().setProved(10);
        }
        super.addError(me);
    }

    protected void addError(SourceFileException me) {
        if (this.getNodeBo() != null) {
            this.getNodeBo().setProved(10);
        }
        super.addError(me);
    }

    public boolean isProvedFormula(String reference) {
        String method = "hasProvedFormula";
        Reference ref = this.getReference(reference, this.getCurrentContext(), false, false);
        if (ref == null) {
            Trace.info(CLASS, "hasProvedFormula", "ref == null");
            return false;
        }
        if (ref.isExternalModuleReference()) {
            Trace.info(CLASS, "hasProvedFormula", "ref is external module");
            return false;
        }
        if (!ref.isNodeReference()) {
            Trace.info(CLASS, "hasProvedFormula", "ref is no node reference");
            return false;
        }
        if (null == ref.getNode()) {
            Trace.info(CLASS, "hasProvedFormula", "ref node == null");
            return false;
        }
        if (ref.isSubReference()) {
            return false;
        }
        if (!ref.isProofLineReference()) {
            if (!ref.getNode().isProved()) {
                Trace.info(CLASS, "hasProvedFormula", "ref node is not marked as proved: " + reference);
            }
            if (!ref.getNode().isProved()) {
                return false;
            }
            if (!ref.getNode().hasFormula()) {
                Trace.info(CLASS, "hasProvedFormula", "node has no formula: " + reference);
                return false;
            }
            return ref.getNode().isProved();
        }
        Trace.info(CLASS, "hasProvedFormula", "proof line references are not ok!");
        return false;
    }

    public Element getNormalizedReferenceFormula(String reference) {
        if (!this.isProvedFormula(reference)) {
            return null;
        }
        Reference ref = this.getReference(reference, this.getCurrentContext(), false, false);
        Element formula = ref.getNode().getFormula();
        return this.getNormalizedFormula(ref.getNode().getQedeqBo(), formula);
    }

    public Element getNormalizedFormula(Element formula) {
        return this.getNormalizedFormula(this.getQedeqBo(), formula);
    }

    private Element getNormalizedFormula(KernelQedeqBo qedeq, Element formula) {
        if (formula == null) {
            return null;
        }
        if (formula.isAtom()) {
            return new DefaultAtom(formula.getAtom().getString());
        }
        return this.getNormalizedFormula(qedeq, formula.getList());
    }

    private ElementList getNormalizedFormula(KernelQedeqBo qedeq, ElementList formula) {
        DefaultElementList result = new DefaultElementList(formula.getOperator());
        if (FormulaUtility.isPredicateConstant(formula)) {
            PredicateKey key = new PredicateKey(formula.getElement(0).getAtom().getString(), "" + (formula.getList().size() - 1));
            DefaultAtom atom = new DefaultAtom(qedeq.getExistenceChecker().get(key).getContext().getModuleLocation().getUrl() + "$" + key.getName());
            result.add(atom);
            for (int i = 1; i < formula.size(); ++i) {
                result.add(this.getNormalizedFormula(qedeq, formula.getElement(i)));
            }
        } else if (FormulaUtility.isFunctionConstant(formula)) {
            FunctionKey key = new FunctionKey(formula.getElement(0).getAtom().getString(), "" + (formula.getList().size() - 1));
            DefaultAtom atom = new DefaultAtom(qedeq.getExistenceChecker().get(key).getContext().getModuleLocation().getUrl() + "$" + key.getName());
            result.add(atom);
            for (int i = 1; i < formula.size(); ++i) {
                result.add(this.getNormalizedFormula(qedeq, formula.getElement(i)));
            }
        } else {
            for (int i = 0; i < formula.size(); ++i) {
                result.add(this.getNormalizedFormula(qedeq, formula.getElement(i)));
            }
        }
        return result;
    }

    public boolean isLocalProofLineReference(String reference) {
        return false;
    }

    public ModuleContext getReferenceContext(String reference) {
        return null;
    }

    public Element getNormalizedLocalProofLineReference(String reference) {
        return null;
    }

    public RuleKey getRule(String ruleName) {
        RuleKey local = this.getLocalRuleKey(ruleName);
        if (local == null) {
            return this.getQedeqBo().getExistenceChecker().getParentRuleKey(ruleName);
        }
        return local;
    }
}

