/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service.latex;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.io.Parameters;
import org.qedeq.base.io.SourcePosition;
import org.qedeq.base.io.TextInput;
import org.qedeq.base.io.TextOutput;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.DateUtility;
import org.qedeq.base.utility.EqualsUtility;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.kernel.bo.log.QedeqLog;
import org.qedeq.kernel.bo.module.ControlVisitor;
import org.qedeq.kernel.bo.module.InternalServiceProcess;
import org.qedeq.kernel.bo.module.KernelNodeBo;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.PluginExecutor;
import org.qedeq.kernel.bo.module.Reference;
import org.qedeq.kernel.bo.service.latex.LatexContentException;
import org.qedeq.kernel.bo.service.latex.QedeqBoDuplicateLanguageChecker;
import org.qedeq.kernel.se.base.list.Element;
import org.qedeq.kernel.se.base.list.ElementList;
import org.qedeq.kernel.se.base.module.Add;
import org.qedeq.kernel.se.base.module.Author;
import org.qedeq.kernel.se.base.module.AuthorList;
import org.qedeq.kernel.se.base.module.Axiom;
import org.qedeq.kernel.se.base.module.ChangedRule;
import org.qedeq.kernel.se.base.module.ChangedRuleList;
import org.qedeq.kernel.se.base.module.Chapter;
import org.qedeq.kernel.se.base.module.Conclusion;
import org.qedeq.kernel.se.base.module.ConditionalProof;
import org.qedeq.kernel.se.base.module.Existential;
import org.qedeq.kernel.se.base.module.FormalProof;
import org.qedeq.kernel.se.base.module.FormalProofLine;
import org.qedeq.kernel.se.base.module.FormalProofLineList;
import org.qedeq.kernel.se.base.module.FunctionDefinition;
import org.qedeq.kernel.se.base.module.Header;
import org.qedeq.kernel.se.base.module.Hypothesis;
import org.qedeq.kernel.se.base.module.Import;
import org.qedeq.kernel.se.base.module.ImportList;
import org.qedeq.kernel.se.base.module.InitialFunctionDefinition;
import org.qedeq.kernel.se.base.module.InitialPredicateDefinition;
import org.qedeq.kernel.se.base.module.Latex;
import org.qedeq.kernel.se.base.module.LatexList;
import org.qedeq.kernel.se.base.module.LinkList;
import org.qedeq.kernel.se.base.module.LiteratureItem;
import org.qedeq.kernel.se.base.module.LiteratureItemList;
import org.qedeq.kernel.se.base.module.LocationList;
import org.qedeq.kernel.se.base.module.ModusPonens;
import org.qedeq.kernel.se.base.module.Node;
import org.qedeq.kernel.se.base.module.PredicateDefinition;
import org.qedeq.kernel.se.base.module.Proof;
import org.qedeq.kernel.se.base.module.Proposition;
import org.qedeq.kernel.se.base.module.Qedeq;
import org.qedeq.kernel.se.base.module.Rename;
import org.qedeq.kernel.se.base.module.Rule;
import org.qedeq.kernel.se.base.module.Section;
import org.qedeq.kernel.se.base.module.SectionList;
import org.qedeq.kernel.se.base.module.Specification;
import org.qedeq.kernel.se.base.module.Subsection;
import org.qedeq.kernel.se.base.module.SubsectionList;
import org.qedeq.kernel.se.base.module.SubsectionType;
import org.qedeq.kernel.se.base.module.SubstFree;
import org.qedeq.kernel.se.base.module.SubstFunc;
import org.qedeq.kernel.se.base.module.SubstPred;
import org.qedeq.kernel.se.base.module.Universal;
import org.qedeq.kernel.se.base.module.UsedByList;
import org.qedeq.kernel.se.common.ModuleAddress;
import org.qedeq.kernel.se.common.ModuleContext;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.RuleKey;
import org.qedeq.kernel.se.common.SourceFileExceptionList;

public final class Qedeq2LatexExecutor
extends ControlVisitor
implements PluginExecutor {
    private static final Class CLASS = Qedeq2LatexExecutor.class;
    private TextOutput printer;
    private String language;
    private final boolean info;
    private final boolean brief;
    private String id;
    private String title;
    private String subContext = "";
    private String label = "";
    private String formula = "";
    private String reason = "";
    private int tabLevel = 0;
    private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyz";

    public Qedeq2LatexExecutor(Plugin plugin, KernelQedeqBo prop, Parameters parameters) {
        super(plugin, prop);
        this.info = parameters.getBoolean("info");
        this.brief = parameters.getBoolean("brief");
    }

    public Object executePlugin(InternalServiceProcess process, Object data) {
        String method = "executePlugin(QedeqBo, Map)";
        try {
            QedeqLog.getInstance().logRequest("Generate LaTeX", this.getQedeqBo().getUrl());
            String[] languages = this.getQedeqBo().getSupportedLanguages();
            for (int j = 0; j < languages.length; ++j) {
                this.language = languages[j];
                String result = this.generateLatex(process, languages[j], "1").toString();
                if (languages[j] != null) {
                    QedeqLog.getInstance().logSuccessfulReply("LaTeX for language \"" + languages[j] + "\" was generated from into \"" + result + "\"", this.getQedeqBo().getUrl());
                    continue;
                }
                QedeqLog.getInstance().logSuccessfulReply("LaTeX for default language was generated into \"" + result + "\"", this.getQedeqBo().getUrl());
            }
            if (languages.length == 0) {
                QedeqLog.getInstance().logMessage("no supported language found, assuming 'en'");
                String result = this.generateLatex(process, "en", "1").toString();
                QedeqLog.getInstance().logSuccessfulReply("LaTeX for language \"en\" was generated into \"" + result + "\"", this.getQedeqBo().getUrl());
            }
        }
        catch (SourceFileExceptionList e) {
            String msg = "Generation failed";
            Trace.fatal(CLASS, this, "executePlugin(QedeqBo, Map)", "Generation failed", e);
            QedeqLog.getInstance().logFailureReply("Generation failed", this.getQedeqBo().getUrl(), e.getMessage());
        }
        catch (IOException e) {
            String msg = "Generation failed";
            Trace.fatal(CLASS, this, "executePlugin(QedeqBo, Map)", "Generation failed", e);
            QedeqLog.getInstance().logFailureReply("Generation failed", this.getQedeqBo().getUrl(), e.getMessage());
        }
        catch (RuntimeException e) {
            Trace.fatal(CLASS, this, "executePlugin(QedeqBo, Map)", "unexpected problem", e);
            QedeqLog.getInstance().logFailureReply("Generation failed", this.getQedeqBo().getUrl(), "unexpected problem: " + (e.getMessage() != null ? e.getMessage() : e.toString()));
        }
        return null;
    }

    public InputStream createLatex(InternalServiceProcess process, String language, String level) throws SourceFileExceptionList, IOException {
        return new FileInputStream(this.generateLatex(process, language, level));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File generateLatex(InternalServiceProcess process, String language, String level) throws SourceFileExceptionList, IOException {
        String method = "generateLatex(String, String)";
        this.language = language;
        try {
            this.getServices().loadRequiredModules(this.getQedeqBo(), process);
            this.getServices().checkWellFormedness(this.getQedeqBo(), process);
        }
        catch (Exception e) {
            Trace.trace(CLASS, "generateLatex(String, String)", e);
        }
        String tex = this.getQedeqBo().getModuleAddress().getFileName();
        if (tex.toLowerCase(Locale.US).endsWith(".xml")) {
            tex = tex.substring(0, tex.length() - 4);
        }
        if (language != null && language.length() > 0) {
            tex = tex + "_" + language;
        }
        File destination = new File(this.getServices().getConfig().getGenerationDirectory(), tex + ".tex").getCanonicalFile();
        this.init();
        try {
            this.printer = "de".equals(language) ? new TextOutput(this.getQedeqBo().getName(), new FileOutputStream(destination), "ISO-8859-1"){

                public void append(String txt) {
                    super.append(Qedeq2LatexExecutor.this.escapeUmlauts(txt));
                }
            } : new TextOutput(this.getQedeqBo().getName(), new FileOutputStream(destination), "UTF-8"){

                public void append(String txt) {
                    super.append(Qedeq2LatexExecutor.this.escapeUmlauts(txt));
                }
            };
            this.traverse(process);
            Object var8_8 = null;
            this.getQedeqBo().addPluginErrorsAndWarnings(this.getPlugin(), this.getErrorList(), this.getWarningList());
            if (this.printer != null) {
                this.printer.flush();
                this.printer.close();
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.getQedeqBo().addPluginErrorsAndWarnings(this.getPlugin(), this.getErrorList(), this.getWarningList());
            if (this.printer != null) {
                this.printer.flush();
                this.printer.close();
            }
            throw throwable;
        }
        if (this.printer != null && this.printer.checkError()) {
            throw this.printer.getError();
        }
        try {
            QedeqBoDuplicateLanguageChecker.check(process, this.getPlugin(), this.getQedeqBo());
        }
        catch (SourceFileExceptionList warnings) {
            this.getQedeqBo().addPluginErrorsAndWarnings(this.getPlugin(), null, warnings);
        }
        return destination.getCanonicalFile();
    }

    protected void init() {
        this.id = null;
        this.title = null;
        this.subContext = "";
    }

    public final void visitEnter(Qedeq qedeq) {
        this.printer.println("% -*- TeX" + (this.language != null ? ":" + this.language.toUpperCase(Locale.US) : "") + " -*-");
        this.printer.println("%%% ====================================================================");
        this.printer.println("%%% @LaTeX-file    " + this.printer.getName());
        this.printer.println("%%% Generated from " + this.getQedeqBo().getModuleAddress());
        this.printer.println("%%% Generated at   " + DateUtility.getTimestamp());
        this.printer.println("%%% ====================================================================");
        this.printer.println();
        this.printer.println("%%% Permission is granted to copy, distribute and/or modify this document");
        this.printer.println("%%% under the terms of the GNU Free Documentation License, Version 1.2");
        this.printer.println("%%% or any later version published by the Free Software Foundation;");
        this.printer.println("%%% with no Invariant Sections, no Front-Cover Texts, and no Back-Cover Texts.");
        this.printer.println();
        this.printer.println("\\documentclass[a4paper,german,10pt,twoside]{book}");
        if ("de".equals(this.language)) {
            this.printer.println("\\usepackage[german]{babel}");
        } else {
            if (!"en".equals(this.language)) {
                this.printer.println("%%% TODO unknown language: " + this.language);
            }
            this.printer.println("\\usepackage[english]{babel}");
        }
        this.printer.println("\\usepackage{makeidx}");
        this.printer.println("\\usepackage{amsmath,amsthm,amssymb}");
        this.printer.println("\\usepackage{color}");
        this.printer.println("\\usepackage{xr}");
        this.printer.println("\\usepackage{tabularx}");
        this.printer.println("\\usepackage[bookmarks=true,bookmarksnumbered,bookmarksopen,");
        this.printer.println("   unicode=true,colorlinks=true,linkcolor=webgreen,");
        this.printer.println("   pagebackref=true,pdfnewwindow=true,pdfstartview=FitH]{hyperref}");
        this.printer.println("\\definecolor{webgreen}{rgb}{0,.5,0}");
        this.printer.println("\\usepackage{epsfig,longtable}");
        this.printer.println("\\usepackage{graphicx}");
        this.printer.println("\\usepackage[all]{hypcap}");
        this.printer.println();
        if ("de".equals(this.language)) {
            this.printer.println("\\newtheorem{thm}{Theorem}");
            this.printer.println("\\newtheorem{cor}[thm]{Korollar}");
            this.printer.println("\\newtheorem{lem}[thm]{Lemma}");
            this.printer.println("\\newtheorem{prop}[thm]{Proposition}");
            this.printer.println("\\newtheorem{ax}{Axiom}");
            this.printer.println("\\newtheorem{rul}{Regel}");
            this.printer.println();
            this.printer.println("\\theoremstyle{definition}");
            this.printer.println("\\newtheorem{defn}{Definition}");
            this.printer.println("\\newtheorem{idefn}[defn]{Initiale Definition}");
            this.printer.println();
            this.printer.println("\\theoremstyle{remark}");
            this.printer.println("\\newtheorem{rem}[thm]{Bemerkung}");
            this.printer.println("\\newtheorem*{notation}{Notation}");
        } else {
            if (!"en".equals(this.language)) {
                this.printer.println("%%% TODO unknown language: " + this.language);
            }
            this.printer.println("\\newtheorem{thm}{Theorem}");
            this.printer.println("\\newtheorem{cor}[thm]{Corollary}");
            this.printer.println("\\newtheorem{lem}[thm]{Lemma}");
            this.printer.println("\\newtheorem{prop}[thm]{Proposition}");
            this.printer.println("\\newtheorem{ax}{Axiom}");
            this.printer.println("\\newtheorem{rul}{Rule}");
            this.printer.println();
            this.printer.println("\\theoremstyle{definition}");
            this.printer.println("\\newtheorem{defn}{Definition}");
            this.printer.println("\\newtheorem{idefn}[defn]{Initial Definition}");
            this.printer.println();
            this.printer.println("\\theoremstyle{remark}");
            this.printer.println("\\newtheorem{rem}[thm]{Remark}");
            this.printer.println("\\newtheorem*{notation}{Notation}");
        }
        this.printer.println();
        this.printer.println();
        this.printer.println("\\addtolength{\\textheight}{7\\baselineskip}");
        this.printer.println("\\addtolength{\\topmargin}{-5\\baselineskip}");
        this.printer.println();
        this.printer.println("\\setlength{\\parindent}{0pt}");
        this.printer.println();
        this.printer.println("\\frenchspacing \\sloppy");
        this.printer.println();
        this.printer.println("\\makeindex");
        this.printer.println();
        this.printer.println();
    }

    public final void visitLeave(Qedeq qedeq) {
        this.printer.println("\\addcontentsline{toc}{chapter}{\\indexname} \\printindex");
        this.printer.println();
        this.printer.println("\\end{document}");
        this.printer.println();
    }

    public void visitEnter(Header header) {
        LatexList tit = header.getTitle();
        this.printer.print("\\title{");
        this.printer.print(this.getLatexListEntry("getTitle()", tit));
        this.printer.println("}");
        this.printer.println("\\author{");
        AuthorList authors = this.getQedeqBo().getQedeq().getHeader().getAuthorList();
        StringBuffer authorList = new StringBuffer();
        for (int i = 0; i < authors.size(); ++i) {
            if (i > 0) {
                authorList.append(", ");
                this.printer.println(", ");
            }
            Author author = authors.get(i);
            String name = author.getName().getLatex().trim();
            this.printer.print(name);
            authorList.append(name);
            String email = author.getEmail();
            if (email == null || email.trim().length() <= 0) continue;
            authorList.append(" \\href{mailto:" + email + "}{" + email + "}");
        }
        this.printer.println();
        this.printer.println("}");
        this.printer.println();
        this.printer.println("\\begin{document}");
        this.printer.println();
        this.printer.println("\\maketitle");
        this.printer.println();
        this.printer.println("\\setlength{\\parskip}{5pt plus 2pt minus 1pt}");
        this.printer.println("\\mbox{}");
        this.printer.println("\\vfill");
        this.printer.println();
        String url = this.getQedeqBo().getUrl();
        if (url != null && url.length() > 0) {
            this.printer.println("\\par");
            if ("de".equals(this.language)) {
                this.printer.println("Die Quelle f{\"ur} dieses Dokument ist hier zu finden:");
            } else {
                if (!"en".equals(this.language)) {
                    this.printer.println("%%% TODO unknown language: " + this.language);
                }
                this.printer.println("The source for this document can be found here:");
            }
            this.printer.println("\\par");
            this.printer.println("\\url{" + url + "}");
            this.printer.println();
        }
        this.printer.println("\\par");
        if ("de".equals(this.language)) {
            this.printer.println("Die vorliegende Publikation ist urheberrechtlich gesch{\"u}tzt.");
        } else {
            if (!"en".equals(this.language)) {
                this.printer.println("%%% TODO unknown language: " + this.language);
            }
            this.printer.println("Copyright by the authors. All rights reserved.");
        }
        String email = header.getEmail();
        if (email != null && email.length() > 0) {
            String emailUrl = "\\href{mailto:" + email + "}{" + email + "}";
            this.printer.println("\\par");
            if ("de".equals(this.language)) {
                this.printer.println("Bei Fragen, Anregungen oder Bitte um Aufnahme in die Liste der abh\u00e4ngigen Module schicken Sie bitte eine EMail an die Adresse " + emailUrl);
                this.printer.println();
                this.printer.println("\\par");
                this.printer.println("Die Autoren dieses Dokuments sind:");
                this.printer.println(authorList);
            } else {
                if (!"en".equals(this.language)) {
                    this.printer.println("%%% TODO unknown language: " + this.language);
                }
                this.printer.println("If you have any questions, suggestions or want to add something to the list of modules that use this one, please send an email to the address " + emailUrl);
                this.printer.println();
                this.printer.println("\\par");
                this.printer.println("The authors of this document are:");
                this.printer.println(authorList);
            }
            this.printer.println();
        }
    }

    public void visitLeave(Header header) {
        this.printer.println();
        this.printer.println();
        this.printer.println("\\setlength{\\parskip}{0pt}");
        this.printer.println("\\tableofcontents");
        this.printer.println();
        this.printer.println("\\setlength{\\parskip}{5pt plus 2pt minus 1pt}");
        this.printer.println();
    }

    public void visitEnter(ImportList imports) throws ModuleDataException {
        this.printer.println();
        this.printer.println();
        this.printer.println("\\par");
        if ("de".equals(this.language)) {
            this.printer.println("Benutzte QEDEQ module:");
        } else {
            if (!"en".equals(this.language)) {
                this.printer.println("%%% TODO unknown language: " + this.language);
            }
            this.printer.println("Used other QEDEQ modules:");
        }
        this.printer.println();
        this.printer.println("\\par");
        this.printer.println();
    }

    public void visitEnter(Import imp) throws ModuleDataException {
        this.printer.println();
        this.printer.println("\\par");
        this.printer.print("\\textbf{" + imp.getLabel() + "} ");
        Specification spec = imp.getSpecification();
        this.printer.print(this.getLatex(spec.getName()));
        if (spec.getLocationList() != null && spec.getLocationList().size() > 0 && spec.getLocationList().get(0).getLocation().length() > 0) {
            this.printer.print(" ");
            this.printer.print("\\url{" + this.getPdfLink((KernelQedeqBo)this.getQedeqBo().getLabels().getReferences().getQedeqBo(imp.getLabel())) + "}");
        }
        this.printer.println();
    }

    private String getUrl(ModuleAddress address, Specification specification) {
        LocationList list = specification.getLocationList();
        if (list == null || list.size() <= 0) {
            return "";
        }
        try {
            return address.getModulePaths(specification)[0].getUrl();
        }
        catch (IOException e) {
            return "";
        }
    }

    public void visitEnter(Chapter chapter) {
        if (this.brief) {
            boolean hasFormalContent = false;
            SectionList sections = chapter.getSectionList();
            if (sections != null) {
                block0: for (int i = 0; i < sections.size() && !hasFormalContent; ++i) {
                    SubsectionList subSections;
                    Section section = sections.get(i);
                    if (section == null || (subSections = section.getSubsectionList()) == null) continue;
                    for (int j = 0; j < subSections.size(); ++j) {
                        SubsectionType subSection = subSections.get(j);
                        if (subSection instanceof Subsection) continue;
                        hasFormalContent = true;
                        continue block0;
                    }
                }
            }
            if (!hasFormalContent) {
                this.setBlocked(true);
                return;
            }
        }
        this.printer.print("\\chapter");
        if (chapter.getNoNumber() != null && chapter.getNoNumber().booleanValue()) {
            this.printer.print("*");
        }
        this.printer.print("{");
        this.printer.print(this.getLatexListEntry("getTitle()", chapter.getTitle()));
        String chapterLabel = "chapter" + this.getCurrentNumbers().getAbsoluteChapterNumber();
        this.printer.println("} \\label{" + chapterLabel + "} \\hypertarget{" + chapterLabel + "}{}");
        if (chapter.getNoNumber() != null && chapter.getNoNumber().booleanValue()) {
            this.printer.println("\\addcontentsline{toc}{chapter}{" + this.getLatexListEntry("getTitle()", chapter.getTitle()) + "}");
        }
        this.printer.println();
        if (chapter.getIntroduction() != null && !this.brief) {
            this.printer.println(this.getLatexListEntry("getIntroduction()", chapter.getIntroduction()));
            this.printer.println();
        }
    }

    public void visitLeave(Chapter chapter) {
        this.printer.println("%% end of chapter " + this.getLatexListEntry("getTitle()", chapter.getTitle()));
        this.printer.println();
        this.setBlocked(false);
    }

    public void visitLeave(SectionList list) {
        this.printer.println();
    }

    public void visitEnter(Section section) {
        if (this.brief) {
            boolean hasFormalContent = false;
            SubsectionList subSections = section.getSubsectionList();
            if (subSections != null) {
                for (int j = 0; j < subSections.size(); ++j) {
                    SubsectionType subSection = subSections.get(j);
                    if (subSection instanceof Subsection) continue;
                    hasFormalContent = true;
                    break;
                }
            }
            if (!hasFormalContent) {
                this.setBlocked(true);
                return;
            }
        }
        this.printer.print("\\section");
        if (section.getNoNumber() != null && section.getNoNumber().booleanValue()) {
            this.printer.print("*");
        }
        this.printer.print("{");
        this.printer.print(this.getLatexListEntry("getTitle()", section.getTitle()));
        String chapterLabel = "chapter" + this.getCurrentNumbers().getAbsoluteChapterNumber() + "_section" + this.getCurrentNumbers().getAbsoluteSectionNumber();
        this.printer.println("} \\label{" + chapterLabel + "} \\hypertarget{" + chapterLabel + "}{}");
        if (section.getIntroduction() != null && !this.brief) {
            this.printer.println(this.getLatexListEntry("getIntroduction()", section.getIntroduction()));
            this.printer.println();
        }
    }

    public void visitLeave(Section section) {
        this.setBlocked(false);
    }

    public void visitEnter(Subsection subsection) {
        if (this.brief) {
            return;
        }
        if (subsection.getTitle() != null) {
            this.printer.print("\\subsection{");
            this.printer.println(this.getLatexListEntry("getTitle()", subsection.getTitle()));
            this.printer.println("}");
        }
        if (subsection.getId() != null) {
            this.printer.println("\\label{" + subsection.getId() + "} \\hypertarget{" + subsection.getId() + "}{}");
        }
        this.printer.println(this.getLatexListEntry("getLatex()", subsection.getLatex()));
    }

    public void visitLeave(Subsection subsection) {
        if (this.brief) {
            return;
        }
        this.printer.println();
        this.printer.println();
    }

    public void visitEnter(Node node) {
        if (node.getPrecedingText() != null && !this.brief) {
            this.printer.println("\\par");
            this.printer.println(this.getLatexListEntry("getPrecedingText()", node.getPrecedingText()));
            this.printer.println();
        }
        this.id = node.getId();
        this.title = null;
        if (node.getTitle() != null) {
            this.title = this.getLatexListEntry("getTitle()", node.getTitle());
        }
    }

    public void visitLeave(Node node) {
        this.printer.println();
        if (node.getSucceedingText() != null && !this.brief) {
            this.printer.println(this.getLatexListEntry("getSucceedingText()", node.getSucceedingText()));
            this.printer.println();
        }
        this.printer.println();
    }

    public void visitEnter(Axiom axiom) {
        this.printer.println("\\begin{ax}" + (this.title != null ? "[" + this.title + "]" : ""));
        this.printer.println("\\label{" + this.id + "} \\hypertarget{" + this.id + "}{}");
        if (this.info) {
            this.printer.println("{\\tt \\tiny [\\verb]" + this.id + "]]}");
        }
        this.printFormula(axiom.getFormula().getElement());
        this.printer.println(this.getLatexListEntry("getDescription()", axiom.getDescription()));
        this.printer.println("\\end{ax}");
    }

    public void visitEnter(Proposition proposition) {
        this.printer.println("\\begin{prop}" + (this.title != null ? "[" + this.title + "]" : ""));
        this.printer.println("\\label{" + this.id + "} \\hypertarget{" + this.id + "}{}");
        if (this.info) {
            this.printer.println("{\\tt \\tiny [\\verb]" + this.id + "]]}");
        }
        this.printTopFormula(proposition.getFormula().getElement(), this.id);
        this.printer.println(this.getLatexListEntry("getDescription()", proposition.getDescription()));
        this.printer.println("\\end{prop}");
    }

    public void visitEnter(Proof proof) {
        if (this.brief) {
            this.setBlocked(true);
            return;
        }
        this.printer.println("\\begin{proof}");
        this.printer.println(this.getLatexListEntry("getNonFormalProof()", proof.getNonFormalProof()));
        this.printer.println("\\end{proof}");
    }

    public void visitLeave(Proof proof) {
        this.setBlocked(false);
    }

    public void visitEnter(FormalProof proof) {
        if (this.brief) {
            this.setBlocked(true);
            return;
        }
        this.tabLevel = 0;
        this.printer.println("\\begin{proof}");
    }

    public void visitEnter(FormalProofLineList lines) {
        if (this.tabLevel == 0) {
            this.printer.println("\\mbox{}\\\\");
            this.printer.println("\\begin{longtable}[h!]{r@{\\extracolsep{\\fill}}p{9cm}@{\\extracolsep{\\fill}}p{4cm}}");
        }
    }

    public void visitLeave(FormalProofLineList lines) {
        if (this.tabLevel == 0) {
            this.printer.println(" & & \\qedhere");
            this.printer.println("\\end{longtable}");
        }
    }

    public void visitEnter(FormalProofLine line) {
        this.label = line.getLabel() != null ? line.getLabel() : "";
        this.formula = line.getFormula() != null ? "$" + this.getQedeqBo().getElement2Latex().getLatex(line.getFormula().getElement()) + "$" : "";
        this.reason = line.getReason() != null ? line.getReason().toString() : "";
    }

    public void visitLeave(FormalProofLine line) {
        if (this.brief) {
            return;
        }
        this.linePrintln();
    }

    private void linePrintln() {
        if (this.formula.length() == 0 && this.reason.length() == 0) {
            return;
        }
        if (this.label.length() > 0) {
            String display = this.getNodeBo().getNodeVo().getId() + "!" + this.label;
            this.printer.print("\\label{" + display + "} \\hypertarget{" + display + "}{\\mbox{(" + this.label + ")}} ");
        }
        this.printer.print(" \\ &  \\ ");
        for (int i = 0; i < this.tabLevel; ++i) {
            this.printer.print("\\mbox{\\qquad}");
        }
        if (this.formula.length() > 0) {
            this.printer.print(this.formula);
        }
        this.printer.print(" \\ &  \\ ");
        if (this.reason.length() > 0) {
            this.printer.print("{\\tiny ");
            this.printer.print(this.reason);
            this.printer.print("}");
        }
        this.printer.println(" \\\\ ");
        this.reason = "";
        this.formula = "";
        this.label = "";
    }

    private String getReference(String reference) {
        return this.getReference(reference, "getReference()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getReference(String reference, String subContext) {
        String context = this.getCurrentContext().getLocationWithinModule();
        try {
            this.getCurrentContext().setLocationWithinModule(context + "." + subContext);
            String string = this.getReference(reference, null, null);
            Object var6_5 = null;
            this.getCurrentContext().setLocationWithinModule(context);
            return string;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.getCurrentContext().setLocationWithinModule(context);
            throw throwable;
        }
    }

    public void visitEnter(ModusPonens r) throws ModuleDataException {
        if (this.brief) {
            return;
        }
        this.reason = this.getRuleReference(r.getName());
        boolean one = false;
        if (r.getReference1() != null) {
            this.reason = this.reason + " " + this.getReference(r.getReference1(), "getReference1()");
            one = true;
        }
        if (r.getReference1() != null) {
            if (one) {
                this.reason = this.reason + ",";
            }
            this.reason = this.reason + " " + this.getReference(r.getReference2(), "getReference2()");
        }
    }

    public void visitEnter(Add r) throws ModuleDataException {
        if (this.brief) {
            return;
        }
        this.reason = this.getRuleReference(r.getName());
        if (r.getReference() != null) {
            this.reason = this.reason + " " + this.getReference(r.getReference());
        }
    }

    public void visitEnter(Rename r) throws ModuleDataException {
        if (this.brief) {
            return;
        }
        this.reason = this.getRuleReference(r.getName());
        if (r.getOriginalSubjectVariable() != null) {
            this.reason = this.reason + " $" + this.getQedeqBo().getElement2Latex().getLatex(r.getOriginalSubjectVariable()) + "$";
        }
        if (r.getReplacementSubjectVariable() != null) {
            this.reason = this.reason + " by $" + this.getQedeqBo().getElement2Latex().getLatex(r.getReplacementSubjectVariable()) + "$";
        }
        if (r.getReference() != null) {
            this.reason = this.reason + " in " + this.getReference(r.getReference());
        }
    }

    public void visitEnter(SubstFree r) throws ModuleDataException {
        if (this.brief) {
            return;
        }
        this.reason = this.getRuleReference(r.getName());
        if (r.getSubjectVariable() != null) {
            this.reason = this.reason + " $" + this.getQedeqBo().getElement2Latex().getLatex(r.getSubjectVariable()) + "$";
        }
        if (r.getSubstituteTerm() != null) {
            this.reason = this.reason + " by $" + this.getQedeqBo().getElement2Latex().getLatex(r.getSubstituteTerm()) + "$";
        }
        if (r.getReference() != null) {
            this.reason = this.reason + " in " + this.getReference(r.getReference());
        }
    }

    public void visitEnter(SubstFunc r) throws ModuleDataException {
        if (this.brief) {
            return;
        }
        this.reason = this.getRuleReference(r.getName());
        if (r.getFunctionVariable() != null) {
            this.reason = this.reason + " $" + this.getQedeqBo().getElement2Latex().getLatex(r.getFunctionVariable()) + "$";
        }
        if (r.getSubstituteTerm() != null) {
            this.reason = this.reason + " by $" + this.getQedeqBo().getElement2Latex().getLatex(r.getSubstituteTerm()) + "$";
        }
        if (r.getReference() != null) {
            this.reason = this.reason + " in " + this.getReference(r.getReference());
        }
    }

    public void visitEnter(SubstPred r) throws ModuleDataException {
        if (this.brief) {
            return;
        }
        this.reason = this.getRuleReference(r.getName());
        if (r.getPredicateVariable() != null) {
            this.reason = this.reason + " $" + this.getQedeqBo().getElement2Latex().getLatex(r.getPredicateVariable()) + "$";
        }
        if (r.getSubstituteFormula() != null) {
            this.reason = this.reason + " by $" + this.getQedeqBo().getElement2Latex().getLatex(r.getSubstituteFormula()) + "$";
        }
        if (r.getReference() != null) {
            this.reason = this.reason + " in " + this.getReference(r.getReference());
        }
    }

    public void visitEnter(Existential r) throws ModuleDataException {
        if (this.brief) {
            return;
        }
        this.reason = this.getRuleReference(r.getName());
        if (r.getSubjectVariable() != null) {
            this.reason = this.reason + " with $" + this.getQedeqBo().getElement2Latex().getLatex(r.getSubjectVariable()) + "$";
        }
        if (r.getReference() != null) {
            this.reason = this.reason + " in " + this.getReference(r.getReference());
        }
    }

    public void visitEnter(Universal r) throws ModuleDataException {
        if (this.brief) {
            return;
        }
        this.reason = this.getRuleReference(r.getName());
        if (r.getSubjectVariable() != null) {
            this.reason = this.reason + " with $" + this.getQedeqBo().getElement2Latex().getLatex(r.getSubjectVariable()) + "$";
        }
        if (r.getReference() != null) {
            this.reason = this.reason + " in " + this.getReference(r.getReference());
        }
    }

    public void visitEnter(ConditionalProof r) throws ModuleDataException {
        if (this.brief) {
            return;
        }
        this.reason = this.getRuleReference(r.getName());
        this.printer.print(" \\ &  \\ ");
        for (int i = 0; i < this.tabLevel; ++i) {
            this.printer.print("\\mbox{\\qquad}");
        }
        this.printer.println("Conditional Proof");
        this.printer.print(" \\ &  \\ ");
        this.printer.println(" \\\\ ");
        ++this.tabLevel;
    }

    public void visitLeave(ConditionalProof proof) {
        if (this.brief) {
            return;
        }
        --this.tabLevel;
    }

    public void visitEnter(Hypothesis hypothesis) {
        if (this.brief) {
            return;
        }
        this.reason = "Hypothesis";
        if (hypothesis.getLabel() != null) {
            this.label = hypothesis.getLabel();
        }
        if (hypothesis.getFormula() != null) {
            this.formula = "$" + this.getQedeqBo().getElement2Latex().getLatex(hypothesis.getFormula().getElement()) + "$";
        }
    }

    public void visitLeave(Hypothesis hypothesis) {
        if (this.brief) {
            return;
        }
        this.linePrintln();
    }

    public void visitEnter(Conclusion conclusion) {
        if (this.brief) {
            return;
        }
        --this.tabLevel;
        this.reason = "Conclusion";
        if (conclusion.getLabel() != null) {
            this.label = conclusion.getLabel();
        }
        if (conclusion.getFormula() != null) {
            this.formula = "$" + this.getQedeqBo().getElement2Latex().getLatex(conclusion.getFormula().getElement()) + "$";
        }
    }

    public void visitLeave(Conclusion conclusion) {
        if (this.brief) {
            return;
        }
        this.linePrintln();
        ++this.tabLevel;
    }

    public void visitLeave(FormalProof proof) {
        if (!this.getBlocked()) {
            this.printer.println("\\end{proof}");
        }
        this.setBlocked(false);
    }

    public void visitEnter(InitialPredicateDefinition definition) {
        this.printer.println("\\begin{idefn}" + (this.title != null ? "[" + this.title + "]" : ""));
        this.printer.println("\\label{" + this.id + "} \\hypertarget{" + this.id + "}{}");
        if (this.info) {
            this.printer.println("{\\tt \\tiny [\\verb]" + this.id + "]]}");
        }
        this.printer.print("$$");
        this.printer.println(this.getLatex(definition.getPredCon()));
        this.printer.println("$$");
        this.printer.println(this.getLatexListEntry("getDescription()", definition.getDescription()));
        this.printer.println("\\end{idefn}");
    }

    public void visitEnter(PredicateDefinition definition) {
        this.printer.println("\\begin{defn}" + (this.title != null ? "[" + this.title + "]" : ""));
        this.printer.println("\\label{" + this.id + "} \\hypertarget{" + this.id + "}{}");
        if (this.info) {
            this.printer.println("{\\tt \\tiny [\\verb]" + this.id + "]]}");
        }
        this.printer.print("$$");
        this.printer.print(this.getLatex(definition.getFormula().getElement()));
        this.printer.println("$$");
        this.printer.println(this.getLatexListEntry("getDescription()", definition.getDescription()));
        this.printer.println("\\end{defn}");
    }

    public void visitEnter(InitialFunctionDefinition definition) {
        this.printer.println("\\begin{idefn}" + (this.title != null ? "[" + this.title + "]" : ""));
        this.printer.println("\\label{" + this.id + "} \\hypertarget{" + this.id + "}{}");
        if (this.info) {
            this.printer.println("{\\tt \\tiny [\\verb]" + this.id + "]]}");
        }
        this.printer.print("$$");
        this.printer.print(this.getLatex(definition.getFunCon()));
        this.printer.println("$$");
        this.printer.println(this.getLatexListEntry("getDescription()", definition.getDescription()));
        this.printer.println("\\end{defn}");
    }

    public void visitEnter(FunctionDefinition definition) {
        this.printer.println("\\begin{defn}" + (this.title != null ? "[" + this.title + "]" : ""));
        this.printer.println("\\label{" + this.id + "} \\hypertarget{" + this.id + "}{}");
        if (this.info) {
            this.printer.println("{\\tt \\tiny [\\verb]" + this.id + "]]}");
        }
        this.printer.print("$$");
        this.printer.print(this.getLatex(definition.getFormula().getElement()));
        this.printer.println("$$");
        this.printer.println("\\end{defn}");
    }

    public void visitLeave(FunctionDefinition definition) {
    }

    public void visitEnter(Rule rule) {
        this.printer.println("\\begin{rul}" + (this.title != null ? "[" + this.title + "]" : ""));
        this.printer.println("\\label{" + this.id + "} \\hypertarget{" + this.id + "}{}");
        if (this.info) {
            this.printer.println("{\\tt \\tiny [\\verb]" + this.id + "]]}");
        }
        this.printer.println();
        this.printer.println("\\par");
        this.printer.println("{\\em " + (rule.getName() != null ? "  Name: \\verb]" + rule.getName() + "]" : "") + (rule.getVersion() != null ? "  -  Version: \\verb]" + rule.getVersion() + "]" : "") + "}");
        this.printer.println();
        this.printer.println();
        this.printer.println(this.getLatexListEntry("getDescription()", rule.getDescription()));
        this.printer.println("\\end{rul}");
    }

    public void visitLeave(Rule rule) {
    }

    public void visitEnter(LinkList linkList) {
        if (linkList.size() <= 0) {
            return;
        }
        if ("de".equals(this.language)) {
            this.printer.println("Basierend auf: ");
        } else {
            if (!"en".equals(this.language)) {
                this.printer.println("%%% TODO unknown language: " + this.language);
            }
            this.printer.println("Based on: ");
        }
        for (int i = 0; i < linkList.size(); ++i) {
            if (linkList.get(i) == null) continue;
            this.printer.print(" " + this.getReference(linkList.get(i), "get(" + i + ")"));
        }
        this.printer.println();
    }

    public void visitEnter(ChangedRuleList list) {
        if (list.size() <= 0) {
            return;
        }
        if ("de".equals(this.language)) {
            this.printer.println("Die folgenden Regeln m\u00fcssen erweitert werden.");
        } else {
            if (!"en".equals(this.language)) {
                this.printer.println("%%% TODO unknown language: " + this.language);
            }
            this.printer.println("The following rules have to be extended.");
        }
        this.printer.println();
    }

    public void visitEnter(ChangedRule rule) {
        this.printer.println("\\par");
        this.printer.println("\\label{" + this.id + "!" + rule.getName() + "} \\hypertarget{" + this.id + "!" + rule.getName() + "}{}");
        this.printer.print("{\\em " + (rule.getName() != null ? "  Name: \\verb]" + rule.getName() + "]" : "") + (rule.getVersion() != null ? "  -  Version: \\verb]" + rule.getVersion() + "]" : ""));
        RuleKey old = this.getLocalRuleKey(rule.getName());
        if (old == null && this.getQedeqBo().getExistenceChecker() != null) {
            old = this.getQedeqBo().getExistenceChecker().getParentRuleKey(rule.getName());
        }
        if (old != null) {
            this.printer.print("  -  Old Version: " + this.getRuleReference(rule.getName(), old.getVersion()));
        }
        this.printer.println("}");
        rule.getName();
        this.printer.println();
        if (rule.getDescription() != null) {
            this.printer.println(this.getLatexListEntry("getDescription()", rule.getDescription()));
            this.printer.println();
            this.printer.println();
        }
    }

    public void visitEnter(LiteratureItemList list) {
        this.printer.println("\\backmatter");
        this.printer.println();
        this.printer.println("\\begin{thebibliography}{99}");
        if ("de".equals(this.language)) {
            this.printer.println("\\addcontentsline{toc}{chapter}{Literaturverzeichnis}");
        } else {
            if (!"en".equals(this.language)) {
                this.printer.println("%%% TODO unknown language: " + this.language);
            }
            this.printer.println("\\addcontentsline{toc}{chapter}{Bibliography}");
        }
        ImportList imports = this.getQedeqBo().getQedeq().getHeader().getImportList();
        if (imports != null && imports.size() > 0) {
            this.printer.println();
            this.printer.println();
            this.printer.println("%% Used other QEDEQ modules:");
            for (int i = 0; i < imports.size(); ++i) {
                Import imp = imports.get(i);
                this.printer.print("\\bibitem{" + imp.getLabel() + "} ");
                Specification spec = imp.getSpecification();
                this.printer.print(this.getLatex(spec.getName()));
                if (spec.getLocationList() != null && spec.getLocationList().size() > 0 && spec.getLocationList().get(0).getLocation().length() > 0) {
                    this.printer.print(" ");
                    this.printer.print("\\url{" + this.getPdfLink((KernelQedeqBo)this.getQedeqBo().getLabels().getReferences().getQedeqBo(imp.getLabel())) + "}");
                }
                this.printer.println();
            }
            this.printer.println();
            this.printer.println();
            this.printer.println("%% Other references:");
            this.printer.println();
        }
    }

    public void visitLeave(LiteratureItemList list) {
        UsedByList usedby = this.getQedeqBo().getQedeq().getHeader().getUsedByList();
        if (usedby != null && usedby.size() > 0) {
            this.printer.println();
            this.printer.println();
            this.printer.println("%% QEDEQ modules that use this one:");
            for (int i = 0; i < usedby.size(); ++i) {
                Specification spec = usedby.get(i);
                this.printer.print("\\bibitem{" + spec.getName() + "} ");
                this.printer.print(this.getLatex(spec.getName()));
                String url = this.getUrl(this.getQedeqBo().getModuleAddress(), spec);
                if (url != null && url.length() > 0) {
                    this.printer.print(" ");
                    this.printer.print("\\url{" + url + "}");
                }
                this.printer.println();
            }
            this.printer.println();
            this.printer.println();
        }
        this.printer.println("\\end{thebibliography}");
    }

    public void visitEnter(LiteratureItem item) {
        this.printer.print("\\bibitem{" + item.getLabel() + "} ");
        this.printer.println(this.getLatexListEntry("getItem()", item.getItem()));
        this.printer.println();
    }

    private void printTopFormula(Element element, String mainLabel) {
        if (!element.isList() || !element.getList().getOperator().equals("AND")) {
            this.printFormula(element);
            return;
        }
        ElementList list = element.getList();
        this.printer.println("\\mbox{}");
        this.printer.println("\\begin{longtable}{{@{\\extracolsep{\\fill}}p{0.9\\linewidth}l}}");
        for (int i = 0; i < list.size(); ++i) {
            String newLabel = "";
            if (list.size() >= ALPHABET.length() * ALPHABET.length()) {
                newLabel = "" + (i + 1);
            } else {
                if (list.size() > ALPHABET.length()) {
                    int div = i / ALPHABET.length();
                    newLabel = "" + ALPHABET.charAt(div);
                }
                newLabel = newLabel + ALPHABET.charAt(i % ALPHABET.length());
            }
            this.printer.println("\\centering $" + this.getLatex(list.getElement(i)) + "$" + " & \\label{" + mainLabel + "/" + newLabel + "} \\hypertarget{" + mainLabel + "/" + newLabel + "}{} \\mbox{\\emph{(" + newLabel + ")}} " + (i + 1 < list.size() ? "\\\\" : ""));
        }
        this.printer.println("\\end{longtable}");
    }

    private void printFormula(Element element) {
        this.printer.println("\\mbox{}");
        this.printer.println("\\begin{longtable}{{@{\\extracolsep{\\fill}}p{\\linewidth}}}");
        this.printer.println("\\centering $" + this.getLatex(element) + "$");
        this.printer.println("\\end{longtable}");
    }

    private String getLatex(Element element) {
        return this.getQedeqBo().getElement2Latex().getLatex(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getLatexListEntry(String method, LatexList list) {
        String string;
        block12: {
            String string2;
            block11: {
                String string3;
                block10: {
                    if (list == null) {
                        return "";
                    }
                    if (method.length() > 0) {
                        this.subContext = method;
                    }
                    try {
                        int i;
                        for (int i2 = 0; this.language != null && i2 < list.size(); ++i2) {
                            if (!this.language.equals(list.get(i2).getLanguage())) continue;
                            if (method.length() > 0) {
                                this.subContext = method + ".get(" + i2 + ")";
                            }
                            String string4 = this.getLatex(list.get(i2));
                            Object var7_8 = null;
                            if (method.length() <= 0) return string4;
                            this.subContext = "";
                            return string4;
                        }
                        String def = this.getQedeqBo().getOriginalLanguage();
                        for (i = 0; i < list.size(); ++i) {
                            if (!EqualsUtility.equals(def, list.get(i).getLanguage())) continue;
                            if (method.length() > 0) {
                                this.subContext = method + ".get(" + i + ")";
                            }
                            string3 = "MISSING! OTHER: " + this.getLatex(list.get(i));
                            break block10;
                        }
                        for (i = 0; i < list.size(); ++i) {
                            if (method.length() > 0) {
                                this.subContext = method + ".get(" + i + ")";
                            }
                            if (null == list.get(i) || null == list.get(i).getLatex() || list.get(i).getLatex().trim().length() <= 0) continue;
                            string2 = "MISSING! OTHER: " + this.getLatex(list.get(i));
                            break block11;
                        }
                        string = "MISSING!";
                        break block12;
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        if (method.length() <= 0) throw throwable;
                        this.subContext = "";
                        throw throwable;
                    }
                }
                Object var7_9 = null;
                if (method.length() <= 0) return string3;
                this.subContext = "";
                return string3;
            }
            Object var7_10 = null;
            if (method.length() <= 0) return string2;
            this.subContext = "";
            return string2;
        }
        Object var7_11 = null;
        if (method.length() <= 0) return string;
        this.subContext = "";
        return string;
    }

    private String getLatex(Latex latex) {
        if (latex == null || latex.getLatex() == null) {
            return "";
        }
        StringBuffer result = new StringBuffer(latex.getLatex());
        this.transformQref(result);
        return this.deleteLineLeadingWhitespace(result.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transformQref(StringBuffer result) {
        String method = "transformQref(StringBuffer)";
        StringBuffer buffer = new StringBuffer(result.toString());
        TextInput input = new TextInput(buffer);
        int last = 0;
        try {
            result.setLength(0);
            while (input.forward("\\qref{")) {
                SourcePosition startPosition = input.getSourcePosition();
                int start = input.getPosition();
                if (!input.forward("}")) {
                    this.addWarning(80007, "ending \"}\" for \"\\qref{\" not found within 1024 characters", startPosition, input.getSourcePosition());
                    continue;
                }
                String ref = input.getSubstring(start + "\\qref{".length(), input.getPosition()).trim();
                input.read();
                Trace.param(CLASS, (Object)this, "transformQref(StringBuffer)", "1 ref", ref);
                if (ref.length() == 0) {
                    this.addWarning(80008, "empty reference: \"\\qref{}\"", startPosition, input.getSourcePosition());
                    continue;
                }
                if (ref.length() > 1024) {
                    this.addWarning(80007, "ending \"}\" for \"\\qref{\" not found within 1024 characters", startPosition, input.getSourcePosition());
                    continue;
                }
                if (ref.indexOf("{") >= 0) {
                    this.addWarning(80007, "ending \"}\" for \"\\qref{\" not found within 1024 characters", startPosition, input.getSourcePosition());
                    continue;
                }
                int end = input.getPosition();
                SourcePosition endPosition = input.getSourcePosition();
                result.append(buffer.substring(last, start));
                result.append(this.getReference(ref, startPosition, endPosition));
                last = end;
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            IoUtility.close(input);
            if (last < buffer.length()) {
                result.append(buffer.substring(last));
            }
            throw throwable;
        }
        IoUtility.close(input);
        if (last < buffer.length()) {
            result.append(buffer.substring(last));
        }
    }

    private String getReference(String reference, SourcePosition start, SourcePosition end) {
        String method = "getReference(String, String)";
        Trace.param(CLASS, (Object)this, "getReference(String, String)", "2 reference", reference);
        Reference ref = this.getReference(reference, this.getCurrentContext(start, end), true, false);
        if (ref.isNodeLocalReference() && ref.isSubReference()) {
            return "\\hyperlink{" + ref.getNodeLabel() + "/" + ref.getSubLabel() + "}{" + "(" + ref.getSubLabel() + ")" + "}";
        }
        if (ref.isNodeLocalReference() && ref.isProofLineReference()) {
            return "\\hyperlink{" + ref.getNodeLabel() + "!" + ref.getProofLineLabel() + "}{" + "(" + ref.getProofLineLabel() + ")" + "}";
        }
        if (!ref.isExternal()) {
            return "\\hyperlink{" + ref.getNodeLabel() + (ref.isSubReference() ? "/" + ref.getSubLabel() : "") + (ref.isProofLineReference() ? "!" + ref.getProofLineLabel() : "") + "}{" + this.getNodeDisplay(ref.getNodeLabel(), ref.getNode()) + (ref.isSubReference() ? " (" + ref.getSubLabel() + ")" : "") + (ref.isProofLineReference() ? " (" + ref.getProofLineLabel() + ")" : "") + "}";
        }
        if (ref.isExternalModuleReference()) {
            return "\\url{" + this.getPdfLink(ref.getExternalQedeq()) + "}~\\cite{" + ref.getExternalQedeqLabel() + "}";
        }
        String external = this.getPdfLink(ref.getExternalQedeq());
        if (external.startsWith("file://")) {
            external = "file:" + external.substring("file://".length());
        }
        return "\\hyperref{" + external + "}{}{" + ref.getNodeLabel() + (ref.isSubReference() ? "/" + ref.getSubLabel() : "") + (ref.isProofLineReference() ? "!" + ref.getProofLineLabel() : "") + "}{" + this.getNodeDisplay(ref.getNodeLabel(), ref.getNode()) + (ref.isSubReference() ? " (" + ref.getSubLabel() + ")" : "") + (ref.isProofLineReference() ? " (" + ref.getProofLineLabel() + ")" : "") + "}~\\cite{" + ref.getExternalQedeqLabel() + "}";
    }

    private String getNodeDisplay(String label, KernelNodeBo kNode) {
        return StringUtility.replace(this.getNodeDisplay(label, kNode, this.language), " ", "~");
    }

    private String getRuleReference(String ruleName) {
        return this.getRuleReference(ruleName, ruleName);
    }

    private String getRuleReference(String ruleName, String caption) {
        String method = "getRuleReference(String, String)";
        Trace.param(CLASS, (Object)this, "getRuleReference(String, String)", "ruleName", ruleName);
        RuleKey key = this.getLocalRuleKey(ruleName);
        if (key == null && this.getQedeqBo().getExistenceChecker() != null) {
            key = this.getQedeqBo().getExistenceChecker().getParentRuleKey(ruleName);
        }
        if (key == null) {
            key = this.getQedeqBo().getLabels().getRuleKey(ruleName);
        }
        KernelQedeqBo qedeq = this.getQedeqBo();
        if (this.getQedeqBo().getExistenceChecker() != null) {
            qedeq = this.getQedeqBo().getExistenceChecker().getQedeq(key);
        }
        String localRef = this.getQedeqBo().getLabels().getRuleLabel(key);
        String refRuleName = qedeq.getLabels().getRule(key).getName();
        if (!ruleName.equals(refRuleName)) {
            localRef = localRef + "!" + ruleName;
        }
        qedeq.getLabels().getRule(key).getName();
        boolean local = this.getQedeqBo().equals(qedeq);
        if (local) {
            return "\\hyperlink{" + localRef + "}{" + caption + "}";
        }
        String external = this.getPdfLink(qedeq);
        if (external.startsWith("file://")) {
            external = "file:" + external.substring("file://".length());
        }
        return "\\hyperref{" + external + "}{}{" + caption + "}{" + localRef + "}";
    }

    public ModuleContext getCurrentContext(SourcePosition startDelta, SourcePosition endDelta) {
        if (this.subContext.length() == 0) {
            return super.getCurrentContext();
        }
        ModuleContext c = new ModuleContext(super.getCurrentContext().getModuleLocation(), super.getCurrentContext().getLocationWithinModule() + "." + this.subContext, startDelta, endDelta);
        return c;
    }

    private void addWarning(int code, String msg, SourcePosition startDelta, SourcePosition endDelta) {
        Trace.param(CLASS, (Object)this, "addWarning", "msg", msg);
        this.addWarning(new LatexContentException(code, msg, this.getCurrentContext(startDelta, endDelta)));
    }

    private String getPdfLink(KernelQedeqBo prop) {
        if (prop == null) {
            return "";
        }
        String url = prop.getUrl();
        int dot = url.lastIndexOf(".");
        if (prop.isSupportedLanguage(this.language)) {
            return url.substring(0, dot) + "_" + this.language + ".pdf";
        }
        String a = prop.getOriginalLanguage();
        return url.substring(0, dot) + (a.length() > 0 ? "_" + a : "") + ".pdf";
    }

    private String getLatex(String text) {
        StringBuffer buffer = new StringBuffer(text);
        StringUtility.replace(buffer, "\\", "\\textbackslash");
        StringUtility.replace(buffer, "$", "\\$");
        StringUtility.replace(buffer, "&", "\\&");
        StringUtility.replace(buffer, "%", "\\%");
        StringUtility.replace(buffer, "#", "\\#");
        StringUtility.replace(buffer, "_", "\\_");
        StringUtility.replace(buffer, "{", "\\{");
        StringUtility.replace(buffer, "}", "\\}");
        StringUtility.replace(buffer, "~", "\\textasciitilde");
        StringUtility.replace(buffer, "^", "\\textasciicircum");
        StringUtility.replace(buffer, "<", "\\textless");
        StringUtility.replace(buffer, ">", "\\textgreater");
        StringUtility.deleteLineLeadingWhitespace(buffer);
        return buffer.toString().trim();
    }

    private String deleteLineLeadingWhitespace(String text) {
        StringBuffer buffer = new StringBuffer(text);
        StringUtility.deleteLineLeadingWhitespace(buffer);
        return buffer.toString().trim();
    }

    private String escapeUmlauts(String nearlyLatex) {
        if (nearlyLatex == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(nearlyLatex);
        StringUtility.replace(buffer, "\u00fc", "{\\\"u}");
        StringUtility.replace(buffer, "\u00f6", "{\\\"o}");
        StringUtility.replace(buffer, "\u00e4", "{\\\"a}");
        StringUtility.replace(buffer, "\u00dc", "{\\\"U}");
        StringUtility.replace(buffer, "\u00d6", "{\\\"O}");
        StringUtility.replace(buffer, "\u00c4", "{\\\"A}");
        StringUtility.replace(buffer, "\u00df", "{\\ss}");
        return buffer.toString();
    }
}

