/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service.heuristic;

import org.qedeq.base.io.Parameters;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.log.QedeqLog;
import org.qedeq.kernel.bo.logic.model.DynamicDirectInterpreter;
import org.qedeq.kernel.bo.logic.model.DynamicModel;
import org.qedeq.kernel.bo.logic.model.FourDynamicModel;
import org.qedeq.kernel.bo.logic.model.HeuristicException;
import org.qedeq.kernel.bo.logic.model.ModelFunctionConstant;
import org.qedeq.kernel.bo.logic.model.ModelPredicateConstant;
import org.qedeq.kernel.bo.module.ControlVisitor;
import org.qedeq.kernel.bo.module.InternalServiceProcess;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.PluginBo;
import org.qedeq.kernel.bo.module.PluginExecutor;
import org.qedeq.kernel.se.base.list.Element;
import org.qedeq.kernel.se.base.module.Axiom;
import org.qedeq.kernel.se.base.module.ConditionalProof;
import org.qedeq.kernel.se.base.module.FormalProofLine;
import org.qedeq.kernel.se.base.module.FunctionDefinition;
import org.qedeq.kernel.se.base.module.InitialFunctionDefinition;
import org.qedeq.kernel.se.base.module.InitialPredicateDefinition;
import org.qedeq.kernel.se.base.module.Node;
import org.qedeq.kernel.se.base.module.PredicateDefinition;
import org.qedeq.kernel.se.base.module.Proposition;
import org.qedeq.kernel.se.base.module.Rule;
import org.qedeq.kernel.se.common.ModuleContext;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.common.SourceFileExceptionList;
import org.qedeq.kernel.se.dto.list.DefaultElementList;

public final class DynamicHeuristicCheckerExecutor
extends ControlVisitor
implements PluginExecutor {
    private static final Class CLASS = DynamicHeuristicCheckerExecutor.class;
    private final DynamicDirectInterpreter interpreter;
    private DefaultElementList condition;

    DynamicHeuristicCheckerExecutor(PluginBo plugin, KernelQedeqBo qedeq, Parameters parameters) {
        super(plugin, qedeq);
        String method = "DynamicHeuristicChecker(PluginBo, QedeqBo, Map)";
        String modelClass = parameters.getString("model");
        DynamicModel model = null;
        if (modelClass != null && modelClass.length() > 0) {
            try {
                Class<?> cl = Class.forName(modelClass);
                model = (DynamicModel)cl.newInstance();
            }
            catch (ClassNotFoundException e) {
                Trace.fatal(CLASS, this, "DynamicHeuristicChecker(PluginBo, QedeqBo, Map)", "Model class not in class path: " + modelClass, e);
            }
            catch (InstantiationException e) {
                Trace.fatal(CLASS, this, "DynamicHeuristicChecker(PluginBo, QedeqBo, Map)", "Model class could not be instanciated: " + modelClass, e);
            }
            catch (IllegalAccessException e) {
                Trace.fatal(CLASS, this, "DynamicHeuristicChecker(PluginBo, QedeqBo, Map)", "Programming error, access for instantiation failed for model: " + modelClass, e);
            }
            catch (RuntimeException e) {
                Trace.fatal(CLASS, this, "DynamicHeuristicChecker(PluginBo, QedeqBo, Map)", "Programming error, instantiation failed for model: " + modelClass, e);
            }
        }
        if (model == null) {
            model = new FourDynamicModel();
        }
        this.interpreter = new DynamicDirectInterpreter(qedeq, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executePlugin(InternalServiceProcess process, Object data) {
        block7: {
            String method = "executePlugin()";
            try {
                try {
                    QedeqLog.getInstance().logRequest("Dynamic heuristic test", this.getQedeqBo().getUrl());
                    try {
                        this.getServices().checkWellFormedness(this.getQedeqBo(), process);
                    }
                    catch (Exception e) {
                        Trace.trace(CLASS, "executePlugin()", e);
                    }
                    this.condition = new DefaultElementList("AND");
                    this.traverse(process);
                    QedeqLog.getInstance().logSuccessfulReply("Heuristic test succesfull", this.getQedeqBo().getUrl());
                }
                catch (SourceFileExceptionList e) {
                    String msg = "Test failed";
                    Trace.fatal(CLASS, this, "executePlugin()", "Test failed", e);
                    QedeqLog.getInstance().logFailureReply("Test failed", this.getQedeqBo().getUrl(), e.getMessage());
                    Object var7_8 = null;
                    this.getQedeqBo().addPluginErrorsAndWarnings(this.getPlugin(), this.getErrorList(), this.getWarningList());
                    break block7;
                }
                catch (RuntimeException e) {
                    Trace.fatal(CLASS, this, "executePlugin()", "unexpected problem", e);
                    QedeqLog.getInstance().logFailureReply("Test failed", this.getQedeqBo().getUrl(), "unexpected problem: " + (e.getMessage() != null ? e.getMessage() : e.toString()));
                    Object var7_9 = null;
                    this.getQedeqBo().addPluginErrorsAndWarnings(this.getPlugin(), this.getErrorList(), this.getWarningList());
                }
                Object var7_7 = null;
                this.getQedeqBo().addPluginErrorsAndWarnings(this.getPlugin(), this.getErrorList(), this.getWarningList());
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                this.getQedeqBo().addPluginErrorsAndWarnings(this.getPlugin(), this.getErrorList(), this.getWarningList());
                throw throwable;
            }
        }
        return null;
    }

    private void test(Element test) {
        boolean useCondition = this.condition.size() > 0;
        try {
            Element toast = test;
            if (this.condition.size() > 0) {
                DefaultElementList withCondition = new DefaultElementList("IMPL");
                withCondition.add(this.condition);
                withCondition.add(test);
                toast = withCondition;
            }
            if (!this.isTautology(this.getCurrentContext(), toast)) {
                this.addWarning(new HeuristicException(77007, "no tautology in our model (\"" + this.interpreter.getModel().getName() + "\")", this.getCurrentContext()));
            }
        }
        catch (HeuristicException h) {
            String begin = this.getCurrentContext().getLocationWithinModule();
            if (!this.getCurrentContext().getModuleLocation().equals(h.getContext().getModuleLocation()) || !h.getContext().getLocationWithinModule().startsWith(begin)) {
                this.addWarning(new HeuristicException(h.getErrorCode(), h.getMessage(), this.getCurrentContext()));
            } else {
                String further = h.getContext().getLocationWithinModule().substring(begin.length());
                if (useCondition) {
                    if (further.startsWith(".getList().getElement(1)")) {
                        further = further.substring(".getList().getElement(1)".length());
                        this.addWarning(new HeuristicException(h.getErrorCode(), h.getMessage(), new ModuleContext(h.getContext().getModuleLocation(), begin + further)));
                    } else {
                        this.addWarning(new HeuristicException(h.getErrorCode(), h.getMessage(), this.getCurrentContext()));
                    }
                } else {
                    this.addWarning(h);
                }
            }
        }
        catch (RuntimeException e) {
            Trace.fatal(CLASS, this, "test(Element)", "unexpected runtime exception", e);
            if (e.getCause() != null && e.getCause() instanceof HeuristicException) {
                HeuristicException h = (HeuristicException)e.getCause();
                this.addWarning(new HeuristicException(h.getErrorCode(), h.getMessage(), this.getCurrentContext()));
            }
            this.addWarning(new HeuristicException(77777, "runtime problem: " + e, this.getCurrentContext()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTautology(ModuleContext moduleContext, Element formula) throws HeuristicException {
        boolean result = true;
        ModuleContext context = moduleContext;
        try {
            while (result &= this.interpreter.calculateValue(new ModuleContext(context), formula)) {
                if (this.interpreter.next()) continue;
                break;
            }
            Object var6_5 = null;
            this.interpreter.clearVariables();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.interpreter.clearVariables();
            throw throwable;
        }
        return result;
    }

    public void visitEnter(Axiom axiom) throws ModuleDataException {
        if (axiom == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        QedeqLog.getInstance().logMessageState("\ttesting axiom", this.getQedeqBo().getUrl());
        if (axiom.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula().getElement()");
            Element test = axiom.getFormula().getElement();
            this.test(test);
        }
        this.setLocationWithinModule(context);
        this.setBlocked(true);
    }

    public void visitLeave(Axiom axiom) {
        this.setBlocked(false);
    }

    public void visitEnter(InitialPredicateDefinition definition) throws ModuleDataException {
        String method = "visitEnter(InitialPredicateDefinition)";
        if (definition == null) {
            return;
        }
        QedeqLog.getInstance().logMessageState("\ttesting initial predicate definition", this.getQedeqBo().getUrl());
        String context = this.getCurrentContext().getLocationWithinModule();
        try {
            ModelPredicateConstant predicate = new ModelPredicateConstant(definition.getName(), Integer.parseInt(definition.getArgumentNumber()));
            if (!this.interpreter.hasPredicateConstant(predicate)) {
                this.setLocationWithinModule(context + ".getName()");
                this.addWarning(new HeuristicException(77082, "unknown predicate constant: " + predicate, this.getCurrentContext()));
            }
        }
        catch (NumberFormatException e) {
            Trace.fatal(CLASS, this, "visitEnter(InitialPredicateDefinition)", "not suported argument number: " + definition.getArgumentNumber(), e);
            this.setLocationWithinModule(context + ".getArgumentNumber()");
            this.addWarning(new HeuristicException(77100, "unknown format for argument size: " + definition.getArgumentNumber(), this.getCurrentContext()));
        }
        this.setLocationWithinModule(context);
        this.setBlocked(true);
    }

    public void visitLeave(InitialPredicateDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(PredicateDefinition definition) throws ModuleDataException {
        String method = "visitEnter(PredicateDefinition)";
        if (definition == null) {
            return;
        }
        QedeqLog.getInstance().logMessageState("\ttesting predicate definition", this.getQedeqBo().getUrl());
        String context = this.getCurrentContext().getLocationWithinModule();
        try {
            this.setLocationWithinModule(context + ".getFormula().getElement()");
            this.test(definition.getFormula().getElement());
        }
        catch (NumberFormatException e) {
            Trace.fatal(CLASS, this, "visitEnter(PredicateDefinition)", "not suported argument number: " + definition.getArgumentNumber(), e);
            this.setLocationWithinModule(context + ".getArgumentNumber()");
            this.addWarning(new HeuristicException(77100, "unknown format for argument size: " + definition.getArgumentNumber(), this.getCurrentContext()));
        }
        this.setLocationWithinModule(context);
        this.setBlocked(true);
    }

    public void visitLeave(PredicateDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(InitialFunctionDefinition definition) throws ModuleDataException {
        String method = "visitEnter(InitialFunctionDefinition)";
        if (definition == null) {
            return;
        }
        QedeqLog.getInstance().logMessageState("\ttesting initial function definition", this.getQedeqBo().getUrl());
        String context = this.getCurrentContext().getLocationWithinModule();
        try {
            ModelFunctionConstant function = new ModelFunctionConstant(definition.getName(), Integer.parseInt(definition.getArgumentNumber()));
            if (!this.interpreter.hasFunctionConstant(function)) {
                this.setLocationWithinModule(context + ".getName()");
                this.addWarning(new HeuristicException(77092, "unknown function constant: " + function, this.getCurrentContext()));
            }
        }
        catch (NumberFormatException e) {
            Trace.fatal(CLASS, this, "visitEnter(InitialFunctionDefinition)", "not suported argument number: " + definition.getArgumentNumber(), e);
            this.setLocationWithinModule(context + ".getArgumentNumber()");
            this.addWarning(new HeuristicException(77100, "unknown format for argument size: " + definition.getArgumentNumber(), this.getCurrentContext()));
        }
        this.setLocationWithinModule(context);
        this.setBlocked(true);
    }

    public void visitLeave(InitialFunctionDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(FunctionDefinition definition) throws ModuleDataException {
        if (definition == null) {
            return;
        }
        QedeqLog.getInstance().logMessageState("\ttesting function definition", this.getQedeqBo().getUrl());
        String context = this.getCurrentContext().getLocationWithinModule();
        this.setLocationWithinModule(context + ".getFormula().getElement()");
        this.test(definition.getFormula().getElement());
        this.setLocationWithinModule(context);
        this.setBlocked(true);
    }

    public void visitLeave(FunctionDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(Node node) {
        QedeqLog.getInstance().logMessageState(super.getLocationDescription(), this.getQedeqBo().getUrl());
    }

    public void visitEnter(Proposition proposition) throws ModuleDataException {
        if (proposition == null) {
            return;
        }
        QedeqLog.getInstance().logMessageState("\ttesting proposition", this.getQedeqBo().getUrl());
        String context = this.getCurrentContext().getLocationWithinModule();
        if (proposition.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula().getElement()");
            Element test = proposition.getFormula().getElement();
            this.test(test);
        }
        this.setLocationWithinModule(context);
    }

    public void visitLeave(Proposition definition) {
    }

    public void visitEnter(FormalProofLine line) throws ModuleDataException {
        if (line == null) {
            return;
        }
        QedeqLog.getInstance().logMessageState("\t\ttesting line " + line.getLabel(), this.getQedeqBo().getUrl());
        String context = this.getCurrentContext().getLocationWithinModule();
        if (line.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula().getElement()");
            this.test(line.getFormula().getElement());
        }
        this.setLocationWithinModule(context);
        this.setBlocked(true);
    }

    public void visitLeave(FormalProofLine line) {
        this.setBlocked(false);
    }

    public void visitEnter(ConditionalProof line) throws ModuleDataException {
        if (line == null) {
            return;
        }
        if (line.getHypothesis() != null && line.getHypothesis().getFormula() != null && line.getHypothesis().getFormula().getElement() != null) {
            this.condition.add(line.getHypothesis().getFormula().getElement());
            QedeqLog.getInstance().logMessageState("\t\tadd condit. " + line.getHypothesis().getLabel(), this.getQedeqBo().getUrl());
        }
    }

    public void visitLeave(ConditionalProof line) {
        if (line == null) {
            return;
        }
        if (line.getHypothesis() != null && line.getHypothesis().getFormula() != null && line.getHypothesis().getFormula().getElement() != null) {
            this.condition.remove(this.condition.size() - 1);
        }
        QedeqLog.getInstance().logMessageState("\t\ttesting line " + line.getConclusion().getLabel(), this.getQedeqBo().getUrl());
        String context = this.getCurrentContext().getLocationWithinModule();
        if (line.getConclusion().getFormula() != null) {
            this.setLocationWithinModule(context + ".getConclusion().getFormula().getElement()");
            Element test = line.getConclusion().getFormula().getElement();
            this.test(test);
        }
    }

    public void visitEnter(Rule rule) throws ModuleDataException {
        this.setBlocked(true);
    }

    public void visitLeave(Rule rule) {
        this.setBlocked(false);
    }

    public String getLocationDescription() {
        return super.getLocationDescription() + "\n" + this.interpreter.toString();
    }
}

