/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service.dependency;

import java.util.HashMap;
import org.qedeq.base.io.Parameters;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.kernel.bo.log.QedeqLog;
import org.qedeq.kernel.bo.module.ControlVisitor;
import org.qedeq.kernel.bo.module.InternalServiceProcess;
import org.qedeq.kernel.bo.module.KernelModuleReferenceList;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.PluginExecutor;
import org.qedeq.kernel.bo.service.dependency.LoadAllRequiredModulesPlugin;
import org.qedeq.kernel.bo.service.dependency.LoadRequiredModuleException;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileException;
import org.qedeq.kernel.se.common.SourceFileExceptionList;
import org.qedeq.kernel.se.state.DependencyState;

public final class LoadRequiredModulesExecutor
extends ControlVisitor
implements PluginExecutor {
    private static final Class CLASS = LoadRequiredModulesExecutor.class;
    static /* synthetic */ Class class$org$qedeq$kernel$bo$service$dependency$LoadRequiredModulesPlugin;

    LoadRequiredModulesExecutor(Plugin plugin, KernelQedeqBo prop, Parameters parameters) {
        super(plugin, prop);
    }

    public Object executePlugin(InternalServiceProcess process, Object data) {
        Boolean all;
        String method = "executePlugin";
        if (this.getQedeqBo().hasLoadedRequiredModules()) {
            return Boolean.TRUE;
        }
        QedeqLog.getInstance().logRequest("Loading required modules", this.getQedeqBo().getUrl());
        HashMap<KernelQedeqBo, KernelQedeqBo> loadingRequiredInProgress = (HashMap<KernelQedeqBo, KernelQedeqBo>)data;
        if (loadingRequiredInProgress == null) {
            loadingRequiredInProgress = new HashMap<KernelQedeqBo, KernelQedeqBo>();
        }
        if (!(all = (Boolean)this.getServices().executePlugin(LoadAllRequiredModulesPlugin.class.getName(), this.getQedeqBo(), null, process)).booleanValue()) {
            String msg = "Loading required modules failed";
            QedeqLog.getInstance().logFailureReply("Loading required modules failed", this.getQedeqBo().getUrl(), "Not all required modules could not even be loaded.");
            this.getQedeqBo().setDependencyFailureState(DependencyState.STATE_LOADING_REQUIRED_MODULES_FAILED, this.getQedeqBo().getErrors());
            return Boolean.FALSE;
        }
        if (loadingRequiredInProgress.containsKey(this.getQedeqBo())) {
            throw new IllegalStateException("Programming error: must not be marked!");
        }
        this.getQedeqBo().setDependencyProgressState(this.getPlugin(), DependencyState.STATE_LOADING_REQUIRED_MODULES);
        loadingRequiredInProgress.put(this.getQedeqBo(), this.getQedeqBo());
        KernelModuleReferenceList required = (KernelModuleReferenceList)this.getQedeqBo().getRequiredModules();
        SourceFileExceptionList sfl = new SourceFileExceptionList();
        Trace.trace(CLASS, (Object)this, "executePlugin", "loading required modules of " + this.getQedeqBo().getUrl());
        for (int i = 0; i < required.size(); ++i) {
            KernelQedeqBo current = required.getKernelQedeqBo(i);
            if (loadingRequiredInProgress.containsKey(current)) {
                LoadRequiredModuleException me = new LoadRequiredModuleException(90722, "Recursive import of modules is forbidden, label: \"" + required.getLabel(i) + "\"", required.getModuleContext(i));
                sfl.add(this.createError(me));
                continue;
            }
            this.getQedeqBo().getKernelServices().executePlugin((class$org$qedeq$kernel$bo$service$dependency$LoadRequiredModulesPlugin == null ? LoadRequiredModulesExecutor.class$("org.qedeq.kernel.bo.service.dependency.LoadRequiredModulesPlugin") : class$org$qedeq$kernel$bo$service$dependency$LoadRequiredModulesPlugin).getName(), current, loadingRequiredInProgress, process);
            if (current.hasLoadedRequiredModules()) continue;
            String text = "Import of module failed, label: \"" + required.getLabel(i) + "\"";
            if (current.getErrors().size() > 0) {
                text = text + ", " + current.getErrors().get(0).getMessage();
            }
            LoadRequiredModuleException me = new LoadRequiredModuleException(90723, text, required.getModuleContext(i));
            sfl.add(this.createError(me));
        }
        loadingRequiredInProgress.remove(this.getQedeqBo());
        if (this.getQedeqBo().getDependencyState().areAllRequiredLoaded()) {
            return Boolean.TRUE;
        }
        this.getQedeqBo().getLabels().setModuleReferences(required);
        if (!this.getQedeqBo().hasBasicFailures() && sfl.size() == 0) {
            this.getQedeqBo().setLoadedRequiredModules();
            QedeqLog.getInstance().logSuccessfulReply("Loading required modules successful", this.getQedeqBo().getUrl());
            return Boolean.TRUE;
        }
        if (sfl.size() != 0) {
            this.getQedeqBo().setDependencyFailureState(DependencyState.STATE_LOADING_REQUIRED_MODULES_FAILED, sfl);
        } else {
            this.getQedeqBo().setDependencyFailureState(DependencyState.STATE_LOADING_REQUIRED_MODULES_FAILED, this.getQedeqBo().getErrors());
        }
        String msg = "Loading required modules failed";
        QedeqLog.getInstance().logFailureReply("Loading required modules failed", this.getQedeqBo().getUrl(), StringUtility.replace(this.getQedeqBo().getErrors().getMessage(), "\n", "\n\t"));
        return Boolean.FALSE;
    }

    public double getExecutionPercentage() {
        return 1.0;
    }

    public boolean getInterrupted() {
        return false;
    }

    public String getLocationDescription() {
        return "running";
    }

    private SourceFileException createError(ModuleDataException me) {
        return this.getQedeqBo().createSourceFileException(this.getPlugin(), me);
    }
}

