/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service.dependency;

import org.qedeq.base.io.Parameters;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.module.ControlVisitor;
import org.qedeq.kernel.bo.module.InternalServiceProcess;
import org.qedeq.kernel.bo.module.KernelModuleReferenceList;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.PluginExecutor;
import org.qedeq.kernel.bo.service.dependency.LoadRequiredModuleException;
import org.qedeq.kernel.se.base.module.Import;
import org.qedeq.kernel.se.base.module.ImportList;
import org.qedeq.kernel.se.common.ModuleContext;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileExceptionList;
import org.qedeq.kernel.se.state.LoadingImportsState;

public final class LoadDirectlyRequiredModulesExecutor
extends ControlVisitor
implements PluginExecutor {
    private static final Class CLASS = LoadDirectlyRequiredModulesExecutor.class;
    private KernelModuleReferenceList required;

    public LoadDirectlyRequiredModulesExecutor(Plugin plugin, KernelQedeqBo prop, Parameters parameter) {
        super(plugin, prop);
    }

    public Object executePlugin(InternalServiceProcess process, Object data) {
        if (this.getQedeqBo().hasLoadedImports()) {
            return this.getQedeqBo().getRequiredModules();
        }
        this.required = new KernelModuleReferenceList();
        try {
            super.traverse(process);
            this.getQedeqBo().setLoadedImports(this.required);
        }
        catch (SourceFileExceptionList sfl) {
            this.getQedeqBo().setLoadingImportsFailureState(LoadingImportsState.STATE_LOADING_IMPORTS_FAILED, sfl);
        }
        return this.required;
    }

    public KernelModuleReferenceList getRequired() {
        return this.required;
    }

    public void visitEnter(Import imp) throws ModuleDataException {
        ModuleContext context = this.getCurrentContext();
        context.setLocationWithinModule(context.getLocationWithinModule() + ".getLabel()");
        try {
            KernelQedeqBo propNew = this.getQedeqBo().getKernelServices().loadModule(this.getQedeqBo().getModuleAddress(), imp.getSpecification());
            this.getRequired().addLabelUnique(context, imp.getLabel(), propNew);
            Trace.param(CLASS, "visitEnter(Import)", "adding context", this.getCurrentContext());
        }
        catch (SourceFileExceptionList e) {
            LoadRequiredModuleException me = new LoadRequiredModuleException(e.get(0).getErrorCode(), "import of module with label \"" + imp.getLabel() + "\" failed: " + e.get(0).getMessage(), context);
            this.addError(me);
            Trace.trace(CLASS, (Object)this, "visitEnter(Import)", (Throwable)e);
        }
    }

    public void visitLeave(ImportList imports) {
        this.setBlocked(true);
    }
}

