/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service;

import java.util.ArrayList;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.kernel.bo.log.ModuleEventLog;
import org.qedeq.kernel.bo.module.InternalPluginBo;
import org.qedeq.kernel.bo.module.KernelModuleReferenceList;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.ModuleConstantsExistenceChecker;
import org.qedeq.kernel.bo.module.ModuleLabels;
import org.qedeq.kernel.bo.service.DefaultKernelQedeqBo;
import org.qedeq.kernel.bo.service.PluginResultManager;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileExceptionList;
import org.qedeq.kernel.se.dto.module.QedeqVo;
import org.qedeq.kernel.se.state.AbstractState;
import org.qedeq.kernel.se.state.DependencyState;
import org.qedeq.kernel.se.state.FormallyProvedState;
import org.qedeq.kernel.se.state.LoadingImportsState;
import org.qedeq.kernel.se.state.LoadingState;
import org.qedeq.kernel.se.state.WellFormedState;

public class StateManager {
    private static final Class CLASS = StateManager.class;
    private final DefaultKernelQedeqBo bo;
    private int loadingCompleteness;
    private LoadingState loadingState;
    private LoadingImportsState loadingImportsState;
    private DependencyState dependencyState;
    private WellFormedState wellFormedState;
    private FormallyProvedState formallyProvedState;
    private PluginResultManager pluginResults;
    private SourceFileExceptionList errors;
    private Plugin currentlyRunningPlugin;

    StateManager(DefaultKernelQedeqBo bo) {
        this.bo = bo;
        this.loadingState = LoadingState.STATE_UNDEFINED;
        this.loadingCompleteness = 0;
        this.loadingImportsState = LoadingImportsState.STATE_UNDEFINED;
        this.dependencyState = DependencyState.STATE_UNDEFINED;
        this.wellFormedState = WellFormedState.STATE_UNCHECKED;
        this.formallyProvedState = FormallyProvedState.STATE_UNCHECKED;
        this.pluginResults = new PluginResultManager();
    }

    public void delete() {
        this.checkIfDeleted();
        this.invalidateOtherDependentModulesToLoaded();
        this.setLoadingState(LoadingState.STATE_DELETED);
        this.bo.setQedeqVo(null);
        this.bo.getKernelRequiredModules().clear();
        this.bo.getDependentModules().clear();
        this.bo.setLabels(null);
        this.setDependencyState(DependencyState.STATE_UNDEFINED);
        this.setWellFormedState(WellFormedState.STATE_UNCHECKED);
        this.setFormallyProvedState(FormallyProvedState.STATE_UNCHECKED);
        this.setErrors(null);
        ModuleEventLog.getInstance().removeModule(this.bo);
    }

    public boolean hasBasicFailures() {
        return this.loadingState.isFailure() || this.dependencyState.isFailure() || this.wellFormedState.isFailure() || this.formallyProvedState.isFailure();
    }

    public boolean hasErrors() {
        return this.hasBasicFailures() || this.getErrors() != null && this.getErrors().size() > 0;
    }

    public boolean hasWarnings() {
        return this.getWarnings() != null && this.getWarnings().size() > 0;
    }

    public void setLoadingCompleteness(int completeness) {
        this.loadingCompleteness = completeness;
    }

    public int getLoadingCompleteness() {
        return this.loadingCompleteness;
    }

    public LoadingState getLoadingState() {
        return this.loadingState;
    }

    public boolean isLoaded() {
        return this.loadingState == LoadingState.STATE_LOADED;
    }

    public void setLoadingProgressState(Plugin plugin, LoadingState state) {
        this.checkIfDeleted();
        if (state == LoadingState.STATE_LOADED) {
            throw new IllegalArgumentException("this state could only be set by calling method setLoaded");
        }
        if (state != LoadingState.STATE_DELETED && state.isFailure()) {
            throw new IllegalArgumentException("this is a failure state, call setLoadingFailureState for " + state);
        }
        if (this.getLoadingState() == LoadingState.STATE_UNDEFINED) {
            this.setLoadingState(state);
            ModuleEventLog.getInstance().addModule(this.bo);
        }
        if (state == LoadingState.STATE_DELETED) {
            throw new IllegalArgumentException("call delete for " + state);
        }
        this.setLoadingState(state);
        this.setCurrentlyRunningPlugin(plugin);
        this.bo.setQedeqVo(null);
        this.bo.getKernelRequiredModules().clear();
        this.bo.getDependentModules().clear();
        this.bo.setLabels(null);
        this.setLoadingImportsState(LoadingImportsState.STATE_UNDEFINED);
        this.setDependencyState(DependencyState.STATE_UNDEFINED);
        this.setWellFormedState(WellFormedState.STATE_UNCHECKED);
        this.setErrors(null);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void setLoadingFailureState(LoadingState state, SourceFileExceptionList e) {
        if (e == null) {
            throw new NullPointerException("Exception must not be null");
        }
        this.checkIfDeleted();
        if (!state.isFailure()) {
            throw new IllegalArgumentException("this is no failure state, call setLoadingProgressState");
        }
        if (this.getLoadingState() == LoadingState.STATE_UNDEFINED) {
            this.setLoadingState(state);
            ModuleEventLog.getInstance().addModule(this.bo);
        }
        this.bo.setQedeqVo(null);
        this.bo.getKernelRequiredModules().clear();
        this.bo.getDependentModules().clear();
        this.bo.setLabels(null);
        this.setLoadingState(state);
        this.setCurrentlyRunningPlugin(null);
        this.setLoadingImportsState(LoadingImportsState.STATE_UNDEFINED);
        this.setDependencyState(DependencyState.STATE_UNDEFINED);
        this.setWellFormedState(WellFormedState.STATE_UNCHECKED);
        this.setFormallyProvedState(FormallyProvedState.STATE_UNCHECKED);
        this.setErrors(e);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void setLoaded(QedeqVo qedeq, ModuleLabels labels) {
        this.checkIfDeleted();
        if (qedeq == null) {
            throw new NullPointerException("Qedeq is null");
        }
        this.setCurrentlyRunningPlugin(null);
        this.setLoadingState(LoadingState.STATE_LOADED);
        this.setLoadingImportsState(LoadingImportsState.STATE_UNDEFINED);
        this.setDependencyState(DependencyState.STATE_UNDEFINED);
        this.setWellFormedState(WellFormedState.STATE_UNCHECKED);
        this.setFormallyProvedState(FormallyProvedState.STATE_UNCHECKED);
        this.setErrors(null);
        this.bo.setQedeqVo(qedeq);
        this.bo.getKernelRequiredModules().clear();
        this.bo.getDependentModules().clear();
        this.bo.setLabels(labels);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void setLoadingImportsProgressState(Plugin plugin, LoadingImportsState state) {
        this.checkIfDeleted();
        if (!this.isLoaded() && state != LoadingImportsState.STATE_UNDEFINED) {
            throw new IllegalStateException("module is not yet loaded");
        }
        if (state.isFailure()) {
            throw new IllegalArgumentException("this is a failure state, call setLoadingImportsFailureState");
        }
        if (state == LoadingImportsState.STATE_LOADED_IMPORTED_MODULES) {
            throw new IllegalArgumentException("this state could only be set by calling method setLoadedImports");
        }
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void setLoadingImportsFailureState(LoadingImportsState state, SourceFileExceptionList e) {
        if (e == null) {
            throw new NullPointerException("Exception must not be null");
        }
        this.checkIfDeleted();
        if (!this.isLoaded()) {
            throw new IllegalStateException("module is not yet loaded");
        }
        if (!state.isFailure()) {
            throw new IllegalArgumentException("this is no failure state, call setLoadingProgressState");
        }
        this.setLoadingImportsState(state);
        this.setCurrentlyRunningPlugin(null);
        this.setErrors(e);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public LoadingImportsState getLoadingImportsState() {
        return this.loadingImportsState;
    }

    public boolean hasLoadedImports() {
        return this.loadingImportsState == LoadingImportsState.STATE_LOADED_IMPORTED_MODULES;
    }

    public void setDependencyProgressState(Plugin plugin, DependencyState state) {
        this.checkIfDeleted();
        if (!this.isLoaded() && state != DependencyState.STATE_UNDEFINED) {
            throw new IllegalStateException("module is not yet loaded");
        }
        if (state.isFailure()) {
            throw new IllegalArgumentException("this is a failure state, call setDependencyFailureState");
        }
        if (state == DependencyState.STATE_LOADED_REQUIRED_MODULES) {
            throw new IllegalArgumentException("this state could only be set by calling method setLoadedRequiredModules");
        }
        this.setWellFormedState(WellFormedState.STATE_UNCHECKED);
        this.setFormallyProvedState(FormallyProvedState.STATE_UNCHECKED);
        this.setDependencyState(state);
        this.setCurrentlyRunningPlugin(null);
        this.setErrors(null);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void setDependencyFailureState(DependencyState state, SourceFileExceptionList e) {
        if (e == null) {
            throw new NullPointerException("Exception must not be null");
        }
        this.checkIfDeleted();
        if (!this.isLoaded()) {
            throw new IllegalStateException("module is not yet loaded");
        }
        if (!state.isFailure()) {
            throw new IllegalArgumentException("this is no failure state, call setLoadingProgressState");
        }
        this.setDependencyState(state);
        this.setCurrentlyRunningPlugin(null);
        this.setErrors(e);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public DependencyState getDependencyState() {
        return this.dependencyState;
    }

    private void invalidateOtherDependentModulesToLoaded() {
        String method = "invalidateOtherDependModulesToLoaded";
        Trace.begin(CLASS, this, "invalidateOtherDependModulesToLoaded");
        Trace.param(CLASS, (Object)this, "invalidateOtherDependModulesToLoaded", "bo", this.bo);
        if (this.hasLoadedRequiredModules()) {
            int i;
            KernelModuleReferenceList dependent = this.bo.getDependentModules();
            Trace.trace(CLASS, (Object)this, "invalidateOtherDependModulesToLoaded", "begin list of dependent modules");
            ArrayList<KernelQedeqBo> list = new ArrayList<KernelQedeqBo>();
            for (i = 0; i < dependent.size(); ++i) {
                Trace.param(CLASS, (Object)this, "invalidateOtherDependModulesToLoaded", "" + i, dependent.getKernelQedeqBo(i));
                list.add(dependent.getKernelQedeqBo(i));
            }
            Trace.trace(CLASS, (Object)this, "invalidateOtherDependModulesToLoaded", "end list of dependent modules");
            for (i = 0; i < list.size(); ++i) {
                DefaultKernelQedeqBo ref = (DefaultKernelQedeqBo)list.get(i);
                if (!dependent.contains(ref)) continue;
                ref.getStateManager().invalidateDependentModulesToLoaded();
            }
            list.clear();
            dependent.clear();
            KernelModuleReferenceList required = this.bo.getKernelRequiredModules();
            for (int i2 = 0; i2 < required.size(); ++i2) {
                DefaultKernelQedeqBo ref = (DefaultKernelQedeqBo)required.getKernelQedeqBo(i2);
                Trace.param(CLASS, (Object)this, "invalidateOtherDependModulesToLoaded", "remove dependence from", ref);
                ref.getDependentModules().remove(this.bo);
            }
            required.clear();
        }
        Trace.end(CLASS, this, "invalidateOtherDependModulesToLoaded");
    }

    private void invalidateDependentModulesToLoaded() {
        String method = "invalidateDependentModulesToLoaded";
        Trace.begin(CLASS, this, "invalidateDependentModulesToLoaded");
        Trace.param(CLASS, (Object)this, "invalidateDependentModulesToLoaded", "bo", this.bo);
        if (this.hasLoadedRequiredModules()) {
            int i;
            KernelModuleReferenceList dependent = this.bo.getDependentModules();
            Trace.trace(CLASS, (Object)this, "invalidateDependentModulesToLoaded", "begin list of dependent modules");
            ArrayList<KernelQedeqBo> list = new ArrayList<KernelQedeqBo>();
            for (i = 0; i < dependent.size(); ++i) {
                Trace.param(CLASS, (Object)this, "invalidateDependentModulesToLoaded", "" + i, dependent.getKernelQedeqBo(i));
                list.add(dependent.getKernelQedeqBo(i));
            }
            Trace.trace(CLASS, (Object)this, "invalidateDependentModulesToLoaded", "end list of dependent modules");
            for (i = 0; i < list.size(); ++i) {
                DefaultKernelQedeqBo ref = (DefaultKernelQedeqBo)list.get(i);
                if (!dependent.contains(ref)) continue;
                ref.getStateManager().invalidateDependentModulesToLoaded();
            }
            list.clear();
            dependent.clear();
            KernelModuleReferenceList required = this.bo.getKernelRequiredModules();
            for (int i2 = 0; i2 < required.size(); ++i2) {
                DefaultKernelQedeqBo ref = (DefaultKernelQedeqBo)required.getKernelQedeqBo(i2);
                Trace.param(CLASS, (Object)this, "invalidateDependentModulesToLoaded", "remove dependence from", ref);
                ref.getDependentModules().remove(this.bo);
            }
            required.clear();
            this.invalidateThisModuleToLoaded();
            this.setLoadingState(LoadingState.STATE_LOADED);
            ModuleEventLog.getInstance().stateChanged(this.bo);
        }
        Trace.end(CLASS, this, "invalidateDependentModulesToLoaded");
    }

    private void invalidateDependentModulesToLoadedImports() {
        String method = "invalidateDependentModulesToLoadedImports";
        Trace.begin(CLASS, this, "invalidateDependentModulesToLoadedImports");
        Trace.param(CLASS, (Object)this, "invalidateDependentModulesToLoadedImports", "bo", this.bo);
        if (this.hasLoadedImports()) {
            int i;
            KernelModuleReferenceList dependent = this.bo.getDependentModules();
            Trace.trace(CLASS, (Object)this, "invalidateDependentModulesToLoadedImports", "begin list of dependent modules");
            ArrayList<KernelQedeqBo> list = new ArrayList<KernelQedeqBo>();
            for (i = 0; i < dependent.size(); ++i) {
                Trace.param(CLASS, (Object)this, "invalidateDependentModulesToLoadedImports", "" + i, dependent.getKernelQedeqBo(i));
                list.add(dependent.getKernelQedeqBo(i));
            }
            Trace.trace(CLASS, (Object)this, "invalidateDependentModulesToLoadedImports", "end list of dependent modules");
            for (i = 0; i < list.size(); ++i) {
                DefaultKernelQedeqBo ref = (DefaultKernelQedeqBo)list.get(i);
                if (!dependent.contains(ref)) continue;
                ref.getStateManager().invalidateDependentModulesToLoadedImports();
            }
            list.clear();
            this.invalidateThisModuleToLoadedImports();
            ModuleEventLog.getInstance().stateChanged(this.bo);
        }
        Trace.end(CLASS, this, "invalidateDependentModulesToLoadedImports");
    }

    private void invalidateOtherDependentModulesToLoadedRequired() {
        if (this.isWellFormed()) {
            KernelModuleReferenceList dependent = this.bo.getDependentModules();
            for (int i = 0; i < dependent.size(); ++i) {
                DefaultKernelQedeqBo ref = (DefaultKernelQedeqBo)dependent.getKernelQedeqBo(i);
                ref.getStateManager().invalidateDependentModulesToLoadedRequired();
            }
        }
    }

    private void invalidateDependentModulesToLoadedRequired() {
        if (this.isWellFormed()) {
            KernelModuleReferenceList dependent = this.bo.getDependentModules();
            for (int i = 0; i < dependent.size(); ++i) {
                DefaultKernelQedeqBo ref = (DefaultKernelQedeqBo)dependent.getKernelQedeqBo(i);
                ref.getStateManager().invalidateDependentModulesToLoadedRequired();
            }
            this.invalidateThisModuleToLoadedReqired();
            ModuleEventLog.getInstance().stateChanged(this.bo);
        }
    }

    private void invalidateOtherDependentModulesToWellFormed() {
        if (this.isFullyFormallyProved()) {
            KernelModuleReferenceList dependent = this.bo.getDependentModules();
            for (int i = 0; i < dependent.size(); ++i) {
                DefaultKernelQedeqBo ref = (DefaultKernelQedeqBo)dependent.getKernelQedeqBo(i);
                ref.getStateManager().invalidateDependentModulesToWellFormed();
            }
        }
    }

    private void invalidateDependentModulesToWellFormed() {
        if (this.isFullyFormallyProved()) {
            KernelModuleReferenceList dependent = this.bo.getDependentModules();
            for (int i = 0; i < dependent.size(); ++i) {
                DefaultKernelQedeqBo ref = (DefaultKernelQedeqBo)dependent.getKernelQedeqBo(i);
                ref.getStateManager().invalidateDependentModulesToWellFormed();
            }
            this.invalidateThisModuleToWellFormed();
            ModuleEventLog.getInstance().stateChanged(this.bo);
        }
    }

    private void invalidateThisModuleToLoaded() {
        if (this.isLoaded()) {
            this.setLoadingState(LoadingState.STATE_LOADED);
            this.setLoadingImportsState(LoadingImportsState.STATE_UNDEFINED);
            this.setDependencyState(DependencyState.STATE_UNDEFINED);
            this.setWellFormedState(WellFormedState.STATE_UNCHECKED);
            this.setFormallyProvedState(FormallyProvedState.STATE_UNCHECKED);
            this.bo.getKernelRequiredModules().clear();
            this.setErrors(null);
        }
    }

    private void invalidateThisModuleToLoadedImports() {
        if (this.hasLoadedImports()) {
            this.setLoadingImportsState(LoadingImportsState.STATE_LOADED_IMPORTED_MODULES);
            this.setDependencyState(DependencyState.STATE_UNDEFINED);
            this.setWellFormedState(WellFormedState.STATE_UNCHECKED);
            this.setFormallyProvedState(FormallyProvedState.STATE_UNCHECKED);
            this.setErrors(null);
        }
    }

    private void invalidateThisModuleToLoadedReqired() {
        if (this.hasLoadedRequiredModules()) {
            this.setDependencyState(DependencyState.STATE_LOADED_REQUIRED_MODULES);
            this.setWellFormedState(WellFormedState.STATE_UNCHECKED);
            this.setFormallyProvedState(FormallyProvedState.STATE_UNCHECKED);
            this.setErrors(null);
        }
    }

    private void invalidateThisModuleToWellFormed() {
        if (this.isWellFormed()) {
            this.setWellFormedState(WellFormedState.STATE_CHECKED);
            this.setFormallyProvedState(FormallyProvedState.STATE_UNCHECKED);
            this.setErrors(null);
        }
    }

    private void invalidateThisModuleToFormallyProved() {
        if (this.isFullyFormallyProved()) {
            this.setFormallyProvedState(FormallyProvedState.STATE_CHECKED);
            this.setErrors(null);
        }
    }

    public boolean hasLoadedRequiredModules() {
        return this.isLoaded() && this.dependencyState == DependencyState.STATE_LOADED_REQUIRED_MODULES;
    }

    public void setLoadedImports(KernelModuleReferenceList required) {
        this.checkIfDeleted();
        if (!this.isLoaded()) {
            throw new IllegalStateException("Loaded imported modules can only be set if module is loaded.\"\nCurrently the status for the module\"" + this.bo.getName() + "\" is \"" + this.bo.getLoadingState() + "\"");
        }
        this.setLoadingImportsState(LoadingImportsState.STATE_LOADED_IMPORTED_MODULES);
        this.setDependencyState(DependencyState.STATE_UNDEFINED);
        this.setWellFormedState(WellFormedState.STATE_UNCHECKED);
        this.setCurrentlyRunningPlugin(null);
        this.setErrors(null);
        this.bo.getKernelRequiredModules().set(required);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void setLoadedRequiredModules() {
        this.checkIfDeleted();
        if (!this.isLoaded()) {
            throw new IllegalStateException("Required modules can only be set if module is loaded.\"\nCurrently the status for the module\"" + this.bo.getName() + "\" is \"" + this.bo.getLoadingState() + "\"");
        }
        KernelModuleReferenceList required = this.bo.getKernelRequiredModules();
        for (int i = 0; i < required.size(); ++i) {
            DefaultKernelQedeqBo current = (DefaultKernelQedeqBo)required.getKernelQedeqBo(i);
            try {
                current.getDependentModules().add(required.getModuleContext(i), required.getLabel(i), this.bo);
                continue;
            }
            catch (ModuleDataException me) {
                throw new RuntimeException(me);
            }
        }
        this.setDependencyState(DependencyState.STATE_LOADED_REQUIRED_MODULES);
        this.setWellFormedState(WellFormedState.STATE_UNCHECKED);
        this.setCurrentlyRunningPlugin(null);
        this.setErrors(null);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void setWellFormed(ModuleConstantsExistenceChecker checker) {
        this.checkIfDeleted();
        if (!this.hasLoadedRequiredModules()) {
            throw new IllegalStateException("Checked can only be set if all required modules are loaded.\"\nCurrently the status for the module\"" + this.bo.getName() + "\" is \"" + this.bo.getLoadingState() + "\"");
        }
        this.setWellFormedState(WellFormedState.STATE_CHECKED);
        this.setCurrentlyRunningPlugin(null);
        this.bo.setExistenceChecker(checker);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void setWellFormedProgressState(Plugin plugin, WellFormedState state) {
        if (this.getDependencyState().getCode() < DependencyState.STATE_LOADED_REQUIRED_MODULES.getCode() && state != WellFormedState.STATE_UNCHECKED) {
            throw new IllegalArgumentException("this state could only be set if all required modules are loaded ");
        }
        if (state.isFailure()) {
            throw new IllegalArgumentException("this is a failure state, call setWellFormedFailureState");
        }
        if (state == WellFormedState.STATE_CHECKED) {
            throw new IllegalArgumentException("set with setChecked(ExistenceChecker)");
        }
        this.setWellFormedState(state);
        this.setCurrentlyRunningPlugin(plugin);
        this.setErrors(null);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void setWellFormedFailureState(WellFormedState state, SourceFileExceptionList e) {
        if (!(this.isLoaded() && this.hasLoadedRequiredModules() || state == WellFormedState.STATE_UNCHECKED)) {
            throw new IllegalArgumentException("this state could only be set if all required modules are loaded ");
        }
        if (!state.isFailure()) {
            throw new IllegalArgumentException("this is no failure state, call setWellFormedProgressState");
        }
        this.setWellFormedState(state);
        this.setCurrentlyRunningPlugin(null);
        this.setErrors(e);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void setFormallyProvedProgressState(Plugin plugin, FormallyProvedState state) {
        if (this.getDependencyState().getCode() < DependencyState.STATE_LOADED_REQUIRED_MODULES.getCode() && state != FormallyProvedState.STATE_UNCHECKED) {
            throw new IllegalArgumentException("this state could only be set if all required modules are loaded ");
        }
        if (state.isFailure()) {
            throw new IllegalArgumentException("this is a failure state, call setFormallyProvedFailureState");
        }
        this.setFormallyProvedState(state);
        this.setCurrentlyRunningPlugin(plugin);
        this.setErrors(null);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void setFormallyProvedFailureState(FormallyProvedState state, SourceFileExceptionList e) {
        if (!(this.isLoaded() && this.hasLoadedRequiredModules() || state == FormallyProvedState.STATE_UNCHECKED)) {
            throw new IllegalArgumentException("this state could only be set if all required modules are well formed ");
        }
        if (!state.isFailure()) {
            throw new IllegalArgumentException("this is no failure state, call setFormallyProvedProgressState");
        }
        this.setFormallyProvedState(state);
        this.setCurrentlyRunningPlugin(null);
        this.setErrors(e);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    private void checkIfDeleted() {
        if (this.getLoadingState() == LoadingState.STATE_DELETED) {
            throw new IllegalStateException("module is already deleted: " + this.bo.getUrl());
        }
    }

    public boolean isWellFormed() {
        return this.hasLoadedRequiredModules() && this.wellFormedState == WellFormedState.STATE_CHECKED;
    }

    public WellFormedState getWellFormedState() {
        return this.wellFormedState;
    }

    public boolean isFullyFormallyProved() {
        return this.isWellFormed() && this.formallyProvedState == FormallyProvedState.STATE_CHECKED;
    }

    public FormallyProvedState getFormallyProvedState() {
        return this.formallyProvedState;
    }

    public String getStateDescription() {
        String result = "";
        result = this.loadingState == LoadingState.STATE_LOADING_FROM_WEB ? this.loadingState.getText() + " (" + this.loadingCompleteness + "%)" : (!this.isLoaded() ? this.loadingState.getText() : (!this.hasLoadedImports() ? (this.loadingImportsState == LoadingImportsState.STATE_UNDEFINED ? this.loadingState.getText() : this.loadingImportsState.getText()) : (!this.hasLoadedRequiredModules() ? (this.dependencyState == DependencyState.STATE_UNDEFINED ? this.loadingImportsState.getText() : this.dependencyState.getText()) : (!this.isWellFormed() ? (this.wellFormedState == WellFormedState.STATE_UNCHECKED ? this.dependencyState.getText() : this.wellFormedState.getText()) : (!this.isFullyFormallyProved() ? (this.formallyProvedState == FormallyProvedState.STATE_UNCHECKED ? this.wellFormedState.getText() : this.formallyProvedState.getText()) : this.formallyProvedState.getText())))));
        String pluginState = this.pluginResults.getPluginStateDescription();
        if (pluginState.length() > 0) {
            result = result + "; " + pluginState;
        }
        return result;
    }

    public AbstractState getCurrentState() {
        if (!this.isLoaded()) {
            return this.loadingState;
        }
        if (!this.hasLoadedImports()) {
            if (this.loadingImportsState == LoadingImportsState.STATE_UNDEFINED) {
                return this.loadingState;
            }
            return this.loadingImportsState;
        }
        if (!this.hasLoadedRequiredModules()) {
            if (this.dependencyState == DependencyState.STATE_UNDEFINED) {
                return this.loadingImportsState;
            }
            return this.dependencyState;
        }
        if (!this.isWellFormed()) {
            if (this.wellFormedState == WellFormedState.STATE_UNCHECKED) {
                return this.dependencyState;
            }
            return this.wellFormedState;
        }
        if (!this.isFullyFormallyProved()) {
            if (this.formallyProvedState == FormallyProvedState.STATE_UNCHECKED) {
                return this.wellFormedState;
            }
            return this.formallyProvedState;
        }
        return this.formallyProvedState;
    }

    public AbstractState getLastSuccesfulState() {
        if (!this.isLoaded()) {
            return LoadingState.STATE_UNDEFINED;
        }
        if (!this.hasLoadedImports()) {
            return LoadingState.STATE_LOADED;
        }
        if (!this.hasLoadedRequiredModules()) {
            return LoadingImportsState.STATE_LOADED_IMPORTED_MODULES;
        }
        if (!this.isWellFormed()) {
            return DependencyState.STATE_LOADED_REQUIRED_MODULES;
        }
        if (!this.isFullyFormallyProved()) {
            return WellFormedState.STATE_CHECKED;
        }
        return FormallyProvedState.STATE_CHECKED;
    }

    protected void setLoadingState(LoadingState state) {
        this.loadingState = state;
    }

    protected void setLoadingImportsState(LoadingImportsState state) {
        this.loadingImportsState = state;
    }

    protected void setDependencyState(DependencyState state) {
        this.dependencyState = state;
    }

    protected void setWellFormedState(WellFormedState state) {
        this.wellFormedState = state;
    }

    protected void setFormallyProvedState(FormallyProvedState state) {
        this.formallyProvedState = state;
    }

    public SourceFileExceptionList getErrors() {
        SourceFileExceptionList result = new SourceFileExceptionList(this.errors);
        result.add(this.pluginResults.getAllErrors());
        return result;
    }

    public SourceFileExceptionList getWarnings() {
        SourceFileExceptionList result = new SourceFileExceptionList();
        result.add(this.pluginResults.getAllWarnings());
        return result;
    }

    public Plugin getCurrentlyRunningPlugin() {
        return this.currentlyRunningPlugin;
    }

    public void setCurrentlyRunningPlugin(Plugin currentlyRunningPlugin) {
        this.currentlyRunningPlugin = currentlyRunningPlugin;
    }

    protected void setErrors(SourceFileExceptionList errors) {
        this.errors = errors;
        if (errors == null) {
            this.pluginResults = new PluginResultManager();
        }
    }

    public void addPluginResults(Plugin plugin, SourceFileExceptionList errors, SourceFileExceptionList warnings) {
        if (plugin instanceof InternalPluginBo) {
            throw new RuntimeException("Programming error: an internal plugin should not add exeptions here!\n" + plugin.getClass().getName());
        }
        this.pluginResults.addResult(plugin, errors, warnings);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void removeAllPluginResults() {
        this.pluginResults.removeAllResults();
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void printDependencyTree() {
        this.printDependencyTree(0);
        System.out.println();
    }

    private void printDependencyTree(int tab) {
        System.out.println(StringUtility.getSpaces(tab) + this.bo.getName());
        int newTab = tab + this.bo.getName().length();
        KernelModuleReferenceList dependent = this.bo.getDependentModules();
        for (int i = 0; i < dependent.size(); ++i) {
            DefaultKernelQedeqBo ref = (DefaultKernelQedeqBo)dependent.getKernelQedeqBo(i);
            ref.getStateManager().printDependencyTree(newTab);
        }
    }
}

