/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service;

import java.util.ArrayList;
import java.util.List;
import org.qedeq.base.io.Parameters;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.KernelContext;
import org.qedeq.kernel.bo.common.PluginCall;
import org.qedeq.kernel.bo.common.ServiceProcess;
import org.qedeq.kernel.bo.log.QedeqLog;
import org.qedeq.kernel.bo.module.InternalServiceProcess;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.PluginBo;
import org.qedeq.kernel.bo.module.PluginExecutor;
import org.qedeq.kernel.bo.service.ModuleArbiter;
import org.qedeq.kernel.bo.service.PluginCallImpl;
import org.qedeq.kernel.bo.service.PluginManager;
import org.qedeq.kernel.bo.service.ServiceProcessImpl;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.visitor.InterruptException;

public class ServiceProcessManager {
    private static final Class CLASS = ServiceProcessManager.class;
    private final List processes = new ArrayList();
    private final List finished = new ArrayList();
    private final List calls = new ArrayList();
    private final PluginManager pluginManager;
    private final ModuleArbiter arbiter;

    public ServiceProcessManager(PluginManager pluginManager, ModuleArbiter arbiter) {
        this.pluginManager = pluginManager;
        this.arbiter = arbiter;
    }

    public synchronized ServiceProcess[] getServiceProcesses() {
        return this.processes.toArray(new ServiceProcess[0]);
    }

    public synchronized ServiceProcess[] getRunningServiceProcesses() {
        ArrayList result = new ArrayList(this.processes);
        int i = 0;
        while (i < result.size()) {
            if (!((ServiceProcess)result.get(i)).isRunning()) {
                result.remove(i);
                continue;
            }
            ++i;
        }
        return result.toArray(new ServiceProcess[0]);
    }

    public synchronized PluginCallImpl createPluginCall(Plugin service, KernelQedeqBo qedeq, Parameters parameters, InternalServiceProcess process, PluginCall parent) {
        PluginCallImpl call = new PluginCallImpl(service, qedeq, parameters, process, parent);
        this.calls.add(call);
        return call;
    }

    public synchronized void terminateAndRemoveAllServiceProcesses() {
        this.terminateAllServiceProcesses();
        this.processes.clear();
    }

    public synchronized void terminateAllServiceProcesses() {
        for (int i = 0; i < this.processes.size(); ++i) {
            ServiceProcess proc = (ServiceProcess)this.processes.get(i);
            proc.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object executePlugin(String id, KernelQedeqBo qedeq, Object data, InternalServiceProcess proc) {
        String method = "executePlugin(String, KernelQedeqBo, Object)";
        PluginBo plugin = this.pluginManager.getPlugin(id);
        if (plugin == null) {
            String message = "Kernel does not know about plugin: ";
            RuntimeException e = new RuntimeException("Kernel does not know about plugin: " + id);
            Trace.fatal(CLASS, this, "executePlugin(String, KernelQedeqBo, Object)", "Kernel does not know about plugin: " + id, e);
            throw e;
        }
        Parameters parameters = KernelContext.getInstance().getConfig().getPluginEntries(plugin);
        InternalServiceProcess process = null;
        if (proc != null) {
            if (!proc.isRunning()) {
                return null;
            }
            process = proc;
        } else {
            process = new ServiceProcessImpl(plugin.getPluginActionName());
            ServiceProcessManager serviceProcessManager = this;
            synchronized (serviceProcessManager) {
                this.processes.add(process);
            }
        }
        process.setBlocked(true);
        PluginCallImpl call = new PluginCallImpl(plugin, qedeq, parameters, process, process.getPluginCall());
        process.setPluginCall(call);
        boolean newBlockedModule = false;
        try {
            newBlockedModule = this.arbiter.lockRequiredModule(process, qedeq);
        }
        catch (InterruptException e) {
            String msg = plugin.getPluginActionName() + " was interrupted.";
            Trace.fatal(CLASS, this, "executePlugin(String, KernelQedeqBo, Object)", msg, e);
            QedeqLog.getInstance().logFailureReply(msg, qedeq.getUrl(), e.getMessage());
            call.setFailureState();
            process.setFailureState();
            return null;
        }
        process.setBlocked(false);
        try {
            process.addBlockedModule(qedeq);
            PluginExecutor exe = plugin.createExecutor(qedeq, parameters);
            qedeq.setCurrentlyRunningPlugin(plugin);
            Object result = exe.executePlugin(process, data);
            if (exe.getInterrupted()) {
                call.setFailureState();
                process.setFailureState();
            } else {
                call.setSuccessState();
            }
            Object object = result;
            return object;
        }
        catch (RuntimeException e) {
            String msg = plugin.getPluginActionName() + " failed with a runtime exception.";
            Trace.fatal(CLASS, this, "executePlugin(String, KernelQedeqBo, Object)", msg, e);
            QedeqLog.getInstance().logFailureReply(msg, qedeq.getUrl(), e.getMessage());
            call.setFailureState();
            process.setFailureState();
            Object var13_21 = null;
            return var13_21;
        }
        finally {
            if (newBlockedModule) {
                this.arbiter.unlockRequiredModule(process, qedeq);
                process.removeBlockedModule(qedeq);
            }
            call.setExecutor(null);
            qedeq.setCurrentlyRunningPlugin(null);
            if (proc == null && process.isRunning()) {
                process.setSuccessState();
            }
        }
    }
}

