/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service;

import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.common.PluginCall;
import org.qedeq.kernel.bo.common.QedeqBo;
import org.qedeq.kernel.bo.common.QedeqBoSet;
import org.qedeq.kernel.bo.common.ServiceProcess;
import org.qedeq.kernel.bo.module.InternalServiceProcess;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.KernelQedeqBoSet;

public class ServiceProcessImpl
implements InternalServiceProcess {
    private static final Class CLASS = ServiceProcessImpl.class;
    private static long globalCounter;
    private PluginCall call = null;
    private final Thread thread;
    private long start;
    private long stop;
    private int state;
    private final String actionName;
    private double executionPercentage = 0.0;
    private String executionActionDescription = "not yet started";
    private boolean blocked;
    private final KernelQedeqBoSet blockedModules;
    private final long id = this.inc();

    public ServiceProcessImpl(String actionName) {
        this.thread = Thread.currentThread();
        this.blockedModules = new KernelQedeqBoSet();
        this.actionName = actionName;
        this.start();
    }

    private synchronized long inc() {
        return globalCounter++;
    }

    public synchronized void setPluginCall(PluginCall call) {
        this.call = call;
    }

    public synchronized PluginCall getPluginCall() {
        return this.call;
    }

    public synchronized Thread getThread() {
        return this.thread;
    }

    public synchronized QedeqBo getQedeq() {
        if (this.call != null) {
            return this.call.getQedeq();
        }
        return null;
    }

    public synchronized String getQedeqName() {
        if (this.call != null) {
            return this.call.getQedeq().getName();
        }
        return "";
    }

    public synchronized String getQedeqUrl() {
        if (this.call != null) {
            return this.call.getQedeq().getUrl();
        }
        return "";
    }

    public synchronized long getStart() {
        return this.start;
    }

    public synchronized long getStop() {
        return this.stop;
    }

    private synchronized void start() {
        this.start = System.currentTimeMillis();
        this.executionActionDescription = "started";
    }

    private synchronized void stop() {
        this.stop = System.currentTimeMillis();
    }

    public synchronized void setSuccessState() {
        if (this.isRunning()) {
            this.state = 1;
            this.stop();
            this.executionActionDescription = "finished";
            this.executionPercentage = 100.0;
        }
    }

    public synchronized void setFailureState() {
        if (this.isRunning()) {
            this.state = -1;
            this.stop();
        }
    }

    public synchronized boolean isRunning() {
        if (this.state == 0) {
            if (!this.thread.isAlive()) {
                Trace.fatal(CLASS, this, "isRunning()", "Thread has unexpectly died", new RuntimeException());
                this.setFailureState();
                return false;
            }
            return true;
        }
        return false;
    }

    public synchronized boolean isBlocked() {
        if (this.isRunning()) {
            return this.blocked;
        }
        return false;
    }

    public synchronized void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public synchronized boolean wasSuccess() {
        return this.state == 1;
    }

    public synchronized boolean wasFailure() {
        return this.state == -1;
    }

    public synchronized void interrupt() {
        this.thread.interrupt();
    }

    public synchronized double getExecutionPercentage() {
        if ((this.isRunning() || this.isBlocked()) && this.call != null) {
            this.executionPercentage = this.call.getExecutionPercentage();
        }
        return this.executionPercentage;
    }

    public synchronized String getActionName() {
        return this.actionName;
    }

    public synchronized String getExecutionActionDescription() {
        if ((this.isRunning() || this.isBlocked()) && this.call != null) {
            this.executionActionDescription = this.call.getExecutionActionDescription();
        }
        return this.executionActionDescription;
    }

    public synchronized QedeqBoSet getBlockedModules() {
        return new KernelQedeqBoSet(this.blockedModules);
    }

    public synchronized void addBlockedModules(KernelQedeqBoSet set) {
        this.blockedModules.add(set);
    }

    public synchronized void addBlockedModule(KernelQedeqBo element) {
        this.blockedModules.add(element);
    }

    public synchronized void removeBlockedModules(KernelQedeqBoSet set) {
        this.blockedModules.remove(set);
    }

    public synchronized void removeBlockedModule(KernelQedeqBo element) {
        this.blockedModules.remove(element);
    }

    public long getId() {
        return this.id;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object obj) {
        return 0 == this.compareTo(obj);
    }

    public int compareTo(Object o) {
        if (!(o instanceof ServiceProcess)) {
            return -1;
        }
        ServiceProcess s = (ServiceProcess)o;
        return this.getId() < s.getId() ? -1 : (this.getId() == s.getId() ? 0 : 1);
    }
}

