/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service;

import org.qedeq.kernel.se.base.list.Atom;
import org.qedeq.kernel.se.base.list.Element;
import org.qedeq.kernel.se.base.list.ElementList;
import org.qedeq.kernel.se.base.module.Add;
import org.qedeq.kernel.se.base.module.Author;
import org.qedeq.kernel.se.base.module.AuthorList;
import org.qedeq.kernel.se.base.module.Axiom;
import org.qedeq.kernel.se.base.module.ChangedRule;
import org.qedeq.kernel.se.base.module.ChangedRuleList;
import org.qedeq.kernel.se.base.module.Chapter;
import org.qedeq.kernel.se.base.module.ChapterList;
import org.qedeq.kernel.se.base.module.Conclusion;
import org.qedeq.kernel.se.base.module.ConditionalProof;
import org.qedeq.kernel.se.base.module.Existential;
import org.qedeq.kernel.se.base.module.FormalProof;
import org.qedeq.kernel.se.base.module.FormalProofLine;
import org.qedeq.kernel.se.base.module.FormalProofLineList;
import org.qedeq.kernel.se.base.module.FormalProofList;
import org.qedeq.kernel.se.base.module.Formula;
import org.qedeq.kernel.se.base.module.FunctionDefinition;
import org.qedeq.kernel.se.base.module.Header;
import org.qedeq.kernel.se.base.module.Hypothesis;
import org.qedeq.kernel.se.base.module.Import;
import org.qedeq.kernel.se.base.module.ImportList;
import org.qedeq.kernel.se.base.module.InitialFunctionDefinition;
import org.qedeq.kernel.se.base.module.InitialPredicateDefinition;
import org.qedeq.kernel.se.base.module.Latex;
import org.qedeq.kernel.se.base.module.LatexList;
import org.qedeq.kernel.se.base.module.LinkList;
import org.qedeq.kernel.se.base.module.LiteratureItem;
import org.qedeq.kernel.se.base.module.LiteratureItemList;
import org.qedeq.kernel.se.base.module.Location;
import org.qedeq.kernel.se.base.module.LocationList;
import org.qedeq.kernel.se.base.module.ModusPonens;
import org.qedeq.kernel.se.base.module.Node;
import org.qedeq.kernel.se.base.module.PredicateDefinition;
import org.qedeq.kernel.se.base.module.Proof;
import org.qedeq.kernel.se.base.module.ProofList;
import org.qedeq.kernel.se.base.module.Proposition;
import org.qedeq.kernel.se.base.module.Qedeq;
import org.qedeq.kernel.se.base.module.Reason;
import org.qedeq.kernel.se.base.module.Rename;
import org.qedeq.kernel.se.base.module.Rule;
import org.qedeq.kernel.se.base.module.Section;
import org.qedeq.kernel.se.base.module.SectionList;
import org.qedeq.kernel.se.base.module.Specification;
import org.qedeq.kernel.se.base.module.Subsection;
import org.qedeq.kernel.se.base.module.SubsectionList;
import org.qedeq.kernel.se.base.module.SubstFree;
import org.qedeq.kernel.se.base.module.SubstFunc;
import org.qedeq.kernel.se.base.module.SubstPred;
import org.qedeq.kernel.se.base.module.Universal;
import org.qedeq.kernel.se.base.module.UsedByList;
import org.qedeq.kernel.se.common.IllegalModuleDataException;
import org.qedeq.kernel.se.common.ModuleAddress;
import org.qedeq.kernel.se.common.ModuleContext;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.dto.list.DefaultAtom;
import org.qedeq.kernel.se.dto.list.DefaultElementList;
import org.qedeq.kernel.se.dto.module.AddVo;
import org.qedeq.kernel.se.dto.module.AuthorListVo;
import org.qedeq.kernel.se.dto.module.AuthorVo;
import org.qedeq.kernel.se.dto.module.AxiomVo;
import org.qedeq.kernel.se.dto.module.ChangedRuleListVo;
import org.qedeq.kernel.se.dto.module.ChangedRuleVo;
import org.qedeq.kernel.se.dto.module.ChapterListVo;
import org.qedeq.kernel.se.dto.module.ChapterVo;
import org.qedeq.kernel.se.dto.module.ConclusionVo;
import org.qedeq.kernel.se.dto.module.ConditionalProofVo;
import org.qedeq.kernel.se.dto.module.ExistentialVo;
import org.qedeq.kernel.se.dto.module.FormalProofLineListVo;
import org.qedeq.kernel.se.dto.module.FormalProofLineVo;
import org.qedeq.kernel.se.dto.module.FormalProofListVo;
import org.qedeq.kernel.se.dto.module.FormalProofVo;
import org.qedeq.kernel.se.dto.module.FormulaVo;
import org.qedeq.kernel.se.dto.module.FunctionDefinitionVo;
import org.qedeq.kernel.se.dto.module.HeaderVo;
import org.qedeq.kernel.se.dto.module.HypothesisVo;
import org.qedeq.kernel.se.dto.module.ImportListVo;
import org.qedeq.kernel.se.dto.module.ImportVo;
import org.qedeq.kernel.se.dto.module.InitialFunctionDefinitionVo;
import org.qedeq.kernel.se.dto.module.InitialPredicateDefinitionVo;
import org.qedeq.kernel.se.dto.module.LatexListVo;
import org.qedeq.kernel.se.dto.module.LatexVo;
import org.qedeq.kernel.se.dto.module.LinkListVo;
import org.qedeq.kernel.se.dto.module.LiteratureItemListVo;
import org.qedeq.kernel.se.dto.module.LiteratureItemVo;
import org.qedeq.kernel.se.dto.module.LocationListVo;
import org.qedeq.kernel.se.dto.module.LocationVo;
import org.qedeq.kernel.se.dto.module.ModusPonensVo;
import org.qedeq.kernel.se.dto.module.NodeVo;
import org.qedeq.kernel.se.dto.module.PredicateDefinitionVo;
import org.qedeq.kernel.se.dto.module.ProofListVo;
import org.qedeq.kernel.se.dto.module.ProofVo;
import org.qedeq.kernel.se.dto.module.PropositionVo;
import org.qedeq.kernel.se.dto.module.QedeqVo;
import org.qedeq.kernel.se.dto.module.RenameVo;
import org.qedeq.kernel.se.dto.module.RuleVo;
import org.qedeq.kernel.se.dto.module.SectionListVo;
import org.qedeq.kernel.se.dto.module.SectionVo;
import org.qedeq.kernel.se.dto.module.SpecificationVo;
import org.qedeq.kernel.se.dto.module.SubsectionListVo;
import org.qedeq.kernel.se.dto.module.SubsectionVo;
import org.qedeq.kernel.se.dto.module.SubstFreeVo;
import org.qedeq.kernel.se.dto.module.SubstFuncVo;
import org.qedeq.kernel.se.dto.module.SubstPredVo;
import org.qedeq.kernel.se.dto.module.UniversalVo;
import org.qedeq.kernel.se.dto.module.UsedByListVo;

public class QedeqVoBuilder {
    private Qedeq original;
    private ModuleContext currentContext;

    protected QedeqVoBuilder(ModuleAddress address) {
        this.currentContext = address.createModuleContext();
    }

    public static QedeqVo createQedeq(ModuleAddress address, Qedeq original) throws ModuleDataException {
        QedeqVoBuilder creator = new QedeqVoBuilder(address);
        QedeqVo vo = creator.create(original);
        return vo;
    }

    protected final QedeqVo create(Qedeq original) throws IllegalModuleDataException {
        this.original = original;
        this.getCurrentContext().setLocationWithinModule("");
        if (original == null) {
            QedeqVo qedeq = null;
            return qedeq;
        }
        QedeqVo qedeq = new QedeqVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (original.getHeader() != null) {
            this.getCurrentContext().setLocationWithinModule(context + "getHeader()");
            qedeq.setHeader(this.create(original.getHeader()));
        }
        if (original.getChapterList() != null) {
            this.getCurrentContext().setLocationWithinModule(context + "getChapterList()");
            qedeq.setChapterList(this.create(original.getChapterList()));
        }
        if (original.getLiteratureItemList() != null) {
            this.getCurrentContext().setLocationWithinModule(context + "getLiteratureItemList()");
            qedeq.setLiteratureItemList(this.create(original.getLiteratureItemList()));
        }
        return qedeq;
    }

    private final HeaderVo create(Header header) throws IllegalModuleDataException {
        if (header == null) {
            return null;
        }
        HeaderVo h = new HeaderVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (header.getTitle() != null) {
            this.setLocationWithinModule(context + ".getTitle()");
            h.setTitle(this.create(header.getTitle()));
        }
        if (header.getAuthorList() != null) {
            this.setLocationWithinModule(context + ".getAuthorList()");
            h.setAuthorList(this.create(header.getAuthorList()));
        }
        if (header.getSummary() != null) {
            this.setLocationWithinModule(context + ".getSummary()");
            h.setSummary(this.create(header.getSummary()));
        }
        if (header.getEmail() != null) {
            this.setLocationWithinModule(context + ".getEmail()");
            h.setEmail(header.getEmail());
        }
        if (header.getSpecification() != null) {
            this.setLocationWithinModule(context + ".getSpecification()");
            h.setSpecification(this.create(header.getSpecification()));
        }
        if (header.getImportList() != null) {
            this.setLocationWithinModule(context + ".getImportList()");
            h.setImportList(this.create(header.getImportList()));
        }
        if (header.getUsedByList() != null) {
            this.setLocationWithinModule(context + ".getUsedByList()");
            h.setUsedByList(this.create(header.getUsedByList()));
        }
        this.setLocationWithinModule(context);
        return h;
    }

    private final UsedByListVo create(UsedByList usedByList) {
        if (usedByList == null) {
            return null;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        UsedByListVo list = new UsedByListVo();
        for (int i = 0; i < usedByList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            list.add(this.create(usedByList.get(i)));
        }
        this.setLocationWithinModule(context);
        return list;
    }

    private final ImportListVo create(ImportList importList) {
        if (importList == null) {
            return null;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        ImportListVo list = new ImportListVo();
        for (int i = 0; i < importList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            list.add(this.create(importList.get(i)));
        }
        this.setLocationWithinModule(context);
        return list;
    }

    private final ImportVo create(Import imp) {
        if (imp == null) {
            return null;
        }
        ImportVo i = new ImportVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (imp.getLabel() != null) {
            this.setLocationWithinModule(context + ".getLabel()");
            i.setLabel(imp.getLabel());
        }
        if (imp.getSpecification() != null) {
            this.setLocationWithinModule(context + ".getSpecification()");
            i.setSpecification(this.create(imp.getSpecification()));
        }
        this.setLocationWithinModule(context);
        return i;
    }

    private final SpecificationVo create(Specification specification) {
        if (specification == null) {
            return null;
        }
        SpecificationVo s = new SpecificationVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (specification.getName() != null) {
            this.setLocationWithinModule(context + ".getName()");
            s.setName(specification.getName());
        }
        if (specification.getRuleVersion() != null) {
            this.setLocationWithinModule(context + ".getRuleVersion()");
            s.setRuleVersion(specification.getRuleVersion());
        }
        if (specification.getLocationList() != null) {
            this.setLocationWithinModule(context + ".getLocationList()");
            s.setLocationList(this.create(specification.getLocationList()));
        }
        this.setLocationWithinModule(context);
        return s;
    }

    private final LocationListVo create(LocationList locationList) {
        if (locationList == null) {
            return null;
        }
        LocationListVo list = new LocationListVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        for (int i = 0; i < locationList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            list.add(this.create(locationList.get(i)));
        }
        this.setLocationWithinModule(context);
        return list;
    }

    private final LocationVo create(Location location) {
        if (location == null) {
            return null;
        }
        LocationVo loc = new LocationVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (location.getLocation() != null) {
            this.setLocationWithinModule(context + ".getLocation()");
            loc.setLocation(location.getLocation());
        }
        this.setLocationWithinModule(context);
        return loc;
    }

    private final AuthorListVo create(AuthorList authorList) {
        if (authorList == null) {
            return null;
        }
        AuthorListVo list = new AuthorListVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        for (int i = 0; i < authorList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            list.add(this.create(authorList.get(i)));
        }
        this.setLocationWithinModule(context);
        return list;
    }

    private final AuthorVo create(Author author) {
        if (author == null) {
            return null;
        }
        AuthorVo a = new AuthorVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (author.getName() != null) {
            this.setLocationWithinModule(context + ".getName()");
            a.setName(this.create(author.getName()));
        }
        if (author.getEmail() != null) {
            this.setLocationWithinModule(context + ".getEmail()");
            a.setEmail(author.getEmail());
        }
        this.setLocationWithinModule(context);
        return a;
    }

    private final ChapterListVo create(ChapterList chapterList) throws IllegalModuleDataException {
        if (chapterList == null) {
            return null;
        }
        ChapterListVo list = new ChapterListVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        for (int i = 0; i < chapterList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            list.add(this.create(chapterList.get(i)));
        }
        this.setLocationWithinModule(context);
        return list;
    }

    private final ChapterVo create(Chapter chapter) throws IllegalModuleDataException {
        if (chapter == null) {
            return null;
        }
        ChapterVo c = new ChapterVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (chapter.getTitle() != null) {
            this.setLocationWithinModule(context + ".getTitle()");
            c.setTitle(this.create(chapter.getTitle()));
        }
        if (chapter.getNoNumber() != null) {
            this.setLocationWithinModule(context + ".getNoNumber()");
            c.setNoNumber(chapter.getNoNumber());
        }
        if (chapter.getIntroduction() != null) {
            this.setLocationWithinModule(context + ".getIntroduction()");
            c.setIntroduction(this.create(chapter.getIntroduction()));
        }
        if (chapter.getSectionList() != null) {
            this.setLocationWithinModule(context + ".getSectionList()");
            c.setSectionList(this.create(chapter.getSectionList()));
        }
        this.setLocationWithinModule(context);
        return c;
    }

    private LiteratureItemListVo create(LiteratureItemList literatureItemList) {
        if (literatureItemList == null) {
            return null;
        }
        LiteratureItemListVo list = new LiteratureItemListVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        for (int i = 0; i < literatureItemList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            list.add(this.create(literatureItemList.get(i)));
        }
        this.setLocationWithinModule(context);
        return list;
    }

    private LiteratureItemVo create(LiteratureItem item) {
        if (item == null) {
            return null;
        }
        LiteratureItemVo it = new LiteratureItemVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (item.getLabel() != null) {
            this.setLocationWithinModule(context + ".getLabel()");
            it.setLabel(item.getLabel());
        }
        if (item.getItem() != null) {
            this.setLocationWithinModule(context + ".getItem()");
            it.setItem(this.create(item.getItem()));
        }
        this.setLocationWithinModule(context);
        return it;
    }

    private final SectionListVo create(SectionList sectionList) throws IllegalModuleDataException {
        if (sectionList == null) {
            return null;
        }
        SectionListVo list = new SectionListVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        for (int i = 0; i < sectionList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            list.add(this.create(sectionList.get(i)));
        }
        this.setLocationWithinModule(context);
        return list;
    }

    private final SectionVo create(Section section) throws IllegalModuleDataException {
        if (section == null) {
            return null;
        }
        SectionVo s = new SectionVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (section.getTitle() != null) {
            this.setLocationWithinModule(context + ".getTitle()");
            s.setTitle(this.create(section.getTitle()));
        }
        if (section.getNoNumber() != null) {
            this.setLocationWithinModule(context + ".getNoNumber()");
            s.setNoNumber(section.getNoNumber());
        }
        if (section.getIntroduction() != null) {
            this.setLocationWithinModule(context + ".getIntroduction()");
            s.setIntroduction(this.create(section.getIntroduction()));
        }
        if (section.getSubsectionList() != null) {
            this.setLocationWithinModule(context + ".getSubsectionList()");
            s.setSubsectionList(this.create(section.getSubsectionList()));
        }
        this.setLocationWithinModule(context);
        return s;
    }

    private final SubsectionListVo create(SubsectionList subsectionList) throws IllegalModuleDataException {
        if (subsectionList == null) {
            return null;
        }
        SubsectionListVo list = new SubsectionListVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        for (int i = 0; i < subsectionList.size(); ++i) {
            if (subsectionList.get(i).getSubsection() != null) {
                this.setLocationWithinModule(context + ".get(" + i + ").getSubsection()");
                list.add(this.create(subsectionList.get(i).getSubsection()));
                continue;
            }
            if (subsectionList.get(i).getNode() != null) {
                this.setLocationWithinModule(context + ".get(" + i + ").getNode()");
                list.add(this.create(subsectionList.get(i).getNode()));
                continue;
            }
            throw new IllegalArgumentException("unexpected subsection type: " + subsectionList.get(i).getClass());
        }
        this.setLocationWithinModule(context);
        return list;
    }

    private final SubsectionVo create(Subsection subsection) {
        if (subsection == null) {
            return null;
        }
        SubsectionVo s = new SubsectionVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (subsection.getId() != null) {
            this.setLocationWithinModule(context + ".getId()");
            s.setId(subsection.getId());
        }
        if (subsection.getLevel() != null) {
            this.setLocationWithinModule(context + ".getLevel()");
            s.setLevel(subsection.getLevel());
        }
        if (subsection.getTitle() != null) {
            this.setLocationWithinModule(context + ".getTitle()");
            s.setTitle(this.create(subsection.getTitle()));
        }
        if (subsection.getLatex() != null) {
            this.setLocationWithinModule(context + ".getLatex()");
            s.setLatex(this.create(subsection.getLatex()));
        }
        this.setLocationWithinModule(context);
        return s;
    }

    private final NodeVo create(Node node) throws IllegalModuleDataException {
        if (node == null) {
            return null;
        }
        NodeVo n = new NodeVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (node.getName() != null) {
            this.setLocationWithinModule(context + ".getName()");
            n.setName(this.create(node.getName()));
        }
        if (node.getId() != null) {
            this.setLocationWithinModule(context + ".getId()");
            n.setId(node.getId());
        }
        if (node.getLevel() != null) {
            this.setLocationWithinModule(context + ".getLevel()");
            n.setLevel(node.getLevel());
        }
        if (node.getTitle() != null) {
            this.setLocationWithinModule(context + ".getTitle()");
            n.setTitle(this.create(node.getTitle()));
        }
        if (node.getPrecedingText() != null) {
            this.setLocationWithinModule(context + ".getPrecedingText()");
            n.setPrecedingText(this.create(node.getPrecedingText()));
        }
        if (node.getNodeType() != null) {
            this.setLocationWithinModule(context + ".getNodeType()");
            if (node.getNodeType() instanceof Axiom) {
                this.setLocationWithinModule(context + ".getNodeType().getAxiom()");
                n.setNodeType(this.create((Axiom)node.getNodeType()));
            } else if (node.getNodeType() instanceof InitialPredicateDefinition) {
                this.setLocationWithinModule(context + ".getNodeType().getInitialPredicateDefinition()");
                n.setNodeType(this.create((InitialPredicateDefinition)node.getNodeType()));
            } else if (node.getNodeType() instanceof PredicateDefinition) {
                this.setLocationWithinModule(context + ".getNodeType().getPredicateDefinition()");
                n.setNodeType(this.create((PredicateDefinition)node.getNodeType()));
            } else if (node.getNodeType() instanceof InitialFunctionDefinition) {
                this.setLocationWithinModule(context + ".getNodeType().getInitialFunctionDefinition()");
                n.setNodeType(this.create((InitialFunctionDefinition)node.getNodeType()));
            } else if (node.getNodeType() instanceof FunctionDefinition) {
                this.setLocationWithinModule(context + ".getNodeType().getFunctionDefinition()");
                n.setNodeType(this.create((FunctionDefinition)node.getNodeType()));
            } else if (node.getNodeType() instanceof Proposition) {
                this.setLocationWithinModule(context + ".getNodeType().getProposition()");
                n.setNodeType(this.create((Proposition)node.getNodeType()));
            } else if (node.getNodeType() instanceof Rule) {
                this.setLocationWithinModule(context + ".getNodeType().getRule()");
                n.setNodeType(this.create((Rule)node.getNodeType()));
            } else {
                throw new IllegalModuleDataException(90100, "Programming error occured. unexpected node type: " + node.getNodeType().getClass(), this.getCurrentContext());
            }
        }
        if (node.getSucceedingText() != null) {
            this.setLocationWithinModule(context + ".getSucceedingText()");
            n.setSucceedingText(this.create(node.getSucceedingText()));
        }
        this.setLocationWithinModule(context);
        return n;
    }

    private final AxiomVo create(Axiom axiom) {
        if (axiom == null) {
            return null;
        }
        AxiomVo a = new AxiomVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (axiom.getDefinedOperator() != null) {
            this.setLocationWithinModule(context + ".getDefinedOperator()");
            a.setDefinedOperator(axiom.getDefinedOperator());
        }
        if (axiom.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula()");
            a.setFormula(this.create(axiom.getFormula()));
        }
        if (axiom.getDescription() != null) {
            this.setLocationWithinModule(context + ".getDescription()");
            a.setDescription(this.create(axiom.getDescription()));
        }
        this.setLocationWithinModule(context);
        return a;
    }

    private final InitialPredicateDefinitionVo create(InitialPredicateDefinition definition) {
        if (definition == null) {
            return null;
        }
        InitialPredicateDefinitionVo d = new InitialPredicateDefinitionVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (definition.getLatexPattern() != null) {
            this.setLocationWithinModule(context + ".getLatexPattern()");
            d.setLatexPattern(definition.getLatexPattern());
        }
        if (definition.getName() != null) {
            this.setLocationWithinModule(context + ".getName()");
            d.setName(definition.getName());
        }
        if (definition.getArgumentNumber() != null) {
            this.setLocationWithinModule(context + ".getArgumentNumber()");
            d.setArgumentNumber(definition.getArgumentNumber());
        }
        if (definition.getPredCon() != null) {
            this.setLocationWithinModule(context + ".getPredCon()");
            d.setPredCon(this.create(definition.getPredCon()));
        }
        if (definition.getDescription() != null) {
            this.setLocationWithinModule(context + ".getDescription()");
            d.setDescription(this.create(definition.getDescription()));
        }
        this.setLocationWithinModule(context);
        return d;
    }

    private final PredicateDefinitionVo create(PredicateDefinition definition) {
        if (definition == null) {
            return null;
        }
        PredicateDefinitionVo d = new PredicateDefinitionVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (definition.getLatexPattern() != null) {
            this.setLocationWithinModule(context + ".getLatexPattern()");
            d.setLatexPattern(definition.getLatexPattern());
        }
        if (definition.getName() != null) {
            this.setLocationWithinModule(context + ".getName()");
            d.setName(definition.getName());
        }
        if (definition.getArgumentNumber() != null) {
            this.setLocationWithinModule(context + ".getArgumentNumber()");
            d.setArgumentNumber(definition.getArgumentNumber());
        }
        if (definition.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula()");
            d.setFormula(this.create(definition.getFormula()));
        }
        if (definition.getDescription() != null) {
            this.setLocationWithinModule(context + ".getDescription()");
            d.setDescription(this.create(definition.getDescription()));
        }
        this.setLocationWithinModule(context);
        return d;
    }

    private final InitialFunctionDefinitionVo create(InitialFunctionDefinition definition) {
        if (definition == null) {
            return null;
        }
        InitialFunctionDefinitionVo d = new InitialFunctionDefinitionVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (definition.getLatexPattern() != null) {
            this.setLocationWithinModule(context + ".getLatexPattern()");
            d.setLatexPattern(definition.getLatexPattern());
        }
        if (definition.getArgumentNumber() != null) {
            this.setLocationWithinModule(context + ".getArgumentNumber()");
            d.setArgumentNumber(definition.getArgumentNumber());
        }
        if (definition.getName() != null) {
            this.setLocationWithinModule(context + ".getName()");
            d.setName(definition.getName());
        }
        if (definition.getFunCon() != null) {
            this.setLocationWithinModule(context + ".getFunCon()");
            d.setFunCon(this.create(definition.getFunCon()));
        }
        if (definition.getDescription() != null) {
            this.setLocationWithinModule(context + ".getDescription()");
            d.setDescription(this.create(definition.getDescription()));
        }
        this.setLocationWithinModule(context);
        return d;
    }

    private final FunctionDefinitionVo create(FunctionDefinition definition) {
        if (definition == null) {
            return null;
        }
        FunctionDefinitionVo d = new FunctionDefinitionVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (definition.getLatexPattern() != null) {
            this.setLocationWithinModule(context + ".getLatexPattern()");
            d.setLatexPattern(definition.getLatexPattern());
        }
        if (definition.getArgumentNumber() != null) {
            this.setLocationWithinModule(context + ".getArgumentNumber()");
            d.setArgumentNumber(definition.getArgumentNumber());
        }
        if (definition.getName() != null) {
            this.setLocationWithinModule(context + ".getName()");
            d.setName(definition.getName());
        }
        if (definition.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula()");
            d.setFormula(this.create(definition.getFormula()));
        }
        if (definition.getDescription() != null) {
            this.setLocationWithinModule(context + ".getDescription()");
            d.setDescription(this.create(definition.getDescription()));
        }
        this.setLocationWithinModule(context);
        return d;
    }

    private final PropositionVo create(Proposition proposition) {
        if (proposition == null) {
            return null;
        }
        PropositionVo p = new PropositionVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (proposition.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula()");
            p.setFormula(this.create(proposition.getFormula()));
        }
        if (proposition.getDescription() != null) {
            this.setLocationWithinModule(context + ".getDescription()");
            p.setDescription(this.create(proposition.getDescription()));
        }
        if (proposition.getProofList() != null) {
            this.setLocationWithinModule(context + ".getProofList()");
            p.setProofList(this.create(proposition.getProofList()));
        }
        if (proposition.getFormalProofList() != null) {
            this.setLocationWithinModule(context + ".getFormalProofList()");
            p.setFormalProofList(this.create(proposition.getFormalProofList()));
        }
        this.setLocationWithinModule(context);
        return p;
    }

    private final RuleVo create(Rule rule) {
        if (rule == null) {
            return null;
        }
        RuleVo r = new RuleVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (rule.getName() != null) {
            this.setLocationWithinModule(context + ".getName()");
            r.setName(rule.getName());
        }
        if (rule.getVersion() != null) {
            this.setLocationWithinModule(context + ".getVersion()");
            r.setVersion(rule.getVersion());
        }
        if (rule.getLinkList() != null) {
            this.setLocationWithinModule(context + ".getLinkList()");
            r.setLinkList(this.create(rule.getLinkList()));
        }
        if (rule.getDescription() != null) {
            this.setLocationWithinModule(context + ".getDescription()");
            r.setDescription(this.create(rule.getDescription()));
        }
        if (rule.getChangedRuleList() != null) {
            this.setLocationWithinModule(context + ".getChangedRuleList()");
            r.setChangedRuleList(this.create(rule.getChangedRuleList()));
        }
        if (rule.getProofList() != null) {
            this.setLocationWithinModule(context + ".getProofList()");
            r.setProofList(this.create(rule.getProofList()));
        }
        this.setLocationWithinModule(context);
        return r;
    }

    private final ChangedRuleListVo create(ChangedRuleList changedRuleList) {
        if (changedRuleList == null) {
            return null;
        }
        ChangedRuleListVo list = new ChangedRuleListVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        for (int i = 0; i < changedRuleList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            list.add(this.create(changedRuleList.get(i)));
        }
        this.setLocationWithinModule(context);
        return list;
    }

    private final ChangedRuleVo create(ChangedRule rule) {
        if (rule == null) {
            return null;
        }
        ChangedRuleVo r = new ChangedRuleVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (rule.getName() != null) {
            this.setLocationWithinModule(context + ".getName()");
            r.setName(rule.getName());
        }
        if (rule.getVersion() != null) {
            this.setLocationWithinModule(context + ".getVersion()");
            r.setVersion(rule.getVersion());
        }
        if (rule.getDescription() != null) {
            this.setLocationWithinModule(context + ".getDescription()");
            r.setDescription(this.create(rule.getDescription()));
        }
        this.setLocationWithinModule(context);
        return r;
    }

    private final LinkListVo create(LinkList linkList) {
        if (linkList == null) {
            return null;
        }
        LinkListVo list = new LinkListVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        for (int i = 0; i < linkList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            list.add(linkList.get(i));
        }
        this.setLocationWithinModule(context);
        return list;
    }

    private final ProofListVo create(ProofList proofList) {
        if (proofList == null) {
            return null;
        }
        ProofListVo list = new ProofListVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        for (int i = 0; i < proofList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            list.add(this.create(proofList.get(i)));
        }
        this.setLocationWithinModule(context);
        return list;
    }

    private final ProofVo create(Proof proof) {
        if (proof == null) {
            return null;
        }
        ProofVo p = new ProofVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        this.setLocationWithinModule(context + ".getKind()");
        p.setKind(proof.getKind());
        this.setLocationWithinModule(context + ".getLevel()");
        p.setLevel(proof.getLevel());
        this.setLocationWithinModule(context);
        if (proof.getNonFormalProof() != null) {
            this.setLocationWithinModule(context + ".getNonFormalProof()");
            p.setNonFormalProof(this.create(proof.getNonFormalProof()));
        }
        this.setLocationWithinModule(context);
        return p;
    }

    private final FormalProofListVo create(FormalProofList proofList) {
        if (proofList == null) {
            return null;
        }
        FormalProofListVo list = new FormalProofListVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        for (int i = 0; i < proofList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            list.add(this.create(proofList.get(i)));
        }
        this.setLocationWithinModule(context);
        return list;
    }

    private final FormalProofVo create(FormalProof proof) {
        if (proof == null) {
            return null;
        }
        FormalProofVo p = new FormalProofVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        this.setLocationWithinModule(context);
        if (proof.getPrecedingText() != null) {
            this.setLocationWithinModule(context + ".getPrecedingText()");
            p.setPrecedingText(this.create(proof.getPrecedingText()));
        }
        if (proof.getFormalProofLineList() != null) {
            this.setLocationWithinModule(context + ".getFormalProofLineList()");
            p.setFormalProofLineList(this.create(proof.getFormalProofLineList()));
        }
        if (proof.getSucceedingText() != null) {
            this.setLocationWithinModule(context + ".getSucceedingText()");
            p.setSucceedingText(this.create(proof.getSucceedingText()));
        }
        this.setLocationWithinModule(context);
        return p;
    }

    private final FormalProofLineListVo create(FormalProofLineList proofList) {
        if (proofList == null) {
            return null;
        }
        FormalProofLineListVo list = new FormalProofLineListVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        for (int i = 0; i < proofList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            if (proofList.get(i) instanceof ConditionalProof) {
                list.add(this.create((ConditionalProof)proofList.get(i)));
                continue;
            }
            list.add(this.create(proofList.get(i)));
        }
        this.setLocationWithinModule(context);
        return list;
    }

    private final FormalProofLineVo create(FormalProofLine proofLine) {
        if (proofLine == null) {
            return null;
        }
        FormalProofLineVo line = new FormalProofLineVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (proofLine.getLabel() != null) {
            this.setLocationWithinModule(context + ".getLabel()");
            line.setLabel(proofLine.getLabel());
        }
        if (proofLine.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula()");
            line.setFormula(this.create(proofLine.getFormula()));
        }
        if (proofLine.getReason() != null) {
            this.setLocationWithinModule(context + ".getReason()");
            line.setReason(this.create(proofLine.getReason()));
        }
        this.setLocationWithinModule(context);
        return line;
    }

    private final ConditionalProofVo create(ConditionalProof proofLine) {
        if (proofLine == null) {
            return null;
        }
        ConditionalProofVo line = new ConditionalProofVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (proofLine.getHypothesis() != null) {
            this.setLocationWithinModule(context + ".getHypothesis()");
            line.setHypothesis(proofLine.getHypothesis());
        }
        if (proofLine.getFormalProofLineList() != null) {
            this.setLocationWithinModule(context + ".getFormalProofLineList()");
            line.setFormalProofLineList(this.create(proofLine.getFormalProofLineList()));
        }
        if (proofLine.getConclusion() != null) {
            this.setLocationWithinModule(context + ".getConclusion()");
            line.setConclusion(this.create(proofLine.getConclusion()));
        }
        this.setLocationWithinModule(context);
        return line;
    }

    private final Reason create(Reason reason) {
        if (reason == null) {
            return null;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        Reason result = null;
        if (reason instanceof ModusPonens) {
            this.setLocationWithinModule(context + ".getModusPonens()");
            ModusPonens r = (ModusPonens)reason;
            result = new ModusPonensVo(r.getReference1(), r.getReference2());
        } else if (reason instanceof Add) {
            this.setLocationWithinModule(context + ".getAdd()");
            Add r = (Add)reason;
            result = new AddVo(r.getReference());
        } else if (reason instanceof Rename) {
            this.setLocationWithinModule(context + ".getRename()");
            Rename r = (Rename)reason;
            result = new RenameVo(r.getReference(), r.getOriginalSubjectVariable(), r.getReplacementSubjectVariable(), r.getOccurrence());
        } else if (reason instanceof SubstFree) {
            this.setLocationWithinModule(context + ".getSubstFree()");
            SubstFree r = (SubstFree)reason;
            result = new SubstFreeVo(r.getReference(), r.getSubjectVariable(), r.getSubstituteTerm());
        } else if (reason instanceof SubstFunc) {
            this.setLocationWithinModule(context + ".getSubstFunc()");
            SubstFunc r = (SubstFunc)reason;
            result = new SubstFuncVo(r.getReference(), r.getFunctionVariable(), r.getSubstituteTerm());
        } else if (reason instanceof SubstPred) {
            this.setLocationWithinModule(context + ".getSubstPred()");
            SubstPred r = (SubstPred)reason;
            result = new SubstPredVo(r.getReference(), r.getPredicateVariable(), r.getSubstituteFormula());
        } else if (reason instanceof Existential) {
            this.setLocationWithinModule(context + ".getExistential()");
            Existential r = (Existential)reason;
            result = new ExistentialVo(r.getReference(), r.getSubjectVariable());
        } else if (reason instanceof Universal) {
            this.setLocationWithinModule(context + ".getUniversal()");
            Universal r = (Universal)reason;
            result = new UniversalVo(r.getReference(), r.getSubjectVariable());
        } else if (reason instanceof ConditionalProof) {
            this.setLocationWithinModule(context + ".getConditionalProof()");
            ConditionalProof r = (ConditionalProof)reason;
            this.setLocationWithinModule(context + ".getConditionalProof().getHypothesis()");
            HypothesisVo h = this.create(r.getHypothesis());
            this.setLocationWithinModule(context + ".getConditionalProof().getFormalProofLineList()");
            FormalProofLineListVo l = this.create(r.getFormalProofLineList());
            this.setLocationWithinModule(context + ".getConditionalProof().getConclusion()");
            ConclusionVo c = this.create(r.getConclusion());
            result = new ConditionalProofVo(h, l, c);
        } else {
            throw new RuntimeException("unknown reason class: " + reason.getClass());
        }
        this.setLocationWithinModule(context);
        return result;
    }

    private final HypothesisVo create(Hypothesis hypothesis) {
        if (hypothesis == null) {
            return null;
        }
        HypothesisVo h = new HypothesisVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (hypothesis.getLabel() != null) {
            h.setLabel(hypothesis.getLabel());
        }
        if (hypothesis.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula()");
            h.setFormula(this.create(hypothesis.getFormula()));
        }
        this.setLocationWithinModule(context);
        return h;
    }

    private final ConclusionVo create(Conclusion conclusion) {
        if (conclusion == null) {
            return null;
        }
        ConclusionVo c = new ConclusionVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (conclusion.getLabel() != null) {
            c.setLabel(conclusion.getLabel());
        }
        if (conclusion.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula()");
            c.setFormula(this.create(conclusion.getFormula()));
        }
        this.setLocationWithinModule(context);
        return c;
    }

    private final FormulaVo create(Formula formula) {
        if (formula == null) {
            return null;
        }
        FormulaVo f = new FormulaVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (formula.getElement() != null) {
            this.setLocationWithinModule(context + ".getElement()");
            f.setElement(this.create(formula.getElement()));
        }
        this.setLocationWithinModule(context);
        return f;
    }

    private final Element create(Element element) {
        if (element == null) {
            return null;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        if (!element.isList()) {
            if (element.isAtom()) {
                return this.create(element.getAtom());
            }
            throw new RuntimeException("unknown element type: " + element);
        }
        this.setLocationWithinModule(context + ".getList()");
        DefaultElementList e = this.create(element.getList());
        this.setLocationWithinModule(context);
        return e;
    }

    private final DefaultElementList create(ElementList list) {
        if (list == null) {
            return null;
        }
        DefaultElementList n = new DefaultElementList(list.getOperator(), new Element[0]);
        String context = this.getCurrentContext().getLocationWithinModule();
        for (int i = 0; i < list.size(); ++i) {
            if (list.getElement(i).isList()) {
                this.setLocationWithinModule(context + ".getElement(" + i + ")");
            }
            n.add(this.create(list.getElement(i)));
        }
        this.setLocationWithinModule(context);
        return n;
    }

    private final DefaultAtom create(Atom atom) {
        if (atom == null) {
            return null;
        }
        return new DefaultAtom(atom.getString());
    }

    private final LatexListVo create(LatexList latexList) {
        if (latexList == null) {
            return null;
        }
        LatexListVo list = new LatexListVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        for (int i = 0; i < latexList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            list.add(this.create(latexList.get(i)));
        }
        this.setLocationWithinModule(context);
        return list;
    }

    private final LatexVo create(Latex latex) {
        if (latex == null) {
            return null;
        }
        LatexVo lat = new LatexVo();
        lat.setLanguage(latex.getLanguage());
        lat.setLatex(latex.getLatex());
        return lat;
    }

    protected void setLocationWithinModule(String locationWithinModule) {
        this.getCurrentContext().setLocationWithinModule(locationWithinModule);
    }

    protected final ModuleContext getCurrentContext() {
        return this.currentContext;
    }

    protected final Qedeq getQedeqOriginal() {
        return this.original;
    }
}

