/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qedeq.base.io.Parameters;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.module.InternalKernelServices;
import org.qedeq.kernel.bo.module.InternalPluginBo;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.PluginBo;

public class PluginManager {
    private static final Class CLASS = PluginManager.class;
    private final Map id2plugin = new HashMap();
    private final List plugins = new ArrayList();
    private final InternalKernelServices kernel;

    public PluginManager(InternalKernelServices kernel) {
        this.kernel = kernel;
    }

    public synchronized PluginBo getPlugin(String id) {
        return (PluginBo)this.id2plugin.get(id);
    }

    synchronized PluginBo[] getNonInternalPlugins() {
        ArrayList result = new ArrayList(this.plugins.size());
        for (int i = 0; i < this.plugins.size(); ++i) {
            if (this.plugins.get(i) instanceof InternalPluginBo) continue;
            result.add(this.plugins.get(i));
        }
        return result.toArray(new PluginBo[0]);
    }

    synchronized void addPlugin(String pluginClass) {
        String method = "addPlugin";
        PluginBo plugin = null;
        try {
            Class<?> cl = Class.forName(pluginClass);
            plugin = (PluginBo)cl.newInstance();
        }
        catch (ClassNotFoundException e) {
            Trace.fatal(CLASS, this, "addPlugin", "Plugin class not in class path: " + pluginClass, e);
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            Trace.fatal(CLASS, this, "addPlugin", "Plugin class could not be istanciated: " + pluginClass, e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            Trace.fatal(CLASS, this, "addPlugin", "Programming error, access for instantiation failed for plugin: " + pluginClass, e);
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            Trace.fatal(CLASS, this, "addPlugin", "Programming error, instantiation failed for plugin: " + pluginClass, e);
            throw new RuntimeException(e);
        }
        this.addPlugin(plugin);
        Parameters parameters = this.kernel.getConfig().getPluginEntries(plugin);
        plugin.setDefaultValuesForEmptyPluginParameters(parameters);
        this.kernel.getConfig().setPluginKeyValues(plugin, parameters);
    }

    synchronized void addPlugin(PluginBo plugin) {
        if (this.id2plugin.get(plugin.getPluginId()) != null) {
            PluginBo oldPlugin = (PluginBo)this.id2plugin.get(plugin.getPluginId());
            IllegalArgumentException e = new IllegalArgumentException("plugin with that name already added: " + oldPlugin.getPluginId() + ": " + plugin.getPluginDescription());
            Trace.fatal(CLASS, this, "addPlugin", "Programing error", e);
            throw e;
        }
        this.id2plugin.put(plugin.getPluginId(), plugin);
        this.plugins.add(plugin);
    }

    public void clearAllPluginResults(KernelQedeqBo qedeq) {
        qedeq.clearAllPluginErrorsAndWarnings();
    }
}

