/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service;

import org.qedeq.base.io.Parameters;
import org.qedeq.kernel.bo.common.PluginCall;
import org.qedeq.kernel.bo.common.QedeqBo;
import org.qedeq.kernel.bo.common.ServiceProcess;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.PluginExecutor;
import org.qedeq.kernel.se.common.Plugin;

public class PluginCallImpl
implements PluginCall {
    private static volatile long globalCounter;
    private final Plugin plugin;
    private final KernelQedeqBo qedeq;
    private final Parameters parameters;
    private long start;
    private long stop;
    private int state;
    private double executionPercentage = 0.0;
    private String executionActionDescription = "not yet started";
    private PluginExecutor executor;
    private final ServiceProcess process;
    private final PluginCall parent;
    private final long id = this.inc();
    private int ret;
    private Object result;

    public PluginCallImpl(Plugin service, KernelQedeqBo qedeq, Parameters parameters, ServiceProcess process, PluginCall parent) {
        this.qedeq = qedeq;
        this.plugin = service;
        this.parameters = parameters;
        this.process = process;
        if (!process.getThread().isAlive()) {
            throw new RuntimeException("thread is already dead");
        }
        this.parent = parent;
        this.start();
    }

    private synchronized long inc() {
        return globalCounter++;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public QedeqBo getQedeq() {
        return this.qedeq;
    }

    public synchronized Parameters getParameters() {
        return this.parameters;
    }

    public synchronized PluginExecutor getExecutor() {
        return this.executor;
    }

    public synchronized void setExecutor(PluginExecutor executor) {
        this.executor = executor;
    }

    public String getParameterString() {
        return this.parameters.getParameterString();
    }

    public long getStart() {
        return this.start;
    }

    public synchronized long getStop() {
        return this.stop;
    }

    private synchronized void start() {
        this.start = System.currentTimeMillis();
        this.executionActionDescription = "started";
    }

    private synchronized void stop() {
        this.stop = System.currentTimeMillis();
    }

    public synchronized void setSuccessState() {
        if (this.isRunning()) {
            this.state = 1;
            this.stop();
            this.executionActionDescription = "finished";
            this.executionPercentage = 100.0;
        }
    }

    public synchronized void setFailureState() {
        if (this.isRunning()) {
            this.state = -1;
            this.stop();
        }
    }

    public synchronized boolean isRunning() {
        return this.state == 0;
    }

    public synchronized boolean isFinished() {
        return this.state != 0;
    }

    public synchronized boolean wasInterrupted() {
        return this.state == -1;
    }

    public synchronized boolean hasNormallyFinished() {
        return this.state == 1;
    }

    public synchronized ServiceProcess getServiceProcess() {
        return this.process;
    }

    public synchronized double getExecutionPercentage() {
        if (this.isRunning() && this.executor != null) {
            this.executionPercentage = this.executor.getExecutionPercentage();
        }
        return this.executionPercentage;
    }

    public synchronized String getExecutionActionDescription() {
        if (this.isRunning() && this.executor != null) {
            this.executionActionDescription = this.executor.getLocationDescription();
        }
        return this.executionActionDescription;
    }

    public long getId() {
        return this.id;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object obj) {
        return 0 == this.compareTo(obj);
    }

    public int compareTo(Object o) {
        if (!(o instanceof PluginCall)) {
            return -1;
        }
        PluginCall s = (PluginCall)o;
        return this.getId() < s.getId() ? -1 : (this.getId() == s.getId() ? 0 : 1);
    }

    public synchronized PluginCall getParentPluginCall() {
        return this.parent;
    }

    public synchronized Object getExecutionResult() {
        return this.result;
    }

    public synchronized int getReturnCode() {
        return this.ret;
    }
}

