/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service;

import java.util.HashMap;
import java.util.Map;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.kernel.bo.common.ServiceProcess;
import org.qedeq.kernel.bo.module.InternalServiceProcess;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.se.common.ModuleContext;
import org.qedeq.kernel.se.visitor.InterruptException;

public class ModuleArbiter {
    private final Map blocked = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lockRequiredModule(InternalServiceProcess process, KernelQedeqBo qedeq) throws InterruptException {
        if (this.isAlreadyLocked(process, qedeq)) {
            return false;
        }
        while (!this.lock(process, qedeq)) {
            Object monitor;
            Object object = monitor = new Object();
            synchronized (object) {
                try {
                    monitor.wait(10000L);
                }
                catch (InterruptedException e) {
                    process.setFailureState();
                    throw new InterruptException(new ModuleContext(qedeq.getModuleAddress()));
                }
            }
            if (!Thread.interrupted()) continue;
            process.setFailureState();
            throw new InterruptException(new ModuleContext(qedeq.getModuleAddress()));
        }
        return true;
    }

    private synchronized boolean lock(ServiceProcess process, KernelQedeqBo qedeq) {
        System.out.println(this.getName(process) + " is trying to lock   " + qedeq.getName());
        ServiceProcess origin = (ServiceProcess)this.blocked.get(qedeq);
        if (origin != null) {
            System.out.println(this.getName(process) + " failed to lock      " + qedeq.getName());
            System.out.println("\tbecause it is locked by " + this.getName(origin));
            return false;
        }
        System.out.println(this.getName(process) + " locked successfuly  " + qedeq.getName());
        this.blocked.put(qedeq, process);
        return true;
    }

    private String getName(ServiceProcess process) {
        return StringUtility.format(process.getId(), 3) + " " + (process.getPluginCall() != null ? StringUtility.getLastDotString(process.getPluginCall().getPlugin().getPluginId()) : "");
    }

    public void unlockRequiredModule(ServiceProcess process, KernelQedeqBo qedeq) {
        this.unlock(process, qedeq);
    }

    /*
     * Enabled aggressive block sorting
     */
    private synchronized void unlock(ServiceProcess process, KernelQedeqBo qedeq) {
        System.out.println(this.getName(process) + " is trying to unlock " + qedeq.getName());
        ServiceProcess origin = (ServiceProcess)this.blocked.get(qedeq);
        if (origin == null) {
            System.out.println(this.getName(process) + " unlock unneccassary " + qedeq.getName());
            return;
        }
        if (origin.equals(process)) {
            System.out.println(this.getName(process) + " unlocked            " + qedeq.getName());
            this.blocked.remove(qedeq);
            return;
        }
        System.out.println(this.getName(process) + " illegal unlock try  " + qedeq.getName());
        throw new IllegalArgumentException("locked by service process " + origin.getId());
    }

    private synchronized ServiceProcess getProcess(KernelQedeqBo qedeq) {
        return (ServiceProcess)this.blocked.get(qedeq);
    }

    private synchronized boolean isLocked(KernelQedeqBo qedeq) {
        return this.blocked.containsKey(qedeq);
    }

    private synchronized boolean isAlreadyLocked(ServiceProcess process, KernelQedeqBo qedeq) {
        return process.equals(this.blocked.get(qedeq));
    }

    private synchronized void addLock(ServiceProcess process, KernelQedeqBo qedeq) {
        this.blocked.put(qedeq, process);
    }

    private synchronized void removeLock(KernelQedeqBo qedeq) {
        this.blocked.remove(qedeq);
    }
}

