/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.common.QedeqBo;
import org.qedeq.kernel.bo.module.InternalKernelServices;
import org.qedeq.kernel.bo.module.KernelModuleReferenceList;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.service.DefaultKernelQedeqBo;
import org.qedeq.kernel.se.common.ModuleAddress;
import org.qedeq.kernel.se.state.LoadingState;

class KernelQedeqBoStorage {
    private static final Class CLASS = KernelQedeqBoStorage.class;
    private final Map bos = new HashMap();

    KernelQedeqBoStorage() {
    }

    synchronized DefaultKernelQedeqBo getKernelQedeqBo(InternalKernelServices services, ModuleAddress address) {
        if (this.bos.containsKey(address)) {
            return (DefaultKernelQedeqBo)this.bos.get(address);
        }
        DefaultKernelQedeqBo prop = new DefaultKernelQedeqBo(services, address);
        this.bos.put(address, prop);
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void removeAllModules() {
        String method = "removeAllModules()";
        Trace.begin(CLASS, this, "removeAllModules()");
        try {
            Iterator iterator = this.bos.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                DefaultKernelQedeqBo prop = (DefaultKernelQedeqBo)entry.getValue();
                prop.delete();
            }
            this.bos.clear();
        }
        catch (RuntimeException e) {
            Trace.trace(CLASS, (Object)this, "removeAllModules()", (Throwable)e);
        }
        finally {
            Trace.end(CLASS, this, "removeAllModules()");
        }
    }

    synchronized void validateDependencies() {
        String method = "validateDependencies";
        boolean error = false;
        Trace.begin(CLASS, this, "validateDependencies");
        Iterator iterator = this.bos.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            DefaultKernelQedeqBo prop = (DefaultKernelQedeqBo)entry.getValue();
            Trace.param(CLASS, (Object)this, "validateDependencies", "prop", prop);
            if (!prop.hasLoadedRequiredModules()) continue;
            KernelModuleReferenceList refs = prop.getKernelRequiredModules();
            for (int i = 0; i < refs.size(); ++i) {
                DefaultKernelQedeqBo ref = (DefaultKernelQedeqBo)refs.getKernelQedeqBo(i);
                KernelModuleReferenceList dependents = ref.getDependentModules();
                if (dependents.contains(prop)) continue;
                Trace.fatal(CLASS, this, "validateDependencies", ref.getUrl() + " missing dependent module: " + prop.getUrl(), null);
                error = true;
            }
            KernelModuleReferenceList dependents = prop.getDependentModules();
            for (int i = 0; i < dependents.size(); ++i) {
                DefaultKernelQedeqBo dependent = (DefaultKernelQedeqBo)dependents.getKernelQedeqBo(i);
                KernelModuleReferenceList refs2 = dependent.getDependentModules();
                if (refs2.contains(prop)) continue;
                Trace.fatal(CLASS, this, "validateDependencies", dependent.getUrl() + " missing required module: " + prop.getUrl(), null);
                error = true;
            }
        }
        Trace.end(CLASS, this, "validateDependencies");
        if (error) {
            Error e = new Error("QEDEQ dependencies and status are flawed! This is a major error!");
            Trace.fatal(CLASS, this, "validateDependencies", "Shutdown because of major validation error", e);
            throw e;
        }
    }

    synchronized void removeModule(KernelQedeqBo prop) {
        String method = "removeModule(KernelQedeqBo)";
        Trace.begin(CLASS, this, "removeModule(KernelQedeqBo)");
        try {
            Trace.trace(CLASS, (Object)this, "removeModule(KernelQedeqBo)", "removing " + prop.getUrl());
            this.bos.remove(prop.getModuleAddress());
        }
        catch (RuntimeException e) {
            Trace.fatal(CLASS, this, "removeModule(KernelQedeqBo)", "unexpected runtime exception", e);
            throw e;
        }
        finally {
            Trace.end(CLASS, this, "removeModule(KernelQedeqBo)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized ModuleAddress[] getAllLoadedModules() {
        String method = "getAllModules()";
        Trace.begin(CLASS, this, "getAllModules()");
        try {
            ArrayList<ModuleAddress> list = new ArrayList<ModuleAddress>();
            Iterator iterator = this.bos.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                QedeqBo prop = (QedeqBo)entry.getValue();
                if (prop.getLoadingState().getCode() < LoadingState.STATE_LOADED.getCode()) continue;
                list.add(prop.getModuleAddress());
            }
            ModuleAddress[] moduleAddressArray = list.toArray(new ModuleAddress[list.size()]);
            return moduleAddressArray;
        }
        finally {
            Trace.end(CLASS, this, "getAllModules()");
        }
    }

    synchronized int getNumberOfLoadedModules() {
        return this.getAllLoadedModules().length;
    }
}

