/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service;

import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.qedeq.base.io.SourceArea;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.EqualsUtility;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.kernel.bo.common.Element2Latex;
import org.qedeq.kernel.bo.common.Element2Utf8;
import org.qedeq.kernel.bo.common.ModuleReferenceList;
import org.qedeq.kernel.bo.module.InternalKernelServices;
import org.qedeq.kernel.bo.module.KernelModuleReferenceList;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.ModuleConstantsExistenceChecker;
import org.qedeq.kernel.bo.module.ModuleLabels;
import org.qedeq.kernel.bo.module.QedeqFileDao;
import org.qedeq.kernel.bo.service.StateManager;
import org.qedeq.kernel.se.base.module.LatexList;
import org.qedeq.kernel.se.base.module.Qedeq;
import org.qedeq.kernel.se.common.ModuleAddress;
import org.qedeq.kernel.se.common.ModuleContext;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileException;
import org.qedeq.kernel.se.common.SourceFileExceptionList;
import org.qedeq.kernel.se.dto.module.QedeqVo;
import org.qedeq.kernel.se.state.AbstractState;
import org.qedeq.kernel.se.state.DependencyState;
import org.qedeq.kernel.se.state.FormallyProvedState;
import org.qedeq.kernel.se.state.LoadingImportsState;
import org.qedeq.kernel.se.state.LoadingState;
import org.qedeq.kernel.se.state.WellFormedState;

public class DefaultKernelQedeqBo
implements KernelQedeqBo {
    private static final Class CLASS = DefaultKernelQedeqBo.class;
    private final InternalKernelServices services;
    private final ModuleAddress address;
    private QedeqVo qedeq;
    private KernelModuleReferenceList required;
    private KernelModuleReferenceList dependent;
    private ModuleConstantsExistenceChecker checker;
    private ModuleLabels labels;
    private Element2Latex converter;
    private Element2Utf8 textConverter;
    private QedeqFileDao loader;
    private final StateManager stateManager;

    public DefaultKernelQedeqBo(InternalKernelServices services, ModuleAddress address) {
        this.services = services;
        this.address = address;
        if (address == null) {
            throw new NullPointerException("ModuleAddress must not be null");
        }
        this.required = new KernelModuleReferenceList();
        this.dependent = new KernelModuleReferenceList();
        this.stateManager = new StateManager(this);
    }

    public void setQedeqFileDao(QedeqFileDao loader) {
        this.loader = loader;
    }

    public QedeqFileDao getLoader() {
        return this.loader;
    }

    public boolean hasBasicFailures() {
        return this.stateManager.hasBasicFailures();
    }

    public boolean hasErrors() {
        return this.stateManager.hasErrors();
    }

    public boolean hasWarnings() {
        return this.stateManager.hasWarnings();
    }

    public ModuleAddress getModuleAddress() {
        return this.address;
    }

    public InternalKernelServices getKernelServices() {
        return this.services;
    }

    public void setLoadingCompleteness(int completeness) {
        this.stateManager.setLoadingCompleteness(completeness);
    }

    public int getLoadingCompleteness() {
        return this.stateManager.getLoadingCompleteness();
    }

    public void delete() {
        this.stateManager.delete();
    }

    public void setLoadingProgressState(Plugin plugin, LoadingState state) {
        this.stateManager.setLoadingProgressState(plugin, state);
    }

    public void setLoadingFailureState(LoadingState state, SourceFileExceptionList e) {
        this.stateManager.setLoadingFailureState(state, e);
    }

    public LoadingState getLoadingState() {
        return this.stateManager.getLoadingState();
    }

    public boolean isLoaded() {
        return this.stateManager.isLoaded();
    }

    public void setLoaded(QedeqVo qedeq, ModuleLabels labels, Element2Latex converter, Element2Utf8 textConverter) {
        this.stateManager.setLoaded(qedeq, labels);
        this.converter = converter;
        this.textConverter = textConverter;
    }

    public Qedeq getQedeq() {
        return this.qedeq;
    }

    public Element2Latex getElement2Latex() {
        return this.converter;
    }

    public Element2Utf8 getElement2Utf8() {
        return this.textConverter;
    }

    public void setLoadingImportsProgressState(Plugin plugin, LoadingImportsState state) {
        this.stateManager.setLoadingImportsProgressState(plugin, state);
    }

    public void setLoadingImportsFailureState(LoadingImportsState state, SourceFileExceptionList e) {
        this.stateManager.setLoadingImportsFailureState(state, e);
    }

    public LoadingImportsState getLoadingImportsState() {
        return this.stateManager.getLoadingImportsState();
    }

    public void setLoadedImports(KernelModuleReferenceList list) {
        this.stateManager.setLoadedImports(list);
    }

    public boolean hasLoadedImports() {
        return this.stateManager.hasLoadedImports();
    }

    public void setDependencyProgressState(Plugin plugin, DependencyState state) {
        this.stateManager.setDependencyProgressState(plugin, state);
    }

    public void setDependencyFailureState(DependencyState state, SourceFileExceptionList e) {
        this.stateManager.setDependencyFailureState(state, e);
    }

    public DependencyState getDependencyState() {
        return this.stateManager.getDependencyState();
    }

    public void setLoadedRequiredModules() {
        this.stateManager.setLoadedRequiredModules();
    }

    public ModuleReferenceList getRequiredModules() {
        return this.getKernelRequiredModules();
    }

    public KernelModuleReferenceList getKernelRequiredModules() {
        return this.required;
    }

    public boolean hasLoadedRequiredModules() {
        return this.stateManager.hasLoadedRequiredModules();
    }

    public KernelModuleReferenceList getDependentModules() {
        return this.dependent;
    }

    public void setWellFormed(ModuleConstantsExistenceChecker checker) {
        this.stateManager.setWellFormed(checker);
    }

    public boolean isWellFormed() {
        return this.stateManager.isWellFormed();
    }

    public boolean isFullyFormallyProved() {
        return this.stateManager.isFullyFormallyProved();
    }

    public void setWellFormedProgressState(Plugin plugin, WellFormedState state) {
        this.stateManager.setWellFormedProgressState(plugin, state);
    }

    public void setWellfFormedFailureState(WellFormedState state, SourceFileExceptionList e) {
        this.stateManager.setWellFormedFailureState(state, e);
    }

    public WellFormedState getWellFormedState() {
        return this.stateManager.getWellFormedState();
    }

    public void setFormallyProvedProgressState(Plugin plugin, FormallyProvedState state) {
        this.stateManager.setFormallyProvedProgressState(plugin, state);
    }

    public void setFormallyProvedFailureState(FormallyProvedState state, SourceFileExceptionList e) {
        this.stateManager.setFormallyProvedFailureState(state, e);
    }

    public FormallyProvedState getFormallyProvedState() {
        return this.stateManager.getFormallyProvedState();
    }

    public SourceFileExceptionList getErrors() {
        return this.stateManager.getErrors();
    }

    public SourceFileExceptionList getWarnings() {
        return this.stateManager.getWarnings();
    }

    public String getStateDescription() {
        return this.stateManager.getStateDescription();
    }

    public AbstractState getCurrentState() {
        return this.stateManager.getCurrentState();
    }

    public AbstractState getLastSuccessfulState() {
        return this.stateManager.getLastSuccesfulState();
    }

    public Plugin getCurrentlyRunningPlugin() {
        return this.stateManager.getCurrentlyRunningPlugin();
    }

    public void setCurrentlyRunningPlugin(Plugin currentlyRunningPlugin) {
        this.stateManager.setCurrentlyRunningPlugin(currentlyRunningPlugin);
    }

    public String getName() {
        if (this.address == null) {
            return "null";
        }
        return this.address.getName();
    }

    public String getRuleVersion() {
        if (this.address == null || this.qedeq == null || this.qedeq.getHeader() == null || this.qedeq.getHeader().getSpecification() == null || this.qedeq.getHeader().getSpecification().getRuleVersion() == null) {
            return "";
        }
        return this.qedeq.getHeader().getSpecification().getRuleVersion();
    }

    public String getUrl() {
        if (this.address == null) {
            return null;
        }
        return this.address.getUrl();
    }

    public void setLabels(ModuleLabels labels) {
        this.labels = labels;
    }

    public ModuleLabels getLabels() {
        return this.labels;
    }

    public SourceFileExceptionList createSourceFileExceptionList(Plugin plugin, ModuleDataException exception) {
        SourceArea referenceArea = null;
        if (exception.getReferenceContext() != null) {
            referenceArea = this.createSourceArea(this.qedeq, exception.getReferenceContext());
        }
        SourceFileException e = new SourceFileException(plugin, exception, this.createSourceArea(this.qedeq, exception.getContext()), referenceArea);
        SourceFileExceptionList list = new SourceFileExceptionList(e);
        return list;
    }

    public SourceFileExceptionList createSourceFileExceptionList(Plugin plugin, ModuleDataException exception, Qedeq qedeq) {
        SourceFileException e = new SourceFileException(plugin, exception, this.createSourceArea(qedeq, exception.getContext()), this.createSourceArea(qedeq, exception.getReferenceContext()));
        SourceFileExceptionList list = new SourceFileExceptionList(e);
        return list;
    }

    public SourceFileException createSourceFileException(Plugin plugin, ModuleDataException exception) {
        SourceArea area = this.createSourceArea(this.qedeq, exception.getContext());
        SourceArea referenceArea = null;
        if (exception.getReferenceContext() != null) {
            referenceArea = this.createSourceArea(this.qedeq, exception.getReferenceContext());
        }
        SourceFileException e = new SourceFileException(plugin, exception, area, referenceArea);
        return e;
    }

    public SourceArea createSourceArea(Qedeq qedeq, ModuleContext context) {
        SourceArea area;
        block3: {
            String method = "createSourceArea(Qedeq, ModuleContext)";
            area = null;
            try {
                area = this.loader.createSourceArea(qedeq, context);
            }
            catch (RuntimeException e) {
                Trace.fatal(CLASS, "createSourceArea(Qedeq, ModuleContext)", "loader couldn't create context: " + context, e);
                if (!Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("qedeq.test.xmlLocationFailures"))) break block3;
                throw e;
            }
        }
        if (area == null) {
            Trace.fatal(CLASS, "createSourceArea", "loader coudn't create context: " + context, new NullPointerException());
            area = new SourceArea(this.getModuleAddress().getUrl());
        }
        return area;
    }

    public String[] getSupportedLanguages() {
        if (!this.isLoaded() || this.getQedeq() == null || this.getQedeq().getHeader() == null || this.getQedeq().getHeader().getTitle() == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        LatexList list = this.getQedeq().getHeader().getTitle();
        ArrayList<String> result = new ArrayList<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            if (null == list.get(i) || list.get(i).getLanguage() == null || list.get(i).getLanguage().trim().length() <= 0) continue;
            result.add(list.get(i).getLanguage());
        }
        return result.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public boolean isSupportedLanguage(String language) {
        return StringUtility.isIn(language, this.getSupportedLanguages());
    }

    public String getOriginalLanguage() {
        String[] supported = this.getSupportedLanguages();
        if (StringUtility.isNotIn("de", supported)) {
            if (supported.length == 0) {
                return "en";
            }
            return supported[0];
        }
        return "de";
    }

    public void setQedeqVo(QedeqVo qedeq) {
        this.qedeq = qedeq;
    }

    protected StateManager getStateManager() {
        return this.stateManager;
    }

    public ModuleConstantsExistenceChecker getExistenceChecker() {
        return this.checker;
    }

    public void setExistenceChecker(ModuleConstantsExistenceChecker checker) {
        this.checker = checker;
    }

    public int hashCode() {
        return this.getModuleAddress() == null ? 0 : this.getModuleAddress().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultKernelQedeqBo) {
            return EqualsUtility.equals(((DefaultKernelQedeqBo)obj).getModuleAddress(), this.getModuleAddress());
        }
        return false;
    }

    public String toString() {
        return this.address.getUrl();
    }

    public void addPluginErrorsAndWarnings(Plugin plugin, SourceFileExceptionList errors, SourceFileExceptionList warnings) {
        this.stateManager.addPluginResults(plugin, errors, warnings);
    }

    public void clearAllPluginErrorsAndWarnings() {
        this.stateManager.removeAllPluginResults();
    }
}

