/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.io.LoadingListener;
import org.qedeq.base.io.SourceArea;
import org.qedeq.base.io.TextInput;
import org.qedeq.base.io.UrlUtility;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.kernel.bo.common.KernelProperties;
import org.qedeq.kernel.bo.common.QedeqBo;
import org.qedeq.kernel.bo.common.ServiceModule;
import org.qedeq.kernel.bo.common.ServiceProcess;
import org.qedeq.kernel.bo.log.QedeqLog;
import org.qedeq.kernel.bo.module.InternalKernelServices;
import org.qedeq.kernel.bo.module.InternalServiceProcess;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.QedeqFileDao;
import org.qedeq.kernel.bo.service.DefaultKernelQedeqBo;
import org.qedeq.kernel.bo.service.KernelQedeqBoStorage;
import org.qedeq.kernel.bo.service.ModuleArbiter;
import org.qedeq.kernel.bo.service.ModuleFileNotFoundException;
import org.qedeq.kernel.bo.service.ModuleLabelsCreator;
import org.qedeq.kernel.bo.service.PluginManager;
import org.qedeq.kernel.bo.service.QedeqVoBuilder;
import org.qedeq.kernel.bo.service.ServiceProcessImpl;
import org.qedeq.kernel.bo.service.ServiceProcessManager;
import org.qedeq.kernel.bo.service.dependency.LoadAllRequiredModulesPlugin;
import org.qedeq.kernel.bo.service.dependency.LoadDirectlyRequiredModulesPlugin;
import org.qedeq.kernel.bo.service.dependency.LoadRequiredModulesPlugin;
import org.qedeq.kernel.bo.service.logic.FormalProofCheckerPlugin;
import org.qedeq.kernel.bo.service.logic.SimpleProofFinderPlugin;
import org.qedeq.kernel.bo.service.logic.WellFormedCheckerPlugin;
import org.qedeq.kernel.se.base.module.Qedeq;
import org.qedeq.kernel.se.base.module.Specification;
import org.qedeq.kernel.se.common.DefaultModuleAddress;
import org.qedeq.kernel.se.common.ModuleAddress;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileException;
import org.qedeq.kernel.se.common.SourceFileExceptionList;
import org.qedeq.kernel.se.config.QedeqConfig;
import org.qedeq.kernel.se.dto.module.QedeqVo;
import org.qedeq.kernel.se.state.LoadingState;
import org.qedeq.kernel.se.visitor.ContextChecker;
import org.qedeq.kernel.se.visitor.DefaultContextChecker;

public class DefaultInternalKernelServices
implements ServiceModule,
InternalKernelServices,
Plugin {
    private static final Class CLASS = DefaultInternalKernelServices.class;
    private static final Object MONITOR = new Object();
    private final String processCounterSync = CLASS.toString();
    private volatile int processCounter = 0;
    private KernelQedeqBoStorage modules;
    private final QedeqConfig config;
    private final KernelProperties kernel;
    private final QedeqFileDao qedeqFileDao;
    private final ModuleArbiter arbiter;
    private final PluginManager pluginManager;
    private final ServiceProcessManager processManager;
    private boolean validate = true;
    private ContextChecker contextChecker;

    public DefaultInternalKernelServices(QedeqConfig config, KernelProperties kernel, QedeqFileDao loader) {
        this.config = config;
        this.kernel = kernel;
        this.qedeqFileDao = loader;
        this.arbiter = new ModuleArbiter();
        this.pluginManager = new PluginManager(this);
        this.processManager = new ServiceProcessManager(this.pluginManager, this.arbiter);
        this.contextChecker = new DefaultContextChecker();
        loader.setServices(this);
        this.pluginManager.addPlugin("org.qedeq.kernel.bo.service.unicode.Qedeq2UnicodeTextPlugin");
        this.pluginManager.addPlugin("org.qedeq.kernel.bo.service.latex.Qedeq2LatexPlugin");
        this.pluginManager.addPlugin("org.qedeq.kernel.bo.service.unicode.Qedeq2Utf8Plugin");
        this.pluginManager.addPlugin("org.qedeq.kernel.bo.service.heuristic.DynamicHeuristicCheckerPlugin");
        this.pluginManager.addPlugin(SimpleProofFinderPlugin.class.getName());
        this.pluginManager.addPlugin(LoadDirectlyRequiredModulesPlugin.class.getName());
        this.pluginManager.addPlugin(LoadAllRequiredModulesPlugin.class.getName());
        this.pluginManager.addPlugin(LoadRequiredModulesPlugin.class.getName());
        this.pluginManager.addPlugin(WellFormedCheckerPlugin.class.getName());
        this.pluginManager.addPlugin(FormalProofCheckerPlugin.class.getName());
    }

    public void startupServices() {
        this.modules = new KernelQedeqBoStorage();
        if (this.config.isAutoReloadLastSessionChecked()) {
            this.autoReloadLastSessionChecked();
        }
    }

    public void shutdownServices() {
        this.processManager.terminateAndRemoveAllServiceProcesses();
        this.modules.removeAllModules();
        this.modules = null;
        Thread.interrupted();
    }

    public void autoReloadLastSessionChecked() {
        if (this.config.isAutoReloadLastSessionChecked()) {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    String method = "autoReloadLastSessionChecked.thread.run()";
                    try {
                        Trace.begin(CLASS, this, "autoReloadLastSessionChecked.thread.run()");
                        QedeqLog.getInstance().logMessage("Trying to load previously successfully loaded modules.");
                        int number = DefaultInternalKernelServices.this.config.getPreviouslyLoadedModules().length;
                        if (DefaultInternalKernelServices.this.loadPreviouslySuccessfullyLoadedModules()) {
                            QedeqLog.getInstance().logMessage("Loading of " + number + " previously successfully loaded module" + (number != 1 ? "s" : "") + " successfully done.");
                        } else {
                            QedeqLog.getInstance().logMessage("Loading of all previously successfully checked modules failed. " + number + " module" + (number != 1 ? "s" : "") + " were tried.");
                        }
                    }
                    catch (Exception e) {
                        Trace.trace(CLASS, (Object)this, "autoReloadLastSessionChecked.thread.run()", (Throwable)e);
                    }
                    finally {
                        Trace.end(CLASS, this, "autoReloadLastSessionChecked.thread.run()");
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllModules() {
        while (true) {
            Object object = this;
            synchronized (object) {
                if (this.processCounter == 0) {
                    this.getModules().removeAllModules();
                    return;
                }
            }
            object = MONITOR;
            synchronized (object) {
                try {
                    MONITOR.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void removeModule(ModuleAddress address) {
        QedeqBo prop = this.getQedeqBo(address);
        if (prop != null) {
            QedeqLog.getInstance().logRequest("Removing module", address.getUrl());
            try {
                this.removeModule(this.getModules().getKernelQedeqBo(this, address));
            }
            catch (RuntimeException e) {
                QedeqLog.getInstance().logFailureReply("Remove failed", address.getUrl(), e.getMessage());
            }
            if (this.validate) {
                this.modules.validateDependencies();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeModule(DefaultKernelQedeqBo prop) {
        while (true) {
            Object object = this;
            synchronized (object) {
                if (this.processCounter == 0) {
                    prop.delete();
                    this.getModules().removeModule(prop);
                    return;
                }
            }
            object = MONITOR;
            synchronized (object) {
                try {
                    MONITOR.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean clearLocalBuffer() {
        String method = "clearLocalBuffer";
        try {
            QedeqLog.getInstance().logMessage("Clear local buffer from all QEDEQ files.");
            this.removeAllModules();
            File bufferDir = this.getBufferDirectory().getCanonicalFile();
            if (bufferDir.exists() && !IoUtility.deleteDir(bufferDir, new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".xml");
                }
            })) {
                throw new IOException("buffer could not be deleted: " + bufferDir);
            }
            QedeqLog.getInstance().logMessage("Local buffer was cleared.");
            return true;
        }
        catch (IOException e) {
            Trace.fatal(CLASS, this, "clearLocalBuffer", "IO access problem", e);
            QedeqLog.getInstance().logMessage("Local buffer not cleared. IO access problem. " + e.getMessage());
            return false;
        }
        catch (RuntimeException e) {
            Trace.fatal(CLASS, this, "clearLocalBuffer", "unexpected problem", e);
            QedeqLog.getInstance().logMessage("Local buffer not cleared. " + e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QedeqBo loadModule(ModuleAddress address) {
        String method = "loadModule(ModuleAddress)";
        this.processInc();
        DefaultKernelQedeqBo prop = this.getModules().getKernelQedeqBo(this, address);
        try {
            DefaultKernelQedeqBo defaultKernelQedeqBo = prop;
            synchronized (defaultKernelQedeqBo) {
                block16: {
                    if (!prop.isLoaded()) break block16;
                    DefaultKernelQedeqBo defaultKernelQedeqBo2 = prop;
                    return defaultKernelQedeqBo2;
                }
                QedeqLog.getInstance().logRequest("Load module", address.getUrl());
                if (prop.getModuleAddress().isFileAddress()) {
                    this.loadLocalModule(prop);
                } else {
                    try {
                        this.getCanonicalReadableFile(prop);
                    }
                    catch (ModuleFileNotFoundException e) {
                        this.saveQedeqFromWebToBuffer(prop);
                    }
                    this.loadBufferedModule(prop);
                }
                QedeqLog.getInstance().logSuccessfulReply("Successfully loaded", address.getUrl());
            }
        }
        catch (SourceFileExceptionList e) {
            Trace.trace(CLASS, (Object)this, "loadModule(ModuleAddress)", (Throwable)e);
            QedeqLog.getInstance().logFailureState("Loading of module failed!", address.getUrl(), e.toString());
        }
        catch (RuntimeException e) {
            Trace.fatal(CLASS, this, "loadModule(ModuleAddress)", "unexpected problem", e);
            QedeqLog.getInstance().logFailureReply("Loading failed", address.getUrl(), e.getMessage());
        }
        finally {
            this.processDec();
        }
        return prop;
    }

    private void loadBufferedModule(DefaultKernelQedeqBo prop) throws SourceFileExceptionList {
        Qedeq qedeq;
        File localFile;
        prop.setLoadingProgressState(this, LoadingState.STATE_LOADING_FROM_BUFFER);
        try {
            localFile = this.getCanonicalReadableFile(prop);
        }
        catch (ModuleFileNotFoundException e) {
            SourceFileExceptionList sfl = this.createSourceFileExceptionList(90700, "Loading module from file buffer failed.", prop.getUrl(), e);
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_FROM_BUFFER_FAILED, sfl);
            throw sfl;
        }
        prop.setQedeqFileDao(this.getQedeqFileDao());
        try {
            qedeq = this.getQedeqFileDao().loadQedeq(new ServiceProcessImpl("loadBufferedModule"), prop, localFile);
        }
        catch (SourceFileExceptionList sfl) {
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_FROM_BUFFER_FAILED, sfl);
            throw sfl;
        }
        this.setCopiedQedeq(prop, qedeq);
    }

    private void loadLocalModule(DefaultKernelQedeqBo prop) throws SourceFileExceptionList {
        Qedeq qedeq;
        File localFile;
        prop.setLoadingProgressState(this, LoadingState.STATE_LOADING_FROM_LOCAL_FILE);
        try {
            localFile = this.getCanonicalReadableFile(prop);
        }
        catch (ModuleFileNotFoundException e) {
            SourceFileExceptionList sfl = this.createSourceFileExceptionList(90710, "Loading module from local file failed.", prop.getUrl(), e);
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_FROM_LOCAL_FILE_FAILED, sfl);
            throw sfl;
        }
        prop.setQedeqFileDao(this.getQedeqFileDao());
        try {
            qedeq = this.getQedeqFileDao().loadQedeq(new ServiceProcessImpl("loadLocalModule"), prop, localFile);
        }
        catch (SourceFileExceptionList sfl) {
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_FROM_LOCAL_FILE_FAILED, sfl);
            throw sfl;
        }
        this.setCopiedQedeq(prop, qedeq);
    }

    private void setCopiedQedeq(DefaultKernelQedeqBo prop, Qedeq qedeq) throws SourceFileExceptionList {
        String method = "setCopiedQedeq(DefaultKernelQedeqBo, Qedeq)";
        prop.setLoadingProgressState(this, LoadingState.STATE_LOADING_INTO_MEMORY);
        QedeqVo vo = null;
        try {
            vo = QedeqVoBuilder.createQedeq(prop.getModuleAddress(), qedeq);
        }
        catch (RuntimeException e) {
            Trace.fatal(CLASS, this, "setCopiedQedeq(DefaultKernelQedeqBo, Qedeq)", "looks like a programming error", e);
            SourceFileExceptionList xl = this.createSourceFileExceptionList(90100, "Programming error occured.", prop.getModuleAddress().getUrl(), e);
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_INTO_MEMORY_FAILED, xl);
            throw xl;
        }
        catch (ModuleDataException e) {
            if (e.getCause() != null) {
                Trace.fatal(CLASS, this, "setCopiedQedeq(DefaultKernelQedeqBo, Qedeq)", "looks like a programming error", e.getCause());
            } else {
                Trace.fatal(CLASS, this, "setCopiedQedeq(DefaultKernelQedeqBo, Qedeq)", "looks like a programming error", e);
            }
            SourceFileExceptionList xl = prop.createSourceFileExceptionList(this, e, qedeq);
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_INTO_MEMORY_FAILED, xl);
            throw xl;
        }
        prop.setQedeqVo(vo);
        ModuleLabelsCreator moduleNodesCreator = new ModuleLabelsCreator(this, prop);
        try {
            moduleNodesCreator.createLabels(new ServiceProcessImpl("copyQedeq"));
            prop.setLoaded(vo, moduleNodesCreator.getLabels(), moduleNodesCreator.getConverter(), moduleNodesCreator.getTextConverter());
        }
        catch (SourceFileExceptionList sfl) {
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_INTO_MEMORY_FAILED, sfl);
            throw sfl;
        }
    }

    private File getCanonicalReadableFile(QedeqBo prop) throws ModuleFileNotFoundException {
        File file;
        String method = "getCanonicalReadableFile(File)";
        File localFile = this.getLocalFilePath(prop.getModuleAddress());
        try {
            file = localFile.getCanonicalFile();
        }
        catch (IOException e) {
            Trace.trace(CLASS, (Object)this, "getCanonicalReadableFile(File)", (Throwable)e);
            throw new ModuleFileNotFoundException("file path not correct: " + localFile);
        }
        if (!file.canRead()) {
            Trace.trace(CLASS, (Object)this, "getCanonicalReadableFile(File)", "file not readable=" + file);
            throw new ModuleFileNotFoundException("file not readable: " + file);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public KernelQedeqBo loadModule(ModuleAddress parent, Specification spec) throws SourceFileExceptionList {
        String method = "loadModule(Module, Specification)";
        Trace.begin(CLASS, this, "loadModule(Module, Specification)");
        Trace.trace(CLASS, (Object)this, "loadModule(Module, Specification)", spec);
        this.processInc();
        DefaultKernelQedeqBo prop = null;
        try {
            ModuleAddress[] modulePaths;
            try {
                modulePaths = parent.getModulePaths(spec);
            }
            catch (IOException e) {
                Trace.fatal(CLASS, this, "loadModule(Module, Specification)", "getting module path failed", e);
                throw this.createSourceFileExceptionList(90700, "Loading module from file buffer failed.", parent.getUrl(), e);
            }
            for (int i = 0; i < modulePaths.length; ++i) {
                DefaultKernelQedeqBo e222;
                DefaultKernelQedeqBo defaultKernelQedeqBo;
                prop = this.getModules().getKernelQedeqBo(this, modulePaths[i]);
                Trace.trace(CLASS, (Object)this, "loadModule(Module, Specification)", "synchronizing at prop=" + prop);
                if (prop.isLoaded()) {
                    defaultKernelQedeqBo = prop;
                    return defaultKernelQedeqBo;
                }
                defaultKernelQedeqBo = prop;
                // MONITORENTER : defaultKernelQedeqBo
                if (prop.isLoaded()) {
                    DefaultKernelQedeqBo defaultKernelQedeqBo2 = prop;
                    // MONITOREXIT : defaultKernelQedeqBo
                    return defaultKernelQedeqBo2;
                }
                try {
                    if (prop.getModuleAddress().isFileAddress()) {
                        this.loadLocalModule(prop);
                    } else {
                        try {
                            this.getCanonicalReadableFile(prop);
                        }
                        catch (ModuleFileNotFoundException e222) {
                            this.saveQedeqFromWebToBuffer(prop);
                        }
                        this.loadBufferedModule(prop);
                    }
                    e222 = prop;
                    // MONITOREXIT : defaultKernelQedeqBo
                }
                catch (SourceFileExceptionList e3) {
                    Trace.trace(CLASS, (Object)this, "loadModule(Module, Specification)", (Throwable)e3);
                    if (i + 1 >= modulePaths.length) throw e3;
                    QedeqLog.getInstance().logMessage("trying alternate path");
                    // MONITOREXIT : defaultKernelQedeqBo
                    continue;
                }
                this.processDec();
                Trace.end(CLASS, this, "loadModule(Module, Specification)");
                return e222;
            }
            DefaultKernelQedeqBo defaultKernelQedeqBo = prop;
            return defaultKernelQedeqBo;
        }
        catch (RuntimeException e) {
            Trace.fatal(CLASS, this, "loadModule(Module, Specification)", "unexpected problem", e);
            QedeqLog.getInstance().logFailureReply("Loading failed", prop != null ? prop.getUrl() : "unknownURL", e.getMessage());
            throw e;
        }
        finally {
            this.processDec();
            Trace.end(CLASS, this, "loadModule(Module, Specification)");
        }
    }

    public ModuleAddress[] getAllLoadedModules() {
        return this.getModules().getAllLoadedModules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadPreviouslySuccessfullyLoadedModules() {
        this.processInc();
        try {
            String[] list = this.config.getPreviouslyLoadedModules();
            boolean errors = false;
            for (int i = 0; i < list.length; ++i) {
                try {
                    ModuleAddress address = this.getModuleAddress(list[i]);
                    QedeqBo prop = this.loadModule(address);
                    if (!prop.hasErrors()) continue;
                    errors = true;
                    continue;
                }
                catch (IOException e) {
                    Trace.fatal(CLASS, this, "loadPreviouslySuccessfullyLoadedModules", "internal error: saved URLs are malformed", e);
                    errors = true;
                }
            }
            boolean bl = !errors;
            return bl;
        }
        finally {
            this.processDec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadAllModulesFromQedeq() {
        this.processInc();
        try {
            String prefix = "http://www.qedeq.org/" + this.kernel.getKernelVersionDirectory() + "/";
            String[] list = new String[]{prefix + "doc/math/qedeq_logic_v1.xml", prefix + "doc/math/qedeq_formal_logic_v1.xml", prefix + "doc/math/qedeq_set_theory_v1.xml", prefix + "doc/project/qedeq_basic_concept.xml", prefix + "doc/project/qedeq_logic_language.xml", prefix + "sample/qedeq_sample1.xml", prefix + "sample/qedeq_sample2.xml", prefix + "sample/qedeq_sample3.xml", prefix + "sample/qedeq_sample4.xml", prefix + "sample/qedeq_error_sample_00.xml", prefix + "sample/qedeq_error_sample_01.xml", prefix + "sample/qedeq_error_sample_02.xml", prefix + "sample/qedeq_error_sample_03.xml", prefix + "sample/qedeq_error_sample_04.xml", prefix + "sample/qedeq_error_sample_05.xml", prefix + "sample/qedeq_error_sample_12.xml", prefix + "sample/qedeq_error_sample_13.xml", prefix + "sample/qedeq_error_sample_14.xml", prefix + "sample/qedeq_error_sample_15.xml", prefix + "sample/qedeq_error_sample_16.xml", prefix + "sample/qedeq_error_sample_17.xml", prefix + "sample/qedeq_error_sample_18.xml"};
            boolean errors = false;
            for (int i = 0; i < list.length; ++i) {
                try {
                    ModuleAddress address = this.getModuleAddress(list[i]);
                    QedeqBo prop = this.loadModule(address);
                    if (!prop.hasErrors()) continue;
                    errors = true;
                    continue;
                }
                catch (IOException e) {
                    Trace.fatal(CLASS, this, "loadPreviouslySuccessfullyLoadedModules", "internal error: saved URLs are malformed", e);
                    errors = true;
                }
            }
            boolean bl = !errors;
            return bl;
        }
        finally {
            this.processDec();
        }
    }

    private void saveQedeqFromWebToBuffer(final DefaultKernelQedeqBo prop) throws SourceFileExceptionList {
        String method = "saveQedeqFromWebToBuffer(DefaultKernelQedeqBo)";
        Trace.begin(CLASS, this, "saveQedeqFromWebToBuffer(DefaultKernelQedeqBo)");
        if (prop.getModuleAddress().isFileAddress()) {
            Trace.fatal(CLASS, this, "saveQedeqFromWebToBuffer(DefaultKernelQedeqBo)", "tried to make a local copy for a local module", null);
            Trace.end(CLASS, this, "saveQedeqFromWebToBuffer(DefaultKernelQedeqBo)");
            return;
        }
        prop.setLoadingProgressState(this, LoadingState.STATE_LOADING_FROM_WEB);
        File f = this.getLocalFilePath(prop.getModuleAddress());
        try {
            UrlUtility.saveUrlToFile(prop.getUrl(), f, this.config.getHttpProxyHost(), this.config.getHttpProxyPort(), this.config.getHttpNonProxyHosts(), this.config.getConnectionTimeout(), this.config.getReadTimeout(), new LoadingListener(){

                public void loadingCompletenessChanged(double completeness) {
                    prop.setLoadingCompleteness((int)completeness * 100);
                }
            });
        }
        catch (IOException e) {
            Trace.trace(CLASS, (Object)this, "saveQedeqFromWebToBuffer(DefaultKernelQedeqBo)", (Throwable)e);
            try {
                f.delete();
            }
            catch (Exception ex) {
                Trace.trace(CLASS, (Object)this, "saveQedeqFromWebToBuffer(DefaultKernelQedeqBo)", (Throwable)ex);
            }
            SourceFileExceptionList sfl = this.createSourceFileExceptionList(90720, "Loading module from web failed.", prop.getUrl(), e);
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_FROM_WEB_FAILED, sfl);
            Trace.trace(CLASS, (Object)this, "saveQedeqFromWebToBuffer(DefaultKernelQedeqBo)", "Couldn't access " + prop.getUrl());
            throw sfl;
        }
        finally {
            Trace.end(CLASS, this, "saveQedeqFromWebToBuffer(DefaultKernelQedeqBo)");
        }
    }

    public final File getLocalFilePath(ModuleAddress address) {
        StringBuffer adr;
        URL url;
        String method = "getLocalFilePath(ModuleAddress)";
        try {
            url = new URL(address.getUrl());
        }
        catch (MalformedURLException e) {
            Trace.fatal(CLASS, this, "getLocalFilePath(ModuleAddress)", "Could not get local file path.", e);
            return null;
        }
        Trace.param(CLASS, (Object)this, "getLocalFilePath(ModuleAddress)", "protocol", url.getProtocol());
        Trace.param(CLASS, (Object)this, "getLocalFilePath(ModuleAddress)", "host", url.getHost());
        Trace.param(CLASS, (Object)this, "getLocalFilePath(ModuleAddress)", "port", url.getPort());
        Trace.param(CLASS, (Object)this, "getLocalFilePath(ModuleAddress)", "path", url.getPath());
        Trace.param(CLASS, (Object)this, "getLocalFilePath(ModuleAddress)", "file", url.getFile());
        if (address.isFileAddress()) {
            try {
                return UrlUtility.transformURLPathToFilePath(url);
            }
            catch (IllegalArgumentException e) {
                Trace.fatal(CLASS, this, "getLocalFilePath(ModuleAddress)", "Loading failed of local file with URL=" + url, e);
                throw new RuntimeException(e);
            }
        }
        StringBuffer file = new StringBuffer(url.getFile());
        StringUtility.replace(file, "_", "_1");
        StringUtility.replace(file, "/", "_2");
        String encoded = file.toString();
        try {
            encoded = URLEncoder.encode(file.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Trace.trace(CLASS, "getLocalFilePath(ModuleAddress)", e);
        }
        file.setLength(0);
        file.append(encoded);
        StringUtility.replace(file, "#", "##");
        StringUtility.replace(file, "_2", "#");
        StringUtility.replace(file, "_1", "_");
        try {
            adr = new StringBuffer(new URL(url.getProtocol(), url.getHost(), url.getPort(), file.toString()).toExternalForm());
        }
        catch (MalformedURLException e) {
            Trace.fatal(CLASS, this, "getLocalFilePath(ModuleAddress)", "unexpected", e);
            throw new RuntimeException(e);
        }
        StringUtility.replace(adr, "://", "_");
        StringUtility.replace(adr, ":", "_");
        return new File(this.getBufferDirectory(), adr.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInc() {
        String string = this.processCounterSync;
        synchronized (string) {
            ++this.processCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDec() {
        String string = this.processCounterSync;
        synchronized (string) {
            --this.processCounter;
        }
    }

    public File getBufferDirectory() {
        return this.config.getBufferDirectory();
    }

    public File getGenerationDirectory() {
        return this.config.getGenerationDirectory();
    }

    public KernelQedeqBo getKernelQedeqBo(ModuleAddress address) {
        return this.getModules().getKernelQedeqBo(this, address);
    }

    public QedeqBo getQedeqBo(ModuleAddress address) {
        return this.getKernelQedeqBo(address);
    }

    public ModuleAddress getModuleAddress(URL url) throws IOException {
        return new DefaultModuleAddress(url);
    }

    public ModuleAddress getModuleAddress(String url) throws IOException {
        return new DefaultModuleAddress(url);
    }

    public ModuleAddress getModuleAddress(File file) throws IOException {
        return new DefaultModuleAddress(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSource(ModuleAddress address) throws IOException {
        KernelQedeqBo bo = this.getKernelQedeqBo(address);
        if (bo.getLoadingState().equals(LoadingState.STATE_UNDEFINED) || bo.getLoadingState().equals(LoadingState.STATE_LOADING_FROM_WEB) || bo.getLoadingState().equals(LoadingState.STATE_LOADING_FROM_WEB_FAILED)) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        Reader reader = this.getQedeqFileDao().getModuleReader(bo);
        try {
            IoUtility.loadReader(reader, buffer);
        }
        finally {
            IoUtility.close(reader);
        }
        return buffer.toString();
    }

    public boolean loadRequiredModules(ModuleAddress address) {
        KernelQedeqBo prop = (KernelQedeqBo)this.loadModule(address);
        if (prop.hasLoadedRequiredModules()) {
            return true;
        }
        this.loadModule(address);
        this.executePlugin(LoadRequiredModulesPlugin.class.getName(), prop, null, null);
        return prop.hasLoadedRequiredModules();
    }

    public boolean loadRequiredModules(KernelQedeqBo qedeq, InternalServiceProcess process) {
        if (qedeq.hasLoadedRequiredModules()) {
            return true;
        }
        this.executePlugin(LoadRequiredModulesPlugin.class.getName(), qedeq, null, process);
        return qedeq.hasLoadedRequiredModules();
    }

    public boolean checkWellFormedness(ModuleAddress address) {
        DefaultKernelQedeqBo prop = this.modules.getKernelQedeqBo(this, address);
        if (prop.isWellFormed()) {
            return true;
        }
        this.loadModule(address);
        this.executePlugin(WellFormedCheckerPlugin.class.getName(), prop, null, null);
        return prop.isWellFormed();
    }

    public boolean checkWellFormedness(KernelQedeqBo qedeq, InternalServiceProcess process) {
        if (qedeq.isWellFormed()) {
            return true;
        }
        this.executePlugin(WellFormedCheckerPlugin.class.getName(), qedeq, null, process);
        return qedeq.isWellFormed();
    }

    public boolean checkFormallyProved(ModuleAddress address) {
        DefaultKernelQedeqBo prop = this.modules.getKernelQedeqBo(this, address);
        if (prop.isFullyFormallyProved()) {
            return true;
        }
        this.loadModule(address);
        this.executePlugin(FormalProofCheckerPlugin.class.getName(), prop, null, null);
        return prop.isFullyFormallyProved();
    }

    public boolean checkFormallyProved(KernelQedeqBo qedeq, InternalServiceProcess process) {
        if (qedeq.isFullyFormallyProved()) {
            return true;
        }
        this.executePlugin(FormalProofCheckerPlugin.class.getName(), qedeq, null, process);
        return qedeq.isFullyFormallyProved();
    }

    public void addPlugin(String pluginClass) {
        this.pluginManager.addPlugin(pluginClass);
    }

    public Plugin[] getPlugins() {
        return this.pluginManager.getNonInternalPlugins();
    }

    public Object executePlugin(String id, ModuleAddress address, Object data) {
        this.loadModule(address);
        return this.processManager.executePlugin(id, this.getKernelQedeqBo(address), data, null);
    }

    public Object executePlugin(String id, KernelQedeqBo qedeq, Object data, InternalServiceProcess process) {
        return this.processManager.executePlugin(id, qedeq, data, process);
    }

    public void clearAllPluginResults(ModuleAddress address) {
        this.pluginManager.clearAllPluginResults(this.getKernelQedeqBo(address));
    }

    public ServiceProcess[] getServiceProcesses() {
        return this.processManager.getServiceProcesses();
    }

    public ServiceProcess[] getRunningServiceProcesses() {
        return this.processManager.getRunningServiceProcesses();
    }

    public void stopAllPluginExecutions() {
        this.processManager.terminateAllServiceProcesses();
    }

    private KernelQedeqBoStorage getModules() {
        return this.modules;
    }

    public SourceFileExceptionList createSourceFileExceptionList(int code, String message, String address, IOException e) {
        return new SourceFileExceptionList(new SourceFileException(this, code, message, e, new SourceArea(address), null));
    }

    public SourceFileExceptionList createSourceFileExceptionList(int code, String message, String address, RuntimeException e) {
        return new SourceFileExceptionList(new SourceFileException(this, code, message, e, new SourceArea(address), null));
    }

    public SourceFileExceptionList createSourceFileExceptionList(int code, String message, String address, Exception e) {
        return new SourceFileExceptionList(new SourceFileException(this, code, message, e, new SourceArea(address), null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSourceFileExceptionList(ModuleAddress address) {
        ArrayList<String> list;
        block11: {
            list = new ArrayList<String>();
            KernelQedeqBo bo = this.getKernelQedeqBo(address);
            SourceFileExceptionList sfl = bo.getErrors();
            if (sfl.size() > 0) {
                StringBuffer buffer = new StringBuffer();
                Reader reader = null;
                try {
                    reader = this.getQedeqFileDao().getModuleReader(bo);
                    IoUtility.loadReader(reader, buffer);
                }
                catch (IOException e) {
                    IoUtility.close(reader);
                    for (int i = 0; i < sfl.size(); ++i) {
                        list.add(sfl.get(i).getDescription());
                    }
                    break block11;
                }
                TextInput input = new TextInput(buffer);
                try {
                    input.setPosition(0);
                    StringBuffer buf = new StringBuffer();
                    for (int i = 0; i < sfl.size(); ++i) {
                        buf.setLength(0);
                        SourceFileException sf = sfl.get(i);
                        buf.append(sf.getDescription());
                        try {
                            if (sf.getSourceArea() != null && sf.getSourceArea().getStartPosition() != null) {
                                buf.append("\n");
                                input.setRow(sf.getSourceArea().getStartPosition().getRow());
                                buf.append(StringUtility.replace(input.getLine(), "\t", " "));
                                buf.append("\n");
                                StringBuffer whitespace = StringUtility.getSpaces(sf.getSourceArea().getStartPosition().getColumn() - 1);
                                buffer.append(whitespace);
                                buffer.append("^");
                            }
                        }
                        catch (Exception e) {
                            Trace.trace(CLASS, (Object)this, "getSourceFileExceptionList(ModuleAddress)", (Throwable)e);
                        }
                        list.add(buf.toString());
                    }
                }
                finally {
                    IoUtility.close(input);
                }
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public String getPluginId() {
        return CLASS.getName();
    }

    public String getPluginActionName() {
        return "Basis";
    }

    public QedeqFileDao getQedeqFileDao() {
        return this.qedeqFileDao;
    }

    public String getPluginDescription() {
        return "provides basic services for loading QEDEQ modules";
    }

    public QedeqConfig getConfig() {
        return this.config;
    }

    public String getKernelVersionDirectory() {
        return this.kernel.getKernelVersionDirectory();
    }

    public String getBuildId() {
        return this.kernel.getBuildId();
    }

    public String getDedication() {
        return this.kernel.getDedication();
    }

    public String getDescriptiveKernelVersion() {
        return this.kernel.getDescriptiveKernelVersion();
    }

    public String getKernelCodeName() {
        return this.kernel.getKernelCodeName();
    }

    public String getKernelVersion() {
        return this.kernel.getKernelVersion();
    }

    public String getMaximalRuleVersion() {
        return this.kernel.getMaximalRuleVersion();
    }

    public boolean isRuleVersionSupported(String ruleVersion) {
        return this.kernel.isRuleVersionSupported(ruleVersion);
    }

    public boolean isSetConnectionTimeOutSupported() {
        return this.kernel.isSetConnectionTimeOutSupported();
    }

    public boolean isSetReadTimeoutSupported() {
        return this.kernel.isSetReadTimeoutSupported();
    }

    public ContextChecker getContextChecker() {
        return this.contextChecker;
    }

    public void setContextChecker(ContextChecker contextChecker) {
        this.contextChecker = contextChecker;
    }
}

