/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.parser;

public final class Operator {
    public static final int INFIX = 0;
    public static final int SIMPLE_PREFIX = 1;
    public static final int POSTFIX = 2;
    public static final int FUNCTION = 4;
    private final int type;
    private final String startSymbol;
    private final String separatorSymbol;
    private final String endSymbol;
    private final int priority;
    private final String qedeq;
    private final String qedeqArgument;
    private final int min;
    private final int max;

    public Operator(String symbol, String qedeq, String qedeqArgument, int priority, int type, int min) {
        this(symbol, qedeq, qedeqArgument, priority, type, min, -1);
    }

    public Operator(String symbol, String qedeq, String qedeqArgument, int priority, int type, int min, int max) {
        this(symbol, null, null, qedeq, qedeqArgument, priority, type, min, max);
    }

    public Operator(String startSymbol, String separatorSymbol, String endSymbol, String qedeq, String qedeqArgument, int priority, int min) {
        this(startSymbol, separatorSymbol, endSymbol, qedeq, qedeqArgument, priority, 1, min, -1);
    }

    public Operator(String startSymbol, String separatorSymbol, String endSymbol, String qedeq, String qedeqArgument, int priority, int min, int max) {
        this(startSymbol, separatorSymbol, endSymbol, qedeq, qedeqArgument, priority, 1, min, max);
    }

    public Operator(String startSymbol, String separatorSymbol, String endSymbol, String qedeq, String qedeqArgument, int priority, int type, int min, int max) {
        this.startSymbol = startSymbol;
        this.separatorSymbol = separatorSymbol;
        this.endSymbol = endSymbol;
        this.type = type;
        this.qedeq = qedeq;
        this.qedeqArgument = qedeqArgument;
        this.priority = priority;
        this.min = min;
        this.max = max;
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown operator type: " + type);
            }
        }
        if (max != -1 && min > max) {
            throw new IllegalArgumentException("Min greater than max: " + min + " > " + max);
        }
        if (this.isInfix() && min < 2) {
            throw new IllegalArgumentException("Infix needs at least two arguments");
        }
    }

    public final String getStartSymbol() {
        return this.startSymbol;
    }

    public String getSeparatorSymbol() {
        return this.separatorSymbol;
    }

    public String getEndSymbol() {
        return this.endSymbol;
    }

    public final boolean isInfix() {
        return this.type == 0;
    }

    public final boolean isPrefix() {
        return this.type == 1 || this.type == 4;
    }

    public final boolean isFunction() {
        return this.type == 4;
    }

    public final boolean isPostfix() {
        return this.type == 2;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final int getMin() {
        return this.min;
    }

    public final int getMax() {
        return this.max;
    }

    public final String getQedeq() {
        return this.qedeq;
    }

    public final String getQedeqArgument() {
        return this.qedeqArgument;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer(this.getStartSymbol());
        buffer.append("[" + this.getMin() + ", ");
        if (this.getMax() == -1) {
            buffer.append("..");
        } else {
            buffer.append(this.getMax());
        }
        buffer.append("]");
        if (this.getSeparatorSymbol() != null) {
            buffer.append(" ").append(this.getSeparatorSymbol());
        }
        if (this.getEndSymbol() != null) {
            buffer.append(" ").append(this.getEndSymbol());
        }
        if (this.isFunction()) {
            buffer.append(", is function");
        }
        if (this.isPrefix()) {
            buffer.append(", is prefix");
        }
        if (this.isInfix()) {
            buffer.append(", is infix");
        }
        if (this.isPostfix()) {
            buffer.append(", is postfix");
        }
        return buffer.toString();
    }
}

