/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.module;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.qedeq.kernel.bo.common.QedeqBo;
import org.qedeq.kernel.bo.common.QedeqBoSet;
import org.qedeq.kernel.bo.module.KernelQedeqBo;

public class KernelQedeqBoSet
implements QedeqBoSet {
    private final Set elements;

    public KernelQedeqBoSet() {
        this.elements = new HashSet();
    }

    public KernelQedeqBoSet(KernelQedeqBo[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException("NullPointer as element array is not allowed");
        }
        this.elements = new HashSet<KernelQedeqBo>(Arrays.asList(elements));
    }

    public KernelQedeqBoSet(KernelQedeqBo element) {
        if (element == null) {
            throw new IllegalArgumentException("NullPointer as element array is not allowed");
        }
        this.elements = new HashSet();
        this.elements.add(element);
    }

    public KernelQedeqBoSet(KernelQedeqBoSet set) {
        if (set == null) {
            throw new IllegalArgumentException("NullPointer as set is not allowed");
        }
        this.elements = new HashSet(set.elements);
    }

    public final boolean contains(KernelQedeqBo element) {
        if (element == null) {
            throw new IllegalArgumentException("NullPointer as element is not allowed");
        }
        return this.elements.contains(element);
    }

    public boolean contains(QedeqBo element) {
        if (element == null) {
            throw new IllegalArgumentException("NullPointer as element is not allowed");
        }
        return this.elements.contains(element);
    }

    public final boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public final KernelQedeqBoSet add(KernelQedeqBo element) {
        if (element == null) {
            throw new IllegalArgumentException("NullPointer as element is not allowed");
        }
        this.elements.add(element);
        return this;
    }

    public final KernelQedeqBoSet add(KernelQedeqBoSet set) {
        if (set == null) {
            throw new IllegalArgumentException("NullPointer as set is not allowed");
        }
        this.elements.addAll(set.elements);
        return this;
    }

    public final KernelQedeqBoSet remove(KernelQedeqBo element) {
        if (element == null) {
            throw new IllegalArgumentException("NullPointer as element is not allowed");
        }
        this.elements.remove(element);
        return this;
    }

    public final KernelQedeqBoSet remove(KernelQedeqBoSet set) {
        if (set == null) {
            throw new IllegalArgumentException("NullPointer as set is not allowed");
        }
        this.elements.removeAll(set.elements);
        return this;
    }

    public final KernelQedeqBoSet intersection(KernelQedeqBoSet set) {
        if (set == null) {
            throw new IllegalArgumentException("NullPointer as set is not allowed");
        }
        this.elements.retainAll(set.elements);
        return this;
    }

    public final int size() {
        return this.elements.size();
    }

    public Iterator iterator() {
        return this.elements.iterator();
    }

    public final boolean equals(Object obj) {
        if (obj instanceof KernelQedeqBoSet) {
            return ((Object)this.elements).equals(((KernelQedeqBoSet)obj).elements);
        }
        return false;
    }

    public final int hashCode() {
        return ((Object)this.elements).hashCode();
    }

    public final String toString() {
        StringBuffer result = new StringBuffer();
        result.append("{");
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            result.append(iterator.next());
            if (!iterator.hasNext()) continue;
            result.append(", ");
        }
        result.append("}");
        return result.toString();
    }
}

