/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.module;

import org.qedeq.kernel.bo.common.NodeBo;
import org.qedeq.kernel.bo.common.QedeqBo;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.se.base.list.Element;
import org.qedeq.kernel.se.base.module.ConditionalProof;
import org.qedeq.kernel.se.base.module.FormalProofLineList;
import org.qedeq.kernel.se.base.module.FormalProofList;
import org.qedeq.kernel.se.base.module.NodeType;
import org.qedeq.kernel.se.base.module.Proposition;
import org.qedeq.kernel.se.base.module.Reason;
import org.qedeq.kernel.se.common.CheckLevel;
import org.qedeq.kernel.se.common.ModuleContext;
import org.qedeq.kernel.se.dto.module.NodeVo;
import org.qedeq.kernel.se.visitor.QedeqNumbers;

public class KernelNodeBo
implements NodeBo,
CheckLevel {
    private final NodeVo node;
    private final ModuleContext context;
    private final KernelQedeqBo qedeq;
    private final QedeqNumbers data;
    private int wellFormedCheck;
    private int provedCheck;

    public KernelNodeBo(NodeVo node, ModuleContext context, KernelQedeqBo qedeq, QedeqNumbers data) {
        this.node = node;
        this.context = new ModuleContext(context);
        this.qedeq = qedeq;
        this.data = new QedeqNumbers(data);
    }

    public NodeVo getNodeVo() {
        return this.node;
    }

    public ModuleContext getModuleContext() {
        return this.context;
    }

    public QedeqBo getParentQedeqBo() {
        return this.qedeq;
    }

    public KernelQedeqBo getQedeqBo() {
        return this.qedeq;
    }

    public QedeqNumbers getNumbers() {
        return this.data;
    }

    public boolean isProofLineLabel(String label) {
        if (label == null || label.length() == 0) {
            return false;
        }
        Proposition theorem = this.getNodeVo().getNodeType().getProposition();
        if (theorem == null) {
            return false;
        }
        FormalProofList proofs = theorem.getFormalProofList();
        if (proofs == null) {
            return false;
        }
        for (int i = 0; i < proofs.size(); ++i) {
            FormalProofLineList list = proofs.get(i).getFormalProofLineList();
            if (!this.hasProofLineLabel(label, list)) continue;
            return true;
        }
        return false;
    }

    private boolean hasProofLineLabel(String label, FormalProofLineList list) {
        if (list == null) {
            return false;
        }
        for (int j = 0; j < list.size(); ++j) {
            if (label.equals(list.get(j).getLabel())) {
                return true;
            }
            Reason reason = list.get(j).getReason();
            if (!(reason instanceof ConditionalProof)) continue;
            ConditionalProof conditionalProof = (ConditionalProof)reason;
            if (conditionalProof.getHypothesis() != null && label.equals(conditionalProof.getHypothesis().getLabel())) {
                return true;
            }
            FormalProofLineList list2 = conditionalProof.getFormalProofLineList();
            if (!this.hasProofLineLabel(label, list2)) continue;
            return true;
        }
        return false;
    }

    public void setWellFormed(int wellFormedCheck) {
        this.wellFormedCheck = wellFormedCheck;
    }

    public boolean isWellFormed() {
        return this.wellFormedCheck >= 20;
    }

    public boolean isNotWellFormed() {
        return this.wellFormedCheck < 20 && this.wellFormedCheck > 0;
    }

    public void setProved(int provedCheck) {
        this.provedCheck = provedCheck;
    }

    public boolean isProved() {
        return this.provedCheck >= 20;
    }

    public boolean isNotProved() {
        return this.provedCheck < 20 && this.provedCheck > 0;
    }

    public boolean hasFormula() {
        return null != this.getFormula();
    }

    public Element getFormula() {
        if (this.getNodeVo() == null || this.getNodeVo().getNodeType() == null) {
            return null;
        }
        NodeType nodeType = this.getNodeVo().getNodeType();
        if (nodeType.getProposition() != null) {
            if (nodeType.getProposition().getFormula() != null) {
                return nodeType.getProposition().getFormula().getElement();
            }
            return null;
        }
        if (nodeType.getPredicateDefinition() != null) {
            if (nodeType.getPredicateDefinition().getFormula() != null) {
                return nodeType.getPredicateDefinition().getFormula().getElement();
            }
            return null;
        }
        if (nodeType.getFunctionDefinition() != null) {
            if (nodeType.getFunctionDefinition().getFormula() != null) {
                return nodeType.getFunctionDefinition().getFormula().getElement();
            }
            return null;
        }
        if (nodeType.getAxiom() != null) {
            if (nodeType.getAxiom().getFormula() != null) {
                return nodeType.getAxiom().getFormula().getElement();
            }
            return null;
        }
        return null;
    }
}

