/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.logic.proof.finder;

import java.util.ArrayList;
import java.util.List;
import org.qedeq.kernel.bo.common.Element2Utf8;
import org.qedeq.kernel.bo.log.ModuleLogListener;
import org.qedeq.kernel.bo.logic.proof.finder.ModusPonensBo;
import org.qedeq.kernel.bo.logic.proof.finder.SubstPredBo;
import org.qedeq.kernel.se.base.list.Element;
import org.qedeq.kernel.se.base.module.Add;
import org.qedeq.kernel.se.base.module.FormalProofLineList;
import org.qedeq.kernel.se.base.module.Reason;
import org.qedeq.kernel.se.base.module.SubstPred;
import org.qedeq.kernel.se.dto.module.AddVo;
import org.qedeq.kernel.se.dto.module.FormalProofLineListVo;
import org.qedeq.kernel.se.dto.module.FormalProofLineVo;
import org.qedeq.kernel.se.dto.module.FormulaVo;
import org.qedeq.kernel.se.dto.module.ModusPonensVo;
import org.qedeq.kernel.se.dto.module.SubstPredVo;

public final class ProofFinderUtility {
    private List new2Old;

    private ProofFinderUtility() {
    }

    public static FormalProofLineList shortenProof(List lines, List reasons, ModuleLogListener log, Element2Utf8 trans) {
        return new ProofFinderUtility().shorten(lines, reasons, log, trans);
    }

    private FormalProofLineList shorten(List lines, List reasons, ModuleLogListener log, Element2Utf8 trans) {
        int j;
        int j2;
        int n;
        boolean[] used = new boolean[lines.size()];
        used[n] = true;
        for (n = lines.size() - 1; n >= 0; --n) {
            if (!used[n]) continue;
            Reason r = (Reason)reasons.get(n);
            if (r instanceof ModusPonensBo) {
                ModusPonensBo mp = (ModusPonensBo)reasons.get(n);
                used[mp.getN1()] = true;
                used[mp.getN2()] = true;
                continue;
            }
            if (r instanceof SubstPredBo) {
                SubstPredBo substPred = (SubstPredBo)reasons.get(n);
                used[substPred.getN()] = true;
                continue;
            }
            if (r instanceof Add) continue;
            throw new IllegalStateException("unexpected reason class: " + r.getClass());
        }
        for (j2 = 0; j2 < lines.size(); ++j2) {
            if (!used[j2]) continue;
            log.logMessageState(ProofFinderUtility.getUtf8Line(lines, reasons, j2, trans));
        }
        this.new2Old = new ArrayList();
        for (j2 = 0; j2 < lines.size(); ++j2) {
            if (!used[j2]) continue;
            this.new2Old.add(new Integer(j2));
        }
        FormalProofLineListVo result = new FormalProofLineListVo();
        for (j = 0; j < this.new2Old.size(); ++j) {
            Reason newReason;
            n = (Integer)this.new2Old.get(j);
            Reason r = (Reason)reasons.get(n);
            if (r instanceof ModusPonensBo) {
                ModusPonensBo mp = (ModusPonensBo)reasons.get(n);
                newReason = new ModusPonensVo("" + (1 + this.old2new(mp.getN1())), "" + (1 + this.old2new(mp.getN2())));
            } else if (r instanceof SubstPredBo) {
                SubstPredBo substPred = (SubstPredBo)reasons.get(n);
                newReason = new SubstPredVo("" + (1 + this.old2new(substPred.getN())), substPred.getPredicateVariable(), substPred.getSubstituteFormula());
            } else if (r instanceof Add) {
                Add add = (Add)reasons.get(n);
                newReason = new AddVo(add.getReference());
            } else {
                throw new IllegalStateException("unexpected reason class: " + r.getClass());
            }
            result.add(new FormalProofLineVo("" + (1 + j), new FormulaVo((Element)lines.get(this.new2old(j))), newReason));
        }
        for (j = 0; j < result.size(); ++j) {
            log.logMessageState(result.get(j).getLabel() + ": " + trans.getUtf8(result.get(j).getFormula().getElement()) + "  " + result.get(j).getReason());
        }
        return result;
    }

    private int old2new(int old) {
        int result = this.new2Old.indexOf(new Integer(old));
        if (result < 0) {
            throw new IllegalArgumentException("not found: " + old);
        }
        return result;
    }

    private int new2old(int n) {
        int result = (Integer)this.new2Old.get(n);
        return result;
    }

    public static String getUtf8Line(List lines, List reasons, int i, Element2Utf8 trans) {
        if (i < 0) {
            return "beginning to prove";
        }
        StringBuffer result = new StringBuffer();
        result.append(i + 1 + ": ");
        Reason reason = (Reason)reasons.get(i);
        Element formula = (Element)lines.get(i);
        return ProofFinderUtility.getUtf8Line(formula, reason, i, trans);
    }

    public static String getUtf8Line(Element formula, Reason reason, int i, Element2Utf8 trans) {
        StringBuffer result = new StringBuffer();
        result.append(i + 1 + ": ");
        result.append(trans.getUtf8(formula));
        result.append("  : ");
        if (reason instanceof SubstPred) {
            SubstPred s = (SubstPred)reason;
            result.append("Subst " + s.getReference() + " ");
            result.append(trans.getUtf8(s.getPredicateVariable()));
            result.append(" by ");
            result.append(trans.getUtf8(s.getSubstituteFormula()));
        } else {
            result.append(reason);
        }
        return result.toString();
    }
}

