/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.logic.proof.finder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.qedeq.base.io.Parameters;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.kernel.bo.common.Element2Utf8;
import org.qedeq.kernel.bo.log.ModuleLogListener;
import org.qedeq.kernel.bo.logic.common.FormulaUtility;
import org.qedeq.kernel.bo.logic.proof.common.ProofException;
import org.qedeq.kernel.bo.logic.proof.common.ProofFinder;
import org.qedeq.kernel.bo.logic.proof.common.ProofFoundException;
import org.qedeq.kernel.bo.logic.proof.common.ProofNotFoundException;
import org.qedeq.kernel.bo.logic.proof.finder.ModusPonensBo;
import org.qedeq.kernel.bo.logic.proof.finder.ProofFinderUtility;
import org.qedeq.kernel.bo.logic.proof.finder.SubstPredBo;
import org.qedeq.kernel.se.base.list.Element;
import org.qedeq.kernel.se.base.list.ElementList;
import org.qedeq.kernel.se.base.module.Add;
import org.qedeq.kernel.se.base.module.FormalProofLineList;
import org.qedeq.kernel.se.base.module.Reason;
import org.qedeq.kernel.se.common.ModuleContext;
import org.qedeq.kernel.se.dto.list.DefaultElementList;
import org.qedeq.kernel.se.dto.list.ElementSet;
import org.qedeq.kernel.se.visitor.InterruptException;

public class ProofFinderImpl
implements ProofFinder {
    private List lines;
    private List reasons;
    private ElementSet allPredVars;
    private ElementSet partGoalFormulas;
    private int mpLast;
    private Element goalFormula;
    private int extraVars;
    private String skipFormulas;
    private int logFrequence;
    private SortedSet substitutionMethods;
    private int maxProofLines;
    private ModuleContext context;
    private ModuleLogListener log;
    private Element2Utf8 trans;

    public void findProof(Element formula, FormalProofLineList proof, ModuleContext context, Parameters parameters, ModuleLogListener log, Element2Utf8 trans) throws ProofException, InterruptException {
        this.goalFormula = formula;
        this.context = new ModuleContext(context);
        this.log = log;
        this.trans = trans;
        this.substitutionMethods = new TreeSet();
        this.extraVars = parameters.getInt("extraVars");
        this.maxProofLines = parameters.getInt("maximumProofLines");
        this.skipFormulas = parameters.getString("skipFormulas").trim();
        if (this.skipFormulas.length() > 0) {
            log.logMessageState("skipping the following formula numbers: " + this.skipFormulas);
            this.skipFormulas = "," + StringUtility.replace(this.skipFormulas, " ", "") + ",";
        }
        System.out.println("maximumProofLines = " + this.maxProofLines);
        int weight = 0;
        weight = parameters.getInt("propositionVariableWeight");
        if (weight > 0) {
            this.substitutionMethods.add(new SubstituteBase(weight, parameters.getInt("propositionVariableOrder")){

                public void substitute(int i) throws ProofException {
                    ProofFinderImpl.this.substituteByPropositionVariables(i);
                }
            });
        }
        if ((weight = parameters.getInt("partFormulaWeight")) > 0) {
            this.substitutionMethods.add(new SubstituteBase(weight, parameters.getInt("partFormulaOrder")){

                public void substitute(int i) throws ProofException {
                    ProofFinderImpl.this.substitutePartGoalFormulas(i);
                }
            });
        }
        if ((weight = parameters.getInt("disjunctionWeight")) > 0) {
            this.substitutionMethods.add(new SubstituteBase(weight, parameters.getInt("disjunctionOrder")){

                public void substitute(int i) throws ProofException {
                    ProofFinderImpl.this.substituteDisjunction(i);
                }
            });
        }
        if ((weight = parameters.getInt("implicationWeight")) > 0) {
            this.substitutionMethods.add(new SubstituteBase(weight, parameters.getInt("implicationOrder")){

                public void substitute(int i) throws ProofException {
                    ProofFinderImpl.this.substituteImplication(i);
                }
            });
        }
        if ((weight = parameters.getInt("negationWeight")) > 0) {
            this.substitutionMethods.add(new SubstituteBase(weight, parameters.getInt("negationOrder")){

                public void substitute(int i) throws ProofException {
                    ProofFinderImpl.this.substituteNegation(i);
                }
            });
        }
        if ((weight = parameters.getInt("conjunctionWeight")) > 0) {
            this.substitutionMethods.add(new SubstituteBase(weight, parameters.getInt("conjunctionOrder")){

                public void substitute(int i) throws ProofException {
                    ProofFinderImpl.this.substituteConjunction(i);
                }
            });
        }
        if ((weight = parameters.getInt("equivalenceWeight")) > 0) {
            this.substitutionMethods.add(new SubstituteBase(weight, parameters.getInt("equivalenceOrder")){

                public void substitute(int i) throws ProofException {
                    ProofFinderImpl.this.substituteEquivalence(i);
                }
            });
        }
        this.logFrequence = parameters.getInt("logFrequence");
        this.lines = new ArrayList();
        this.reasons = new ArrayList();
        this.setAllPredVars(proof);
        this.partGoalFormulas = FormulaUtility.getPartFormulas(this.goalFormula);
        log.logMessageState("our goal: " + trans.getUtf8(formula));
        int size2 = 0;
        while (true) {
            if (Thread.interrupted()) {
                throw new InterruptException(this.context);
            }
            int size1 = this.lines.size();
            this.tryModusPonensAll();
            Iterator iter = this.substitutionMethods.iterator();
            while (iter.hasNext()) {
                Substitute method = (Substitute)iter.next();
                for (int j = 0; j < method.getWeight() && method.nextLine() < this.lines.size(); ++j) {
                    method.substitute();
                    this.tryModusPonensAll();
                }
            }
            if (size2 == this.lines.size()) {
                log.logMessageState("Proof not found with current restrictions. During search we generated this number of proof lines: " + size2);
                throw new ProofNotFoundException(23791200, "Proof not found with current restrictions. During search we generated this number of proof lines: " + size2, context);
            }
            size2 = size1;
        }
    }

    private void setAllPredVars(FormalProofLineList proof) {
        this.log.logMessageState("using the following formulas:");
        this.allPredVars = new ElementSet();
        for (int i = 0; i < proof.size(); ++i) {
            Reason reason;
            if (this.skipFormulas.indexOf("," + (i + 1) + ",") >= 0 || !((reason = proof.get(i).getReason()) instanceof Add)) continue;
            Element formula = proof.get(i).getFormula().getElement();
            this.lines.add(formula);
            this.reasons.add(reason);
            this.log.logMessageState(ProofFinderUtility.getUtf8Line(formula, reason, i, this.trans));
            this.allPredVars.union(FormulaUtility.getPropositionVariables(formula));
        }
        String max = "A";
        Iterator iter = this.allPredVars.iterator();
        while (iter.hasNext()) {
            ElementList v = (ElementList)iter.next();
            String name = v.getElement(0).getAtom().getString();
            if (-1 != max.compareTo(name)) continue;
            max = name;
        }
        System.out.println("Adding extra variables:");
        for (int i = 1; i <= this.extraVars; ++i) {
            max = (char)(max.charAt(0) + i) + "";
            System.out.println("\t" + max);
            this.allPredVars.add(FormulaUtility.createPredicateVariable(max));
        }
    }

    private void tryModusPonensAll() throws ProofException {
        int until = this.lines.size();
        for (int i = 0; i < until; ++i) {
            int j;
            Element first = (Element)this.lines.get(i);
            if (!FormulaUtility.isImplication(first)) continue;
            int n = j = i < this.mpLast ? this.mpLast : 0;
            while (j < until) {
                if (((Object)first.getList().getElement(0)).equals(this.lines.get(j))) {
                    ModusPonensBo mp = new ModusPonensBo(i, j);
                    this.addFormula(first.getList().getElement(1), mp);
                }
                ++j;
            }
        }
        this.mpLast = until;
    }

    private void substituteByPropositionVariables(int i) throws ProofException {
        Element f = (Element)this.lines.get(i);
        ElementSet vars = FormulaUtility.getPropositionVariables(f);
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            ElementList var = (ElementList)iter.next();
            Iterator all = this.allPredVars.iterator();
            while (all.hasNext()) {
                ElementList subst = (ElementList)all.next();
                if (var.equals(subst)) continue;
                Element created = FormulaUtility.replaceOperatorVariable(f, var, subst);
                this.addFormula(created, new SubstPredBo(i, var, subst));
            }
        }
    }

    private void substitutePartGoalFormulas(int i) throws ProofException {
        Element f = (Element)this.lines.get(i);
        ElementSet vars = FormulaUtility.getPropositionVariables(f);
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            ElementList var = (ElementList)iter.next();
            Iterator all = this.partGoalFormulas.iterator();
            while (all.hasNext()) {
                ElementList subst = (ElementList)all.next();
                if (var.equals(subst)) continue;
                Element created = FormulaUtility.replaceOperatorVariable(f, var, subst);
                this.addFormula(created, new SubstPredBo(i, var, subst));
            }
        }
    }

    private void substituteNegation(int i) throws ProofException {
        Element f = (Element)this.lines.get(i);
        ElementSet vars = FormulaUtility.getPropositionVariables(f);
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            ElementList var = (ElementList)iter.next();
            Iterator all = this.allPredVars.iterator();
            while (all.hasNext()) {
                ElementList var2 = (ElementList)all.next();
                DefaultElementList subst = new DefaultElementList("NOT");
                subst.add(var2);
                Element created = FormulaUtility.replaceOperatorVariable(f, var, subst);
                this.addFormula(created, new SubstPredBo(i, var, subst));
            }
        }
    }

    private void substituteConjunction(int i) throws ProofException {
        Element f = (Element)this.lines.get(i);
        ElementSet vars = FormulaUtility.getPropositionVariables(f);
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            ElementList var = (ElementList)iter.next();
            this.createReplacement(i, f, var, "AND", true);
            this.createReplacement(i, f, var, "AND", false);
        }
    }

    private void substituteDisjunction(int i) throws ProofException {
        Element f = (Element)this.lines.get(i);
        ElementSet vars = FormulaUtility.getPropositionVariables(f);
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            ElementList var = (ElementList)iter.next();
            this.createReplacement(i, f, var, "OR", true);
            this.createReplacement(i, f, var, "OR", false);
        }
    }

    private void substituteImplication(int i) throws ProofException {
        Element f = (Element)this.lines.get(i);
        ElementSet vars = FormulaUtility.getPropositionVariables(f);
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            ElementList var = (ElementList)iter.next();
            this.createReplacement(i, f, var, "IMPL", true);
            this.createReplacement(i, f, var, "IMPL", false);
        }
    }

    private void substituteEquivalence(int i) throws ProofException {
        Element f = (Element)this.lines.get(i);
        ElementSet vars = FormulaUtility.getPropositionVariables(f);
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            ElementList var = (ElementList)iter.next();
            this.createReplacement(i, f, var, "EQUI", true);
            this.createReplacement(i, f, var, "EQUI", false);
        }
    }

    private void createReplacement(int i, Element f, ElementList var, String operator, boolean left) throws ProofException {
        Iterator a = this.allPredVars.iterator();
        while (a.hasNext()) {
            ElementList var2 = (ElementList)a.next();
            DefaultElementList subst = new DefaultElementList(operator);
            if (left) {
                subst.add(var);
                subst.add(var2);
            } else {
                subst.add(var2);
                subst.add(var);
            }
            Element created = FormulaUtility.replaceOperatorVariable(f, var, subst);
            this.addFormula(created, new SubstPredBo(i, var, subst));
        }
    }

    private void addFormula(Element formula, Reason reason) throws ProofException {
        if (!this.lines.contains(formula)) {
            this.lines.add(formula);
            this.reasons.add(reason);
            if (((Object)this.goalFormula).equals(formula)) {
                int size = this.lines.size();
                this.log.logMessageState("Proof found! During search we generated this number of proof lines: " + size);
                throw new ProofFoundException(23791210, "Proof found! During search we generated this number of proof lines: " + size, ProofFinderUtility.shortenProof(this.lines, this.reasons, this.log, this.trans), this.context);
            }
            if (this.lines.size() >= this.maxProofLines) {
                int size = this.lines.size();
                if (this.logFrequence > 0) {
                    this.log.logMessageState(ProofFinderUtility.getUtf8Line(this.lines, this.reasons, this.lines.size() - 1, this.trans));
                }
                this.log.logMessageState("Proof not found with current restrictions. During search we generated this number of proof lines: " + size);
                throw new ProofNotFoundException(23791200, "Proof not found with current restrictions. During search we generated this number of proof lines: " + size, this.context);
            }
            if (this.logFrequence > 0 && (this.lines.size() - 1) % this.logFrequence == 0) {
                this.log.logMessageState(ProofFinderUtility.getUtf8Line(this.lines, this.reasons, this.lines.size() - 1, this.trans));
            }
        }
    }

    public String getExecutionActionDescription() {
        return ProofFinderUtility.getUtf8Line(this.lines, this.reasons, this.lines.size() - 1, this.trans);
    }

    static interface Substitute
    extends Comparable {
        public int nextLine();

        public void substitute() throws ProofException;

        public int getWeight();

        public int getOrder();
    }

    private abstract class SubstituteBase
    implements Substitute {
        private int next = 0;
        private final int weight;
        private final int order;

        SubstituteBase(int weight, int order) {
            this.weight = weight;
            this.order = order;
        }

        public int getWeight() {
            return this.weight;
        }

        public int getOrder() {
            return this.order;
        }

        public int nextLine() {
            return this.next;
        }

        public int compareTo(Object obj) {
            if (obj instanceof Substitute) {
                Substitute sub = (Substitute)obj;
                if (this.order == sub.getOrder()) {
                    return -1;
                }
                if (this.order < sub.getOrder()) {
                    return -1;
                }
                return 1;
            }
            return -1;
        }

        public void substitute() throws ProofException {
            this.substitute(this.next);
            ++this.next;
        }

        public abstract void substitute(int var1) throws ProofException;
    }
}

