/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.logic.proof.checker;

import java.util.HashMap;
import java.util.Map;
import org.qedeq.base.io.Version;
import org.qedeq.base.io.VersionSet;
import org.qedeq.base.utility.Enumerator;
import org.qedeq.base.utility.EqualsUtility;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.kernel.bo.logic.common.FormulaUtility;
import org.qedeq.kernel.bo.logic.common.LogicalCheckExceptionList;
import org.qedeq.kernel.bo.logic.common.ReferenceResolver;
import org.qedeq.kernel.bo.logic.proof.checker.ProofCheckException;
import org.qedeq.kernel.bo.logic.proof.common.ProofChecker;
import org.qedeq.kernel.bo.logic.proof.common.RuleChecker;
import org.qedeq.kernel.bo.logic.wf.FormulaCheckerImpl;
import org.qedeq.kernel.se.base.list.Element;
import org.qedeq.kernel.se.base.list.ElementList;
import org.qedeq.kernel.se.base.module.Add;
import org.qedeq.kernel.se.base.module.ConditionalProof;
import org.qedeq.kernel.se.base.module.Existential;
import org.qedeq.kernel.se.base.module.FormalProofLine;
import org.qedeq.kernel.se.base.module.FormalProofLineList;
import org.qedeq.kernel.se.base.module.ModusPonens;
import org.qedeq.kernel.se.base.module.Reason;
import org.qedeq.kernel.se.base.module.Rename;
import org.qedeq.kernel.se.base.module.Rule;
import org.qedeq.kernel.se.base.module.SubstFree;
import org.qedeq.kernel.se.base.module.SubstFunc;
import org.qedeq.kernel.se.base.module.SubstPred;
import org.qedeq.kernel.se.base.module.Universal;
import org.qedeq.kernel.se.common.ModuleAddress;
import org.qedeq.kernel.se.common.ModuleContext;
import org.qedeq.kernel.se.common.RuleKey;
import org.qedeq.kernel.se.dto.list.DefaultElementList;
import org.qedeq.kernel.se.dto.list.ElementSet;

public class ProofChecker2Impl
implements ProofChecker,
ReferenceResolver {
    private FormalProofLineList proof;
    private ModuleContext moduleContext;
    private ModuleContext currentContext;
    private ReferenceResolver resolver;
    private LogicalCheckExceptionList exceptions;
    private boolean[] lineProved;
    private Map label2line;
    private final VersionSet supported = new VersionSet();
    private ElementList conditions;
    private RuleChecker checker;

    public ProofChecker2Impl() {
        this.supported.add("0.01.00");
        this.supported.add("0.02.00");
    }

    public LogicalCheckExceptionList checkRule(Rule rule, ModuleContext context, RuleChecker checker, ReferenceResolver resolver) {
        this.exceptions = new LogicalCheckExceptionList();
        RuleKey ruleKey = new RuleKey(rule.getName(), rule.getVersion());
        if (rule.getVersion() == null || !this.supported.contains(rule.getVersion())) {
            ProofCheckException ex = new ProofCheckException(37430, "proof method is not supported for this proof checker: " + ruleKey + ", we only support: " + this.supported, context);
            this.exceptions.add(ex);
        }
        return this.exceptions;
    }

    public LogicalCheckExceptionList checkProof(Element formula, FormalProofLineList proof, RuleChecker checker, ModuleContext moduleContext, ReferenceResolver resolver) {
        DefaultElementList con = new DefaultElementList("AND");
        return this.checkProof(con, formula, proof, checker, moduleContext, resolver);
    }

    private LogicalCheckExceptionList checkProof(ElementList conditions, Element formula, FormalProofLineList proof, RuleChecker checker, ModuleContext moduleContext, ReferenceResolver resolver) {
        this.conditions = conditions;
        this.proof = proof;
        this.checker = checker;
        this.resolver = resolver;
        this.moduleContext = moduleContext;
        this.currentContext = new ModuleContext(moduleContext);
        this.exceptions = new LogicalCheckExceptionList();
        String context = moduleContext.getLocationWithinModule();
        this.lineProved = new boolean[proof.size()];
        this.label2line = new HashMap();
        for (int i = 0; i < proof.size(); ++i) {
            String getReason;
            boolean ok = true;
            this.setLocationWithinModule(context + ".get(" + i + ")");
            FormalProofLine line = proof.get(i);
            if (line == null || line.getFormula() == null || line.getFormula().getElement() == null) {
                ok = false;
                this.handleProofCheckException(37100, "proof line must not be empty", this.getCurrentContext());
                continue;
            }
            this.setLocationWithinModule(context + ".get(" + i + ").getReason()");
            Reason reason = line.getReason();
            if (reason == null) {
                ok = false;
                this.handleProofCheckException(37110, "reason must not be empty", this.getCurrentContext());
                continue;
            }
            if (line.getLabel() != null && line.getLabel().length() > 0) {
                this.setLocationWithinModule(context + ".get(" + i + ").getLabel()");
                this.addLocalLineLabel(i, line.getLabel());
            }
            if (this.hasConditions()) {
                this.setLocationWithinModule(context + ".get(" + i + ").getFormula.getElement()");
                DefaultElementList full = new DefaultElementList("IMPL");
                if (conditions.size() > 1) {
                    full.add(conditions);
                } else {
                    full.add(conditions.getElement(0));
                }
                full.add(line.getFormula().getElement());
                FormulaCheckerImpl checkWf = new FormulaCheckerImpl();
                LogicalCheckExceptionList list = checkWf.checkFormula(full, this.getCurrentContext());
                if (list.size() > 0) {
                    ok = false;
                    this.handleProofCheckException(37410, "the conditions for this proof line doesn't agree with the formula " + list.get(0).getMessage(), this.getCurrentContext());
                    continue;
                }
            }
            if ((getReason = ".get" + StringUtility.getClassName(reason.getClass())).endsWith("Vo")) {
                getReason = getReason.substring(0, getReason.length() - 2) + "()";
                this.setLocationWithinModule(context + ".get(" + i + ").getReason()" + getReason);
            }
            if (reason instanceof Add) {
                ok = this.check((Add)reason, i, line.getFormula().getElement());
            } else if (reason instanceof Rename) {
                ok = this.check((Rename)reason, i, line.getFormula().getElement());
            } else if (reason instanceof ModusPonens) {
                ok = this.check((ModusPonens)reason, i, line.getFormula().getElement());
            } else if (reason instanceof SubstFree) {
                ok = this.check((SubstFree)reason, i, line.getFormula().getElement());
            } else if (reason instanceof SubstPred) {
                ok = this.check((SubstPred)reason, i, line.getFormula().getElement());
            } else if (reason instanceof SubstFunc) {
                ok = this.check((SubstFunc)reason, i, line.getFormula().getElement());
            } else if (reason instanceof Universal) {
                ok = this.check((Universal)reason, i, line.getFormula().getElement());
            } else if (reason instanceof Existential) {
                ok = this.check((Existential)reason, i, line.getFormula().getElement());
            } else if (reason instanceof ConditionalProof) {
                this.setLocationWithinModule(context + ".get(" + i + ")");
                ok = this.check((ConditionalProof)reason, i, line.getFormula().getElement());
            } else {
                ok = false;
                this.handleProofCheckException(37120, "this is no allowed basic rule: " + reason.getName(), this.getCurrentContext());
            }
            this.lineProved[i] = ok;
            if (i != proof.size() - 1 || ((Object)formula).equals(line.getFormula().getElement())) continue;
            this.handleProofCheckException(37200, "the last proof line must be identical to the proposition formula", this.getModuleContextOfProofLineFormula(i));
        }
        return this.exceptions;
    }

    private void addLocalLineLabel(int i, String label) {
        if (label != null && label.length() > 0) {
            Integer n = (Integer)this.label2line.get(label);
            if (n != null) {
                ModuleContext lc = new ModuleContext(this.moduleContext.getModuleLocation(), this.moduleContext.getLocationWithinModule() + ".get(" + this.label2line.get(label) + ").getLabel()");
                this.handleProofCheckException(37150, "this proof line label exists already in this proof: " + label, this.getCurrentContext(), lc);
            } else if (this.isLocalProofLineReference(label)) {
                this.handleProofCheckException(37150, "this proof line label exists already in this proof: " + label, this.getCurrentContext(), this.resolver.getReferenceContext(label));
            }
            this.label2line.put(label, new Integer(i));
        }
    }

    private boolean check(Add add, int i, Element element) {
        Element current;
        String context = this.currentContext.getLocationWithinModule();
        boolean ok = true;
        if (add.getReference() == null) {
            ok = false;
            this.setLocationWithinModule(context + ".getReference()");
            this.handleProofCheckException(37220, "this is not a reference to a proved formula: ", this.getCurrentContext());
            return ok;
        }
        if (!this.resolver.isProvedFormula(add.getReference())) {
            ok = false;
            this.setLocationWithinModule(context + ".getReference()");
            this.handleProofCheckException(37130, "this is not a reference to a proved formula: " + add.getReference(), this.getCurrentContext());
            return ok;
        }
        Element expected = this.resolver.getNormalizedReferenceFormula(add.getReference());
        if (!EqualsUtility.equals(expected, current = this.resolver.getNormalizedFormula(element))) {
            ok = false;
            this.handleProofCheckException(37140, "this is not the expected part formula, please check with label: " + add.getReference(), this.getDiffModuleContextOfProofLineFormula(i, expected));
            return ok;
        }
        RuleKey defined = this.checker.getRule(add.getName());
        if (defined == null) {
            ok = false;
            this.handleProofCheckException(37420, "proof method was not defined yet: " + add.getName(), this.getCurrentContext());
            return ok;
        }
        if (!this.supported.contains(defined.getVersion())) {
            ok = false;
            this.handleProofCheckException(37430, "proof method is not supported for this proof checker: " + defined.getVersion() + ", we only support: " + this.supported, this.getCurrentContext());
            return ok;
        }
        if (this.hasConditions() && !Version.equals("0.02.00", defined.getVersion())) {
            ok = false;
            this.handleProofCheckException(37440, "you need a higher rule version for applying this rule here, needed: 0.02.00, current: " + defined.getVersion(), this.getCurrentContext());
            return ok;
        }
        return ok;
    }

    private boolean check(Rename rename, int i, Element element) {
        String context = this.currentContext.getLocationWithinModule();
        boolean ok = true;
        Element f = this.getNormalizedLocalProofLineReference(rename.getReference());
        if (f == null) {
            ok = false;
            this.setLocationWithinModule(context + ".getReference()");
            this.handleProofCheckException(37160, "this proof line label dosn't (yet) exist in this proof: " + rename.getReference(), this.getCurrentContext());
        } else {
            Element current;
            Element expected = FormulaUtility.replaceSubjectVariableQuantifier(rename.getOriginalSubjectVariable(), rename.getReplacementSubjectVariable(), f, rename.getOccurrence(), new Enumerator());
            if (!EqualsUtility.equals(expected, current = this.resolver.getNormalizedFormula(element))) {
                ok = false;
                this.handleProofCheckException(37140, "this is not the expected part formula, please check with label: " + rename.getReference(), this.getDiffModuleContextOfProofLineFormula(i, expected));
            } else {
                ok = true;
            }
        }
        RuleKey defined = this.checker.getRule(rename.getName());
        if (defined == null) {
            ok = false;
            this.handleProofCheckException(37420, "proof method was not defined yet: " + rename.getName(), this.getCurrentContext());
            return ok;
        }
        if (!this.supported.contains(defined.getVersion())) {
            ok = false;
            this.handleProofCheckException(37430, "proof method is not supported for this proof checker: " + defined.getVersion() + ", we only support: " + this.supported, this.getCurrentContext());
            return ok;
        }
        if (this.hasConditions() && !Version.equals("0.02.00", defined.getVersion())) {
            ok = false;
            this.handleProofCheckException(37440, "you need a higher rule version for applying this rule here, needed: 0.02.00, current: " + defined.getVersion(), this.getCurrentContext());
            return ok;
        }
        return ok;
    }

    private boolean check(SubstFree substFree, int i, Element element) {
        String context = this.currentContext.getLocationWithinModule();
        boolean ok = true;
        Element f = this.getNormalizedLocalProofLineReference(substFree.getReference());
        if (f == null) {
            ok = false;
            this.setLocationWithinModule(context + ".getReference()");
            this.handleProofCheckException(37160, "this proof line label dosn't (yet) exist in this proof: " + substFree.getReference(), this.getCurrentContext());
        } else {
            Element expected;
            Element current = this.resolver.getNormalizedFormula(element);
            if (!EqualsUtility.equals(current, expected = f.replace(substFree.getSubjectVariable(), this.resolver.getNormalizedFormula(substFree.getSubstituteTerm())))) {
                ok = false;
                this.handleProofCheckException(37140, "this is not the expected part formula, please check with label: " + substFree.getReference(), this.getDiffModuleContextOfProofLineFormula(i, expected));
                return ok;
            }
        }
        if (FormulaUtility.containsOperatorVariable(this.conditions, substFree.getSubjectVariable())) {
            ok = false;
            this.setLocationWithinModule(context + ".getSubstituteFormula()");
            this.handleProofCheckException(37380, "the operator that should be substituted was found within a precondition", this.getCurrentContext());
            return ok;
        }
        RuleKey defined = this.checker.getRule(substFree.getName());
        if (defined == null) {
            ok = false;
            this.handleProofCheckException(37420, "proof method was not defined yet: " + substFree.getName(), this.getCurrentContext());
            return ok;
        }
        if (!this.supported.contains(defined.getVersion())) {
            ok = false;
            this.handleProofCheckException(37430, "proof method is not supported for this proof checker: " + defined.getVersion() + ", we only support: " + this.supported, this.getCurrentContext());
            return ok;
        }
        if (this.hasConditions() && !Version.equals("0.02.00", defined.getVersion())) {
            ok = false;
            this.handleProofCheckException(37440, "you need a higher rule version for applying this rule here, needed: 0.02.00, current: " + defined.getVersion(), this.getCurrentContext());
            return ok;
        }
        return ok;
    }

    private boolean check(SubstPred substPred, int i, Element element) {
        ElementSet betaFree;
        Element beta;
        String context = this.currentContext.getLocationWithinModule();
        boolean ok = true;
        Element alpha = this.getNormalizedLocalProofLineReference(substPred.getReference());
        if (alpha == null) {
            ok = false;
            this.setLocationWithinModule(context + ".getReference()");
            this.handleProofCheckException(37160, "this proof line label dosn't (yet) exist in this proof: " + substPred.getReference(), this.getCurrentContext());
            return ok;
        }
        Element current = this.resolver.getNormalizedFormula(element);
        if (substPred.getSubstituteFormula() == null) {
            ok = false;
            this.handleProofCheckException(37210, "the substitution formula is missing", this.getCurrentContext());
            return ok;
        }
        Element p = this.resolver.getNormalizedFormula(substPred.getPredicateVariable());
        Element expected = FormulaUtility.replaceOperatorVariable(alpha, p, beta = this.resolver.getNormalizedFormula(substPred.getSubstituteFormula()));
        if (!EqualsUtility.equals(current, expected)) {
            ok = false;
            this.handleProofCheckException(37140, "this is not the expected part formula, please check with label: " + substPred.getReference(), this.getDiffModuleContextOfProofLineFormula(i, expected));
            return ok;
        }
        ElementSet predFree = FormulaUtility.getFreeSubjectVariables(p);
        if (predFree.size() != p.getList().size() - 1) {
            ok = false;
            this.setLocationWithinModule(context + ".getPredicateVariable()");
            this.handleProofCheckException(37240, "only free subject variables as parameters allowed", this.getDiffModuleContextOfProofLineFormula(i, expected));
            return ok;
        }
        for (int j = 1; j < p.getList().size(); ++j) {
            if (FormulaUtility.isSubjectVariable(p.getList().getElement(j))) continue;
            ok = false;
            this.setLocationWithinModule(context + ".getPredicateVariable()");
            this.handleProofCheckException(37240, "only free subject variables as parameters allowed", this.getCurrentContext());
            return ok;
        }
        ElementSet fBound = FormulaUtility.getBoundSubjectVariables(alpha);
        if (!fBound.intersection((betaFree = FormulaUtility.getFreeSubjectVariables(beta)).minus(predFree)).isEmpty()) {
            ok = false;
            this.setLocationWithinModule(context + ".getSubstituteFormula()");
            this.handleProofCheckException(37250, "free subject variables should not get bound during substitution", this.getCurrentContext());
            return ok;
        }
        ElementSet betaBound = FormulaUtility.getBoundSubjectVariables(beta);
        if (!FormulaUtility.testOperatorVariable(alpha, p, betaBound)) {
            ok = false;
            this.setLocationWithinModule(context + ".getSubstituteFormula()");
            this.handleProofCheckException(37260, "the substitution location contains subject variables that are bound within the replacement formula", this.getCurrentContext());
            return ok;
        }
        if (FormulaUtility.containsOperatorVariable(this.conditions, p)) {
            ok = false;
            this.setLocationWithinModule(context + ".getPredicateVariable()");
            this.handleProofCheckException(37380, "the operator that should be substituted was found within a precondition", this.getCurrentContext());
            return ok;
        }
        RuleKey defined = this.checker.getRule(substPred.getName());
        if (defined == null) {
            ok = false;
            this.handleProofCheckException(37420, "proof method was not defined yet: " + substPred.getName(), this.getCurrentContext());
            return ok;
        }
        if (!this.supported.contains(defined.getVersion())) {
            ok = false;
            this.handleProofCheckException(37430, "proof method is not supported for this proof checker: " + defined.getVersion() + ", we only support: " + this.supported, this.getCurrentContext());
            return ok;
        }
        if (this.hasConditions() && !Version.equals("0.02.00", defined.getVersion())) {
            ok = false;
            this.handleProofCheckException(37440, "you need a higher rule version for applying this rule here, needed: 0.02.00, current: " + defined.getVersion(), this.getCurrentContext());
            return ok;
        }
        return ok;
    }

    private boolean check(SubstFunc substFunc, int i, Element element) {
        ElementSet sigmaFree;
        Element tau;
        String context = this.currentContext.getLocationWithinModule();
        boolean ok = true;
        Element alpha = this.getNormalizedLocalProofLineReference(substFunc.getReference());
        if (alpha == null) {
            ok = false;
            this.setLocationWithinModule(context + ".getReference()");
            this.handleProofCheckException(37160, "this proof line label dosn't (yet) exist in this proof: " + substFunc.getReference(), this.getCurrentContext());
            return ok;
        }
        Element current = this.resolver.getNormalizedFormula(element);
        if (substFunc.getSubstituteTerm() == null) {
            ok = false;
            this.handleProofCheckException(37210, "the substitution formula is missing", this.getCurrentContext());
            return ok;
        }
        Element sigma = this.resolver.getNormalizedFormula(substFunc.getFunctionVariable());
        Element expected = FormulaUtility.replaceOperatorVariable(alpha, sigma, tau = this.resolver.getNormalizedFormula(substFunc.getSubstituteTerm()));
        if (!EqualsUtility.equals(current, expected)) {
            ok = false;
            this.handleProofCheckException(37140, "this is not the expected part formula, please check with label: " + substFunc.getReference(), this.getDiffModuleContextOfProofLineFormula(i, expected));
            return ok;
        }
        ElementSet funcFree = FormulaUtility.getFreeSubjectVariables(sigma);
        if (funcFree.size() != sigma.getList().size() - 1) {
            ok = false;
            this.setLocationWithinModule(context + ".getPredicateVariable()");
            this.handleProofCheckException(37240, "only free subject variables as parameters allowed", this.getDiffModuleContextOfProofLineFormula(i, expected));
            return ok;
        }
        for (int j = 1; j < sigma.getList().size(); ++j) {
            if (FormulaUtility.isSubjectVariable(sigma.getList().getElement(j))) continue;
            ok = false;
            this.setLocationWithinModule(context + ".getPredicateVariable()");
            this.handleProofCheckException(37240, "only free subject variables as parameters allowed", this.getCurrentContext());
            return ok;
        }
        ElementSet fBound = FormulaUtility.getBoundSubjectVariables(alpha);
        if (!fBound.intersection((sigmaFree = FormulaUtility.getFreeSubjectVariables(tau)).minus(funcFree)).isEmpty()) {
            ok = false;
            this.setLocationWithinModule(context + ".getSubstituteFormula()");
            this.handleProofCheckException(37250, "free subject variables should not get bound during substitution", this.getCurrentContext());
            return ok;
        }
        ElementSet sigmaBound = FormulaUtility.getBoundSubjectVariables(tau);
        if (!FormulaUtility.testOperatorVariable(alpha, sigma, sigmaBound)) {
            ok = false;
            this.setLocationWithinModule(context + ".getSubstituteFormula()");
            this.handleProofCheckException(37260, "the substitution location contains subject variables that are bound within the replacement formula", this.getCurrentContext());
            return ok;
        }
        if (FormulaUtility.containsOperatorVariable(this.conditions, sigma)) {
            ok = false;
            this.setLocationWithinModule(context + ".getPredicateVariable()");
            this.handleProofCheckException(37380, "the operator that should be substituted was found within a precondition", this.getCurrentContext());
            return ok;
        }
        RuleKey defined = this.checker.getRule(substFunc.getName());
        if (defined == null) {
            ok = false;
            this.handleProofCheckException(37420, "proof method was not defined yet: " + substFunc.getName(), this.getCurrentContext());
            return ok;
        }
        if (!this.supported.contains(defined.getVersion())) {
            ok = false;
            this.handleProofCheckException(37430, "proof method is not supported for this proof checker: " + defined.getVersion() + ", we only support: " + this.supported, this.getCurrentContext());
            return ok;
        }
        if (this.hasConditions() && !Version.equals("0.02.00", defined.getVersion())) {
            ok = false;
            this.handleProofCheckException(37440, "you need a higher rule version for applying this rule here, needed: 0.02.00, current: " + defined.getVersion(), this.getCurrentContext());
            return ok;
        }
        return ok;
    }

    private boolean check(ModusPonens mp, int i, Element element) {
        RuleKey defined;
        Element f2;
        String context = this.currentContext.getLocationWithinModule();
        boolean ok = true;
        Element f1 = this.getNormalizedLocalProofLineReference(mp.getReference1());
        if (f1 == null) {
            ok = false;
            this.setLocationWithinModule(context + ".getReference1()");
            this.handleProofCheckException(37160, "this proof line label dosn't (yet) exist in this proof: " + mp.getReference1(), this.getCurrentContext());
        }
        if ((f2 = this.getNormalizedLocalProofLineReference(mp.getReference2())) == null) {
            ok = false;
            this.setLocationWithinModule(context + ".getReference2()");
            this.handleProofCheckException(37160, "this proof line label dosn't (yet) exist in this proof: " + mp.getReference2(), this.getCurrentContext());
        }
        if (ok) {
            Element current = this.getNormalizedFormula(element);
            if (!FormulaUtility.isImplication(f1)) {
                ok = false;
                this.setLocationWithinModule(context + ".getReference1()");
                this.handleProofCheckException(37170, "this proof line label must point to an implication (with two arguments): " + mp.getReference1(), this.getCurrentContext());
            } else if (!((Object)f2).equals(f1.getList().getElement(0))) {
                ok = false;
                this.setLocationWithinModule(context + ".getReference2()");
                this.handleProofCheckException(37180, "this proof line label must be the hypothesis for the first reference: " + mp.getReference2(), this.getCurrentContext(), this.resolver.getReferenceContext(mp.getReference1()));
            } else if (!((Object)current).equals(f1.getList().getElement(1))) {
                ok = false;
                this.setLocationWithinModule(context + ".getReference1()");
                this.handleProofCheckException(37190, "this proof line must be the conclusion of the first reference: " + mp.getReference1(), this.getCurrentContext(), this.resolver.getReferenceContext(mp.getReference1()));
            } else {
                ok = true;
            }
        }
        if ((defined = this.checker.getRule(mp.getName())) == null) {
            ok = false;
            this.handleProofCheckException(37420, "proof method was not defined yet: " + mp.getName(), this.getCurrentContext());
            return ok;
        }
        if (!this.supported.contains(defined.getVersion())) {
            ok = false;
            this.handleProofCheckException(37430, "proof method is not supported for this proof checker: " + defined.getVersion() + ", we only support: " + this.supported, this.getCurrentContext());
            return ok;
        }
        if (this.hasConditions() && !Version.equals("0.02.00", defined.getVersion())) {
            ok = false;
            this.handleProofCheckException(37440, "you need a higher rule version for applying this rule here, needed: 0.02.00, current: " + defined.getVersion(), this.getCurrentContext());
            return ok;
        }
        return ok;
    }

    private boolean check(Universal universal, int i, Element element) {
        String context = this.currentContext.getLocationWithinModule();
        boolean ok = true;
        Element reference = this.getNormalizedLocalProofLineReference(universal.getReference());
        if (reference == null) {
            ok = false;
            this.setLocationWithinModule(context + ".getReference()");
            this.handleProofCheckException(37160, "this proof line label dosn't (yet) exist in this proof: " + universal.getReference(), this.getCurrentContext());
        } else {
            Element current = this.getNormalizedFormula(element);
            if (!FormulaUtility.isImplication(current)) {
                ok = false;
                this.setLocationWithinModule(context + ".getReference()");
                this.handleProofCheckException(37170, "this proof line label must point to an implication (with two arguments): " + universal.getReference(), this.getCurrentContext());
                return ok;
            }
            if (!FormulaUtility.isSubjectVariable(universal.getSubjectVariable())) {
                ok = false;
                this.setLocationWithinModule(context + ".getSubjectVariable()");
                this.handleProofCheckException(37270, "subject variable is missing", this.getCurrentContext());
                return ok;
            }
            DefaultElementList expected = new DefaultElementList("IMPL");
            expected.add(reference.getList().getElement(0));
            DefaultElementList uni = new DefaultElementList("FORALL");
            uni.add(universal.getSubjectVariable());
            uni.add(reference.getList().getElement(1));
            expected.add(uni);
            if (!EqualsUtility.equals(current, expected)) {
                ok = false;
                this.handleProofCheckException(37140, "this is not the expected part formula, please check with label: " + universal.getReference(), this.getDiffModuleContextOfProofLineFormula(i, expected));
                return ok;
            }
        }
        RuleKey defined = this.checker.getRule(universal.getName());
        if (defined == null) {
            ok = false;
            this.handleProofCheckException(37420, "proof method was not defined yet: " + universal.getName(), this.getCurrentContext());
            return ok;
        }
        if (!this.supported.contains(defined.getVersion())) {
            ok = false;
            this.handleProofCheckException(37430, "proof method is not supported for this proof checker: " + defined.getVersion() + ", we only support: " + this.supported, this.getCurrentContext());
            return ok;
        }
        if (this.hasConditions() && !Version.equals("0.02.00", defined.getVersion())) {
            ok = false;
            this.handleProofCheckException(37440, "you need a higher rule version for applying this rule here, needed: 0.02.00, current: " + defined.getVersion(), this.getCurrentContext());
            return ok;
        }
        return ok;
    }

    private boolean check(Existential existential, int i, Element element) {
        String context = this.currentContext.getLocationWithinModule();
        boolean ok = true;
        Element reference = this.getNormalizedLocalProofLineReference(existential.getReference());
        if (reference == null) {
            ok = false;
            this.setLocationWithinModule(context + ".getReference()");
            this.handleProofCheckException(37160, "this proof line label dosn't (yet) exist in this proof: " + existential.getReference(), this.getCurrentContext());
        } else {
            Element current = this.getNormalizedFormula(element);
            if (!FormulaUtility.isImplication(current)) {
                ok = false;
                this.setLocationWithinModule(context + ".getReference()");
                this.handleProofCheckException(37170, "this proof line label must point to an implication (with two arguments): " + existential.getReference(), this.getCurrentContext());
                return ok;
            }
            if (!FormulaUtility.isSubjectVariable(existential.getSubjectVariable())) {
                ok = false;
                this.setLocationWithinModule(context + ".getSubjectVariable()");
                this.handleProofCheckException(37270, "subject variable is missing", this.getCurrentContext());
                return ok;
            }
            DefaultElementList expected = new DefaultElementList("IMPL");
            DefaultElementList exi = new DefaultElementList("EXISTS");
            exi.add(existential.getSubjectVariable());
            exi.add(reference.getList().getElement(0));
            expected.add(exi);
            expected.add(reference.getList().getElement(1));
            if (!EqualsUtility.equals(current, expected)) {
                ok = false;
                this.handleProofCheckException(37140, "this is not the expected part formula, please check with label: " + existential.getReference(), this.getDiffModuleContextOfProofLineFormula(i, expected));
                return ok;
            }
        }
        RuleKey defined = this.checker.getRule(existential.getName());
        if (defined == null) {
            ok = false;
            this.handleProofCheckException(37420, "proof method was not defined yet: " + existential.getName(), this.getCurrentContext());
            return ok;
        }
        if (!this.supported.contains(defined.getVersion())) {
            ok = false;
            this.handleProofCheckException(37430, "proof method is not supported for this proof checker: " + defined.getVersion() + ", we only support: " + this.supported, this.getCurrentContext());
            return ok;
        }
        if (this.hasConditions() && !Version.equals("0.02.00", defined.getVersion())) {
            ok = false;
            this.handleProofCheckException(37440, "you need a higher rule version for applying this rule here, needed: 0.02.00, current: " + defined.getVersion(), this.getCurrentContext());
            return ok;
        }
        return ok;
    }

    private boolean check(final ConditionalProof cp, int i, Element element) {
        final ModuleAddress address = this.currentContext.getModuleLocation();
        final String context = this.currentContext.getLocationWithinModule();
        boolean ok = true;
        if (cp.getHypothesis() == null || cp.getHypothesis().getFormula() == null || cp.getHypothesis().getFormula().getElement() == null) {
            ok = false;
            this.setLocationWithinModule(context + ".getHypothesis()");
            this.handleProofCheckException(37100, "proof line must not be empty", this.getCurrentContext());
            return ok;
        }
        if (cp.getFormalProofLineList() == null || cp.getFormalProofLineList().size() <= 0) {
            ok = false;
            this.setLocationWithinModule(context + ".getFormalProofLineList()");
            this.handleProofCheckException(37370, "missing proof lines for conditional proof", this.getCurrentContext());
            return ok;
        }
        ReferenceResolver newResolver = new ReferenceResolver(){

            public Element getNormalizedFormula(Element formula) {
                return ProofChecker2Impl.this.getNormalizedFormula(formula);
            }

            public Element getNormalizedReferenceFormula(String reference) {
                if (EqualsUtility.equals(reference, cp.getHypothesis().getLabel())) {
                    return ProofChecker2Impl.this.resolver.getNormalizedFormula(cp.getHypothesis().getFormula().getElement());
                }
                return ProofChecker2Impl.this.getNormalizedReferenceFormula(reference);
            }

            public boolean isProvedFormula(String reference) {
                if (EqualsUtility.equals(reference, cp.getHypothesis().getLabel())) {
                    return true;
                }
                return ProofChecker2Impl.this.isProvedFormula(reference);
            }

            public boolean isLocalProofLineReference(String reference) {
                if (EqualsUtility.equals(reference, cp.getHypothesis().getLabel())) {
                    return true;
                }
                return ProofChecker2Impl.this.isLocalProofLineReference(reference);
            }

            public ModuleContext getReferenceContext(String reference) {
                if (EqualsUtility.equals(reference, cp.getHypothesis().getLabel())) {
                    return new ModuleContext(address, context + ".getHypothesis().getLabel()");
                }
                return ProofChecker2Impl.this.getReferenceContext(reference);
            }

            public Element getNormalizedLocalProofLineReference(String reference) {
                if (EqualsUtility.equals(reference, cp.getHypothesis().getLabel())) {
                    return ProofChecker2Impl.this.resolver.getNormalizedFormula(cp.getHypothesis().getFormula().getElement());
                }
                return ProofChecker2Impl.this.getNormalizedLocalProofLineReference(reference);
            }
        };
        int last = cp.getFormalProofLineList().size() - 1;
        this.setLocationWithinModule(context + ".getFormalProofLineList().get(" + last + ")");
        FormalProofLine line = cp.getFormalProofLineList().get(last);
        if (line == null || line.getFormula() == null || line.getFormula().getElement() == null) {
            ok = false;
            this.handleProofCheckException(37100, "proof line must not be empty", this.getCurrentContext());
            return ok;
        }
        Element lastFormula = this.resolver.getNormalizedFormula(line.getFormula().getElement());
        ElementList newConditions = (ElementList)this.conditions.copy();
        newConditions.add(cp.getHypothesis().getFormula().getElement());
        this.setLocationWithinModule(context + ".getFormalProofLineList()");
        LogicalCheckExceptionList eList = new ProofChecker2Impl().checkProof(newConditions, lastFormula, cp.getFormalProofLineList(), this.checker, this.getCurrentContext(), newResolver);
        this.exceptions.add(eList);
        ok = eList.size() == 0;
        this.setLocationWithinModule(context + ".getConclusion()");
        if (cp.getConclusion() == null || cp.getConclusion().getFormula() == null || cp.getConclusion().getFormula().getElement() == null) {
            ok = false;
            this.handleProofCheckException(37100, "proof line must not be empty", this.getCurrentContext());
            return ok;
        }
        Element c = this.resolver.getNormalizedFormula(cp.getConclusion().getFormula().getElement());
        this.setLocationWithinModule(context + ".getConclusion().getFormula().getElement()");
        if (!FormulaUtility.isImplication(c)) {
            ok = false;
            this.handleProofCheckException(37170, "this proof line label must point to an implication (with two arguments): ", this.getCurrentContext());
            return ok;
        }
        DefaultElementList expected = new DefaultElementList("IMPL");
        expected.add(cp.getHypothesis().getFormula().getElement());
        expected.add(lastFormula);
        if (!EqualsUtility.equals(cp.getConclusion().getFormula().getElement(), expected)) {
            ok = false;
            this.handleProofCheckException(37142, "this is not the expected part formula", this.getDiffModuleContextOfProofLineFormula(i, expected));
            return ok;
        }
        RuleKey defined = this.checker.getRule(cp.getName());
        if (defined == null) {
            ok = false;
            this.handleProofCheckException(37420, "proof method was not defined yet: " + cp.getName(), this.getCurrentContext());
            return ok;
        }
        if (!this.supported.contains(defined.getVersion())) {
            ok = false;
            this.handleProofCheckException(37430, "proof method is not supported for this proof checker: " + defined.getVersion() + ", we only support: " + this.supported, this.getCurrentContext());
            return ok;
        }
        if (this.hasConditions() && !Version.equals("0.02.00", defined.getVersion())) {
            ok = false;
            this.handleProofCheckException(37440, "you need a higher rule version for applying this rule here, needed: 0.02.00, current: " + defined.getVersion(), this.getCurrentContext());
            return ok;
        }
        return ok;
    }

    private ModuleContext getModuleContextOfProofLineFormula(int i) {
        if (this.proof.get(i) instanceof ConditionalProof) {
            return new ModuleContext(this.moduleContext.getModuleLocation(), this.moduleContext.getLocationWithinModule() + ".get(" + i + ").getConclusion().getFormula().getElement()");
        }
        return new ModuleContext(this.moduleContext.getModuleLocation(), this.moduleContext.getLocationWithinModule() + ".get(" + i + ").getFormula().getElement()");
    }

    private ModuleContext getDiffModuleContextOfProofLineFormula(int i, Element expected) {
        String diff = FormulaUtility.getDifferenceLocation(this.proof.get(i).getFormula().getElement(), expected);
        if (this.proof.get(i) instanceof ConditionalProof) {
            return new ModuleContext(this.moduleContext.getModuleLocation(), this.moduleContext.getLocationWithinModule() + ".get(" + i + ").getConclusion().getFormula().getElement()" + diff);
        }
        return new ModuleContext(this.moduleContext.getModuleLocation(), this.moduleContext.getLocationWithinModule() + ".get(" + i + ").getFormula().getElement()" + diff);
    }

    private boolean hasConditions() {
        return this.conditions.size() > 0;
    }

    private Element getNormalizedProofLine(Integer n) {
        if (n == null) {
            return null;
        }
        int i = n;
        if (i < 0 || i >= this.proof.size()) {
            return null;
        }
        return this.resolver.getNormalizedFormula(this.proof.get(i).getFormula().getElement());
    }

    private void handleProofCheckException(int code, String msg, ModuleContext context) {
        ProofCheckException ex = new ProofCheckException(code, msg, context);
        this.exceptions.add(ex);
    }

    private void handleProofCheckException(int code, String msg, ModuleContext context, ModuleContext referenceContext) {
        ProofCheckException ex = new ProofCheckException(code, msg, null, context, referenceContext);
        this.exceptions.add(ex);
    }

    protected void setLocationWithinModule(String locationWithinModule) {
        this.getCurrentContext().setLocationWithinModule(locationWithinModule);
    }

    protected final ModuleContext getCurrentContext() {
        return this.currentContext;
    }

    public boolean isProvedFormula(String reference) {
        if (this.label2line.containsKey(reference)) {
            return this.lineProved[(Integer)this.label2line.get(reference)];
        }
        return this.resolver.isProvedFormula(reference);
    }

    public Element getNormalizedReferenceFormula(String reference) {
        if (this.label2line.containsKey(reference)) {
            return this.getNormalizedProofLine((Integer)this.label2line.get(reference));
        }
        return this.resolver.getNormalizedReferenceFormula(reference);
    }

    public Element getNormalizedFormula(Element element) {
        return this.resolver.getNormalizedFormula(element);
    }

    public boolean isLocalProofLineReference(String reference) {
        if (this.label2line.containsKey(reference)) {
            return true;
        }
        return this.resolver.isLocalProofLineReference(reference);
    }

    public Element getNormalizedLocalProofLineReference(String reference) {
        if (this.label2line.containsKey(reference)) {
            return this.getNormalizedProofLine((Integer)this.label2line.get(reference));
        }
        Element result = this.resolver.getNormalizedLocalProofLineReference(reference);
        return result;
    }

    public ModuleContext getReferenceContext(String reference) {
        if (this.label2line.containsKey(reference)) {
            ModuleContext lc = new ModuleContext(this.moduleContext.getModuleLocation(), this.moduleContext.getLocationWithinModule() + ".get(" + this.label2line.get(reference) + ").getLabel()");
            return lc;
        }
        return this.resolver.getReferenceContext(reference);
    }
}

