/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.logic.proof.checker;

import java.util.HashMap;
import java.util.Map;
import org.qedeq.base.io.Version;
import org.qedeq.base.utility.Enumerator;
import org.qedeq.base.utility.EqualsUtility;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.kernel.bo.logic.common.FormulaUtility;
import org.qedeq.kernel.bo.logic.common.LogicalCheckExceptionList;
import org.qedeq.kernel.bo.logic.common.ReferenceResolver;
import org.qedeq.kernel.bo.logic.proof.checker.ProofCheckException;
import org.qedeq.kernel.bo.logic.proof.common.ProofChecker;
import org.qedeq.kernel.bo.logic.proof.common.RuleChecker;
import org.qedeq.kernel.se.base.list.Element;
import org.qedeq.kernel.se.base.module.Add;
import org.qedeq.kernel.se.base.module.Existential;
import org.qedeq.kernel.se.base.module.FormalProofLine;
import org.qedeq.kernel.se.base.module.FormalProofLineList;
import org.qedeq.kernel.se.base.module.ModusPonens;
import org.qedeq.kernel.se.base.module.Reason;
import org.qedeq.kernel.se.base.module.Rename;
import org.qedeq.kernel.se.base.module.Rule;
import org.qedeq.kernel.se.base.module.SubstFree;
import org.qedeq.kernel.se.base.module.SubstFunc;
import org.qedeq.kernel.se.base.module.SubstPred;
import org.qedeq.kernel.se.base.module.Universal;
import org.qedeq.kernel.se.common.ModuleContext;
import org.qedeq.kernel.se.common.RuleKey;
import org.qedeq.kernel.se.dto.list.DefaultElementList;
import org.qedeq.kernel.se.dto.list.ElementSet;

public class ProofChecker1Impl
implements ProofChecker {
    private FormalProofLineList proof;
    private ModuleContext moduleContext;
    private ModuleContext currentContext;
    private ReferenceResolver resolver;
    private LogicalCheckExceptionList exceptions;
    private boolean[] lineProved;
    private Map label2line;
    private final Version ruleVersion = new Version("0.01.00");
    private RuleChecker checker;

    public LogicalCheckExceptionList checkRule(Rule rule, ModuleContext context, RuleChecker checker, ReferenceResolver resolver) {
        this.exceptions = new LogicalCheckExceptionList();
        RuleKey ruleKey = new RuleKey(rule.getName(), rule.getVersion());
        if (rule.getVersion() == null || !this.ruleVersion.equals(rule.getVersion())) {
            ProofCheckException ex = new ProofCheckException(37430, "proof method is not supported for this proof checker: " + ruleKey + ", we only support: " + "{" + this.ruleVersion + "}", context);
            this.exceptions.add(ex);
        }
        return this.exceptions;
    }

    public LogicalCheckExceptionList checkProof(Element formula, FormalProofLineList proof, RuleChecker checker, ModuleContext moduleContext, ReferenceResolver resolver) {
        this.proof = proof;
        this.resolver = resolver;
        this.moduleContext = moduleContext;
        this.checker = checker;
        this.currentContext = new ModuleContext(moduleContext);
        this.exceptions = new LogicalCheckExceptionList();
        String context = moduleContext.getLocationWithinModule();
        this.lineProved = new boolean[proof.size()];
        this.label2line = new HashMap();
        for (int i = 0; i < proof.size(); ++i) {
            String getReason;
            boolean ok = true;
            this.setLocationWithinModule(context + ".get(" + i + ")");
            FormalProofLine line = proof.get(i);
            if (line == null || line.getFormula() == null || line.getFormula().getElement() == null) {
                ok = false;
                this.handleProofCheckException(37100, "proof line must not be empty", this.getCurrentContext());
                continue;
            }
            this.setLocationWithinModule(context + ".get(" + i + ").getReason()");
            Reason reason = line.getReason();
            if (reason == null) {
                ok = false;
                this.handleProofCheckException(37110, "reason must not be empty", this.getCurrentContext());
                continue;
            }
            if (line.getLabel() != null && line.getLabel().length() > 0) {
                Integer n = (Integer)this.label2line.get(line.getLabel());
                if (n != null) {
                    ModuleContext lc = new ModuleContext(moduleContext.getModuleLocation(), moduleContext.getLocationWithinModule() + ".get(" + this.label2line.get(line.getLabel()) + ").getLabel()");
                    this.setLocationWithinModule(context + ".get(" + i + ").getLabel()");
                    this.handleProofCheckException(37150, "this proof line label exists already in this proof: " + line.getLabel(), this.getCurrentContext(), lc);
                }
                this.label2line.put(line.getLabel(), new Integer(i));
            }
            if ((getReason = ".get" + StringUtility.getClassName(reason.getClass())).endsWith("Vo")) {
                getReason = getReason.substring(0, getReason.length() - 2) + "()";
                this.setLocationWithinModule(context + ".get(" + i + ").getReason()" + getReason);
            }
            if (reason instanceof Add) {
                ok = this.check((Add)reason, i, line.getFormula().getElement());
            } else if (reason instanceof Rename) {
                ok = this.check((Rename)reason, i, line.getFormula().getElement());
            } else if (reason instanceof ModusPonens) {
                ok = this.check((ModusPonens)reason, i, line.getFormula().getElement());
            } else if (reason instanceof SubstFree) {
                ok = this.check((SubstFree)reason, i, line.getFormula().getElement());
            } else if (reason instanceof SubstPred) {
                ok = this.check((SubstPred)reason, i, line.getFormula().getElement());
            } else if (reason instanceof SubstFunc) {
                ok = this.check((SubstFunc)reason, i, line.getFormula().getElement());
            } else if (reason instanceof Universal) {
                ok = this.check((Universal)reason, i, line.getFormula().getElement());
            } else if (reason instanceof Existential) {
                ok = this.check((Existential)reason, i, line.getFormula().getElement());
            } else {
                ok = false;
                this.handleProofCheckException(37120, "this is no allowed basic rule: " + reason.getName(), this.getCurrentContext());
            }
            this.lineProved[i] = ok;
            if (i != proof.size() - 1 || ((Object)formula).equals(line.getFormula().getElement())) continue;
            this.handleProofCheckException(37200, "the last proof line must be identical to the proposition formula" + reason.getName(), this.getModuleContextOfProofLineFormula(i));
        }
        return this.exceptions;
    }

    private boolean check(Add add, int i, Element element) {
        Element current;
        String context = this.currentContext.getLocationWithinModule();
        boolean ok = true;
        if (add.getReference() == null) {
            ok = false;
            this.setLocationWithinModule(context + ".getReference()");
            this.handleProofCheckException(37220, "this is not a reference to a proved formula: ", this.getCurrentContext());
            return ok;
        }
        if (!this.resolver.isProvedFormula(add.getReference())) {
            ok = false;
            this.setLocationWithinModule(context + ".getReference()");
            this.handleProofCheckException(37130, "this is not a reference to a proved formula: " + add.getReference(), this.getCurrentContext());
            return ok;
        }
        Element expected = this.resolver.getNormalizedReferenceFormula(add.getReference());
        if (!EqualsUtility.equals(expected, current = this.resolver.getNormalizedFormula(element))) {
            ok = false;
            this.handleProofCheckException(37140, "this is not the expected part formula, please check with label: " + add.getReference(), this.getDiffModuleContextOfProofLineFormula(i, expected));
            return ok;
        }
        RuleKey defined = this.checker.getRule(add.getName());
        if (defined == null) {
            ok = false;
            this.handleProofCheckException(37420, "proof method was not defined yet: " + add.getName(), this.getCurrentContext());
            return ok;
        }
        if (!this.ruleVersion.equals(defined.getVersion())) {
            ok = false;
            this.handleProofCheckException(37430, "proof method is not supported for this proof checker: " + defined.getVersion(), this.getCurrentContext());
            return ok;
        }
        return ok;
    }

    private boolean check(Rename rename, int i, Element element) {
        String context = this.currentContext.getLocationWithinModule();
        boolean ok = true;
        Integer n = (Integer)this.label2line.get(rename.getReference());
        if (n == null) {
            ok = false;
            this.setLocationWithinModule(context + ".getReference()");
            this.handleProofCheckException(37160, "this proof line label dosn't (yet) exist in this proof: " + rename.getReference(), this.getCurrentContext());
        } else {
            Element current;
            Element f = this.getNormalizedProofLine(n);
            Element expected = FormulaUtility.replaceSubjectVariableQuantifier(rename.getOriginalSubjectVariable(), rename.getReplacementSubjectVariable(), f, rename.getOccurrence(), new Enumerator());
            if (!EqualsUtility.equals(expected, current = this.resolver.getNormalizedFormula(element))) {
                ok = false;
                this.handleProofCheckException(37140, "this is not the expected part formula, please check with label: " + rename.getReference(), this.getDiffModuleContextOfProofLineFormula(i, expected));
            } else {
                ok = true;
            }
        }
        RuleKey defined = this.checker.getRule(rename.getName());
        if (defined == null) {
            ok = false;
            this.handleProofCheckException(37420, "proof method was not defined yet: " + rename.getName(), this.getCurrentContext());
            return ok;
        }
        if (!this.ruleVersion.equals(defined.getVersion())) {
            ok = false;
            this.handleProofCheckException(37430, "proof method is not supported for this proof checker: " + defined.getVersion(), this.getCurrentContext());
            return ok;
        }
        return ok;
    }

    private boolean check(SubstFree substFree, int i, Element element) {
        String context = this.currentContext.getLocationWithinModule();
        boolean ok = true;
        Integer n = (Integer)this.label2line.get(substFree.getReference());
        if (n == null) {
            ok = false;
            this.setLocationWithinModule(context + ".getReference()");
            this.handleProofCheckException(37160, "this proof line label dosn't (yet) exist in this proof: " + substFree.getReference(), this.getCurrentContext());
        } else {
            Element expected;
            Element f = this.getNormalizedProofLine(n);
            Element current = this.resolver.getNormalizedFormula(element);
            if (!EqualsUtility.equals(current, expected = f.replace(substFree.getSubjectVariable(), this.resolver.getNormalizedFormula(substFree.getSubstituteTerm())))) {
                ok = false;
                this.handleProofCheckException(37140, "this is not the expected part formula, please check with label: " + substFree.getReference(), this.getDiffModuleContextOfProofLineFormula(i, expected));
                return ok;
            }
        }
        RuleKey defined = this.checker.getRule(substFree.getName());
        if (defined == null) {
            ok = false;
            this.handleProofCheckException(37420, "proof method was not defined yet: " + substFree.getName(), this.getCurrentContext());
            return ok;
        }
        if (!this.ruleVersion.equals(defined.getVersion())) {
            ok = false;
            this.handleProofCheckException(37430, "proof method is not supported for this proof checker: " + defined.getVersion(), this.getCurrentContext());
            return ok;
        }
        return ok;
    }

    private boolean check(SubstPred substPred, int i, Element element) {
        String context = this.currentContext.getLocationWithinModule();
        boolean ok = true;
        Integer n = (Integer)this.label2line.get(substPred.getReference());
        if (n == null) {
            ok = false;
            this.setLocationWithinModule(context + ".getReference()");
            this.handleProofCheckException(37160, "this proof line label dosn't (yet) exist in this proof: " + substPred.getReference(), this.getCurrentContext());
        } else {
            ElementSet betaFree;
            Element beta;
            Element alpha = this.getNormalizedProofLine(n);
            Element current = this.resolver.getNormalizedFormula(element);
            if (substPred.getSubstituteFormula() == null) {
                ok = false;
                this.handleProofCheckException(37210, "the substitution formula is missing", this.getCurrentContext());
                return ok;
            }
            Element p = this.resolver.getNormalizedFormula(substPred.getPredicateVariable());
            Element expected = FormulaUtility.replaceOperatorVariable(alpha, p, beta = this.resolver.getNormalizedFormula(substPred.getSubstituteFormula()));
            if (!EqualsUtility.equals(current, expected)) {
                ok = false;
                this.handleProofCheckException(37140, "this is not the expected part formula, please check with label: " + substPred.getReference(), this.getDiffModuleContextOfProofLineFormula(i, expected));
                return ok;
            }
            ElementSet predFree = FormulaUtility.getFreeSubjectVariables(p);
            if (predFree.size() != p.getList().size() - 1) {
                ok = false;
                this.setLocationWithinModule(context + ".getPredicateVariable()");
                this.handleProofCheckException(37240, "only free subject variables as parameters allowed", this.getDiffModuleContextOfProofLineFormula(i, expected));
                return ok;
            }
            for (int j = 1; j < p.getList().size(); ++j) {
                if (FormulaUtility.isSubjectVariable(p.getList().getElement(j))) continue;
                ok = false;
                this.setLocationWithinModule(context + ".getPredicateVariable()");
                this.handleProofCheckException(37240, "only free subject variables as parameters allowed", this.getCurrentContext());
                return ok;
            }
            ElementSet fBound = FormulaUtility.getBoundSubjectVariables(alpha);
            if (!fBound.intersection((betaFree = FormulaUtility.getFreeSubjectVariables(beta)).minus(predFree)).isEmpty()) {
                ok = false;
                this.setLocationWithinModule(context + ".getSubstituteFormula()");
                this.handleProofCheckException(37250, "free subject variables should not get bound during substitution", this.getCurrentContext());
                return ok;
            }
            ElementSet betaBound = FormulaUtility.getBoundSubjectVariables(beta);
            if (!FormulaUtility.testOperatorVariable(alpha, p, betaBound)) {
                ok = false;
                this.setLocationWithinModule(context + ".getSubstituteFormula()");
                this.handleProofCheckException(37260, "the substitution location contains subject variables that are bound within the replacement formula", this.getCurrentContext());
                return ok;
            }
        }
        RuleKey defined = this.checker.getRule(substPred.getName());
        if (defined == null) {
            ok = false;
            this.handleProofCheckException(37420, "proof method was not defined yet: " + substPred.getName(), this.getCurrentContext());
            return ok;
        }
        if (!this.ruleVersion.equals(defined.getVersion())) {
            ok = false;
            this.handleProofCheckException(37430, "proof method is not supported for this proof checker: " + defined.getVersion(), this.getCurrentContext());
            return ok;
        }
        return ok;
    }

    private boolean check(SubstFunc substFunc, int i, Element element) {
        String context = this.currentContext.getLocationWithinModule();
        boolean ok = true;
        Integer n = (Integer)this.label2line.get(substFunc.getReference());
        if (n == null) {
            ok = false;
            this.setLocationWithinModule(context + ".getReference()");
            this.handleProofCheckException(37160, "this proof line label dosn't (yet) exist in this proof: " + substFunc.getReference(), this.getCurrentContext());
        } else {
            ElementSet sigmaFree;
            Element tau;
            Element alpha = this.getNormalizedProofLine(n);
            Element current = this.resolver.getNormalizedFormula(element);
            if (substFunc.getSubstituteTerm() == null) {
                ok = false;
                this.handleProofCheckException(37210, "the substitution formula is missing", this.getCurrentContext());
                return ok;
            }
            Element sigma = this.resolver.getNormalizedFormula(substFunc.getFunctionVariable());
            Element expected = FormulaUtility.replaceOperatorVariable(alpha, sigma, tau = this.resolver.getNormalizedFormula(substFunc.getSubstituteTerm()));
            if (!EqualsUtility.equals(current, expected)) {
                ok = false;
                this.handleProofCheckException(37140, "this is not the expected part formula, please check with label: " + substFunc.getReference(), this.getDiffModuleContextOfProofLineFormula(i, expected));
                return ok;
            }
            ElementSet funcFree = FormulaUtility.getFreeSubjectVariables(sigma);
            if (funcFree.size() != sigma.getList().size() - 1) {
                ok = false;
                this.setLocationWithinModule(context + ".getPredicateVariable()");
                this.handleProofCheckException(37240, "only free subject variables as parameters allowed", this.getDiffModuleContextOfProofLineFormula(i, expected));
                return ok;
            }
            for (int j = 1; j < sigma.getList().size(); ++j) {
                if (FormulaUtility.isSubjectVariable(sigma.getList().getElement(j))) continue;
                ok = false;
                this.setLocationWithinModule(context + ".getPredicateVariable()");
                this.handleProofCheckException(37240, "only free subject variables as parameters allowed", this.getCurrentContext());
                return ok;
            }
            ElementSet fBound = FormulaUtility.getBoundSubjectVariables(alpha);
            if (!fBound.intersection((sigmaFree = FormulaUtility.getFreeSubjectVariables(tau)).minus(funcFree)).isEmpty()) {
                ok = false;
                this.setLocationWithinModule(context + ".getSubstituteFormula()");
                this.handleProofCheckException(37250, "free subject variables should not get bound during substitution", this.getCurrentContext());
                return ok;
            }
            ElementSet sigmaBound = FormulaUtility.getBoundSubjectVariables(tau);
            if (!FormulaUtility.testOperatorVariable(alpha, sigma, sigmaBound)) {
                ok = false;
                this.setLocationWithinModule(context + ".getSubstituteFormula()");
                this.handleProofCheckException(37260, "the substitution location contains subject variables that are bound within the replacement formula", this.getCurrentContext());
                return ok;
            }
        }
        RuleKey defined = this.checker.getRule(substFunc.getName());
        if (defined == null) {
            ok = false;
            this.handleProofCheckException(37420, "proof method was not defined yet: " + substFunc.getName(), this.getCurrentContext());
            return ok;
        }
        if (!this.ruleVersion.equals(defined.getVersion())) {
            ok = false;
            this.handleProofCheckException(37430, "proof method is not supported for this proof checker: " + defined.getVersion(), this.getCurrentContext());
            return ok;
        }
        return ok;
    }

    private boolean check(ModusPonens mp, int i, Element element) {
        RuleKey defined;
        Integer n2;
        String context = this.currentContext.getLocationWithinModule();
        boolean ok = true;
        Integer n1 = (Integer)this.label2line.get(mp.getReference1());
        if (n1 == null) {
            ok = false;
            this.setLocationWithinModule(context + ".getReference1()");
            this.handleProofCheckException(37160, "this proof line label dosn't (yet) exist in this proof: " + mp.getReference1(), this.getCurrentContext());
        }
        if ((n2 = (Integer)this.label2line.get(mp.getReference2())) == null) {
            ok = false;
            this.setLocationWithinModule(context + ".getReference2()");
            this.handleProofCheckException(37160, "this proof line label dosn't (yet) exist in this proof: " + mp.getReference2(), this.getCurrentContext());
        }
        if (ok) {
            Element f1 = this.getNormalizedProofLine(n1);
            Element f2 = this.getNormalizedProofLine(n2);
            Element current = this.getNormalizedProofLine(i);
            if (!FormulaUtility.isImplication(f1)) {
                ok = false;
                this.setLocationWithinModule(context + ".getReference1()");
                this.handleProofCheckException(37170, "this proof line label must point to an implication (with two arguments): " + mp.getReference1(), this.getCurrentContext());
            } else if (!((Object)f2).equals(f1.getList().getElement(0))) {
                ok = false;
                this.setLocationWithinModule(context + ".getReference2()");
                this.handleProofCheckException(37180, "this proof line label must be the hypothesis for the first reference: " + mp.getReference2(), this.getCurrentContext(), this.getModuleContextOfProofLineFormula(n1));
            } else if (!((Object)current).equals(f1.getList().getElement(1))) {
                ok = false;
                this.setLocationWithinModule(context + ".getReference1()");
                this.handleProofCheckException(37190, "this proof line must be the conclusion of the first reference: " + mp.getReference1(), this.getCurrentContext(), this.getModuleContextOfProofLineFormula(n1));
            } else {
                ok = true;
            }
        }
        if ((defined = this.checker.getRule(mp.getName())) == null) {
            ok = false;
            this.handleProofCheckException(37420, "proof method was not defined yet: " + mp.getName(), this.getCurrentContext());
            return ok;
        }
        if (!this.ruleVersion.equals(defined.getVersion())) {
            ok = false;
            this.handleProofCheckException(37430, "proof method is not supported for this proof checker: " + defined.getVersion(), this.getCurrentContext());
            return ok;
        }
        return ok;
    }

    private boolean check(Universal universal, int i, Element element) {
        String context = this.currentContext.getLocationWithinModule();
        boolean ok = true;
        Integer n = (Integer)this.label2line.get(universal.getReference());
        if (n == null) {
            ok = false;
            this.setLocationWithinModule(context + ".getReference()");
            this.handleProofCheckException(37160, "this proof line label dosn't (yet) exist in this proof: " + universal.getReference(), this.getCurrentContext());
        } else {
            Element f = this.getNormalizedProofLine(n);
            Element current = this.resolver.getNormalizedFormula(element);
            if (!FormulaUtility.isImplication(f)) {
                ok = false;
                this.setLocationWithinModule(context + ".getReference()");
                this.handleProofCheckException(37170, "this proof line label must point to an implication (with two arguments): " + universal.getReference(), this.getCurrentContext());
                return ok;
            }
            if (!FormulaUtility.isSubjectVariable(universal.getSubjectVariable())) {
                ok = false;
                this.setLocationWithinModule(context + ".getSubjectVariable()");
                this.handleProofCheckException(37270, "subject variable is missing", this.getCurrentContext());
                return ok;
            }
            DefaultElementList expected = new DefaultElementList("IMPL");
            expected.add(f.getList().getElement(0));
            DefaultElementList uni = new DefaultElementList("FORALL");
            uni.add(universal.getSubjectVariable());
            uni.add(f.getList().getElement(1));
            expected.add(uni);
            if (!EqualsUtility.equals(current, expected)) {
                ok = false;
                this.handleProofCheckException(37140, "this is not the expected part formula, please check with label: " + universal.getReference(), this.getDiffModuleContextOfProofLineFormula(i, expected));
                return ok;
            }
        }
        RuleKey defined = this.checker.getRule(universal.getName());
        if (defined == null) {
            ok = false;
            this.handleProofCheckException(37420, "proof method was not defined yet: " + universal.getName(), this.getCurrentContext());
            return ok;
        }
        if (!this.ruleVersion.equals(defined.getVersion())) {
            ok = false;
            this.handleProofCheckException(37430, "proof method is not supported for this proof checker: " + defined.getVersion(), this.getCurrentContext());
            return ok;
        }
        return ok;
    }

    private boolean check(Existential existential, int i, Element element) {
        String context = this.currentContext.getLocationWithinModule();
        boolean ok = true;
        Integer n = (Integer)this.label2line.get(existential.getReference());
        if (n == null) {
            ok = false;
            this.setLocationWithinModule(context + ".getReference()");
            this.handleProofCheckException(37160, "this proof line label dosn't (yet) exist in this proof: " + existential.getReference(), this.getCurrentContext());
        } else {
            Element f = this.getNormalizedProofLine(n);
            Element current = this.resolver.getNormalizedFormula(element);
            if (!FormulaUtility.isImplication(f)) {
                ok = false;
                this.setLocationWithinModule(context + ".getReference()");
                this.handleProofCheckException(37170, "this proof line label must point to an implication (with two arguments): " + existential.getReference(), this.getCurrentContext());
                return ok;
            }
            if (!FormulaUtility.isSubjectVariable(existential.getSubjectVariable())) {
                ok = false;
                this.setLocationWithinModule(context + ".getSubjectVariable()");
                this.handleProofCheckException(37270, "subject variable is missing", this.getCurrentContext());
                return ok;
            }
            DefaultElementList expected = new DefaultElementList(f.getList().getOperator());
            DefaultElementList exi = new DefaultElementList("EXISTS");
            exi.add(existential.getSubjectVariable());
            exi.add(f.getList().getElement(0));
            expected.add(exi);
            expected.add(f.getList().getElement(1));
            if (!EqualsUtility.equals(current, expected)) {
                ok = false;
                this.handleProofCheckException(37140, "this is not the expected part formula, please check with label: " + existential.getReference(), this.getDiffModuleContextOfProofLineFormula(i, expected));
                return ok;
            }
        }
        RuleKey defined = this.checker.getRule(existential.getName());
        if (defined == null) {
            ok = false;
            this.handleProofCheckException(37420, "proof method was not defined yet: " + existential.getName(), this.getCurrentContext());
            return ok;
        }
        if (!this.ruleVersion.equals(defined.getVersion())) {
            ok = false;
            this.handleProofCheckException(37430, "proof method is not supported for this proof checker: " + defined.getVersion(), this.getCurrentContext());
            return ok;
        }
        return ok;
    }

    private ModuleContext getModuleContextOfProofLineFormula(int i) {
        return new ModuleContext(this.moduleContext.getModuleLocation(), this.moduleContext.getLocationWithinModule() + ".get(" + i + ").getFormula().getElement()");
    }

    private ModuleContext getDiffModuleContextOfProofLineFormula(int i, Element expected) {
        String diff = FormulaUtility.getDifferenceLocation(this.proof.get(i).getFormula().getElement(), expected);
        return new ModuleContext(this.moduleContext.getModuleLocation(), this.moduleContext.getLocationWithinModule() + ".get(" + i + ").getFormula().getElement()" + diff);
    }

    private Element getNormalizedProofLine(Integer n) {
        if (n == null) {
            return null;
        }
        return this.getNormalizedProofLine((int)n);
    }

    private Element getNormalizedProofLine(int i) {
        if (i < 0 || i >= this.proof.size()) {
            return null;
        }
        return this.resolver.getNormalizedFormula(this.proof.get(i).getFormula().getElement());
    }

    private void handleProofCheckException(int code, String msg, ModuleContext context) {
        ProofCheckException ex = new ProofCheckException(code, msg, context);
        this.exceptions.add(ex);
    }

    private void handleProofCheckException(int code, String msg, ModuleContext context, ModuleContext referenceContext) {
        ProofCheckException ex = new ProofCheckException(code, msg, null, context, referenceContext);
        this.exceptions.add(ex);
    }

    protected void setLocationWithinModule(String locationWithinModule) {
        this.getCurrentContext().setLocationWithinModule(locationWithinModule);
    }

    protected final ModuleContext getCurrentContext() {
        return this.currentContext;
    }
}

