/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.logic.model;

import java.util.ArrayList;
import java.util.List;
import org.qedeq.base.utility.Enumerator;
import org.qedeq.kernel.bo.logic.model.Model;
import org.qedeq.kernel.bo.logic.model.Predicate;
import org.qedeq.kernel.bo.logic.model.PredicateVariable;

public final class PredicateVariableInterpreter {
    private List predicateVariables;
    private List predicateVariableCounters;
    private Model model;

    public PredicateVariableInterpreter(Model model) {
        this.model = model;
        this.predicateVariables = new ArrayList();
        this.predicateVariableCounters = new ArrayList();
    }

    private int getPredicateVariableSelection(PredicateVariable var) {
        int selection;
        if (this.predicateVariables.contains(var)) {
            int index = this.predicateVariables.indexOf(var);
            selection = ((Enumerator)this.predicateVariableCounters.get(index)).getNumber();
        } else {
            selection = 0;
            this.predicateVariables.add(var);
            this.predicateVariableCounters.add(new Enumerator());
        }
        return selection;
    }

    public Predicate getPredicate(PredicateVariable var) {
        return this.model.getPredicate(var.getArgumentNumber(), this.getPredicateVariableSelection(var));
    }

    public boolean next() {
        boolean next = true;
        for (int i = this.predicateVariables.size() - 1; i >= -1; --i) {
            if (i < 0) {
                next = false;
                break;
            }
            PredicateVariable var = (PredicateVariable)this.predicateVariables.get(i);
            Enumerator number = (Enumerator)this.predicateVariableCounters.get(i);
            if (number.getNumber() + 1 < this.model.getPredicateSize(var.getArgumentNumber())) {
                number.increaseNumber();
                break;
            }
            number.reset();
        }
        return next;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("predicate variables {");
        for (int i = 0; i < this.predicateVariables.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            PredicateVariable var = (PredicateVariable)this.predicateVariables.get(i);
            buffer.append(this.predicateVariables.get(i));
            buffer.append("=");
            buffer.append(this.getPredicate(var));
        }
        buffer.append("}");
        return buffer.toString();
    }

    public void clear() {
        this.predicateVariables.clear();
        this.predicateVariableCounters.clear();
    }
}

