/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.logic.model;

import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.kernel.bo.logic.model.Entity;

public abstract class Predicate {
    private static final Class CLASS = Predicate.class;
    private final int minimum;
    private final int maximum;
    private final String display;
    private final String description;

    public Predicate(int minimum, int maximum, String display, String description) {
        this.minimum = minimum;
        this.maximum = maximum;
        this.display = display;
        this.description = description;
    }

    public static Predicate not(final Predicate predicate) {
        return new Predicate(predicate.getMinimumArgumentNumber(), predicate.getMaximumArgumentNumber(), "!" + predicate.toString(), "!" + predicate.getDescription()){

            public boolean calculate(Entity[] entities) {
                String method = "not.calculate(Entity[])";
                if (Trace.isDebugEnabled(CLASS)) {
                    Trace.param(CLASS, "not.calculate(Entity[])", "toString", this.toString());
                    Trace.param(CLASS, "not.calculate(Entity[])", "entities", StringUtility.toString(entities));
                }
                boolean result = !predicate.calculate(entities);
                Trace.param(CLASS, "not.calculate(Entity[])", "result  ", result);
                return result;
            }
        };
    }

    public static Predicate and(final Predicate op1, final Predicate op2) {
        if (op1.getMinimumArgumentNumber() > op2.getMaximumArgumentNumber() || op1.getMaximumArgumentNumber() < op2.getMinimumArgumentNumber()) {
            throw new IllegalArgumentException("Predicates can not be combined " + op1 + " and " + op2);
        }
        return new Predicate(Math.max(op1.getMinimumArgumentNumber(), op2.getMinimumArgumentNumber()), Math.min(op1.getMaximumArgumentNumber(), op2.getMaximumArgumentNumber()), op1.toString() + " and " + op2.toString(), op1.getDescription() + " and " + op2.getDescription()){

            public boolean calculate(Entity[] entities) {
                String method = "and.calculate(Entity[])";
                if (Trace.isDebugEnabled(CLASS)) {
                    Trace.param(CLASS, "and.calculate(Entity[])", "toString", this.toString());
                    Trace.param(CLASS, "and.calculate(Entity[])", "entities", StringUtility.toString(entities));
                }
                boolean result = op1.calculate(entities) && op2.calculate(entities);
                Trace.param(CLASS, "and.calculate(Entity[])", "result  ", result);
                return result;
            }
        };
    }

    public static Predicate or(final Predicate op1, final Predicate op2) {
        if (op1.getMinimumArgumentNumber() > op2.getMaximumArgumentNumber() || op1.getMaximumArgumentNumber() < op2.getMinimumArgumentNumber()) {
            throw new IllegalArgumentException("Predicates can not be combined " + op1 + " and " + op2);
        }
        return new Predicate(Math.max(op1.getMinimumArgumentNumber(), op2.getMinimumArgumentNumber()), Math.min(op1.getMaximumArgumentNumber(), op2.getMaximumArgumentNumber()), op1.toString() + " or " + op2.toString(), op1.getDescription() + " or " + op2.getDescription()){

            public boolean calculate(Entity[] entities) {
                String method = "or.calculate(Entity[])";
                if (Trace.isDebugEnabled(CLASS)) {
                    Trace.param(CLASS, "or.calculate(Entity[])", "toString", this.toString());
                    Trace.param(CLASS, "or.calculate(Entity[])", "entities", StringUtility.toString(entities));
                }
                if (Trace.isDebugEnabled(CLASS)) {
                    Trace.param(CLASS, "or.calculate(Entity[])", "toString", this.toString());
                    Trace.param(CLASS, "or.calculate(Entity[])", "entities", StringUtility.toString(entities));
                }
                boolean result = op1.calculate(entities) || op2.calculate(entities);
                Trace.param(CLASS, "or.calculate(Entity[])", "result  ", result);
                return result;
            }
        };
    }

    public static Predicate isEntity(final Entity entity) {
        return new Predicate(1, 99, "=" + entity, "= " + entity.getDescription()){

            public boolean calculate(Entity[] entities) {
                String method = "isEntity.calculate(Entity[])";
                if (Trace.isDebugEnabled(CLASS)) {
                    Trace.param(CLASS, "isEntity.calculate(Entity[])", "toString", this.toString());
                    Trace.param(CLASS, "isEntity.calculate(Entity[])", "entities", StringUtility.toString(entities));
                }
                if (Trace.isDebugEnabled(CLASS)) {
                    Trace.param(CLASS, "isEntity.calculate(Entity[])", "toString", this.toString());
                    Trace.param(CLASS, "isEntity.calculate(Entity[])", "entities", StringUtility.toString(entities));
                }
                boolean result = true;
                for (int i = 0; i < entities.length; ++i) {
                    result &= entity.getValue() == entities[i].getValue();
                }
                Trace.param(CLASS, "isEntity.calculate(Entity[])", "result  ", result);
                return result;
            }
        };
    }

    public int getMinimumArgumentNumber() {
        return this.minimum;
    }

    public int getMaximumArgumentNumber() {
        return this.maximum;
    }

    public String toString() {
        return this.display;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract boolean calculate(Entity[] var1);
}

