/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.logic.model;

import org.qedeq.base.utility.EqualsUtility;

public abstract class Operator {
    private final String name;
    private final int number;

    public Operator(String name, int number) {
        this.name = name;
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public int getArgumentNumber() {
        return this.number;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.number ^ this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Operator)) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        Operator var = (Operator)other;
        return this.number == var.number && EqualsUtility.equals(this.name, var.name);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.name);
        if (this.number > 0) {
            buffer.append("(");
            for (int i = 0; i < this.number; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append("*");
            }
            buffer.append(")");
        }
        return buffer.toString();
    }
}

