/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.logic.model;

import java.util.ArrayList;
import java.util.List;
import org.qedeq.base.utility.Enumerator;
import org.qedeq.kernel.bo.logic.model.Function;
import org.qedeq.kernel.bo.logic.model.FunctionVariable;
import org.qedeq.kernel.bo.logic.model.Model;

public final class FunctionVariableInterpreter {
    private Model model;
    private List functionVariables;
    private List functionVariableCounters;

    public FunctionVariableInterpreter(Model model) {
        this.model = model;
        this.functionVariables = new ArrayList();
        this.functionVariableCounters = new ArrayList();
    }

    private int getFunctionVariableSelection(FunctionVariable var) {
        int selection;
        if (this.functionVariables.contains(var)) {
            int index = this.functionVariables.indexOf(var);
            selection = ((Enumerator)this.functionVariableCounters.get(index)).getNumber();
        } else {
            selection = 0;
            this.functionVariables.add(var);
            this.functionVariableCounters.add(new Enumerator());
        }
        return selection;
    }

    public Function getFunction(FunctionVariable var) {
        return this.model.getFunction(var.getArgumentNumber(), this.getFunctionVariableSelection(var));
    }

    public boolean next() {
        boolean next = true;
        for (int i = this.functionVariables.size() - 1; i >= -1; --i) {
            if (i < 0) {
                next = false;
                break;
            }
            FunctionVariable var = (FunctionVariable)this.functionVariables.get(i);
            Enumerator number = (Enumerator)this.functionVariableCounters.get(i);
            if (number.getNumber() + 1 < this.model.getFunctionSize(var.getArgumentNumber())) {
                number.increaseNumber();
                break;
            }
            number.reset();
        }
        return next;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("function variables {");
        for (int i = 0; i < this.functionVariables.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            FunctionVariable var = (FunctionVariable)this.functionVariables.get(i);
            buffer.append(this.functionVariables.get(i));
            buffer.append("=");
            buffer.append(this.getFunction(var));
        }
        buffer.append("}");
        return buffer.toString();
    }

    public void clear() {
        this.functionVariables.clear();
        this.functionVariableCounters.clear();
    }
}

