/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.logic.model;

import org.qedeq.kernel.bo.logic.model.DynamicModel;
import org.qedeq.kernel.bo.logic.model.Entity;
import org.qedeq.kernel.bo.logic.model.Function;
import org.qedeq.kernel.bo.logic.model.ModelPredicateConstant;
import org.qedeq.kernel.bo.logic.model.Predicate;

public final class FourDynamicModel
extends DynamicModel {
    public static final Entity ZERO = new Entity(0, "{}", "{} or empty set");
    public static final Entity ONE = new Entity(1, "{{}}", "{{}} or 1");
    public static final Entity TWO = new Entity(2, "{{}, {{}}}", "{{}, {{}}} or 2");
    public static final Entity THREE = new Entity(3, "{{{}}}", "{{{}}} or 3");
    public static final Function FUNCTION_ZERO = Function.createConstant(ZERO);
    public static final Function FUNCTION_ONE = Function.createConstant(ONE);
    public static final Function FUNCTION_TWO = Function.createConstant(TWO);
    public static final Function FUNCTION_THREE = Function.createConstant(THREE);
    public static final Predicate IS_ZERO = Predicate.isEntity(ZERO);
    public static final Predicate IS_ONE = Predicate.isEntity(ONE);
    public static final Predicate IS_TWO = Predicate.isEntity(TWO);
    public static final Predicate IS_THREE = Predicate.isEntity(THREE);
    private final Function functionModulo3 = new Function(0, 99, "% 3", "modulo 3"){

        public Entity map(Entity[] entities) {
            int result = 0;
            for (int i = 0; i < entities.length; ++i) {
                result += entities[i].getValue() % 3;
            }
            return FourDynamicModel.this.getEntity(result %= 3);
        }
    };
    private final Function functionPlus1Modulo3 = new Function(0, 99, "+1 % 3", "plus 1 modulo 3"){

        public Entity map(Entity[] entities) {
            int result = 1;
            for (int i = 0; i < entities.length; ++i) {
                result += entities[i].getValue() % 3;
            }
            return FourDynamicModel.this.getEntity(result %= 3);
        }
    };

    public FourDynamicModel() {
        super("four elements");
        this.addEntity(ZERO);
        this.addEntity(ONE);
        this.addEntity(TWO);
        this.addEntity(THREE);
        this.addFunction(0, FUNCTION_ZERO);
        this.addFunction(0, FUNCTION_ONE);
        this.addFunction(0, FUNCTION_TWO);
        this.addFunction(0, FUNCTION_THREE);
        this.addFunction(1, FUNCTION_ZERO);
        this.addFunction(1, FUNCTION_ONE);
        this.addFunction(0, FUNCTION_TWO);
        this.addFunction(0, FUNCTION_THREE);
        this.addFunction(1, this.functionModulo3);
        this.addFunction(1, this.functionPlus1Modulo3);
        this.addFunction(2, FUNCTION_ZERO);
        this.addFunction(2, FUNCTION_ONE);
        this.addFunction(0, FUNCTION_TWO);
        this.addFunction(0, FUNCTION_THREE);
        this.addFunction(2, this.functionModulo3);
        this.addFunction(2, this.functionPlus1Modulo3);
        this.addPredicate(0, FALSE);
        this.addPredicate(0, TRUE);
        this.addPredicate(1, FALSE);
        this.addPredicate(1, TRUE);
        this.addPredicate(1, EVEN);
        this.addPredicate(1, IS_ZERO);
        this.addPredicate(1, IS_ONE);
        this.addPredicate(1, IS_TWO);
        this.addPredicate(1, IS_THREE);
        this.addPredicate(2, FALSE);
        this.addPredicate(2, TRUE);
        this.addPredicate(2, EVEN);
        this.addPredicate(2, LESS);
        this.addPredicate(2, EQUAL);
        this.addPredicate(2, IS_ZERO);
        this.addPredicate(2, IS_ONE);
        this.addPredicate(2, IS_TWO);
        this.addPredicate(2, IS_THREE);
        this.addPredicateConstant(new ModelPredicateConstant("in", 2), new Predicate(2, 2, "in", "Element of"){

            public boolean calculate(Entity[] entities) {
                if (entities.length != 2) {
                    return false;
                }
                int element = entities[0].getValue();
                switch (entities[1].getValue()) {
                    case 0: {
                        return false;
                    }
                    case 1: {
                        return element == 0;
                    }
                    case 2: {
                        return element < 2;
                    }
                    case 3: {
                        return element == 1;
                    }
                }
                return false;
            }
        });
    }

    public String getDescription() {
        return "This model has four entities: {}, {{}}, {{}, {{}}}, {{{}}}.";
    }

    public Entity comprehension(Entity[] array) {
        Entity result = ZERO;
        block6: for (int i = 0; i < array.length; ++i) {
            int element = array[i].getValue();
            switch (result.getValue()) {
                case 0: {
                    if (element == 0) {
                        result = ONE;
                        continue block6;
                    }
                    if (element != 1) continue block6;
                    result = THREE;
                    continue block6;
                }
                case 1: {
                    if (element != 1) continue block6;
                    result = TWO;
                    continue block6;
                }
                case 2: {
                    continue block6;
                }
                case 3: {
                    if (element != 0) continue block6;
                    result = TWO;
                    continue block6;
                }
                default: {
                    throw new RuntimeException("unknown value for entity " + array[i]);
                }
            }
        }
        return result;
    }
}

