/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.logic.common;

import java.util.ArrayList;
import java.util.List;
import org.qedeq.base.utility.EqualsUtility;
import org.qedeq.kernel.bo.logic.common.PredicateKey;
import org.qedeq.kernel.bo.logic.common.SubjectVariable;
import org.qedeq.kernel.se.base.list.ElementList;
import org.qedeq.kernel.se.common.ModuleContext;

public final class PredicateConstant {
    private final PredicateKey key;
    private final ElementList completeFormula;
    private final ModuleContext context;
    private final ElementList predicate;
    private final ElementList definingFormula;
    private final List subjectVariables;

    public PredicateConstant(PredicateKey key, ElementList completeFormula, ModuleContext context) {
        this.key = key;
        this.completeFormula = completeFormula;
        this.context = new ModuleContext(context);
        ElementList list = completeFormula.getList();
        this.predicate = list.getElement(0).getList();
        this.definingFormula = list.getElement(1).getList();
        this.subjectVariables = new ArrayList(this.predicate.size() - 1);
        for (int i = 0; i < this.predicate.size() - 1; ++i) {
            this.subjectVariables.add(new SubjectVariable(this.predicate.getElement(i + 1).getList().getElement(0).getAtom().getString()));
        }
    }

    public PredicateKey getKey() {
        return this.key;
    }

    public String getName() {
        return this.key.getName();
    }

    public String getArguments() {
        return this.key.getArguments();
    }

    public ElementList getCompleteFormula() {
        return this.completeFormula;
    }

    public ModuleContext getContext() {
        return this.context;
    }

    public ElementList getPredicate() {
        return this.predicate;
    }

    public List getSubjectVariables() {
        return this.subjectVariables;
    }

    public ElementList getDefiningFormula() {
        return this.definingFormula;
    }

    public int hashCode() {
        return (this.getKey() != null ? this.getKey().hashCode() : 0) ^ (this.getCompleteFormula() != null ? this.getCompleteFormula().hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PredicateConstant)) {
            return false;
        }
        PredicateConstant other = (PredicateConstant)obj;
        return EqualsUtility.equals(this.getKey(), other.getKey()) && EqualsUtility.equals(this.getCompleteFormula(), other.getCompleteFormula());
    }

    public String toString() {
        return this.getName() + "[" + this.getArguments() + "]";
    }
}

