/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.logic.common;

import org.qedeq.base.utility.Enumerator;
import org.qedeq.base.utility.EqualsUtility;
import org.qedeq.kernel.bo.logic.common.Operators;
import org.qedeq.kernel.se.base.list.Atom;
import org.qedeq.kernel.se.base.list.Element;
import org.qedeq.kernel.se.base.list.ElementList;
import org.qedeq.kernel.se.dto.list.DefaultAtom;
import org.qedeq.kernel.se.dto.list.DefaultElementList;
import org.qedeq.kernel.se.dto.list.ElementSet;

public final class FormulaUtility
implements Operators {
    private FormulaUtility() {
    }

    public static final boolean isSubjectVariable(Element element) {
        if (element == null || !element.isList() || element.getList() == null) {
            return false;
        }
        ElementList list = element.getList();
        if (list.getOperator().equals("VAR")) {
            if (list.size() != 1) {
                return false;
            }
            Element first = element.getList().getElement(0);
            if (first == null || !first.isAtom() || first.getAtom() == null) {
                return false;
            }
            Atom atom = first.getAtom();
            return atom.getString() != null && atom.getAtom().getString() != null && atom.getString().length() != 0;
        }
        return false;
    }

    public static final boolean isPredicateVariable(Element element) {
        return FormulaUtility.isOperator("PREDVAR", element);
    }

    public static final boolean isPropositionVariable(Element element) {
        return FormulaUtility.isOperator("PREDVAR", element) && element.getList().size() <= 1;
    }

    public static final boolean isFunctionVariable(Element element) {
        return FormulaUtility.isOperator("FUNVAR", element);
    }

    public static final boolean isPredicateConstant(Element element) {
        return FormulaUtility.isOperator("PREDCON", element);
    }

    public static final boolean isFunctionConstant(Element element) {
        return FormulaUtility.isOperator("FUNCON", element);
    }

    public static boolean isOperator(String operator, Element element) {
        return FormulaUtility.isOperator(operator, element, 0);
    }

    private static boolean isOperator(String operator, Element element, int minArguments) {
        if (element == null || !element.isList() || element.getList() == null) {
            return false;
        }
        ElementList list = element.getList();
        if (list.getOperator().equals(operator)) {
            if (list.size() < 1 + minArguments) {
                return false;
            }
            Element first = element.getList().getElement(0);
            if (first == null || !first.isAtom() || first.getAtom() == null) {
                return false;
            }
            Atom atom = first.getAtom();
            return atom.getString() != null && atom.getAtom().getString() != null && atom.getString().length() != 0;
        }
        return false;
    }

    public static final ElementSet getFreeSubjectVariables(Element element) {
        ElementSet free = new ElementSet();
        if (FormulaUtility.isSubjectVariable(element)) {
            free.add(element);
        } else if (element.isList()) {
            ElementList list = element.getList();
            if (FormulaUtility.isBindingOperator(list)) {
                for (int i = 1; i < list.size(); ++i) {
                    free.union(FormulaUtility.getFreeSubjectVariables(list.getElement(i)));
                }
                free.remove(list.getElement(0));
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    free.union(FormulaUtility.getFreeSubjectVariables(list.getElement(i)));
                }
            }
        }
        return free;
    }

    public static final ElementSet getBoundSubjectVariables(Element element) {
        ElementSet bound;
        block4: {
            bound = new ElementSet();
            if (!element.isList()) break block4;
            ElementList list = element.getList();
            if (FormulaUtility.isBindingOperator(list)) {
                bound.add(list.getElement(0));
                for (int i = 1; i < list.size(); ++i) {
                    bound.union(FormulaUtility.getBoundSubjectVariables(list.getElement(i)));
                }
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    bound.union(FormulaUtility.getBoundSubjectVariables(list.getElement(i)));
                }
            }
        }
        return bound;
    }

    public static final ElementSet getSubjectVariables(Element element) {
        ElementSet all = new ElementSet();
        if (FormulaUtility.isSubjectVariable(element)) {
            all.add(element);
        } else if (element.isList()) {
            ElementList list = element.getList();
            for (int i = 1; i < list.size(); ++i) {
                all.union(FormulaUtility.getSubjectVariables(list.getElement(i)));
            }
        }
        return all;
    }

    public static final ElementSet getPredicateVariables(Element element) {
        ElementSet all = new ElementSet();
        if (FormulaUtility.isPredicateVariable(element)) {
            ElementList pred = element.getList();
            DefaultElementList normalized = new DefaultElementList(pred.getOperator());
            normalized.add(pred.getElement(0));
            for (int i = 1; i < pred.size(); ++i) {
                normalized.add(FormulaUtility.createSubjectVariable("x_" + i));
            }
            all.add(normalized);
        } else if (element.isList()) {
            ElementList list = element.getList();
            for (int i = 0; i < list.size(); ++i) {
                all.union(FormulaUtility.getPredicateVariables(list.getElement(i)));
            }
        }
        return all;
    }

    public static final ElementSet getPropositionVariables(Element element) {
        ElementSet all = new ElementSet();
        if (FormulaUtility.isPropositionVariable(element)) {
            all.add(element);
        } else if (element.isList()) {
            ElementList list = element.getList();
            for (int i = 0; i < list.size(); ++i) {
                all.union(FormulaUtility.getPropositionVariables(list.getElement(i)));
            }
        }
        return all;
    }

    public static final ElementSet getPartFormulas(Element element) {
        ElementSet all;
        block5: {
            ElementList list;
            block8: {
                block7: {
                    block6: {
                        block4: {
                            all = new ElementSet();
                            if (element == null || element.isAtom()) {
                                return all;
                            }
                            list = element.getList();
                            if (!FormulaUtility.isPredicateVariable(list)) break block4;
                            all.add(element);
                            break block5;
                        }
                        if (!FormulaUtility.isPredicateConstant(list)) break block6;
                        all.add(list);
                        break block5;
                    }
                    if (!"AND".equals(list.getOperator()) && !"OR".equals(list.getOperator()) && !"NOT".equals(list.getOperator()) && !"IMPL".equals(list.getOperator()) && !"EQUI".equals(list.getOperator())) break block7;
                    all.add(list);
                    for (int i = 0; i < list.size(); ++i) {
                        all.union(FormulaUtility.getPartFormulas(list.getElement(i)));
                    }
                    break block5;
                }
                if (!FormulaUtility.isBindingOperator(list)) break block8;
                all.add(list);
                for (int i = 0; i < list.size(); ++i) {
                    all.union(FormulaUtility.getPartFormulas(list.getElement(i)));
                }
                break block5;
            }
            if (FormulaUtility.isSubjectVariable(list) || FormulaUtility.isFunctionVariable(list) || FormulaUtility.isFunctionConstant(list)) break block5;
            for (int i = 0; i < list.size(); ++i) {
                all.union(FormulaUtility.getPartFormulas(list.getElement(i)));
            }
        }
        return all;
    }

    public static boolean isBindingOperator(ElementList list) {
        String operator = list.getOperator();
        if (operator == null || list.size() <= 0 || !FormulaUtility.isSubjectVariable(list.getElement(0))) {
            return false;
        }
        return operator.equals("EXISTS") || operator.equals("EXISTSU") || operator.equals("FORALL") || operator.equals("CLASS");
    }

    public static String getDifferenceLocation(Element first, Element second) {
        StringBuffer diff = new StringBuffer();
        FormulaUtility.equal(diff, first, second);
        return diff.toString();
    }

    private static boolean equal(StringBuffer firstContext, Element first, Element second) {
        if (first == null) {
            return second == null;
        }
        if (second == null) {
            return false;
        }
        if (first.isAtom()) {
            if (!second.isAtom()) {
                return false;
            }
            return EqualsUtility.equals(first.getAtom().getString(), second.getAtom().getString());
        }
        if (second.isAtom()) {
            return false;
        }
        if (!EqualsUtility.equals(first.getList().getOperator(), second.getList().getOperator())) {
            return false;
        }
        if (first.getList().size() != second.getList().size()) {
            return false;
        }
        for (int i = 0; i < first.getList().size(); ++i) {
            int length = firstContext.length();
            firstContext.append(".getList().getElement(" + i + ")");
            if (!FormulaUtility.equal(firstContext, first.getList().getElement(i), second.getList().getElement(i))) {
                return false;
            }
            firstContext.setLength(length);
        }
        return true;
    }

    public static Element replaceSubjectVariableQuantifier(Element originalSubjectVariable, Element replacementSubjectVariable, Element formulaElement, int occurrenceGoal, Enumerator occurreneCurrent) {
        if (formulaElement.isAtom()) {
            return formulaElement;
        }
        ElementList formula = formulaElement.getList();
        if (occurreneCurrent.getNumber() > occurrenceGoal) {
            return formula.copy();
        }
        DefaultElementList result = new DefaultElementList(formula.getOperator());
        if (FormulaUtility.isBindingOperator(formula) && ((Object)formula.getElement(0)).equals(originalSubjectVariable)) {
            occurreneCurrent.increaseNumber();
            if (occurrenceGoal == occurreneCurrent.getNumber()) {
                return formula.replace(originalSubjectVariable, replacementSubjectVariable);
            }
        }
        for (int i = 0; i < formula.size(); ++i) {
            result.add(FormulaUtility.replaceSubjectVariableQuantifier(originalSubjectVariable, replacementSubjectVariable, formula.getElement(i), occurrenceGoal, occurreneCurrent));
        }
        return result;
    }

    public static Element replaceOperatorVariable(Element formula, Element operatorVariable, Element replacement) {
        if (formula == null || operatorVariable == null || replacement == null || formula.isAtom() || operatorVariable.isAtom() || replacement.isAtom()) {
            return formula;
        }
        ElementList f = formula.getList();
        ElementList ov = operatorVariable.getList();
        ElementList r = replacement.getList();
        if (f.size() < 1 || ov.size() < 1) {
            return formula;
        }
        Element rn = r;
        for (int i = 1; i < ov.size(); ++i) {
            rn = rn.replace(ov.getElement(i), FormulaUtility.createMeta(ov.getElement(i)));
        }
        return FormulaUtility.replaceOperatorVariableMeta(formula, operatorVariable, rn);
    }

    private static Element replaceOperatorVariableMeta(Element formula, Element operatorVariable, Element replacement) {
        ElementList result;
        if (formula.isAtom() || operatorVariable.isAtom() || replacement.isAtom()) {
            return formula;
        }
        ElementList f = formula.getList();
        ElementList ov = operatorVariable.getList();
        ElementList r = replacement.getList();
        if (f.size() < 1 || ov.size() < 1) {
            return formula.copy();
        }
        if (EqualsUtility.equals(f.getOperator(), ov.getOperator()) && f.size() == ov.size() && ((Object)f.getElement(0)).equals(ov.getElement(0))) {
            result = r;
            for (int i = 1; i < ov.size(); ++i) {
                result = (ElementList)result.replace(FormulaUtility.createMeta(ov.getElement(i)), FormulaUtility.replaceOperatorVariableMeta(f.getElement(i), operatorVariable, replacement));
            }
        } else {
            result = new DefaultElementList(f.getOperator());
            for (int i = 0; i < f.size(); ++i) {
                result.add(FormulaUtility.replaceOperatorVariableMeta(f.getElement(i), operatorVariable, replacement));
            }
        }
        return result;
    }

    public static boolean containsOperatorVariable(Element formula, Element operatorVariable) {
        if (formula == null || formula.isAtom() || operatorVariable == null || operatorVariable.isAtom()) {
            return false;
        }
        ElementList f = formula.getList();
        ElementList ov = operatorVariable.getList();
        if (f.size() < 1 || ov.size() < 1) {
            return f.equals(ov);
        }
        if (EqualsUtility.equals(f.getOperator(), ov.getOperator()) && f.size() == ov.size() && ((Object)f.getElement(0)).equals(ov.getElement(0))) {
            return true;
        }
        for (int i = 0; i < f.size(); ++i) {
            if (!FormulaUtility.containsOperatorVariable(f.getElement(i), operatorVariable)) continue;
            return true;
        }
        return false;
    }

    public static boolean testOperatorVariable(Element formula, Element operatorVariable, ElementSet bound) {
        if (formula.isAtom() || operatorVariable.isAtom()) {
            return true;
        }
        ElementList f = formula.getList();
        ElementList ov = operatorVariable.getList();
        if (f.size() < 1 || ov.size() < 1) {
            return true;
        }
        boolean ok = true;
        if (EqualsUtility.equals(f.getOperator(), ov.getOperator()) && f.size() == ov.size() && ((Object)f.getElement(0)).equals(ov.getElement(0))) {
            if (!FormulaUtility.getSubjectVariables(f).intersection(bound).isEmpty()) {
                return false;
            }
        } else {
            for (int i = 0; ok && i < f.size(); ++i) {
                ok = FormulaUtility.testOperatorVariable(f.getElement(i), operatorVariable, bound);
            }
        }
        return ok;
    }

    public static boolean isImplication(Element formula) {
        if (formula.isAtom()) {
            return false;
        }
        ElementList f = formula.getList();
        return "IMPL".equals(f.getList().getOperator()) && f.getList().size() == 2;
    }

    public static Element createMeta(Element subjectVariable) {
        if (!FormulaUtility.isSubjectVariable(subjectVariable)) {
            return subjectVariable;
        }
        DefaultElementList result = new DefaultElementList("METAVAR");
        result.add(subjectVariable.getList().getElement(0));
        return result;
    }

    public static Element createSubjectVariable(String subjectVariableName) {
        DefaultElementList result = new DefaultElementList("VAR");
        result.add(new DefaultAtom(subjectVariableName));
        return result;
    }

    public static Element createPredicateVariable(String predicateVariableName) {
        DefaultElementList result = new DefaultElementList("PREDVAR");
        result.add(new DefaultAtom(predicateVariableName));
        return result;
    }
}

