/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.log;

import java.util.ArrayList;
import java.util.List;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.log.LogListener;

public final class QedeqLog
implements LogListener {
    private static final Class CLASS = QedeqLog.class;
    private static QedeqLog instance = new QedeqLog();
    private List loggers = new ArrayList();

    public static final QedeqLog getInstance() {
        return instance;
    }

    private QedeqLog() {
    }

    public synchronized void addLog(LogListener log) {
        if (log == null) {
            return;
        }
        this.loggers.add(log);
        Trace.paramInfo(CLASS, (Object)this, "addLog(LogListener)", "log", log.getClass());
    }

    public synchronized void removeLog(LogListener log) {
        this.loggers.remove(log);
        if (log != null) {
            Trace.paramInfo(CLASS, (Object)this, "removeLog(LogListener)", "log", log.getClass());
        }
    }

    public synchronized void logMessageState(String text, String url) {
        for (int i = 0; i < this.loggers.size(); ++i) {
            try {
                ((LogListener)this.loggers.get(i)).logMessageState(text, url);
                continue;
            }
            catch (RuntimeException e) {
                Trace.fatal(CLASS, this, "logMessageState", "LogListener throwed RuntimeException", e);
            }
        }
    }

    public synchronized void logFailureState(String text, String url, String description) {
        for (int i = 0; i < this.loggers.size(); ++i) {
            try {
                ((LogListener)this.loggers.get(i)).logFailureState(text, url, description);
                continue;
            }
            catch (RuntimeException e) {
                Trace.fatal(CLASS, this, "logFailureState", "LogListener throwed RuntimeException", e);
            }
        }
    }

    public synchronized void logSuccessfulState(String text, String url) {
        for (int i = 0; i < this.loggers.size(); ++i) {
            try {
                ((LogListener)this.loggers.get(i)).logSuccessfulState(text, url);
                continue;
            }
            catch (RuntimeException e) {
                Trace.fatal(CLASS, this, "logSuccessfulState", "LogListener throwed RuntimeException", e);
            }
        }
    }

    public synchronized void logRequest(String text, String url) {
        for (int i = 0; i < this.loggers.size(); ++i) {
            try {
                ((LogListener)this.loggers.get(i)).logRequest(text, url);
                continue;
            }
            catch (RuntimeException e) {
                Trace.fatal(CLASS, this, "logRequest", "LogListener throwed RuntimeException", e);
            }
        }
    }

    public synchronized void logSuccessfulReply(String text, String url) {
        for (int i = 0; i < this.loggers.size(); ++i) {
            try {
                ((LogListener)this.loggers.get(i)).logSuccessfulReply(text, url);
                continue;
            }
            catch (RuntimeException e) {
                Trace.fatal(CLASS, this, "logSuccessfulReply", "LogListener throwed RuntimeException", e);
            }
        }
    }

    public synchronized void logFailureReply(String text, String url, String description) {
        for (int i = 0; i < this.loggers.size(); ++i) {
            try {
                ((LogListener)this.loggers.get(i)).logFailureReply(text, url, description);
                continue;
            }
            catch (RuntimeException e) {
                Trace.fatal(CLASS, this, "logFailureReply", "LogListener throwed RuntimeException", e);
            }
        }
    }

    public synchronized void logMessage(String text) {
        for (int i = 0; i < this.loggers.size(); ++i) {
            try {
                ((LogListener)this.loggers.get(i)).logMessage(text);
                continue;
            }
            catch (RuntimeException e) {
                Trace.fatal(CLASS, this, "logMessage", "LogListener throwed RuntimeException", e);
            }
        }
    }
}

