/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.log;

import java.io.PrintStream;
import org.qedeq.base.utility.DateUtility;
import org.qedeq.kernel.bo.log.LogListener;

public final class LogListenerImpl
implements LogListener {
    private PrintStream out = System.out;
    private String lastModuleUrl = "";

    public LogListenerImpl() {
        this(System.out);
    }

    public LogListenerImpl(PrintStream stream) {
        this.out = stream;
    }

    public final void setPrintStream(PrintStream stream) {
        this.out = stream;
    }

    public final void logMessageState(String text, String url) {
        if (!this.lastModuleUrl.equals(url)) {
            this.out.println(url);
            this.lastModuleUrl = url != null ? url : "";
        }
        this.out.println(DateUtility.getTimestamp() + " state:   " + text);
    }

    public final void logFailureState(String text, String url, String description) {
        if (!this.lastModuleUrl.equals(url)) {
            this.out.println(url);
            this.lastModuleUrl = url != null ? url : "";
        }
        this.out.println(DateUtility.getTimestamp() + " failure: " + text + "\n\t" + description);
    }

    public final void logSuccessfulState(String text, String url) {
        if (!this.lastModuleUrl.equals(url)) {
            this.out.println(url);
            this.lastModuleUrl = url != null ? url : "";
        }
        this.out.println(DateUtility.getTimestamp() + " success: " + text);
    }

    public void logRequest(String text, String url) {
        if (!this.lastModuleUrl.equals(url)) {
            this.out.println(url);
            this.lastModuleUrl = url != null ? url : "";
        }
        this.out.println(DateUtility.getTimestamp() + " request: " + text);
    }

    public final void logMessage(String text) {
        this.lastModuleUrl = "";
        this.out.println(DateUtility.getTimestamp() + " " + text);
    }

    public void logSuccessfulReply(String text, String url) {
        if (!this.lastModuleUrl.equals(url)) {
            this.out.println(url);
            this.lastModuleUrl = url != null ? url : "";
        }
        this.out.println(DateUtility.getTimestamp() + " reply:   " + text);
    }

    public void logFailureReply(String text, String url, String description) {
        if (!this.lastModuleUrl.equals(url)) {
            this.out.println(url);
            this.lastModuleUrl = url != null ? url : "";
        }
        this.out.println(DateUtility.getTimestamp() + " reply:   " + text + "\n\t" + description);
    }
}

