/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.base.utility;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.SystemUtils;

public final class StringUtility {
    static final String FORMATED_ZERO = "00000000000000000000";
    static final String FORMATED_SPACES = "                    ";

    private StringUtility() {
    }

    public static String replace(String text, String search, String replace) {
        int pos2;
        int len;
        if (text == null) {
            return "";
        }
        int n = len = search != null ? search.length() : 0;
        if (len == 0) {
            return text;
        }
        StringBuffer result = new StringBuffer();
        int pos1 = 0;
        while (0 <= (pos2 = text.indexOf(search, pos1))) {
            result.append(text.substring(pos1, pos2));
            if (replace != null) {
                result.append(replace);
            }
            pos1 = pos2 + len;
        }
        if (pos1 < text.length()) {
            result.append(text.substring(pos1));
        }
        return result.toString();
    }

    public static void replace(StringBuffer text, String search, String replace) {
        int pos2;
        if (search == null || search.length() <= 0) {
            return;
        }
        StringBuffer result = new StringBuffer(text.length() + 16);
        int pos1 = 0;
        int len = search.length();
        while (0 <= (pos2 = text.indexOf(search, pos1))) {
            result.append(text.substring(pos1, pos2));
            result.append(replace != null ? replace : "");
            pos1 = pos2 + len;
        }
        if (pos1 < text.length()) {
            result.append(text.substring(pos1));
        }
        text.setLength(0);
        text.append(result);
    }

    public static String substring(String text, int position, int length) {
        int start = Math.max(0, position);
        int l = position + length - start;
        if (l <= 0) {
            return "";
        }
        int end = start + l;
        if (end < text.length()) {
            return text.substring(start, end);
        }
        return text.substring(start);
    }

    public static String toString(Object[] list) {
        StringBuffer buffer = new StringBuffer(30);
        buffer.append("(");
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                if (list[i] instanceof CharSequence) {
                    buffer.append("\"");
                    buffer.append(list[i].toString());
                    buffer.append("\"");
                    continue;
                }
                buffer.append(String.valueOf(list[i]));
            }
        }
        buffer.append(")");
        return buffer.toString();
    }

    public static String toString(Set set) {
        StringBuffer buffer = new StringBuffer(30);
        buffer.append("{");
        if (set != null) {
            Iterator e = set.iterator();
            boolean notFirst = false;
            while (e.hasNext()) {
                if (notFirst) {
                    buffer.append(", ");
                } else {
                    notFirst = true;
                }
                Object obj = e.next();
                if (obj instanceof CharSequence) {
                    buffer.append("\"");
                    buffer.append(String.valueOf(obj));
                    buffer.append("\"");
                    continue;
                }
                buffer.append(String.valueOf(obj));
            }
        }
        buffer.append("}");
        return buffer.toString();
    }

    public static String toString(Map map) {
        StringBuffer buffer = new StringBuffer(30);
        buffer.append("{");
        if (map != null) {
            Iterator e = map.entrySet().iterator();
            boolean notFirst = false;
            while (e.hasNext()) {
                if (notFirst) {
                    buffer.append(", ");
                } else {
                    notFirst = true;
                }
                Map.Entry entry = e.next();
                buffer.append(String.valueOf(entry.getKey()));
                buffer.append("=");
                Object value = entry.getValue();
                if (value instanceof CharSequence) {
                    buffer.append("\"");
                    buffer.append(String.valueOf(value));
                    buffer.append("\"");
                    continue;
                }
                buffer.append(String.valueOf(value));
            }
        }
        buffer.append("}");
        return buffer.toString();
    }

    public static String asLines(Set set) {
        StringBuffer buffer = new StringBuffer(30);
        if (set != null) {
            Iterator e = set.iterator();
            boolean notFirst = false;
            while (e.hasNext()) {
                if (notFirst) {
                    buffer.append("\n");
                } else {
                    notFirst = true;
                }
                buffer.append(String.valueOf(e.next()));
            }
        }
        return buffer.toString();
    }

    public static String quote(String unquoted) {
        StringBuffer result = new StringBuffer(unquoted.length() + 4);
        result.append('\"');
        for (int i = 0; i < unquoted.length(); ++i) {
            if (unquoted.charAt(i) == '\"') {
                result.append("\"\"");
                continue;
            }
            result.append(unquoted.charAt(i));
        }
        result.append('\"');
        return result.toString();
    }

    public static boolean isLetterDigitString(String text) {
        if (text.length() <= 0) {
            return false;
        }
        if (!Character.isLetter(text.charAt(0))) {
            return false;
        }
        for (int i = 1; i < text.length(); ++i) {
            if (Character.isLetterOrDigit(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static StringBuffer getSpaces(int length) {
        StringBuffer buffer = new StringBuffer(length >= 0 ? length : 0);
        for (int i = 0; i < length; ++i) {
            buffer.append(' ');
        }
        return buffer;
    }

    public static String getLastDotString(String full) {
        if (full == null) {
            return "";
        }
        int p = full.lastIndexOf(46);
        if (p < 0) {
            return full;
        }
        return full.substring(p + 1);
    }

    public static String getLastTwoDotStrings(String full) {
        if (full == null) {
            return "";
        }
        int p = full.lastIndexOf(46);
        if (p < 1) {
            return full;
        }
        int q = full.lastIndexOf(46, p - 1);
        if (q < 0) {
            return full;
        }
        return full.substring(q + 1);
    }

    public static String getClassName(Class clazz) {
        return StringUtility.getLastDotString(clazz.getName());
    }

    public static void deleteLineLeadingWhitespace(StringBuffer buffer) {
        int current;
        int lastLf = -1;
        for (current = 0; current < buffer.length() && Character.isWhitespace(buffer.charAt(current)); ++current) {
            if ('\n' != buffer.charAt(current)) continue;
            lastLf = current;
        }
        String empty = buffer.substring(lastLf + 1, current);
        if (empty.length() > 0) {
            buffer.delete(lastLf + 1, current);
            StringUtility.replace(buffer, "\n" + empty, "\n");
        }
    }

    public static String escapeProperty(String value) {
        Properties newprops = new Properties();
        newprops.put("key", value);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            newprops.store(out, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            String file = out.toString("ISO-8859-1");
            return file.substring(file.indexOf(10) + 1 + "key=".length()).trim();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static final String alignRight(long number, int length) {
        return StringUtility.alignRight("" + number, length);
    }

    public static final String alignRight(String string, int length) {
        if (length > FORMATED_SPACES.length()) {
            throw new IllegalArgumentException("maximum length                      exceeded: " + length);
        }
        if (length < 1) {
            throw new IllegalArgumentException("length must be bigger than 0: " + length);
        }
        String temp = FORMATED_SPACES + string;
        return temp.substring(Math.min(temp.length() - length, FORMATED_SPACES.length()));
    }

    public static final String format(long number, int length) {
        if (length > FORMATED_ZERO.length()) {
            throw new IllegalArgumentException("maximum length 00000000000000000000 exceeded: " + length);
        }
        if (length < 1) {
            throw new IllegalArgumentException("length must be bigger than 0: " + length);
        }
        String temp = FORMATED_ZERO + number;
        return temp.substring(Math.min(temp.length() - length, FORMATED_ZERO.length()));
    }

    public static String byte2Hex(byte[] data) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            String b = Integer.toHexString(0xFF & data[i]);
            if (i != 0) {
                if (0 != i % 16) {
                    buffer.append(" ");
                } else {
                    buffer.append("\n");
                }
            }
            if (b.length() < 2) {
                buffer.append("0");
            }
            buffer.append(b.toUpperCase(Locale.US));
        }
        return buffer.toString();
    }

    public static String string2Hex(String data) {
        try {
            return StringUtility.byte2Hex(data.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String string2Hex(String data, String encoding) throws UnsupportedEncodingException {
        return StringUtility.byte2Hex(data.getBytes(encoding));
    }

    public static byte[] hex2byte(String hex) {
        StringBuffer buffer = new StringBuffer(hex.length());
        for (int i = 0; i < hex.length(); ++i) {
            char c = hex.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (!Character.isLetterOrDigit(c)) {
                throw new IllegalArgumentException("Illegal hex char");
            }
            buffer.append(c);
        }
        if (buffer.length() % 2 != 0) {
            throw new IllegalArgumentException("Bad padding");
        }
        byte[] result = new byte[buffer.length() / 2];
        for (int i = 0; i < buffer.length() / 2; ++i) {
            try {
                result[i] = (byte)Integer.parseInt(buffer.substring(2 * i, 2 * i + 2), 16);
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Illegal hex char");
            }
        }
        return result;
    }

    public static String hex2String(String hex) {
        try {
            return new String(StringUtility.hex2byte(hex), "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String hex2String(String hex, String encoding) throws UnsupportedEncodingException {
        return new String(StringUtility.hex2byte(hex), encoding);
    }

    public static String getSystemLineSeparator() {
        return SystemUtils.LINE_SEPARATOR != null ? SystemUtils.LINE_SEPARATOR : "\n";
    }

    public static String useSystemLineSeparator(String text) {
        if (text == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(text.length());
        BufferedReader reader = new BufferedReader(new StringReader(text));
        String separator = StringUtility.getSystemLineSeparator();
        try {
            String line;
            while (null != (line = reader.readLine())) {
                buffer.append(line);
                buffer.append(separator);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return buffer.toString();
    }

    public static String[] split(String text, String delimiter) {
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        int found = -delimiter.length();
        while (-1 < (found = text.indexOf(delimiter, start))) {
            list.add(text.substring(start, found));
            start = found + delimiter.length();
        }
        list.add(text.substring(start));
        return list.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static String escapeXml(String value) {
        return StringEscapeUtils.escapeXml((String)value);
    }

    public static String unescapeXml(String value) {
        return StringEscapeUtils.unescapeXml((String)value);
    }

    public static boolean isNotIn(String lookFor, String[] array) {
        if (lookFor == null || lookFor.length() <= 0) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!lookFor.equals(array[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isIn(String lookFor, String[] array) {
        return !StringUtility.isNotIn(lookFor, array);
    }
}

